/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;

public class WorldGrid
implements Trackable {
    private static final float[] DASHED_LINE = new float[]{1.0f, 8.0f};
    private static final float[] DOTTED_LINE = new float[]{2.0f, 2.0f};
    private static Stroke dashed;
    private static Stroke dotted;
    private static int defaultAlpha;
    private static Color defaultColor;
    ArrayList<Line2D> dashedLines = new ArrayList();
    ArrayList<Line2D> dottedLines = new ArrayList();
    TPoint[] viewCorners = new TPoint[]{new TPoint(), new TPoint(), new TPoint(), new TPoint()};
    Point2D[] worldCorners = new Point2D[4];
    TPoint[] lineEnds = new TPoint[]{new TPoint(), new TPoint()};
    double[] minMaxWorldValues = new double[4];
    int[] minMaxIndices = new int[4];
    boolean showMajorX = true;
    boolean showMinorX = true;
    boolean showMajorY = true;
    boolean showMinorY = true;
    private int alpha = defaultAlpha;
    private Color lineColor = defaultColor;
    private boolean visible;

    static {
        defaultAlpha = 128;
        defaultColor = new Color(128, 128, 128, defaultAlpha);
    }

    public WorldGrid() {
        dashed = new BasicStroke(2.0f, 0, 0, 8.0f, DASHED_LINE, 0.0f);
        dotted = new BasicStroke(2.0f, 0, 0, 8.0f, DOTTED_LINE, 0.0f);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Line2D.Double double_;
        double d;
        ArrayList<Line2D> arrayList;
        boolean bl;
        if (!this.visible || !this.showMajorX && !this.showMajorY) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Rectangle rectangle = trackerPanel.getVisibleRect();
        int n = 0;
        while (n < 4) {
            switch (n) {
                case 0: {
                    this.viewCorners[n].setScreenPosition(rectangle.x, rectangle.y, trackerPanel);
                    break;
                }
                case 1: {
                    this.viewCorners[n].setScreenPosition(rectangle.x + rectangle.width, rectangle.y, trackerPanel);
                    break;
                }
                case 2: {
                    this.viewCorners[n].setScreenPosition(rectangle.x, rectangle.y + rectangle.height, trackerPanel);
                    break;
                }
                default: {
                    this.viewCorners[n].setScreenPosition(rectangle.x + rectangle.width, rectangle.y + rectangle.height, trackerPanel);
                }
            }
            this.worldCorners[n] = this.viewCorners[n].getWorldPosition(trackerPanel);
            if (n == 0) {
                this.minMaxWorldValues[0] = this.minMaxWorldValues[1] = this.worldCorners[n].getX();
                this.minMaxWorldValues[2] = this.minMaxWorldValues[3] = this.worldCorners[n].getY();
            } else {
                this.minMaxWorldValues[0] = Math.min(this.minMaxWorldValues[0], this.worldCorners[n].getX());
                this.minMaxWorldValues[1] = Math.max(this.minMaxWorldValues[1], this.worldCorners[n].getX());
                this.minMaxWorldValues[2] = Math.min(this.minMaxWorldValues[2], this.worldCorners[n].getY());
                this.minMaxWorldValues[3] = Math.max(this.minMaxWorldValues[3], this.worldCorners[n].getY());
            }
            ++n;
        }
        n = Math.min(60, rectangle.width / 25);
        double d2 = (this.minMaxWorldValues[1] - this.minMaxWorldValues[0]) / (double)n;
        double d3 = 1.0;
        while (d3 * 10.0 < d2) {
            d3 *= 10.0;
        }
        while (d3 > d2) {
            d3 /= 10.0;
        }
        double d4 = d2 / d3;
        int n2 = 10;
        int n3 = 100;
        if (d4 < 2.0) {
            n2 = 2;
            n3 = 10;
        } else if (d4 < 5.0) {
            n2 = 5;
            n3 = 10;
        }
        d2 = (double)n2 * d3;
        int n4 = 0;
        while (n4 < 4) {
            this.minMaxIndices[n4] = (int)(this.minMaxWorldValues[n4] / d2);
            ++n4;
        }
        this.dashedLines.clear();
        this.dottedLines.clear();
        if (this.showMajorX) {
            n4 = this.minMaxIndices[0] - 1;
            while (n4 < this.minMaxIndices[1] + 1) {
                boolean bl2 = bl = n4 * n2 % n3 == 0;
                if (bl || this.showMinorX) {
                    arrayList = bl ? this.dottedLines : this.dashedLines;
                    d = (double)n4 * d2;
                    double_ = new Line2D.Double();
                    arrayList.add(double_);
                    this.lineEnds[0].setWorldPosition(d, this.minMaxWorldValues[2], trackerPanel);
                    this.lineEnds[1].setWorldPosition(d, this.minMaxWorldValues[3], trackerPanel);
                    double_.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                }
                ++n4;
            }
        }
        if (this.showMajorY) {
            n4 = this.minMaxIndices[2] - 1;
            while (n4 < this.minMaxIndices[3] + 1) {
                boolean bl3 = bl = n4 * n2 % n3 == 0;
                if (bl || this.showMinorY) {
                    arrayList = bl ? this.dottedLines : this.dashedLines;
                    d = (double)n4 * d2;
                    double_ = new Line2D.Double();
                    arrayList.add(double_);
                    this.lineEnds[0].setWorldPosition(this.minMaxWorldValues[0], d, trackerPanel);
                    this.lineEnds[1].setWorldPosition(this.minMaxWorldValues[1], d, trackerPanel);
                    double_.setLine(this.lineEnds[0].getScreenPosition(trackerPanel), this.lineEnds[1].getScreenPosition(trackerPanel));
                }
                ++n4;
            }
        }
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(this.lineColor);
        graphics2D.setStroke(dashed);
        int n5 = 0;
        while (n5 < this.dashedLines.size()) {
            graphics2D.draw(this.dashedLines.get(n5));
            ++n5;
        }
        graphics2D.setStroke(dotted);
        n5 = 0;
        while (n5 < this.dottedLines.size()) {
            graphics2D.draw(this.dottedLines.get(n5));
            ++n5;
        }
        graphics2D.setStroke(stroke);
        graphics2D.setColor(color);
    }

    public Color getColor() {
        return this.lineColor;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.lineColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alpha);
        }
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int n) {
        n = Math.min(n, 255);
        this.alpha = n = Math.max(n, 0);
        this.setColor(this.lineColor);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isCustom() {
        return !defaultColor.equals(this.lineColor);
    }

    public void setMajorXGridVisible(boolean bl) {
        this.showMajorX = bl;
    }

    public void setMinorXGridVisible(boolean bl) {
        this.showMinorX = bl;
    }

    public void setMajorYGridVisible(boolean bl) {
        this.showMajorY = bl;
    }

    public void setMinorYGridVisible(boolean bl) {
        this.showMinorY = bl;
    }
}

