/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.opensourcephysics.cabrillo.tracker.VectorStep;

public class VectorChain
extends ArrayList<VectorStep> {
    protected VectorChain(VectorStep vectorStep) {
        if (this.isAllowed(vectorStep)) {
            vectorStep.chain = this;
            super.add(vectorStep);
        }
    }

    public VectorChain(VectorStep vectorStep, VectorStep vectorStep2) {
        if (this.isAllowed(vectorStep) && this.isAllowed(vectorStep2)) {
            vectorStep.chain = this;
            super.add(vectorStep);
            this.add(vectorStep2);
        }
    }

    public VectorStep getEnd() {
        return (VectorStep)this.get(this.size() - 1);
    }

    public VectorStep getStart() {
        return (VectorStep)this.get(0);
    }

    public VectorStep removeEnd() {
        if (this.size() == 0) {
            return null;
        }
        VectorStep vectorStep = this.getEnd();
        vectorStep.chain = null;
        vectorStep.attach(null);
        super.remove(this.size() - 1);
        return vectorStep;
    }

    public VectorChain breakAt(VectorStep vectorStep) {
        if (vectorStep.chain != this || vectorStep == this.getStart()) {
            return null;
        }
        if (vectorStep == this.getEnd()) {
            this.removeEnd();
            return null;
        }
        ArrayList<VectorStep> arrayList = this.remove(vectorStep);
        VectorChain vectorChain = new VectorChain(vectorStep);
        int n = 1;
        while (n < arrayList.size()) {
            vectorChain.add(arrayList.get(n));
            ++n;
        }
        return vectorChain;
    }

    @Override
    public void clear() {
        for (VectorStep vectorStep : this) {
            vectorStep.chain = null;
            vectorStep.attach(null);
        }
        super.clear();
    }

    @Override
    public boolean add(VectorStep vectorStep) {
        if (vectorStep.getChain() != null) {
            return this.add(vectorStep.getChain());
        }
        if (this.isAllowed(vectorStep)) {
            VectorStep vectorStep2 = this.getEnd();
            vectorStep.attach(vectorStep2.getHinge());
            vectorStep.chain = this;
            super.add(vectorStep);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(VectorChain vectorChain) {
        if (vectorChain == this) {
            return false;
        }
        ArrayList<VectorStep> arrayList = vectorChain.remove(vectorChain.getStart());
        this.addAll((Collection<? extends VectorStep>)arrayList);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends VectorStep> collection) {
        boolean bl = false;
        Iterator<? extends VectorStep> iterator = collection.iterator();
        while (iterator.hasNext()) {
            boolean bl2 = bl = this.add(iterator.next()) || bl;
        }
        return bl;
    }

    @Override
    public void add(int n, VectorStep vectorStep) {
    }

    @Override
    public VectorStep remove(int n) {
        return null;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public void removeRange(int n, int n2) {
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends VectorStep> collection) {
        return false;
    }

    @Override
    public VectorStep set(int n, VectorStep vectorStep) {
        return null;
    }

    protected boolean isAllowed(VectorStep vectorStep) {
        if (vectorStep.getChain() != null) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        Class<?> clazz = this.getEnd().getTrack().getClass();
        return clazz.equals(vectorStep.getTrack().getClass());
    }

    protected ArrayList<VectorStep> remove(VectorStep vectorStep) {
        ArrayList<VectorStep> arrayList = new ArrayList<VectorStep>();
        int n = this.size();
        int n2 = this.indexOf(vectorStep);
        while (n2 < n) {
            arrayList.add(0, this.removeEnd());
            ++n2;
        }
        return arrayList;
    }
}

