/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.MonitorDialog;
import org.opensourcephysics.cabrillo.tracker.PrefsDialog;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.TransferImage;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.ControlsRes;
import org.opensourcephysics.controls.ListChooser;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.DataTable;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoAdapter;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TrackerIO
extends VideoIO {
    protected static final String TAB = "\t";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String SEMICOLON = ";";
    protected static FileFilter zipFileFilter;
    protected static FileFilter trkFileFilter;
    protected static FileFilter trzFileFilter;
    protected static FileFilter videoAndTrkFileFilter;
    protected static FileFilter txtFileFilter;
    protected static FileFilter jarFileFilter;
    protected static String defaultDelimiter;
    protected static String delimiter;
    protected static Map<String, String> delimiters;
    protected static Map<String, String> customDelimiters;
    protected static boolean isffmpegError;
    protected static TFrame theFrame;
    protected static PropertyChangeListener ffmpegListener;
    protected static boolean loadInSeparateThread;
    protected static Set<MonitorDialog> monitors;
    protected static double defaultBadFrameTolerance;

    static {
        delimiter = defaultDelimiter = TAB;
        delimiters = new TreeMap<String, String>();
        customDelimiters = new TreeMap<String, String>();
        isffmpegError = false;
        loadInSeparateThread = true;
        monitors = new HashSet<MonitorDialog>();
        defaultBadFrameTolerance = 0.2;
        ffmpegListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("ffmpeg_error") && !isffmpegError) {
                    isffmpegError = true;
                    if (!Tracker.warnXuggleError) {
                        if (propertyChangeEvent.getNewValue() != null) {
                            String string = propertyChangeEvent.getNewValue().toString();
                            int n = string.indexOf("]");
                            if (n > -1) {
                                string = string.substring(n + 1);
                            }
                            string = String.valueOf(string) + TrackerRes.getString("TrackerIO.ErrorFFMPEG.LogMessage");
                            OSPLog.warning(string);
                        }
                        return;
                    }
                    Box box = Box.createVerticalBox();
                    box.add(new JLabel(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Message1")));
                    String string = propertyChangeEvent.getNewValue().toString();
                    int n = string.lastIndexOf("]");
                    if (n > -1) {
                        string = string.substring(n + 1).trim();
                    }
                    box.add(new JLabel("  "));
                    JLabel jLabel = new JLabel("\"" + string + "\"");
                    jLabel.setBorder(BorderFactory.createEmptyBorder(0, 60, 0, 0));
                    box.add(jLabel);
                    box.add(new JLabel("  "));
                    box.add(new JLabel(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Message2")));
                    box.add(new JLabel("  "));
                    box.setBorder(BorderFactory.createEmptyBorder(20, 15, 0, 15));
                    final JDialog jDialog = new JDialog((Frame)theFrame, false);
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jDialog.setContentPane(jPanel);
                    jPanel.add((Component)box, "Center");
                    JButton jButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
                    jButton.setForeground(new Color(0, 0, 102));
                    jButton.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jDialog.setVisible(false);
                        }
                    });
                    JButton jButton2 = new JButton(TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox"));
                    jButton2.setForeground(new Color(0, 0, 102));
                    jButton2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Tracker.warnXuggleError = false;
                            jDialog.setVisible(false);
                        }
                    });
                    JPanel jPanel2 = new JPanel();
                    jPanel2.add(jButton2);
                    jPanel2.add(jButton);
                    jPanel2.setBorder(BorderFactory.createEtchedBorder());
                    jPanel.add((Component)jPanel2, "South");
                    FontSizer.setFonts(jDialog, FontSizer.getLevel());
                    jDialog.pack();
                    jDialog.setTitle(TrackerRes.getString("TrackerIO.Dialog.ErrorFFMPEG.Title"));
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    int n2 = (dimension.width - jDialog.getBounds().width) / 2;
                    int n3 = (dimension.height - jDialog.getBounds().height) / 2;
                    jDialog.setLocation(n2, n3);
                    jDialog.setVisible(true);
                }
            }
        };
        OSPLog.getOSPLog().addPropertyChangeListener(ffmpegListener);
        zipFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return "zip".equals(string);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.ZipFileFilter.Description");
            }
        };
        trkFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (zipFileFilter.accept(file)) {
                    return true;
                }
                if (trzFileFilter.accept(file)) {
                    return true;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return "trk".equals(string);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.DataFileFilter.Description");
            }
        };
        trzFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return "trz".equals(string);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.ZIPResourceFilter.Description");
            }
        };
        videoAndTrkFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (trkFileFilter.accept(file)) {
                    return true;
                }
                return videoFileFilter.accept(file);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.VideoAndDataFileFilter.Description");
            }
        };
        txtFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return "txt".equals(string);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.TextFileFilter.Description");
            }
        };
        jarFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = VideoIO.getExtension(file);
                return "jar".equals(string);
            }

            @Override
            public String getDescription() {
                return TrackerRes.getString("TrackerIO.JarFileFilter.Description");
            }
        };
        delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Tab"), TAB);
        delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Space"), SPACE);
        delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Comma"), COMMA);
        delimiters.put(TrackerRes.getString("TrackerIO.Delimiter.Semicolon"), SEMICOLON);
    }

    private TrackerIO() {
    }

    public static File save(File file, TrackerPanel trackerPanel) {
        VideoClip videoClip;
        trackerPanel.restoreViews();
        TrackerIO.getChooser().setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(trkFileFilter);
        chooser.setAccessory(null);
        if (file == null && trackerPanel.getDataFile() == null && ((videoClip = trackerPanel.getPlayer().getVideoClip()).getVideo() != null || videoClip.getVideoPath() != null)) {
            File file2 = new File(videoClip.getVideoPath()).getParentFile();
            chooser.setCurrentDirectory(file2);
        }
        boolean bl = file == null;
        file = VideoIO.save(file, trackerPanel, TrackerRes.getString("TrackerIO.Dialog.SaveTab.Title"));
        chooser.removeChoosableFileFilter(trkFileFilter);
        chooser.setAcceptAllFileFilterUsed(true);
        if (bl && file != null) {
            Tracker.addRecent(XML.getAbsolutePath(file), false);
            TMenuBar.getMenuBar(trackerPanel).refresh();
        }
        return file;
    }

    public static File saveTabset(File file, TFrame tFrame) {
        TrackerPanel trackerPanel;
        int n = 0;
        int n2 = 0;
        while (n2 < tFrame.getTabCount()) {
            trackerPanel = tFrame.getTrackerPanel(n2);
            if (trackerPanel.getDataFile() != null) {
                ++n;
            } else {
                String string;
                Video video = trackerPanel.getVideo();
                if (!trackerPanel.changed && video != null && (string = (String)video.getProperty("absolutePath")) != null) {
                    ++n;
                } else {
                    int n3 = JOptionPane.showConfirmDialog(tFrame, String.valueOf(TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message1")) + SPACE + n2 + " (\"" + tFrame.getTabTitle(n2) + "\") " + TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message2") + XML.NEW_LINE + TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Message3"), TrackerRes.getString("TrackerIO.Dialog.TabMustBeSaved.Title"), 1);
                    if (n3 == 2) {
                        return null;
                    }
                    if (n3 == 0) {
                        TrackerIO.getChooser().setAccessory(null);
                        File file2 = VideoIO.save(null, trackerPanel, TrackerRes.getString("TrackerIO.Dialog.SaveTab.Title"));
                        if (file2 == null) {
                            return null;
                        }
                        Tracker.addRecent(XML.getAbsolutePath(file2), false);
                        ++n;
                    }
                }
            }
            ++n2;
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(tFrame, TrackerRes.getString("TrackerIO.Dialog.NoTabs.Message"), TrackerRes.getString("TrackerIO.Dialog.NoTabs.Title"), 2);
            return null;
        }
        if (file == null) {
            File[] fileArray = TrackerIO.getChooserFiles("save tabset");
            if (fileArray == null || !TrackerIO.canWrite(fileArray[0])) {
                return null;
            }
            file = fileArray[0];
        }
        tFrame.tabsetFile = file;
        XMLControlElement xMLControlElement = new XMLControlElement(tFrame);
        xMLControlElement.write(XML.getAbsolutePath(file));
        Tracker.addRecent(XML.getAbsolutePath(file), false);
        trackerPanel = tFrame.getTrackerPanel(tFrame.getSelectedTab());
        TMenuBar.getMenuBar(trackerPanel).refresh();
        return file;
    }

    public static File[] getChooserFiles(String string) {
        JFileChooser jFileChooser = TrackerIO.getChooser();
        int n = 1;
        if (string.toLowerCase().equals("open")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAccessory(videoEnginePanel);
            videoEnginePanel.reset();
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(videoAndTrkFileFilter);
            jFileChooser.setFileFilter(videoAndTrkFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.removeChoosableFileFilter(videoAndTrkFileFilter);
            jFileChooser.setSelectedFile(new File(""));
            jFileChooser.resetChoosableFileFilters();
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("open trk")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAccessory(null);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(trkFileFilter);
            jFileChooser.setFileFilter(trkFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("open any")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("open video")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAccessory(videoEnginePanel);
            videoEnginePanel.reset();
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(videoFileFilter);
            jFileChooser.setFileFilter(videoFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Open.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("open data")) {
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(txtFileFilter);
            jFileChooser.addChoosableFileFilter(jarFileFilter);
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.OpenData.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("save")) {
            jFileChooser.setAccessory(null);
            jFileChooser.setMultiSelectionEnabled(false);
            n = jFileChooser.showSaveDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0 && TrackerIO.canWrite(file)) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("import file")) {
            jFileChooser.setAccessory(null);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(trkFileFilter);
            jFileChooser.setFileFilter(trkFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Import.Title"));
            n = jFileChooser.showOpenDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("export file")) {
            jFileChooser.setAccessory(null);
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.addChoosableFileFilter(trkFileFilter);
            jFileChooser.setFileFilter(trkFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.Export.Title"));
            n = jFileChooser.showSaveDialog(null);
            File file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                return new File[]{file};
            }
            return null;
        }
        if (string.toLowerCase().equals("save tabset")) {
            jFileChooser.setAccessory(null);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(trkFileFilter);
            jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.SaveTabset.Title"));
            String string2 = "";
            File file = new File(String.valueOf(string2) + "." + defaultXMLExt);
            String string3 = XML.getDirectoryPath(string2);
            if (!string3.equals("")) {
                XML.createFolders(string3);
                jFileChooser.setCurrentDirectory(new File(string3));
            }
            jFileChooser.setSelectedFile(file);
            n = jFileChooser.showSaveDialog(null);
            file = jFileChooser.getSelectedFile();
            jFileChooser.resetChoosableFileFilters();
            jFileChooser.setSelectedFile(new File(""));
            if (n == 0) {
                if (!defaultXMLExt.equals(TrackerIO.getExtension(file))) {
                    string2 = XML.stripExtension(file.getPath());
                    file = new File(String.valueOf(string2) + "." + defaultXMLExt);
                }
                return new File[]{file};
            }
            return null;
        }
        return VideoIO.getChooserFiles(string);
    }

    public static File getChooserFileForExtension(String string) {
        string = string != null && !string.trim().equals("") ? string.trim().toLowerCase() : null;
        final String string2 = string;
        chooser.setDialogTitle(MediaRes.getString("VideoIO.Dialog.SaveVideoAs.Title"));
        chooser.resetChoosableFileFilters();
        chooser.setAccessory(null);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(string2 != null);
        if (string2 != null) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    if (file.isDirectory()) {
                        return true;
                    }
                    String string = VideoIO.getExtension(file);
                    return string2.equals(string);
                }

                @Override
                public String getDescription() {
                    String string = TrackerRes.getString("TMenuBar.Menu.File").toLowerCase();
                    return String.valueOf(string2.toUpperCase()) + TrackerIO.SPACE + string + " (." + string2 + ")";
                }
            };
            chooser.addChoosableFileFilter(fileFilter);
            chooser.setFileFilter(fileFilter);
        }
        int n = chooser.showSaveDialog(null);
        File file = chooser.getSelectedFile();
        chooser.resetChoosableFileFilters();
        chooser.setSelectedFile(new File(""));
        if (file == null) {
            return null;
        }
        if (n == 0) {
            if (string2 != null && !string2.equals(XML.getExtension(file.getName()))) {
                String string3 = file.getAbsolutePath();
                string3 = String.valueOf(XML.stripExtension(string3)) + "." + string2;
                file = new File(string3);
            }
            if (!TrackerIO.canWrite(file)) {
                return null;
            }
            return file;
        }
        return null;
    }

    public static boolean canWrite(File file) {
        int n;
        if (file.exists() && !file.canWrite()) {
            JOptionPane.showMessageDialog(null, ControlsRes.getString("Dialog.ReadOnly.Message"), ControlsRes.getString("Dialog.ReadOnly.Title"), -1);
            return false;
        }
        return !file.exists() || (n = JOptionPane.showConfirmDialog(null, "\"" + file.getName() + "\" " + TrackerRes.getString("TrackerIO.Dialog.ReplaceFile.Message"), TrackerRes.getString("TrackerIO.Dialog.ReplaceFile.Title"), 0)) == 0;
    }

    public static Video getVideo(String string, VideoType videoType) {
        boolean bl = OSPLog.isConsoleMessagesLogged();
        if (!Tracker.warnXuggleError) {
            OSPLog.setConsoleMessagesLogged(false);
        }
        if (string.startsWith("file:")) {
            string = ResourceLoader.getNonURIPath(string);
        }
        Video video = VideoIO.getVideo(string, videoType);
        OSPLog.setConsoleMessagesLogged(bl);
        return video;
    }

    private static void open(String string, TrackerPanel trackerPanel, TFrame tFrame, VideoType videoType, ArrayList<String> arrayList) {
        OSPLog.finer("opening " + string);
        String string2 = string;
        string = ResourceLoader.getURIPath(string);
        isffmpegError = false;
        theFrame = tFrame;
        VideoIO.setCanceled(false);
        String string3 = ResourceLoader.getNonURIPath(string);
        if (string2.startsWith("//") && string3.startsWith("/") && !string3.startsWith("//")) {
            string3 = "/" + string3;
        }
        if (tFrame.loadedFiles.contains(string3)) {
            OSPLog.finest("path already loaded " + string3);
            return;
        }
        tFrame.loadedFiles.add(string3);
        if (!string.startsWith("http:")) {
            string = string3;
        }
        String string4 = XML.getName(string);
        File file = new File(string4);
        TrackerPanel trackerPanel2 = trackerPanel == null ? new TrackerPanel() : trackerPanel;
        boolean bl = trackerPanel2.changed;
        MonitorDialog monitorDialog = new MonitorDialog(tFrame, string);
        monitorDialog.setVisible(true);
        monitors.add(monitorDialog);
        String string5 = null;
        if (videoFileFilter.accept(file)) {
            Object object;
            Serializable serializable;
            Object object2;
            Object object3;
            OSPLog.finest("opening video path " + string);
            if (string.startsWith("http:")) {
                object3 = XML.getName(string);
                object2 = ResourceLoader.downloadToOSPCache(string, (String)(object3 = ResourceLoader.getNonURIPath((String)object3)), false);
                if (object2 != null) {
                    string = ((File)object2).toURI().toString();
                }
            }
            object3 = videoType;
            object2 = TrackerIO.getVideo(string, videoType);
            monitorDialog.stop();
            if (object2 == null && !VideoIO.isCanceled()) {
                Object object4;
                Object object5;
                serializable = new ArrayList<VideoType>();
                object = VideoIO.getEngine();
                if (object3 == null) {
                    object5 = XML.getExtension(string);
                    if (!((String)object).equals("Xuggle") && (object4 = VideoIO.getVideoType("Xuggle", (String)object5)) != null) {
                        ((ArrayList)serializable).add((VideoType)object4);
                    }
                    if (!((String)object).equals("QT") && (object4 = VideoIO.getVideoType("QT", (String)object5)) != null) {
                        ((ArrayList)serializable).add((VideoType)object4);
                    }
                }
                if (((ArrayList)serializable).isEmpty()) {
                    monitorDialog.close();
                    JOptionPane.showMessageDialog(trackerPanel2.getTFrame(), String.valueOf(MediaRes.getString("VideoIO.Dialog.BadVideo.Message")) + "\n\n" + string, MediaRes.getString("VideoClip.Dialog.BadVideo.Title"), 2);
                } else {
                    object5 = new JCheckBox(MediaRes.getString("VideoIO.Dialog.TryDifferentEngine.Checkbox"));
                    object2 = VideoIO.getVideo(string, serializable, (JComponent)object5, tFrame);
                    if (object2 != null && ((AbstractButton)object5).isSelected()) {
                        object4 = object2.getClass().getSimpleName();
                        String string6 = ((String)object4).indexOf("Xuggle") > -1 ? "Xuggle" : (((String)object4).indexOf("QT") > -1 ? "QT" : "none");
                        VideoIO.setEngine(string6);
                        PrefsDialog prefsDialog = tFrame.getPrefsDialog();
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.videoPanel);
                        tFrame.showPrefsDialog();
                    }
                }
            }
            if (object2 == null) {
                monitorDialog.close();
                return;
            }
            if (!VideoIO.isCanceled()) {
                if (monitorDialog.isVisible()) {
                    monitorDialog.setProgress(85);
                }
                videoType = (VideoType)object2.getProperty("video_type");
                OSPLog.finer(object2.getProperty("path") + " opened as " + videoType.getClass().getSimpleName() + SPACE + videoType.getDescription());
                trackerPanel2.frame = tFrame;
                if (VideoIO.isCanceled()) {
                    return;
                }
                tFrame.addTab(trackerPanel2);
                if (monitorDialog.isVisible()) {
                    monitorDialog.setProgress(95);
                }
                serializable = tFrame.getSplitPane(trackerPanel2, 0);
                ((JSplitPane)serializable).setDividerLocation(tFrame.defaultRightDivider);
                TMenuBar.getMenuBar(trackerPanel2).refresh();
                trackerPanel2.setVideo((Video)object2);
                boolean bl2 = bl = trackerPanel != null;
                if (object2.getFrameCount() == 1) {
                    trackerPanel2.getPlayer().getVideoClip().setStepCount(10);
                }
                if (trackerPanel == null) {
                    object = trackerPanel2.getCoords();
                    ((ImageCoordSystem)object).setAllOriginsXY(object2.getWidth() / 2.0, object2.getHeight() / 2.0);
                }
                trackerPanel2.repaint();
                tFrame.setSelectedTab(trackerPanel2);
                monitorDialog.close();
                if (Tracker.warnVariableDuration) {
                    TrackerIO.findBadVideoFrames(trackerPanel2, defaultBadFrameTolerance, true, true, true);
                }
            }
        } else {
            Class<?> clazz;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (zipFileFilter.accept(file) || trzFileFilter.accept(file)) {
                Object object;
                Object object6;
                Object object7;
                Object object8;
                Serializable serializable;
                monitorDialog.stop();
                String string7 = XML.getName(ResourceLoader.getNonURIPath(string));
                boolean bl3 = string.startsWith("http:/");
                if (bl3 && (serializable = ResourceLoader.downloadToOSPCache(string, string7, false)) != null) {
                    string = ((File)serializable).toURI().toString();
                    OSPLog.finest("downloaded zip file: " + string);
                }
                serializable = new ArrayList();
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                String[] stringArray = null;
                Set<String> set = ResourceLoader.getZipContents(string);
                String[] stringArray2 = set.iterator();
                while (stringArray2.hasNext()) {
                    object8 = stringArray2.next();
                    if (((String)object8).endsWith(".trk")) {
                        object7 = ResourceLoader.getURIPath(String.valueOf(string) + "!/" + (String)object8);
                        OSPLog.finest("found trk file " + object7);
                        ((ArrayList)serializable).add(object7);
                        continue;
                    }
                    if (((String)object8).endsWith(".pdf")) {
                        arrayList3.add(object8);
                        continue;
                    }
                    if (!((String)object8).endsWith(".html") && !((String)object8).endsWith(".htm")) continue;
                    object7 = XML.stripExtension(string7);
                    object6 = XML.getName((String)object8);
                    if (XML.stripExtension((String)object6).equals(String.valueOf(object7) + "_info")) continue;
                    arrayList2.add(object8);
                }
                if (((ArrayList)serializable).isEmpty() && arrayList3.isEmpty() && arrayList2.isEmpty()) {
                    object8 = TrackerRes.getString("TFrame.Dialog.LibraryError.Message");
                    JOptionPane.showMessageDialog(tFrame, String.valueOf(object8) + " \"" + string7 + "\".", TrackerRes.getString("TFrame.Dialog.LibraryError.Title"), 2);
                    return;
                }
                if (!((ArrayList)serializable).isEmpty()) {
                    object8 = new ArrayList();
                    object7 = ((ArrayList)serializable).iterator();
                    while (object7.hasNext()) {
                        stringArray2 = (String)object7.next();
                        ((ArrayList)object8).add(XML.stripExtension(XML.getName((String)stringArray2)));
                        object6 = new XMLControlElement((String)stringArray2);
                        if (object6.getObjectClassName().endsWith("TrackerPanel")) {
                            TrackerIO.findPageViewFiles((XMLControl)object6, hashMap);
                            continue;
                        }
                        if (stringArray != null || !object6.getObjectClassName().endsWith("TFrame")) continue;
                        stringArray = stringArray2;
                    }
                    if (!arrayList2.isEmpty()) {
                        object = stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
                        int n = stringArray2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            object7 = object[n2];
                            boolean bl4 = false;
                            for (String string8 : hashMap.keySet()) {
                                boolean bl5 = bl4 = bl4 || ((String)object7).endsWith(string8);
                            }
                            if (bl4) {
                                arrayList2.remove(object7);
                            }
                            Iterator<Object> iterator = ((ArrayList)object8).iterator();
                            while (iterator.hasNext()) {
                                String string8;
                                string8 = (String)iterator.next();
                                if (!((String)object7).contains(String.valueOf(string8) + "_info.")) continue;
                                arrayList2.remove(object7);
                            }
                            ++n2;
                        }
                    }
                    if (stringArray != null) {
                        ((ArrayList)serializable).clear();
                        ((ArrayList)serializable).add(stringArray);
                    }
                }
                object8 = new ArrayList();
                if (!arrayList2.isEmpty() || !arrayList3.isEmpty()) {
                    stringArray2 = new File(System.getProperty("java.io.tmpdir"));
                    object7 = ResourceLoader.unzip(string, (File)stringArray2, true);
                    Iterator<File> iterator = object7.iterator();
                    while (iterator.hasNext()) {
                        object6 = iterator.next();
                        ((File)object6).deleteOnExit();
                        object = XML.getPathRelativeTo(((File)object6).getPath(), stringArray2.getPath());
                        if (!arrayList3.contains(object) && !arrayList2.contains(object)) continue;
                        String string9 = ResourceLoader.getURIPath(((File)object6).getAbsolutePath());
                        ((ArrayList)object8).add(string9);
                    }
                    object6 = new Runnable((ArrayList)object8){
                        private final /* synthetic */ ArrayList val$tempFiles;
                        {
                            this.val$tempFiles = arrayList;
                        }

                        @Override
                        public void run() {
                            for (String string : this.val$tempFiles) {
                                OSPDesktop.displayURL(string);
                            }
                        }
                    };
                    new Thread((Runnable)object6).start();
                }
                if (!VideoIO.isCanceled()) {
                    monitorDialog.close();
                    TrackerIO.open((Collection<String>)((Object)serializable), tFrame, (ArrayList<String>)object8);
                    Tracker.addRecent(string3, false);
                    return;
                }
                monitorDialog.close();
                return;
            }
            XMLControlElement xMLControlElement = new XMLControlElement();
            string5 = xMLControlElement.read(string);
            if (VideoIO.isCanceled()) {
                return;
            }
            monitorDialog.stop();
            if (monitorDialog.isVisible()) {
                monitorDialog.setProgress(20);
            }
            if (TrackerPanel.class.isAssignableFrom(clazz = xMLControlElement.getObjectClass())) {
                XMLControl xMLControl = xMLControlElement.getChildControl("videoclip");
                if (xMLControl != null) {
                    int n = xMLControl.getInt("video_framecount");
                    if ((xMLControl = xMLControl.getChildControl("video")) != null) {
                        String string10 = xMLControl.getString("path");
                        monitorDialog.setName(string10);
                        monitorDialog.setFrameCount(n);
                    }
                }
                xMLControlElement.loadObject(trackerPanel2);
                trackerPanel2.frame = tFrame;
                trackerPanel2.defaultFileName = XML.getName(string);
                trackerPanel2.openedFromPath = string;
                TrackerIO.findPageViewFiles(xMLControlElement, trackerPanel2.pageViewFilePaths);
                if (arrayList != null) {
                    for (String string11 : arrayList) {
                        trackerPanel2.supplementalFilePaths.add(string11);
                    }
                }
                trackerPanel2.setDataFile(new File(ResourceLoader.getNonURIPath(string)));
                if (monitorDialog.isVisible()) {
                    monitorDialog.setProgress(80);
                }
                if (VideoIO.isCanceled()) {
                    return;
                }
                tFrame.addTab(trackerPanel2);
                if (monitorDialog.isVisible()) {
                    monitorDialog.setProgress(90);
                }
                tFrame.setSelectedTab(trackerPanel2);
                tFrame.showTrackControl(trackerPanel2);
                tFrame.showNotes(trackerPanel2);
                tFrame.refresh();
            } else {
                if (TFrame.class.isAssignableFrom(clazz)) {
                    monitorDialog.close();
                    xMLControlElement.loadObject(tFrame);
                    string2 = XML.forwardSlash(string2);
                    Tracker.addRecent(ResourceLoader.getNonURIPath(string2), false);
                    trackerPanel2 = tFrame.getTrackerPanel(tFrame.getSelectedTab());
                    if (trackerPanel2 != null) {
                        TMenuBar.getMenuBar(trackerPanel2).refresh();
                    }
                    return;
                }
                if (!xMLControlElement.failedToRead()) {
                    monitorDialog.close();
                    JOptionPane.showMessageDialog(trackerPanel2.getTFrame(), "\"" + XML.getName(string) + "\" " + MediaRes.getString("VideoIO.Dialog.XMLMismatch.Message"), MediaRes.getString("VideoIO.Dialog.XMLMismatch.Title"), 2);
                    return;
                }
                monitorDialog.close();
                JOptionPane.showMessageDialog(trackerPanel2.getTFrame(), String.valueOf(MediaRes.getString("VideoIO.Dialog.BadFile.Message")) + ResourceLoader.getNonURIPath(string));
                return;
            }
        }
        monitorDialog.close();
        string2 = XML.forwardSlash(string2);
        if (string5 != null && (string5.contains(".zip!") || string5.contains(".trz!") || string5.contains(".jar!"))) {
            string2 = XML.forwardSlash(string5);
        }
        Tracker.addRecent(ResourceLoader.getNonURIPath(string2), false);
        TMenuBar.getMenuBar(trackerPanel2).refresh();
        TTrackBar.refreshMemoryButton();
        trackerPanel2.changed = bl;
    }

    public static void open(File file, TFrame tFrame) {
        Object object;
        VideoType videoType = null;
        if (file == null && (object = TrackerIO.getChooserFiles("open")) != null) {
            file = object[0];
            videoType = videoEnginePanel.getSelectedVideoType();
        }
        if (file == null) {
            OSPLog.finer("no file to open");
            return;
        }
        tFrame.loadedFiles.clear();
        object = XML.getAbsolutePath(file);
        VideoType videoType2 = videoType;
        Runnable runnable = new Runnable((String)object, tFrame, videoType2){
            private final /* synthetic */ String val$path;
            private final /* synthetic */ TFrame val$frame;
            private final /* synthetic */ VideoType val$vidType;
            {
                this.val$path = string;
                this.val$frame = tFrame;
                this.val$vidType = videoType;
            }

            @Override
            public void run() {
                OSPLog.finest("opening File");
                TrackerIO.open(this.val$path, null, this.val$frame, this.val$vidType, null);
            }
        };
        if (loadInSeparateThread) {
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        } else {
            runnable.run();
        }
    }

    public static void open(URL uRL, TFrame tFrame) {
        if (uRL == null) {
            return;
        }
        String string = uRL.toExternalForm();
        OSPLog.finest("opening URL");
        TrackerIO.open(string, tFrame);
    }

    public static void open(final Collection<String> collection, final TFrame tFrame, final ArrayList<String> arrayList) {
        if (collection == null || collection.isEmpty()) {
            return;
        }
        tFrame.loadedFiles.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (String string : collection) {
                    OSPLog.finest("opening URL " + string);
                    TrackerIO.open(string, null, tFrame, null, arrayList);
                }
            }
        };
        if (loadInSeparateThread) {
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        } else {
            runnable.run();
        }
    }

    public static void open(final String string, final TFrame tFrame) {
        tFrame.loadedFiles.clear();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TrackerIO.open(string, null, tFrame, null, null);
            }
        };
        if (loadInSeparateThread) {
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        } else {
            runnable.run();
        }
    }

    public static File importFile(TrackerPanel trackerPanel) {
        File[] fileArray = TrackerIO.getChooserFiles("import file");
        if (fileArray == null) {
            return null;
        }
        File file = fileArray[0];
        OSPLog.fine("importing from " + file);
        XMLControlElement xMLControlElement = new XMLControlElement(file.getAbsolutePath());
        Class<?> clazz = xMLControlElement.getObjectClass();
        if (TrackerPanel.class.equals(clazz)) {
            ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerIO.Dialog.Import.Title"), TrackerRes.getString("TrackerIO.Dialog.Import.Message"), trackerPanel);
            if (TrackerIO.choose(xMLControlElement, listChooser)) {
                trackerPanel.changed = true;
                xMLControlElement.loadObject(trackerPanel);
            }
        } else {
            JOptionPane.showMessageDialog(trackerPanel.getTFrame(), String.valueOf(TrackerRes.getString("TrackerPanel.Dialog.LoadFailed.Message")) + SPACE + XML.getName(XML.getAbsolutePath(file)), TrackerRes.getString("TrackerPanel.Dialog.LoadFailed.Title"), 2);
            return null;
        }
        TTrackBar.refreshMemoryButton();
        return file;
    }

    public static File saveVideo(File file, TrackerPanel trackerPanel) {
        boolean bl;
        Video video = trackerPanel.getVideo();
        if (video == null) {
            return null;
        }
        if (video instanceof ImageVideo && !(bl = ((ImageVideo)video).saveInvalidImages())) {
            return null;
        }
        String string = (String)video.getProperty("absolutePath");
        String string2 = XML.getExtension(string);
        if (file == null) {
            File file2 = TrackerIO.getChooserFileForExtension(string2);
            if (file2 == null) {
                return null;
            }
            return TrackerIO.saveVideo(file2, trackerPanel);
        }
        boolean bl2 = ResourceLoader.copyAllFiles(new File(string), file);
        if (bl2) {
            Tracker.addRecent(XML.getAbsolutePath(file), false);
            TMenuBar.getMenuBar(trackerPanel).refresh();
            return file;
        }
        return null;
    }

    public static void importVideo(final TrackerPanel trackerPanel) {
        JFileChooser jFileChooser = TrackerIO.getChooser();
        jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.ImportVideo.Title"));
        File[] fileArray = TrackerIO.getChooserFiles("open video");
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        final VideoType videoType = videoEnginePanel.getSelectedVideoType();
        final File file = fileArray[0];
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TrackerIO.importVideo(file, trackerPanel, videoType);
                OSPLog.finest("completed importing file " + file);
            }
        };
        if (loadInSeparateThread) {
            Thread thread = new Thread(runnable);
            thread.setPriority(5);
            thread.setDaemon(true);
            thread.start();
        } else {
            runnable.run();
        }
    }

    public static void importVideo(File file, TrackerPanel trackerPanel, VideoType videoType) {
        while (Tracker.qtLoading && !Tracker.qtLoaded) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        String string = XML.getAbsolutePath(file);
        OSPLog.finest("importing file: " + string);
        TFrame tFrame = trackerPanel.getTFrame();
        tFrame.loadedFiles.clear();
        TrackerIO.open(string, trackerPanel, tFrame, videoType, null);
    }

    public static ArrayList<Integer> findBadVideoFrames(TrackerPanel trackerPanel, double d, boolean bl, boolean bl2, boolean bl3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        Video video = trackerPanel.getVideo();
        if (video == null) {
            return arrayList;
        }
        double d2 = video.getDuration();
        boolean bl4 = false;
        while (!bl4) {
            int n = 0;
            double d3 = d2 / (double)(video.getFrameCount() - arrayList.size());
            while (n < video.getFrameCount()) {
                double d4 = Math.abs(d3 - video.getFrameDuration(n)) / d3;
                if (d4 > d && !arrayList.contains(n)) {
                    d2 -= video.getFrameDuration(n);
                    arrayList.add(n);
                    break;
                }
                ++n;
            }
            boolean bl5 = bl4 = n == video.getFrameCount();
        }
        if (arrayList.contains(video.getFrameCount() - 1)) {
            arrayList.remove(new Integer(video.getFrameCount() - 1));
        }
        if (bl) {
            Object[] objectArray;
            int n;
            String string = TrackerRes.getString("TrackerIO.Dialog.DurationIsConstant.Message");
            int n2 = 1;
            if (arrayList.isEmpty() && bl2) {
                return arrayList;
            }
            if (!arrayList.isEmpty()) {
                n2 = 2;
                int n3 = arrayList.get(arrayList.size() - 1);
                int n4 = -1;
                int n5 = 0;
                n = 0;
                int n6 = -1;
                for (Integer object2 : arrayList) {
                    int n8 = object2 - n6 - 2;
                    if (n8 <= n4) continue;
                    n5 = n6 + 1;
                    n = object2 - 1;
                    n4 = n8;
                    n6 = object2;
                }
                VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
                if (videoClip.getEndFrameNumber() - n3 - 1 > n4) {
                    n5 = n3 + 1;
                    n = videoClip.getEndFrameNumber();
                }
                NumberFormat numberFormat = NumberFormat.getInstance();
                numberFormat.setMaximumFractionDigits(2);
                numberFormat.setMinimumFractionDigits(2);
                string = TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message1");
                string = String.valueOf(string) + SPACE + (int)(d * 100.0) + "%.";
                string = String.valueOf(string) + "\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message2");
                string = String.valueOf(string) + "\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message3");
                string = String.valueOf(string) + "\n\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Message4");
                for (Integer n7 : arrayList) {
                    string = String.valueOf(string) + SPACE + n7;
                    if (n7 >= n3) continue;
                    string = String.valueOf(string) + COMMA;
                }
                string = String.valueOf(string) + "\n\n" + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Recommended") + ":  " + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Start") + SPACE + n5 + ",  " + TrackerRes.getString("TrackerIO.Dialog.DurationVaries.End") + SPACE + n + "\n ";
            }
            String string2 = TrackerRes.getString("Dialog.Button.OK");
            String string3 = TrackerRes.getString("Tracker.Dialog.NoVideoEngine.Checkbox");
            if (bl3) {
                String[] stringArray = new String[2];
                stringArray[0] = string3;
                objectArray = stringArray;
                stringArray[1] = string2;
            } else {
                Object[] objectArray2 = new String[1];
                objectArray = objectArray2;
                objectArray2[0] = string2;
            }
            Object[] objectArray3 = objectArray;
            n = JOptionPane.showOptionDialog(theFrame, string, TrackerRes.getString("TrackerIO.Dialog.DurationVaries.Title"), 0, n2, null, objectArray3, string2);
            if (n >= 0 && n < objectArray3.length && ((String)objectArray3[n]).equals(string3)) {
                Tracker.warnVariableDuration = false;
            }
        }
        return arrayList;
    }

    public static File[] insertImagesIntoVideo(TrackerPanel trackerPanel, int n) {
        JFileChooser jFileChooser = TrackerIO.getChooser();
        jFileChooser.setDialogTitle(TrackerRes.getString("TrackerIO.Dialog.AddImage.Title"));
        File[] fileArray = TrackerIO.getChooserFiles("insert image");
        return TrackerIO.insertImagesIntoVideo(fileArray, trackerPanel, n);
    }

    public static File[] insertImagesIntoVideo(File[] fileArray, TrackerPanel trackerPanel, int n) {
        if (fileArray == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            File[] fileArray2;
            Object object;
            File file = fileArray[n2];
            if (imageFileFilter.accept(file)) {
                try {
                    object = (ImageVideo)trackerPanel.getVideo();
                    ((ImageVideo)object).insert(file.getAbsolutePath(), n, fileArray.length == 1);
                    fileArray2 = trackerPanel.getPlayer().getVideoClip();
                    fileArray2.setStepCount(((VideoAdapter)object).getFrameCount());
                    trackerPanel.getPlayer().setStepNumber(fileArray2.frameToStep(n++));
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            } else {
                object = TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Message1");
                if (n2 < fileArray.length - 1) {
                    object = String.valueOf(object) + XML.NEW_LINE + TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Message2");
                    int n3 = JOptionPane.showConfirmDialog(trackerPanel, "\"" + file + "\" " + (String)object, TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Title"), 2);
                    if (n3 != 0) {
                        if (n2 == 0) {
                            return null;
                        }
                        File[] fileArray3 = new File[n2];
                        System.arraycopy(fileArray, 0, fileArray3, 0, n2);
                        TTrackBar.refreshMemoryButton();
                        return fileArray3;
                    }
                } else {
                    JOptionPane.showMessageDialog(trackerPanel.getTFrame(), "\"" + file + "\" " + (String)object, TrackerRes.getString("TrackerIO.Dialog.NotAnImage.Title"), 2);
                    if (n2 == 0) {
                        return null;
                    }
                    fileArray2 = new File[n2];
                    System.arraycopy(fileArray, 0, fileArray2, 0, n2);
                    TTrackBar.refreshMemoryButton();
                    return fileArray2;
                }
            }
            ++n2;
        }
        TTrackBar.refreshMemoryButton();
        return fileArray;
    }

    public static File exportFile(TrackerPanel trackerPanel) {
        XMLControlElement xMLControlElement = new XMLControlElement(trackerPanel);
        ListChooser listChooser = new ListChooser(TrackerRes.getString("TrackerIO.Dialog.Export.Title"), TrackerRes.getString("TrackerIO.Dialog.Export.Message"), trackerPanel);
        if (TrackerIO.choose(xMLControlElement, listChooser)) {
            Object object;
            File[] fileArray = TrackerIO.getChooserFiles("export file");
            if (fileArray == null) {
                return null;
            }
            File file = fileArray[0];
            if (!defaultXMLExt.equals(TrackerIO.getExtension(file))) {
                object = XML.stripExtension(file.getPath());
                file = new File(String.valueOf(object) + "." + defaultXMLExt);
            }
            if (!TrackerIO.canWrite(file)) {
                return null;
            }
            try {
                object = new FileWriter(file);
                xMLControlElement.write((Writer)object);
                return file;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public static boolean choose(XMLControl xMLControl, ListChooser listChooser) {
        ArrayList<XMLControl> arrayList = new ArrayList<XMLControl>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<XMLControl> arrayList3 = new ArrayList<XMLControl>();
        ArrayList<Object> arrayList4 = new ArrayList<Object>();
        Object var6_6 = null;
        Object var7_7 = null;
        XMLControl[] xMLControlArray = xMLControl.getChildControls();
        int n = 0;
        while (n < xMLControlArray.length) {
            Object object = xMLControlArray[n].getPropertyName();
            if (((String)object).equals("coords")) {
                object = TrackerRes.getString("TMenuBar.MenuItem.Coords");
            } else if (((String)object).equals("videoclip")) {
                object = TrackerRes.getString("TMenuBar.MenuItem.VideoClip");
            }
            arrayList3.add(xMLControlArray[n]);
            if (!((String)object).equals("clipcontrol") && !((String)object).equals("toolbar")) {
                arrayList.add(xMLControlArray[n]);
                arrayList2.add((String)object);
            }
            ++n;
        }
        for (Object object : xMLControl.getPropertyContent()) {
            if ("tracks".indexOf(object.getPropertyName()) != -1) {
                xMLControlArray = object.getChildControls();
                int n2 = 0;
                while (n2 < xMLControlArray.length) {
                    arrayList.add(xMLControlArray[n2]);
                    arrayList2.add(xMLControlArray[n2].getPropertyName());
                    arrayList3.add(xMLControlArray[n2]);
                    ++n2;
                }
                continue;
            }
            if (object.getPropertyType().equals("object")) continue;
            arrayList4.add(object);
        }
        if (listChooser.choose(arrayList, arrayList2)) {
            boolean bl;
            XMLProperty xMLProperty;
            for (Object object : arrayList4) {
                xMLControl.setValue(object.getPropertyName(), null);
            }
            xMLControl.getPropertyContent().removeAll(arrayList4);
            boolean bl2 = false;
            for (XMLControl xMLControl2 : arrayList3) {
                Object object;
                if (xMLControl2 == var7_7) {
                    bl2 = arrayList.contains(xMLControl2);
                    continue;
                }
                if (xMLControl2 == var6_6) {
                    if (arrayList.contains(xMLControl2) || bl2) continue;
                    object = xMLControl2.getParentProperty();
                    xMLControl.setValue(object.getPropertyName(), null);
                    xMLControl.getPropertyContent().remove(object);
                    continue;
                }
                if (arrayList.contains(xMLControl2)) continue;
                object = xMLControl2.getParentProperty();
                xMLProperty = object.getParentProperty();
                if (xMLProperty == xMLControl) {
                    xMLControl.setValue(object.getPropertyName(), null);
                }
                xMLProperty.getPropertyContent().remove(object);
            }
            boolean bl3 = true;
            for (Object object : xMLControl.getPropertyContent()) {
                xMLProperty = (XMLProperty)object;
                if ("tracks".indexOf(xMLProperty.getPropertyName()) <= -1) continue;
                boolean bl4 = bl = xMLProperty.getChildControls().length == 0;
            }
            if (bl) {
                xMLControl.setValue("tracks", null);
            }
            return true;
        }
        return false;
    }

    public static void copyXML(Object object) {
        XMLControlElement xMLControlElement = new XMLControlElement(object);
        StringSelection stringSelection = new StringSelection(xMLControlElement.toXML());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static boolean pasteXML(TrackerPanel trackerPanel) {
        Class<?> clazz;
        XMLControlElement xMLControlElement;
        block11: {
            block12: {
                block10: {
                    block9: {
                        try {
                            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                            Transferable transferable = clipboard.getContents(null);
                            xMLControlElement = new XMLControlElement();
                            xMLControlElement.readXML((String)transferable.getTransferData(DataFlavor.stringFlavor));
                            clazz = xMLControlElement.getObjectClass();
                            if (!xMLControlElement.failedToRead() && clazz != null) break block9;
                            return false;
                        }
                        catch (Exception exception) {}
                    }
                    if (!TTrack.class.isAssignableFrom(clazz)) break block10;
                    TTrack tTrack = (TTrack)xMLControlElement.loadObject(null);
                    if (tTrack != null) {
                        trackerPanel.addTrack(tTrack);
                        trackerPanel.setSelectedTrack(tTrack);
                        return true;
                    }
                    break block11;
                }
                if (!VideoClip.class.isAssignableFrom(clazz)) break block12;
                VideoClip videoClip = (VideoClip)xMLControlElement.loadObject(null);
                if (videoClip != null) {
                    VideoClip videoClip2 = trackerPanel.getPlayer().getVideoClip();
                    XMLControlElement xMLControlElement2 = new XMLControlElement(videoClip2);
                    trackerPanel.getPlayer().setVideoClip(videoClip);
                    Undo.postVideoReplace(trackerPanel, xMLControlElement2);
                    return true;
                }
                break block11;
            }
            if (!ImageCoordSystem.class.isAssignableFrom(clazz)) break block11;
            XMLControlElement xMLControlElement3 = new XMLControlElement(trackerPanel.getCoords());
            xMLControlElement.loadObject(trackerPanel.getCoords());
            Undo.postCoordsEdit(trackerPanel, xMLControlElement3);
            return true;
        }
        if (TrackerPanel.class.isAssignableFrom(clazz)) {
            xMLControlElement.loadObject(trackerPanel);
            return true;
        }
        return false;
    }

    public static void copyTable(DataTable dataTable, boolean bl, String string) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringBuffer stringBuffer = TrackerIO.getData(dataTable, bl);
        if (!(string = string.replace(' ', '_')).endsWith(XML.NEW_LINE)) {
            string = String.valueOf(string) + XML.NEW_LINE;
        }
        StringSelection stringSelection = new StringSelection(String.valueOf(string) + stringBuffer.toString());
        clipboard.setContents(stringSelection, stringSelection);
    }

    public static void copyImage(Image image) {
        TransferImage transferImage = new TransferImage(image);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferImage, null);
    }

    public static Image getClipboardImage() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                return image;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static StringBuffer getData(DataTable dataTable, boolean bl) {
        Object object;
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        int[] nArray = dataTable.getSelectedRows();
        int[] nArray2 = dataTable.getSelectedColumns();
        int[] nArray3 = null;
        int[] nArray4 = null;
        if (nArray.length == 0) {
            dataTable.selectAll();
            nArray3 = nArray;
            nArray4 = nArray2;
            nArray = dataTable.getSelectedRows();
            nArray2 = dataTable.getSelectedColumns();
        }
        int n3 = 0;
        while (n3 < nArray2.length) {
            if (!dataTable.isRowNumberVisible() || nArray2[n3] != 0) {
                stringBuffer.append(dataTable.getColumnName(nArray2[n3]));
                if (n3 < nArray2.length - 1) {
                    stringBuffer.append(delimiter);
                }
            }
            ++n3;
        }
        stringBuffer.append(XML.NEW_LINE);
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance();
        decimalFormat.applyPattern("0.000000000E0");
        DateFormat dateFormat = DateFormat.getInstance();
        int n4 = 0;
        while (n4 < nArray.length) {
            n2 = 0;
            while (n2 < nArray2.length) {
                n = dataTable.convertColumnIndexToModel(nArray2[n2]);
                if (!dataTable.isRowNumberVisible() || n != 0) {
                    object = null;
                    if (bl) {
                        object = dataTable.getFormattedValueAt(nArray[n4], nArray2[n2]);
                    } else {
                        object = dataTable.getValueAt(nArray[n4], nArray2[n2]);
                        if (object != null) {
                            if (object instanceof Number) {
                                object = decimalFormat.format(object);
                            } else if (object instanceof Date) {
                                object = dateFormat.format(object);
                            }
                        }
                    }
                    if (object != null) {
                        stringBuffer.append(object);
                    }
                    if (n2 < nArray2.length - 1) {
                        stringBuffer.append(delimiter);
                    }
                }
                ++n2;
            }
            stringBuffer.append(XML.NEW_LINE);
            ++n4;
        }
        if (nArray3 != null) {
            dataTable.clearSelection();
            object = nArray3;
            n = nArray3.length;
            n2 = 0;
            while (n2 < n) {
                n4 = object[n2];
                dataTable.addRowSelectionInterval(n4, n4);
                ++n2;
            }
            object = nArray4;
            n = nArray4.length;
            n2 = 0;
            while (n2 < n) {
                n4 = object[n2];
                dataTable.addColumnSelectionInterval(n4, n4);
                ++n2;
            }
        }
        return stringBuffer;
    }

    public static void setDelimiter(String string) {
        if (string != null) {
            delimiter = string;
        }
    }

    public static String getDelimiter() {
        return delimiter;
    }

    public static void addCustomDelimiter(String string) {
        if (!delimiters.values().contains(string)) {
            customDelimiters.put(string, string);
        }
    }

    public static void removeCustomDelimiter(String string) {
        if (TrackerIO.getDelimiter().equals(string)) {
            TrackerIO.setDelimiter(defaultDelimiter);
        }
        String string2 = null;
        for (String string3 : customDelimiters.keySet()) {
            if (!customDelimiters.get(string3).equals(string)) continue;
            string2 = string3;
        }
        if (string2 != null) {
            customDelimiters.remove(string2);
        }
    }

    private static void findPageViewFiles(XMLControl xMLControl, Map<String, String> map) {
        String string = xMLControl.toXML();
        String string2 = "PageTView$TabView";
        int n = string.indexOf(string2);
        while (n > -1) {
            Resource resource;
            string = string.substring(n + string2.length());
            string2 = "<property name=\"text\" type=\"string\">";
            n = string.indexOf(string2);
            String string3 = string.substring(n + string2.length());
            n = string3.indexOf("</property>");
            if (((string3 = string3.substring(0, n)).endsWith(".html") || string3.endsWith(".htm")) && (resource = ResourceLoader.getResource(string3)) != null) {
                String string4 = resource.getURL().toExternalForm();
                String string5 = ResourceLoader.getNonURIPath(resource.getAbsolutePath());
                int n2 = string5.indexOf("!/");
                if (n2 > 0) {
                    File file = new File(System.getProperty("java.io.tmpdir"));
                    string5 = string5.substring(0, n2);
                    ResourceLoader.unzip(string5, file, true);
                    file = new File(file, string3);
                    if (file.exists()) {
                        resource = ResourceLoader.getResource(file.getAbsolutePath());
                        string4 = resource.getURL().toExternalForm();
                    } else {
                        string3 = null;
                    }
                }
                if (string3 != null) {
                    map.put(string3, string4);
                }
            }
            string2 = "PageTView$TabView";
            n = string.indexOf(string2);
        }
    }

    static class ComponentImage
    implements Printable {
        private BufferedImage image;
        Component c;

        ComponentImage(Component component) {
            this.c = component;
            if (component instanceof JFrame) {
                component = ((JFrame)component).getContentPane();
            } else if (component instanceof JDialog) {
                component = ((JDialog)component).getContentPane();
            }
            int n = component.isVisible() ? component.getWidth() : component.getPreferredSize().width;
            int n2 = component.isVisible() ? component.getHeight() : component.getPreferredSize().height;
            this.image = new BufferedImage(n, n2, 5);
            if (component instanceof Renderable) {
                this.image = ((Renderable)((Object)component)).render(this.image);
            } else {
                Graphics graphics = this.image.getGraphics();
                component.paint(graphics);
                graphics.dispose();
            }
        }

        BufferedImage getImage() {
            return this.image;
        }

        void copyToClipboard() {
            TrackerIO.copyImage(this.image);
        }

        public void print() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PageFormat pageFormat = new PageFormat();
            Book book = new Book();
            book.append(this, pageFormat);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException printerException) {
                    JOptionPane.showMessageDialog(this.c, TrackerRes.getString("TActions.Dialog.PrintError.Message"), TrackerRes.getString("TActions.Dialog.PrintError.Title"), 0);
                }
            }
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            if (n >= 1) {
                return 1;
            }
            if (graphics == null) {
                return 1;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            double d = pageFormat.getImageableWidth() / (double)this.image.getWidth();
            double d2 = pageFormat.getImageableHeight() / (double)this.image.getHeight();
            double d3 = Math.min(d, d2);
            d3 = Math.min(d3, 1.0);
            graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            graphics2D.scale(d3, d3);
            graphics2D.drawImage((Image)this.image, 0, 0, null);
            return 0;
        }
    }
}

