/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableColumnModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TableTrackView;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.FontSizer;

public class TableTView
extends TrackChooserTView {
    protected Icon icon = new ImageIcon(Tracker.class.getResource("resources/images/datatable.gif"));
    protected JDialog columnsDialog;
    protected JLabel trackLabel;
    protected JButton defineButton;
    protected JButton closeButton;
    protected JButton textColumnButton;
    protected JPanel buttonPanel;
    protected boolean dialogVisible;

    public TableTView(TrackerPanel trackerPanel) {
        super(trackerPanel);
        this.getColumnsDialog();
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Table");
    }

    @Override
    public Icon getViewIcon() {
        return this.icon;
    }

    @Override
    protected TrackView createTrackView(TTrack tTrack) {
        TableTrackView tableTrackView = new TableTrackView(tTrack, this.trackerPanel, this);
        FontSizer.setFonts(tableTrackView, FontSizer.getLevel());
        return tableTrackView;
    }

    @Override
    public void setSelectedTrack(TTrack tTrack) {
        if (tTrack == null) {
            this.noDataLabel.setText(TrackerRes.getString("TableTView.Label.NoData"));
        }
        super.setSelectedTrack(tTrack);
        if (this.columnsDialog == null || !this.columnsDialog.isVisible()) {
            return;
        }
        if (this.getSelectedTrack() == null) {
            this.columnsDialog.setVisible(false);
        } else {
            this.showColumnsDialog(this.getSelectedTrack());
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.columnsDialog == null) {
            return;
        }
        FontSizer.setFonts(this.columnsDialog, FontSizer.getLevel());
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.Close"));
        this.defineButton.setText(TrackerRes.getString("TView.Menuitem.Define"));
        this.defineButton.setToolTipText(TrackerRes.getString("Button.Define.Tooltip"));
        this.columnsDialog.setTitle(TrackerRes.getString("TableTView.Dialog.TableColumns.Title"));
        this.textColumnButton.setText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
        this.textColumnButton.setToolTipText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Tooltip"));
    }

    protected void showColumnsDialog(TTrack tTrack) {
        if (this.getColumnsDialog() == null) {
            return;
        }
        this.refreshColumnsDialog(tTrack);
        Point point = new Frame().getLocation();
        if (this.columnsDialog.getLocation().x == point.x) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.columnsDialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.columnsDialog.getBounds().height) / 2;
            this.columnsDialog.setLocation(n, n2);
        }
        if (!this.columnsDialog.isVisible()) {
            this.columnsDialog.setVisible(true);
        }
    }

    protected void refreshColumnsDialog(TTrack tTrack) {
        if (this.getColumnsDialog() == null) {
            return;
        }
        Container container = this.columnsDialog.getContentPane();
        container.removeAll();
        this.trackLabel.setIcon(tTrack.getFootprint().getIcon(21, 16));
        this.trackLabel.setText(tTrack.getName());
        container.add(this.trackLabel);
        TableTrackView tableTrackView = (TableTrackView)this.getTrackView(tTrack);
        tableTrackView.refreshColumnCheckboxes();
        container.add(tableTrackView.columnsScroller);
        container.add(this.buttonPanel);
        FontSizer.setFonts(container, FontSizer.getLevel());
        container.setPreferredSize(null);
        Dimension dimension = container.getPreferredSize();
        dimension.height = Math.min(dimension.height, 300);
        container.setPreferredSize(dimension);
        this.columnsDialog.pack();
        this.textColumnButton.setEnabled(!tTrack.isLocked());
        this.columnsDialog.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (propertyChangeEvent.getNewValue() == this.trackerPanel && this.isVisible()) {
                if (this.columnsDialog != null) {
                    this.columnsDialog.setVisible(this.dialogVisible);
                }
            } else {
                boolean bl = this.dialogVisible;
                if (this.columnsDialog != null) {
                    this.columnsDialog.setVisible(false);
                }
                this.dialogVisible = bl;
            }
        } else if (propertyChangeEvent.getPropertyName().equals("function")) {
            super.propertyChange(propertyChangeEvent);
            TTrack tTrack = this.getSelectedTrack();
            if (tTrack != null && this.columnsDialog != null) {
                this.refreshColumnsDialog(tTrack);
                JViewport jViewport = ((TableTrackView)this.getTrackView((TTrack)tTrack)).columnsScroller.getViewport();
                Dimension dimension = jViewport.getViewSize();
                int n = jViewport.getExtentSize().height;
                jViewport.setViewPosition(new Point(0, dimension.height - n));
            }
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    private JDialog getColumnsDialog() {
        TFrame tFrame = this.trackerPanel.getTFrame();
        if (this.columnsDialog == null && tFrame != null) {
            this.columnsDialog = new JDialog(tFrame, false){

                @Override
                public void setVisible(boolean bl) {
                    super.setVisible(bl);
                    TableTView.this.dialogVisible = bl;
                }
            };
            this.columnsDialog.setTitle(TrackerRes.getString("TableTView.Dialog.TableColumns.Title"));
            this.columnsDialog.setResizable(false);
            tFrame.addPropertyChangeListener("tab", this);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 3));
            this.columnsDialog.setContentPane(jPanel);
            this.closeButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
            this.closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TableTView.this.columnsDialog.setVisible(false);
                }
            });
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TTrack tTrack = TableTView.this.getSelectedTrack();
                    if (tTrack != null) {
                        TableTView.this.trackerPanel.getDataBuilder().setSelectedPanel(tTrack.getName());
                        TableTView.this.trackerPanel.getDataBuilder().setVisible(true);
                    }
                }
            };
            this.defineButton = new JButton(TrackerRes.getString("TView.Menuitem.Define"));
            this.defineButton.addActionListener(actionListener);
            this.defineButton.setToolTipText(TrackerRes.getString("Button.Define.Tooltip"));
            this.textColumnButton = new JButton(TrackerRes.getString("TableTrackView.Menu.TextColumn.Text"));
            this.textColumnButton.setToolTipText(TrackerRes.getString("TableTrackView.Menu.TextColumn.Tooltip"));
            this.textColumnButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    TableTrackView tableTrackView = (TableTrackView)TableTView.this.getTrackView(TableTView.this.getSelectedTrack());
                    tableTrackView.getPopup();
                    jPopupMenu.add(tableTrackView.createTextColumnItem);
                    if (tableTrackView.deleteTextColumnMenu.getMenuComponentCount() > 0) {
                        jPopupMenu.add(tableTrackView.deleteTextColumnMenu);
                        jPopupMenu.add(tableTrackView.renameTextColumnMenu);
                    }
                    FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                    jPopupMenu.show(TableTView.this.textColumnButton, 0, TableTView.this.textColumnButton.getHeight());
                }
            });
            this.buttonPanel = new JPanel();
            this.buttonPanel.add(this.defineButton);
            this.buttonPanel.add(this.textColumnButton);
            this.buttonPanel.add(this.closeButton);
            this.trackLabel = new JLabel();
            this.trackLabel.setBorder(BorderFactory.createEmptyBorder(7, 0, 6, 0));
            this.trackLabel.setAlignmentX(0.5f);
        }
        return this.columnsDialog;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TableTView tableTView = (TableTView)object;
            TTrack tTrack = tableTView.getSelectedTrack();
            if (tTrack != null) {
                xMLControl.setValue("selected_track", tTrack.getName());
                ArrayList<Object> arrayList = new ArrayList<Object>();
                Map map = tableTView.trackViews;
                for (Object object2 : map.keySet()) {
                    if (!((TrackView)map.get(object2)).isCustomState()) continue;
                    arrayList.add(object2);
                }
                if (!arrayList.isEmpty()) {
                    String[][][] stringArray;
                    Object object2;
                    object2 = new ArrayList();
                    String[][] stringArrayArray = new String[arrayList.size()][];
                    Iterator iterator = arrayList.iterator();
                    int n = -1;
                    while (iterator.hasNext()) {
                        tTrack = (TTrack)iterator.next();
                        stringArray = (String[][][])tableTView.getTrackView(tTrack);
                        String[] stringArray2 = stringArray.getOrderedVisibleColumns();
                        stringArrayArray[++n] = new String[stringArray2.length + 1];
                        System.arraycopy(stringArray2, 0, stringArrayArray[n], 1, stringArray2.length);
                        stringArrayArray[n][0] = tTrack.getName();
                        String[][] stringArray3 = stringArray.getColumnFormats();
                        if (stringArray3.length <= 0) continue;
                        String[][] stringArray4 = new String[stringArray3.length][3];
                        int n2 = 0;
                        while (n2 < stringArray3.length) {
                            stringArray4[n2][0] = tTrack.getName();
                            stringArray4[n2][1] = stringArray3[n2][0];
                            stringArray4[n2][2] = stringArray3[n2][1];
                            ++n2;
                        }
                        ((ArrayList)object2).add(stringArray4);
                    }
                    xMLControl.setValue("track_columns", stringArrayArray);
                    if (!((ArrayList)object2).isEmpty()) {
                        stringArray = (String[][][])((ArrayList)object2).toArray((T[])new String[0][0][0]);
                        xMLControl.setValue("column_formats", stringArray);
                    }
                }
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            String[][] stringArray;
            Object object2;
            Object object32;
            String[][][] stringArray2;
            TableTView tableTView = (TableTView)object;
            String[][] stringArray3 = (String[][])xMLControl.getObject("track_columns");
            if (stringArray3 != null) {
                stringArray2 = tableTView.trackViews;
                for (Object object32 : stringArray2.keySet()) {
                    object2 = (TableTrackView)tableTView.getTrackView((TTrack)object32);
                    if (object2 == null) continue;
                    int n = 0;
                    while (n < stringArray3.length) {
                        String[] stringArray4 = stringArray3[n];
                        if (stringArray4[0].equals(((TTrack)object32).getName())) {
                            Object object4;
                            String[] stringArray5;
                            object2.refresh = false;
                            int n2 = 0;
                            while (n2 < object2.checkBoxes.length) {
                                object2.checkBoxes[n2].setSelected(false);
                                int n3 = object2.data.getDatasets().size();
                                if (n2 >= n3) {
                                    stringArray5 = ((TTrack)object32).getTextColumnNames().get(n2 - n3);
                                    object2.textColumnsVisible.remove(stringArray5);
                                }
                                ++n2;
                            }
                            n2 = 1;
                            while (n2 < stringArray4.length) {
                                if (stringArray4[n2].equals("theta") && object32 instanceof PointMass) {
                                    stringArray4[n2] = "\u03b8r";
                                } else if (stringArray4[n2].equals("theta")) {
                                    stringArray4[n2] = "\u03b8";
                                } else if (stringArray4[n2].equals("theta_v")) {
                                    stringArray4[n2] = "\u03b8v";
                                } else if (stringArray4[n2].equals("theta_a")) {
                                    stringArray4[n2] = "\u03b8a";
                                } else if (stringArray4[n2].equals("theta_p")) {
                                    stringArray4[n2] = "\u03b8p";
                                } else if (stringArray4[n2].equals("n") && object32 instanceof PointMass) {
                                    stringArray4[n2] = "step";
                                } else if (stringArray4[n2].equals("KE")) {
                                    stringArray4[n2] = "K";
                                } else if (stringArray4[n2].equals("x-comp")) {
                                    stringArray4[n2] = "x";
                                } else if (stringArray4[n2].equals("y-comp")) {
                                    stringArray4[n2] = "y";
                                } else if (stringArray4[n2].equals("x_tail")) {
                                    stringArray4[n2] = "xtail";
                                } else if (stringArray4[n2].equals("y_tail")) {
                                    stringArray4[n2] = "ytail";
                                }
                                object2.setVisible(stringArray4[n2], true);
                                ++n2;
                            }
                            stringArray = object2.getVisibleColumns();
                            String[] stringArray6 = new String[stringArray.length + 1];
                            stringArray6[0] = ((TTrack)object32).getDataName(0);
                            System.arraycopy(stringArray, 0, stringArray6, 1, stringArray.length);
                            stringArray5 = new String[stringArray4.length - 1];
                            System.arraycopy(stringArray4, 1, stringArray5, 0, stringArray5.length);
                            final int[] nArray = new int[stringArray5.length];
                            int n4 = 0;
                            while (n4 < stringArray5.length) {
                                object4 = stringArray5[n4];
                                int n5 = 0;
                                while (n5 < stringArray6.length) {
                                    if (stringArray6[n5].equals(object4)) {
                                        nArray[n4] = n5;
                                    }
                                    ++n5;
                                }
                                ++n4;
                            }
                            final TableColumnModel tableColumnModel = object2.dataTable.getColumnModel();
                            object4 = new Runnable(){

                                @Override
                                public void run() {
                                    int n = 0;
                                    while (n < nArray.length) {
                                        int n2 = 0;
                                        while (n2 < nArray.length) {
                                            if (tableColumnModel.getColumn(n2).getModelIndex() == nArray[n]) {
                                                tableColumnModel.moveColumn(n2, n);
                                                break;
                                            }
                                            ++n2;
                                        }
                                        ++n;
                                    }
                                }
                            };
                            SwingUtilities.invokeLater((Runnable)object4);
                            object2.refresh = true;
                        }
                        ++n;
                    }
                }
            }
            if ((stringArray2 = (String[][][])xMLControl.getObject("column_formats")) != null) {
                object32 = tableTView.trackViews;
                for (Object object5 : object32.keySet()) {
                    TableTrackView tableTrackView = (TableTrackView)tableTView.getTrackView((TTrack)object5);
                    if (tableTrackView == null) continue;
                    int n = 0;
                    while (n < stringArray2.length) {
                        stringArray = stringArray2[n];
                        if (stringArray[0][0].equals(((TTrack)object5).getName())) {
                            tableTrackView.refresh = false;
                            int n6 = 0;
                            while (n6 < stringArray.length) {
                                tableTrackView.dataTable.setFormatPattern(stringArray[n6][1], stringArray[n6][2]);
                                ++n6;
                            }
                            tableTrackView.refresh = true;
                        }
                        ++n;
                    }
                }
            }
            if ((object32 = tableTView.getTrack(xMLControl.getString("selected_track"))) != null) {
                Object object5;
                tableTView.setSelectedTrack((TTrack)object32);
                object5 = (TableTrackView)tableTView.getTrackView((TTrack)object32);
                object2 = (String[])xMLControl.getObject("visible_columns");
                if (object2 != null) {
                    ((TableTrackView)object5).refresh = false;
                    int n = 0;
                    while (n < ((TableTrackView)object5).checkBoxes.length) {
                        ((TableTrackView)object5).checkBoxes[n].setSelected(false);
                        ++n;
                    }
                    n = 0;
                    while (n < ((String[])object2).length) {
                        ((TableTrackView)object5).setVisible(object2[n], true);
                        ++n;
                    }
                    ((TableTrackView)object5).refresh = true;
                    ((TableTrackView)object5).refresh(tableTView.trackerPanel.getFrameNumber());
                }
            }
            return object;
        }
    }
}

