/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.Calibration;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.OffsetOrigin;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class TTrackBar
extends JToolBar
implements PropertyChangeListener {
    protected static Map<TrackerPanel, TTrackBar> trackbars = new HashMap<TrackerPanel, TTrackBar>();
    protected static JButton memoryButton;
    protected static JButton newVersionButton;
    protected static boolean outOfMemory;
    protected static Icon smallSelectIcon;
    protected static JButton testButton;
    protected static Timer testTimer;
    protected static boolean showOutOfMemoryDialog;
    protected TrackerPanel trackerPanel;
    protected Component toolbarEnd;
    protected int toolbarComponentHeight;
    protected TButton trackButton;
    protected TButton selectButton;
    protected JLabel emptyLabel = new JLabel();
    protected JPopupMenu selectPopup = new JPopupMenu();

    static {
        outOfMemory = false;
        showOutOfMemoryDialog = true;
        smallSelectIcon = new ImageIcon(Tracker.class.getResource("resources/images/small_select.gif"));
        if (Tracker.testOn) {
            testButton = new JButton("Save Origin/Angle Data");
            testButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TFrame tFrame = (TFrame)testButton.getTopLevelAncestor();
                    if (tFrame != null && tFrame.getSelectedTab() > -1) {
                        if (testTimer == null) {
                            testTimer = new Timer(500, new ActionListener(){

                                @Override
                                public void actionPerformed(ActionEvent actionEvent) {
                                    if (!testTimer.isRepeats()) {
                                        testTimer.stop();
                                        testTimer = null;
                                    }
                                }
                            });
                            testTimer.setInitialDelay(20);
                            testTimer.setRepeats(false);
                            testTimer.start();
                        } else {
                            testTimer.stop();
                            testTimer = null;
                        }
                    }
                }
            });
        }
        memoryButton = new TButton(){

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TTrackBar.Memory.Menu.SetSize"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TFrame tFrame = (TFrame)memoryButton.getTopLevelAncestor();
                        if (tFrame != null && tFrame.getSelectedTab() > -1) {
                            TrackerPanel trackerPanel = tFrame.getTrackerPanel(tFrame.getSelectedTab());
                            TActions.getAction("config", trackerPanel).actionPerformed(null);
                            JPanel jPanel = tFrame.prefsDialog.runtimePanel;
                            tFrame.prefsDialog.tabbedPane.setSelectedComponent(jPanel);
                        }
                    }
                });
                return jPopupMenu;
            }
        };
        Font font = memoryButton.getFont();
        memoryButton.setFont(font.deriveFont(0, font.getSize() - 1));
        memoryButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TTrackBar.refreshMemoryButton();
            }
        });
        Border border = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border border2 = BorderFactory.createLineBorder(Color.GRAY);
        memoryButton.setBorder(BorderFactory.createCompoundBorder(border2, border));
        newVersionButton = new TButton(){

            @Override
            public JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("TTrackBar.Popup.MenuItem.Upgrade"));
                jPopupMenu.add(jMenuItem);
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string = "http://" + Tracker.trackerWebsite;
                        OSPDesktop.displayURL(string);
                    }
                });
                JMenuItem jMenuItem2 = new JMenuItem(TrackerRes.getString("TTrackBar.Popup.MenuItem.Ignore"));
                jPopupMenu.add(jMenuItem2);
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Tracker.newerVersion = null;
                        Tracker.lastMillisChecked = System.currentTimeMillis();
                        TFrame tFrame = (TFrame)newVersionButton.getTopLevelAncestor();
                        if (tFrame != null && tFrame.getSelectedTab() > -1) {
                            TrackerPanel trackerPanel = tFrame.getTrackerPanel(tFrame.getSelectedTab());
                            TTrackBar tTrackBar = trackbars.get(trackerPanel);
                            tTrackBar.refresh();
                        }
                    }
                });
                return jPopupMenu;
            }
        };
        newVersionButton.setFont(font.deriveFont(0, font.getSize() - 1));
        newVersionButton.setForeground(Color.GREEN.darker());
        newVersionButton.setBorder(BorderFactory.createCompoundBorder(border2, border));
        OSPLog.getOSPLog().addPropertyChangeListener("error", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
                if (n == 1) {
                    outOfMemory = true;
                }
            }
        });
    }

    public static synchronized TTrackBar getTrackbar(TrackerPanel trackerPanel) {
        TTrackBar tTrackBar = trackbars.get(trackerPanel);
        if (tTrackBar == null) {
            tTrackBar = new TTrackBar(trackerPanel);
            trackbars.put(trackerPanel, tTrackBar);
        }
        return tTrackBar;
    }

    public void setFontLevel(int n) {
        Object[] objectArray = new Object[]{this.trackButton};
        FontSizer.setFonts(objectArray, n);
    }

    private TTrackBar(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("track", this);
        this.trackerPanel.addPropertyChangeListener("selectedtrack", this);
        this.trackerPanel.addPropertyChangeListener("selectedpoint", this);
        this.createGUI();
        this.refresh();
        this.validate();
    }

    protected JPopupMenu getPopup(TTrack tTrack) {
        JMenu jMenu = tTrack.getMenu(this.trackerPanel);
        FontSizer.setFonts(jMenu, FontSizer.getLevel());
        return jMenu.getPopupMenu();
    }

    protected void createGUI() {
        this.setFloatable(false);
        this.setBorder(BorderFactory.createEmptyBorder(3, 0, 2, 0));
        this.selectButton = new TButton(smallSelectIcon){

            @Override
            protected JPopupMenu getPopup() {
                return TTrackBar.this.getSelectTrackPopup();
            }
        };
        this.trackButton = new TButton();
        this.trackButton.setOpaque(false);
        this.emptyLabel.setOpaque(false);
        Border border = BorderFactory.createEmptyBorder(1, 4, 1, 4);
        Border border2 = BorderFactory.createLineBorder(Color.GRAY);
        this.trackButton.setBorder(BorderFactory.createCompoundBorder(border2, border));
        this.toolbarEnd = Box.createHorizontalGlue();
    }

    protected JPopupMenu getSelectTrackPopup() {
        Object object;
        this.selectPopup.removeAll();
        final CoordAxes coordAxes = this.trackerPanel.getAxes();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                TTrack tTrack = TTrackBar.this.trackerPanel.getTrack(jMenuItem.getText());
                if (tTrack == null) {
                    return;
                }
                if (TTrackBar.this.trackerPanel.calibrationTools.contains(tTrack) || tTrack == coordAxes) {
                    tTrack.setVisible(true);
                }
                TTrackBar.this.trackerPanel.setSelectedTrack(tTrack);
            }
        };
        boolean bl = false;
        ArrayList<TTrack> arrayList = this.trackerPanel.getUserTracks();
        for (TTrack tTrack : arrayList) {
            bl = true;
            object = new JMenuItem(tTrack.getName(), tTrack.getFootprint().getIcon(21, 16));
            ((AbstractButton)object).addActionListener(actionListener);
            this.selectPopup.add((JMenuItem)object);
        }
        if (bl) {
            this.selectPopup.addSeparator();
        }
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            if (arrayList.contains(tTrack) || tTrack == this.trackerPanel.getAxes() && !this.trackerPanel.isEnabled("button.axes") || this.trackerPanel.calibrationTools.contains(tTrack) && tTrack instanceof TapeMeasure && (((TapeMeasure)(object = (TapeMeasure)tTrack)).isStickMode() && !this.trackerPanel.isEnabled("calibration.stick") || !((TapeMeasure)object).isStickMode() && !this.trackerPanel.isEnabled("calibration.tape")) || tTrack instanceof Calibration && !this.trackerPanel.isEnabled("calibration.points") || tTrack instanceof OffsetOrigin && !this.trackerPanel.isEnabled("calibration.offsetOrigin") || tTrack instanceof PerspectiveTrack) continue;
            object = new JMenuItem(tTrack.getName(), tTrack.getFootprint().getIcon(21, 16));
            ((AbstractButton)object).addActionListener(actionListener);
            this.selectPopup.add((JMenuItem)object);
        }
        FontSizer.setFonts(this.selectPopup, FontSizer.getLevel());
        return this.selectPopup;
    }

    protected void refresh() {
        Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refresh");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList<Component> arrayList;
                Object object;
                TTrackBar.this.selectButton.setToolTipText(TrackerRes.getString("TToolBar.Button.SelectTrack.Tooltip"));
                TTrack tTrack = TTrackBar.this.trackButton.getTrack();
                if (tTrack != null) {
                    tTrack.removePropertyChangeListener("name", TTrackBar.this);
                    tTrack.removePropertyChangeListener("color", TTrackBar.this);
                    tTrack.removePropertyChangeListener("footprint", TTrackBar.this);
                    TTrackBar.this.toolbarComponentHeight = TTrackBar.this.trackButton.getPreferredSize().height;
                } else {
                    object = TTrackBar.this.trackerPanel.getAxes();
                    if (object != null) {
                        TTrackBar.this.trackButton.setTrack((TTrack)object);
                        TTrackBar.this.toolbarComponentHeight = TTrackBar.this.trackButton.getPreferredSize().height;
                    }
                }
                TTrackBar.this.removeAll();
                object = new Dimension(TTrackBar.this.toolbarComponentHeight, TTrackBar.this.toolbarComponentHeight);
                TTrackBar.this.selectButton.setPreferredSize((Dimension)object);
                TTrackBar.this.selectButton.setMaximumSize((Dimension)object);
                TTrackBar.this.add(TTrackBar.this.selectButton);
                tTrack = TTrackBar.this.trackerPanel.getSelectedTrack();
                if (tTrack != null) {
                    Serializable serializable;
                    Serializable serializable22;
                    TTrackBar.this.trackButton.setTrack(tTrack);
                    tTrack.addPropertyChangeListener("name", TTrackBar.this);
                    tTrack.addPropertyChangeListener("color", TTrackBar.this);
                    tTrack.addPropertyChangeListener("footprint", TTrackBar.this);
                    TTrackBar.this.add(TTrackBar.this.trackButton);
                    arrayList = tTrack.getToolbarTrackComponents(TTrackBar.this.trackerPanel);
                    for (Serializable serializable22 : arrayList) {
                        if (serializable22 instanceof JComponent && !(serializable22 instanceof JButton) && !(serializable22 instanceof JCheckBox)) {
                            JComponent jComponent = (JComponent)serializable22;
                            jComponent.setMaximumSize(null);
                            jComponent.setPreferredSize(null);
                            serializable = jComponent.getPreferredSize();
                            ((Dimension)serializable).height = TTrackBar.this.toolbarComponentHeight;
                            jComponent.setPreferredSize((Dimension)serializable);
                            jComponent.setMaximumSize((Dimension)serializable);
                        }
                        TTrackBar.this.add((Component)serializable22);
                    }
                    serializable22 = TTrackBar.this.trackerPanel.getSelectedPoint();
                    if (serializable22 != null) {
                        arrayList = tTrack.getToolbarPointComponents(TTrackBar.this.trackerPanel, (TPoint)serializable22);
                        for (Component component : arrayList) {
                            if (component instanceof JComponent && !(component instanceof JButton)) {
                                serializable = (JComponent)component;
                                ((JComponent)serializable).setMaximumSize(null);
                                ((JComponent)serializable).setPreferredSize(null);
                                Dimension dimension = ((JComponent)serializable).getPreferredSize();
                                dimension.height = TTrackBar.this.toolbarComponentHeight;
                                ((JComponent)serializable).setPreferredSize(dimension);
                                ((JComponent)serializable).setMaximumSize(dimension);
                            }
                            TTrackBar.this.add(component);
                        }
                    }
                }
                TTrackBar.this.add(TTrackBar.this.toolbarEnd);
                if (testButton != null) {
                    TTrackBar.this.add(testButton);
                }
                if (Tracker.newerVersion != null) {
                    arrayList = TrackerRes.getString("TTrackBar.Button.Version");
                    newVersionButton.setText(String.valueOf(arrayList) + " " + Tracker.newerVersion);
                    TTrackBar.this.add(newVersionButton);
                }
                memoryButton.setToolTipText(TrackerRes.getString("TTrackBar.Button.Memory.Tooltip"));
                TTrackBar.this.add(memoryButton);
                TTrackBar.this.revalidate();
                TTrackBar.this.repaint();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("selectedtrack")) {
            this.refresh();
        } else if (string.equals("footprint") || string.equals("color") || string.equals("name")) {
            this.refresh();
        } else if (string.equals("selectedpoint")) {
            this.refresh();
        } else if (string.equals("track")) {
            this.refresh();
        }
    }

    protected static void refreshMemoryButton() {
        System.gc();
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        long l = memoryMXBean.getHeapMemoryUsage().getUsed() / 0x100000L;
        long l2 = memoryMXBean.getHeapMemoryUsage().getMax() / 0x100000L;
        if (outOfMemory && showOutOfMemoryDialog) {
            outOfMemory = false;
            showOutOfMemoryDialog = false;
            l = l2;
            JOptionPane.showMessageDialog(memoryButton, String.valueOf(TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message1")) + "\n" + TrackerRes.getString("Tracker.Dialog.OutOfMemory.Message2"), TrackerRes.getString("Tracker.Dialog.OutOfMemory.Title"), 2);
        }
        String string = String.valueOf(TrackerRes.getString("TTrackBar.Button.Memory")) + " ";
        String string2 = String.valueOf(TrackerRes.getString("DynamicSystem.Parameter.Of")) + " ";
        memoryButton.setText(String.valueOf(string) + l + "MB " + string2 + l2 + "MB");
        double d = (double)l / (double)l2;
        memoryButton.setForeground(d > 0.8 ? Color.red : Color.black);
    }
}

