/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.opensourcephysics.cabrillo.tracker.AutoTracker;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.PerspectiveTrack;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.cabrillo.tracker.VectorStep;
import org.opensourcephysics.cabrillo.tracker.VectorSum;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.TPoint;

public class TMouseHandler
implements InteractiveMouseHandler {
    static Cursor markPointCursor;
    static Cursor autoTrackCursor;
    static Cursor autoTrackMarkCursor;
    Interactive iad = null;
    TPoint p = null;
    boolean stepCreated = false;
    boolean autoTracked = false;
    boolean marking;
    TTrack selectedTrack;
    int frameNumber;
    Point mousePtRelativeToViewRect = new Point();
    Point viewLoc = new Point();
    Dimension dim = new Dimension();

    static {
        ImageIcon imageIcon = new ImageIcon(Tracker.class.getResource("resources/images/creatept.gif"));
        markPointCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(8, 8), TrackerRes.getString("Tracker.Cursor.Crosshair.Description"));
        imageIcon = new ImageIcon(Tracker.class.getResource("resources/images/autotrack.gif"));
        autoTrackCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(9, 9), TrackerRes.getString("PointMass.Cursor.Autotrack.Description"));
        imageIcon = new ImageIcon(Tracker.class.getResource("resources/images/autotrack_mark.gif"));
        autoTrackMarkCursor = Toolkit.getDefaultToolkit().createCustomCursor(imageIcon.getImage(), new Point(9, 9), TrackerRes.getString("PointMass.Cursor.Autotrack.Description"));
    }

    @Override
    public void handleMouseAction(InteractivePanel interactivePanel, MouseEvent mouseEvent) {
        if (!(interactivePanel instanceof TrackerPanel)) {
            return;
        }
        if (OSPRuntime.isPopupTrigger(mouseEvent) || interactivePanel.getZoomBox().isVisible()) {
            return;
        }
        TrackerPanel trackerPanel = (TrackerPanel)interactivePanel;
        if (!trackerPanel.isDrawingInImageSpace()) {
            return;
        }
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component component = keyboardFocusManager.getFocusOwner();
        AutoTracker autoTracker = trackerPanel.getAutoTracker();
        if (autoTracker.getTrack() == null) {
            autoTracker.setTrack(trackerPanel.getSelectedTrack());
        }
        switch (trackerPanel.getMouseAction()) {
            case 7: {
                Step step;
                this.selectedTrack = trackerPanel.getSelectedTrack();
                this.frameNumber = trackerPanel.getFrameNumber();
                this.iad = trackerPanel.getInteractive();
                boolean bl = mouseEvent.isShiftDown();
                this.marking = trackerPanel.setCursorForMarking(bl, mouseEvent);
                if (this.selectedTrack != null && this.marking != this.selectedTrack.isMarking) {
                    this.selectedTrack.setMarking(this.marking);
                    this.selectedTrack.repaint(trackerPanel);
                }
                if (this.marking) {
                    this.iad = null;
                }
                if (this.selectedTrack != null && autoTracker.getWizard().isVisible() && autoTracker.getTrack() == this.selectedTrack && (step = this.selectedTrack.getStep(this.frameNumber)) != null) {
                    this.selectedTrack.repaint(step);
                }
                if (!TTrackBar.outOfMemory) break;
                TTrackBar.refreshMemoryButton();
                break;
            }
            case 1: {
                Cloneable cloneable2;
                boolean bl;
                if (Tracker.startupHintShown) {
                    Tracker.startupHintShown = false;
                    trackerPanel.setMessage("");
                }
                TrackControl.getControl((TrackerPanel)trackerPanel).popup.setVisible(false);
                this.marking = this.selectedTrack != null && trackerPanel.getCursor() == this.selectedTrack.getMarkingCursor(mouseEvent);
                AutoTracker.KeyFrame keyFrame = this.getActiveKeyFrame(autoTracker);
                if (this.marking) {
                    Object object;
                    int n;
                    this.iad = null;
                    boolean bl2 = TMouseHandler.isAutoTrackTrigger(mouseEvent);
                    this.frameNumber = trackerPanel.getFrameNumber();
                    Step step = this.selectedTrack.getStep(this.frameNumber);
                    int n2 = n = this.selectedTrack.getTargetIndex();
                    if (step == null || !bl2) {
                        if (bl2) {
                            this.selectedTrack.autoMarkAt(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                            step = this.selectedTrack.getStep(this.frameNumber);
                        } else {
                            boolean bl3 = step == null;
                            step = this.selectedTrack.createStep(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                            object = step.getPoints();
                            if (bl3 && ((TPoint[])object).length > n + 1) {
                                n2 = n + 1;
                            }
                        }
                    } else if (step.getPoints()[n] == null) {
                        TPoint[] tPointArray;
                        if (keyFrame != null) {
                            tPointArray = keyFrame.getTarget();
                            tPointArray.setXY(trackerPanel.getMouseX(), trackerPanel.getMouseY());
                        }
                        this.selectedTrack.autoMarkAt(this.frameNumber, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                        tPointArray = step.getPoints();
                        if (tPointArray.length > n + 1) {
                            n2 = n + 1;
                        }
                    }
                    if (TMouseHandler.isAutoTrackTrigger(mouseEvent) && step != null && step.getPoints()[n] != null) {
                        TPoint tPoint = step.getPoints()[n];
                        if ((this.selectedTrack instanceof CoordAxes || this.selectedTrack instanceof TapeMeasure || this.selectedTrack instanceof PerspectiveTrack || this.selectedTrack instanceof Protractor) && autoTracker.getTrack() == this.selectedTrack && ((AutoTracker.FrameData)(object = autoTracker.getFrame(this.frameNumber))).getKeyFrame() == null) {
                            tPoint.setXY(trackerPanel.getMouseX(), trackerPanel.getMouseY());
                        }
                        autoTracker.addKeyFrame(tPoint, trackerPanel.getMouseX(), trackerPanel.getMouseY());
                        TTrackBar.getTrackbar(trackerPanel).refresh();
                    }
                    if (step != null && !TMouseHandler.isAutoTrackTrigger(mouseEvent)) {
                        trackerPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                        trackerPanel.setSelectedPoint(step.getDefaultPoint());
                        this.selectedTrack.repaint(step);
                        this.p = trackerPanel.getSelectedPoint();
                        this.iad = this.p;
                        this.stepCreated = keyFrame == null;
                    }
                    this.selectedTrack.setTargetIndex(n2);
                    autoTracker.getWizard().refreshGUI();
                    break;
                }
                if (this.iad instanceof TPoint) {
                    this.p = (TPoint)this.iad;
                    Step step = null;
                    for (TTrack tTrack : trackerPanel.getTracks()) {
                        step = tTrack.getStep(this.p, trackerPanel);
                        if (step != null) break;
                    }
                    boolean bl4 = trackerPanel.selectedSteps.contains(step);
                    if (mouseEvent.isControlDown()) {
                        if (bl4) {
                            this.p = null;
                            trackerPanel.selectedSteps.remove(step);
                        } else {
                            if (!trackerPanel.selectedSteps.isEmpty()) {
                                this.p = null;
                            }
                            trackerPanel.selectedSteps.add(step);
                        }
                    } else if (!trackerPanel.selectedSteps.contains(step)) {
                        for (Object object : trackerPanel.selectedSteps) {
                            ((Step)object).erase();
                        }
                        trackerPanel.selectedSteps.clear();
                        trackerPanel.selectedSteps.add(step);
                    }
                    if (step != null) {
                        step.erase();
                    }
                    if (this.p instanceof AutoTracker.Handle) {
                        ((AutoTracker.Handle)this.p).setScreenLocation(mouseEvent.getX(), mouseEvent.getY(), trackerPanel);
                    }
                    if (this.p != null) {
                        this.p.showCoordinates(trackerPanel);
                    }
                    trackerPanel.setSelectedPoint(this.p);
                    if (!(this.p instanceof Step.Handle)) break;
                    ((Step.Handle)this.p).setPositionOnLine(mouseEvent.getX(), mouseEvent.getY(), trackerPanel);
                    break;
                }
                boolean bl5 = bl = trackerPanel.getSelectedPoint() != null;
                if (bl) {
                    trackerPanel.setSelectedPoint(null);
                } else if (trackerPanel.selectedSteps.isChanged()) {
                    Undo.postStepSetEdit(trackerPanel.selectedSteps, trackerPanel.selectedSteps.getUndoControl());
                }
                for (Cloneable cloneable2 : trackerPanel.selectedSteps) {
                    ((Step)cloneable2).erase();
                }
                trackerPanel.selectedSteps.clear();
                if (!trackerPanel.isShowCoordinates()) {
                    trackerPanel.hideMouseBox();
                    trackerPanel.setMouseCursor(Cursor.getDefaultCursor());
                }
                if (mouseEvent.getClickCount() == 2) {
                    trackerPanel.setSelectedTrack(null);
                }
                cloneable2 = trackerPanel.scrollPane.getViewport().getViewRect();
                this.viewLoc.setLocation(((Rectangle)cloneable2).getLocation());
                Point point = mouseEvent.getPoint();
                this.mousePtRelativeToViewRect.setLocation(point.x - ((Rectangle)cloneable2).x, point.y - ((Rectangle)cloneable2).y);
                trackerPanel.scrollPane.getViewport().getView().getSize(this.dim);
                if (this.dim.width <= ((Rectangle)cloneable2).width && this.dim.height <= ((Rectangle)cloneable2).height) break;
                trackerPanel.setMouseCursor(Tracker.grabCursor);
                break;
            }
            case 3: {
                this.p = trackerPanel.getSelectedPoint();
                TTrack tTrack = trackerPanel.getSelectedTrack();
                if (this.p != null) {
                    int n = 0;
                    int n3 = 0;
                    if (tTrack != null && tTrack.isLocked() && !(tTrack instanceof VectorSum)) {
                        Toolkit.getDefaultToolkit().beep();
                        return;
                    }
                    this.p.setAdjusting(true);
                    Point point = this.p.getScreenPosition(trackerPanel);
                    n = mouseEvent.getX() - point.x;
                    n3 = mouseEvent.getY() - point.y;
                    this.p.setScreenPosition(mouseEvent.getX(), mouseEvent.getY(), trackerPanel, mouseEvent);
                    this.p.showCoordinates(trackerPanel);
                    for (Step step : trackerPanel.selectedSteps) {
                        this.p = step.points[0];
                        if (this.p == trackerPanel.getSelectedPoint()) continue;
                        this.p.setAdjusting(true);
                        point = this.p.getScreenPosition(trackerPanel);
                        this.p.setScreenPosition(point.x + n, point.y + n3, trackerPanel, mouseEvent);
                    }
                } else if (trackerPanel.getCursor() != Tracker.zoomInCursor && trackerPanel.getCursor() != Tracker.zoomOutCursor) {
                    Point point = mouseEvent.getPoint();
                    Rectangle rectangle = trackerPanel.scrollPane.getViewport().getViewRect();
                    trackerPanel.scrollPane.getViewport().getView().getSize(this.dim);
                    int n = this.mousePtRelativeToViewRect.x - point.x + rectangle.x;
                    int n4 = this.mousePtRelativeToViewRect.y - point.y + rectangle.y;
                    int n5 = Math.max(0, this.viewLoc.x + n);
                    n5 = Math.min(n5, this.dim.width - rectangle.width);
                    int n6 = Math.max(0, this.viewLoc.y + n4);
                    n6 = Math.min(n6, this.dim.height - rectangle.height);
                    if (n5 != rectangle.x || n6 != rectangle.y) {
                        trackerPanel.setMouseCursor(Tracker.grabbedCursor);
                        rectangle.x = n5;
                        rectangle.y = n6;
                        trackerPanel.scrollRectToVisible(rectangle);
                    } else {
                        this.viewLoc.setLocation(rectangle.getLocation());
                        this.mousePtRelativeToViewRect.setLocation(point.x - rectangle.x, point.y - rectangle.y);
                    }
                }
                if (trackerPanel.getSelectedStep() != null) break;
                trackerPanel.repaint();
                break;
            }
            case 2: {
                trackerPanel.setMouseCursor(Cursor.getDefaultCursor());
                trackerPanel.requestFocusInWindow();
                this.p = trackerPanel.getSelectedPoint();
                if (this.p != null) {
                    this.p.setAdjusting(false);
                    if (this.p instanceof VectorStep.Handle) {
                        ((VectorStep.Handle)this.p).snap(trackerPanel);
                    }
                }
                if (this.stepCreated && this.selectedTrack != null && this.selectedTrack.isAutoAdvance()) {
                    trackerPanel.getPlayer().step();
                    trackerPanel.hideMouseBox();
                    this.stepCreated = false;
                }
                this.autoTracked = false;
                break;
            }
            case 5: {
                if (component == null || component instanceof JTextComponent) break;
                trackerPanel.requestFocusInWindow();
            }
        }
    }

    protected static boolean isAutoTrackTrigger(InputEvent inputEvent) {
        return inputEvent.isControlDown();
    }

    protected AutoTracker.KeyFrame getActiveKeyFrame(AutoTracker autoTracker) {
        AutoTracker.FrameData frameData;
        if (this.selectedTrack != null && autoTracker.getWizard().isVisible() && autoTracker.getTrack() == this.selectedTrack && (frameData = autoTracker.getFrame(this.frameNumber)) != null && frameData.getKeyFrame() == frameData) {
            return (AutoTracker.KeyFrame)frameData;
        }
        return null;
    }
}

