/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.ImageVideo;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class TMat
implements Measurable,
Trackable,
PropertyChangeListener {
    protected Rectangle mat;
    private Rectangle2D bounds;
    private Paint paint = Color.white;
    private boolean visible = true;
    protected boolean isValidMeasure = false;
    private TrackerPanel trackerPanel;
    private ImageCoordSystem coords;
    protected Rectangle drawingBounds;

    public TMat(TrackerPanel trackerPanel) {
        this.trackerPanel = trackerPanel;
        this.trackerPanel.addPropertyChangeListener("coords", this);
        this.coords = this.trackerPanel.getCoords();
        this.coords.addPropertyChangeListener("transform", this);
        this.mat = new Rectangle();
        this.trackerPanel.addDrawable(this);
        this.refresh();
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (!(drawingPanel instanceof VideoPanel) || !this.isVisible()) {
            return;
        }
        VideoPanel videoPanel = (VideoPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Paint paint = graphics2D.getPaint();
        graphics2D.transform(videoPanel.getPixelTransform());
        if (!videoPanel.isDrawingInImageSpace()) {
            object = videoPanel.getCoords();
            int n = videoPanel.getFrameNumber();
            graphics2D.transform(((ImageCoordSystem)object).getToWorldTransform(n));
        }
        graphics2D.setPaint(this.paint);
        graphics2D.fill(this.mat);
        graphics2D.setTransform(affineTransform);
        graphics2D.setPaint(paint);
        object = videoPanel.getPixelTransform().createTransformedShape(this.mat);
        Rectangle2D rectangle2D = object.getBounds2D();
        this.drawingBounds = new Rectangle((int)Math.round(rectangle2D.getMinX()), (int)Math.round(rectangle2D.getMinY()), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public double getXMin() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.bounds.getMinX();
    }

    @Override
    public double getXMax() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.bounds.getMaxX();
    }

    @Override
    public double getYMin() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.bounds.getMinY();
    }

    @Override
    public double getYMax() {
        if (!this.isValidMeasure) {
            this.getWorldBounds();
        }
        return this.bounds.getMaxY();
    }

    @Override
    public boolean isMeasured() {
        return this.isVisible();
    }

    public void refresh() {
        this.coords.removePropertyChangeListener("transform", this);
        this.coords = this.trackerPanel.getCoords();
        this.coords.addPropertyChangeListener("transform", this);
        this.mat.width = (int)this.trackerPanel.getImageWidth();
        this.mat.height = (int)this.trackerPanel.getImageHeight();
        int n = (int)TrackerPanel.getDefaultImageWidth();
        int n2 = (int)TrackerPanel.getDefaultImageHeight();
        Video video = this.trackerPanel.getVideo();
        if (video != null) {
            if (video instanceof ImageVideo && video.getFilterStack().isEmpty()) {
                Dimension dimension = ((ImageVideo)video).getSize();
                n = dimension.width;
                n2 = dimension.height;
            } else {
                BufferedImage bufferedImage = video.getImage();
                if (bufferedImage != null) {
                    n = bufferedImage.getWidth();
                    n2 = bufferedImage.getHeight();
                }
            }
        }
        this.mat.x = Math.min((n - this.mat.width) / 2, 0);
        this.mat.y = Math.min((n2 - this.mat.height) / 2, 0);
        this.isValidMeasure = false;
        this.trackerPanel.scale();
    }

    public double getXOffset() {
        return this.mat.x;
    }

    public double getYOffset() {
        return this.mat.y;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("transform")) {
            this.isValidMeasure = false;
        } else if (propertyChangeEvent.getPropertyName().equals("coords")) {
            this.refresh();
        }
    }

    private void getWorldBounds() {
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n = videoClip.getStepCount();
        AffineTransform affineTransform = imageCoordSystem.getToWorldTransform(videoClip.stepToFrame(0));
        this.bounds = affineTransform.createTransformedShape(this.mat).getBounds2D();
        int n2 = 0;
        while (n2 < n) {
            affineTransform = imageCoordSystem.getToWorldTransform(videoClip.stepToFrame(n2));
            this.bounds.add(affineTransform.createTransformedShape(this.mat).getBounds2D());
            ++n2;
        }
        this.isValidMeasure = true;
    }
}

