/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.cabrillo.tracker.CoordAxes;
import org.opensourcephysics.cabrillo.tracker.ExportVideoDialog;
import org.opensourcephysics.cabrillo.tracker.ExportZipDialog;
import org.opensourcephysics.cabrillo.tracker.FileDropHandler;
import org.opensourcephysics.cabrillo.tracker.MainTView;
import org.opensourcephysics.cabrillo.tracker.MonitorDialog;
import org.opensourcephysics.cabrillo.tracker.PrefsDialog;
import org.opensourcephysics.cabrillo.tracker.PropertiesDialog;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TActions;
import org.opensourcephysics.cabrillo.tracker.TMat;
import org.opensourcephysics.cabrillo.tracker.TMenuBar;
import org.opensourcephysics.cabrillo.tracker.TMouseHandler;
import org.opensourcephysics.cabrillo.tracker.TToolBar;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.TView;
import org.opensourcephysics.cabrillo.tracker.TViewChooser;
import org.opensourcephysics.cabrillo.tracker.ThumbnailDialog;
import org.opensourcephysics.cabrillo.tracker.TrackControl;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.InteractiveMouseHandler;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.BaselineFilter;
import org.opensourcephysics.media.core.BrightnessFilter;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.DarkGhostFilter;
import org.opensourcephysics.media.core.DeinterlaceFilter;
import org.opensourcephysics.media.core.Filter;
import org.opensourcephysics.media.core.GhostFilter;
import org.opensourcephysics.media.core.GrayScaleFilter;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.NegativeFilter;
import org.opensourcephysics.media.core.PerspectiveFilter;
import org.opensourcephysics.media.core.RadialDistortionFilter;
import org.opensourcephysics.media.core.ResizeFilter;
import org.opensourcephysics.media.core.RotateFilter;
import org.opensourcephysics.media.core.SumFilter;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoFileFilter;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.DataTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.LaunchPanel;
import org.opensourcephysics.tools.Launcher;
import org.opensourcephysics.tools.LibraryBrowser;
import org.opensourcephysics.tools.LibraryResource;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TFrame
extends OSPFrame
implements PropertyChangeListener {
    protected static String helpPath = "/org/opensourcephysics/cabrillo/tracker/resources/help/";
    protected static String helpPathWeb = "http://physlets.org/tracker/help/";
    static Color yellow = new Color(255, 255, 105);
    private JToolBar playerBar;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem closeItem;
    private JMenuBar defaultMenuBar;
    private JMenu recentMenu;
    private Map<JPanel, Object[]> tabs = new HashMap<JPanel, Object[]>();
    protected JTabbedPane tabbedPane;
    protected JTextPane notesTextPane;
    protected Action saveNotesAction;
    protected JButton cancelNotesDialogButton;
    protected JButton closeNotesDialogButton;
    protected JCheckBox displayWhenLoadedCheckbox;
    protected JDialog notesDialog;
    protected JDialog helpDialog;
    protected LibraryBrowser libraryBrowser;
    protected Launcher helpLauncher;
    protected JDialog dataToolDialog;
    protected TrackerPanel prevPanel;
    protected double defaultRightDivider = 0.7;
    protected double defaultBottomDivider = 0.5;
    protected FileDropHandler fileDropHandler;
    protected Action openRecentAction;
    protected boolean splashing = true;
    protected ArrayList<String> loadedFiles = new ArrayList();
    protected boolean anglesInRadians = Tracker.isRadians;
    protected File tabsetFile;
    protected int framesLoaded;
    protected int prevFramesLoaded;
    protected PrefsDialog prefsDialog;

    public TFrame() {
        super("Tracker");
        this.setName("Tracker");
        if (Tracker.TRACKER_ICON != null) {
            this.setIconImage(Tracker.TRACKER_ICON.getImage());
        }
        this.setDefaultCloseOperation(0);
        this.createGUI();
        this.pack();
        this.fileDropHandler = new FileDropHandler(this);
        this.tabbedPane.setTransferHandler(this.fileDropHandler);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        this.setMaximizedBounds(rectangle);
        double d = FontSizer.getFactor(Tracker.preferredFontLevel) - 1.0;
        int n = Math.min(rectangle.width, (int)(1024.0 + d * 800.0));
        int n2 = Math.min(rectangle.height, 3 * n / 4);
        Dimension dimension = new Dimension(n, n2);
        this.setSize(dimension);
        int n3 = (rectangle.width - dimension.width) / 2;
        int n4 = (rectangle.height - dimension.height) / 2;
        this.setLocation(n3, n4);
        TrackerRes.addPropertyChangeListener("locale", this);
    }

    public TFrame(TrackerPanel trackerPanel) {
        this();
        this.addTab(trackerPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTab(final TrackerPanel trackerPanel) {
        Object object;
        boolean bl;
        if (this.getTab(trackerPanel) >= 0) {
            return;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TFrame.this.refreshTab(trackerPanel);
            }
        };
        trackerPanel.addPropertyChangeListener("datafile", propertyChangeListener);
        trackerPanel.addPropertyChangeListener("video", propertyChangeListener);
        this.addPropertyChangeListener("radian_angles", trackerPanel);
        JPanel jPanel = new JPanel(new BorderLayout());
        Tracker.setProgress(30);
        MainTView mainTView = this.getMainView(trackerPanel);
        Container[] containerArray = this.createViews(trackerPanel);
        JSplitPane[] jSplitPaneArray = this.getSplitPanes(trackerPanel);
        Tracker.setProgress(50);
        TToolBar tToolBar = this.getToolBar(trackerPanel);
        Tracker.setProgress(60);
        TMenuBar tMenuBar = this.getMenuBar(trackerPanel);
        TTrackBar tTrackBar = this.getTrackBar(trackerPanel);
        Object[] objectArray = new Object[]{mainTView, containerArray, jSplitPaneArray, tToolBar, tMenuBar, tTrackBar};
        this.tabs.put(jPanel, objectArray);
        this.setIgnoreRepaint(true);
        String string = trackerPanel.getTitle();
        JTabbedPane jTabbedPane = this.tabbedPane;
        synchronized (jTabbedPane) {
            this.tabbedPane.addTab(string, jPanel);
            int n = this.getTab(trackerPanel);
            this.tabbedPane.setToolTipTextAt(n, trackerPanel.getToolTipPath());
        }
        boolean bl2 = bl = trackerPanel.viewsProperty != null;
        if (trackerPanel.selectedViewsProperty != null) {
            Object object2;
            Object object3;
            int n;
            Object object4;
            if (!bl) {
                object4 = trackerPanel.selectedViewsProperty.getChildControls();
                n = 0;
                while (n < Math.min(((XMLControl[])object4).length, containerArray.length)) {
                    if (object4[n] != null && containerArray[n] instanceof TViewChooser && (object3 = ((TViewChooser)(object2 = (TViewChooser)containerArray[n])).getView((Class<?>)(object = object4[n].getObjectClass()))) != null) {
                        if (((TViewChooser)object2).getSelectedView() != object3) {
                            ((TViewChooser)object2).setSelectedView((TView)object3);
                        }
                        object4[n].loadObject(object3);
                    }
                    ++n;
                }
            } else {
                object4 = trackerPanel.selectedViewsProperty.getPropertyContent().iterator();
                n = -1;
                while (object4.hasNext() && n < containerArray.length) {
                    if (!(containerArray[++n] instanceof TViewChooser)) continue;
                    object2 = (TViewChooser)containerArray[n];
                    object = (XMLProperty)object4.next();
                    if (object == null) continue;
                    object3 = (String)object.getPropertyContent().get(0);
                    ((TViewChooser)object2).setSelectedView(((TViewChooser)object2).getView((String)object3));
                }
            }
            trackerPanel.selectedViewsProperty = null;
        }
        if (bl) {
            List<Object> list = trackerPanel.viewsProperty.getPropertyContent();
            for (Object object2 : list) {
                if (object2 == null) continue;
                object = object2.getPropertyName().substring(1);
                int n = Integer.parseInt((String)(object = ((String)object).substring(0, ((String)object).length() - 1)));
                if (n >= containerArray.length || !(containerArray[n] instanceof TViewChooser)) continue;
                XMLControl[] xMLControlArray = object2.getChildControls();
                TViewChooser tViewChooser = (TViewChooser)containerArray[n];
                int n2 = 0;
                while (n2 < xMLControlArray.length) {
                    Class<?> clazz = xMLControlArray[n2].getObjectClass();
                    TView tView = tViewChooser.getView(clazz);
                    if (tView != null) {
                        xMLControlArray[n2].loadObject(tView);
                    }
                    ++n2;
                }
            }
            trackerPanel.viewsProperty = null;
        }
        this.setViews(trackerPanel, containerArray);
        this.initialize(trackerPanel);
        FontSizer.setFonts(jPanel, FontSizer.getLevel());
        for (TTrack tTrack : trackerPanel.getTracks()) {
            tTrack.setAnglesInRadians(this.anglesInRadians);
        }
        this.setIgnoreRepaint(false);
        trackerPanel.changed = false;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TFrame.this.getTabCount() > 1) {
                    TrackerPanel trackerPanel2 = TFrame.this.getTrackerPanel(0);
                    if (TFrame.this.tabbedPane.getTitleAt(0).equals(TrackerRes.getString("TrackerPanel.NewTab.Name")) && !trackerPanel2.changed) {
                        TFrame.this.removeTab(trackerPanel2);
                    }
                }
                trackerPanel.refreshTrackData();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeAllTabs() {
        int n = this.getTabCount() - 1;
        while (n >= 0) {
            try {
                if (!this.getTrackerPanel(n).save()) {
                    return;
                }
                this.removeTab(this.getTrackerPanel(n));
            }
            catch (Exception exception) {}
            --n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTab(TrackerPanel trackerPanel) {
        Container container;
        int n = this.getTab(trackerPanel);
        if (n == -1) {
            return;
        }
        if (!trackerPanel.save()) {
            return;
        }
        this.notesDialog.setVisible(false);
        if (trackerPanel.dataBuilder != null) {
            trackerPanel.dataBuilder.dispose();
        }
        this.firePropertyChange("tab", trackerPanel, null);
        this.removePropertyChangeListener("radian_angles", trackerPanel);
        TrackControl.getControl(trackerPanel).setVisible(false);
        ClipInspector clipInspector = trackerPanel.getPlayer().getVideoClip().getClipInspector();
        if (clipInspector != null) {
            clipInspector.setVisible(false);
        }
        trackerPanel.setVideo(null);
        System.gc();
        Object[] objectArray = this.tabs.get(trackerPanel);
        if (objectArray != null) {
            this.playerBar = ((MainTView)objectArray[0]).getPlayerBar();
            container = this.playerBar.getTopLevelAncestor();
            if (container != null && container != this) {
                container.setVisible(false);
            }
        }
        container = (JPanel)this.tabbedPane.getComponentAt(n);
        container.removeAll();
        this.tabs.remove(container);
        Container container2 = this.tabbedPane;
        synchronized (container2) {
            this.tabbedPane.remove(container);
        }
        objectArray = this.tabs.get(this.tabbedPane.getSelectedComponent());
        if (objectArray != null) {
            this.setJMenuBar((JMenuBar)objectArray[4]);
            ((TTrackBar)objectArray[5]).refresh();
            this.playerBar = ((MainTView)objectArray[0]).getPlayerBar();
            container2 = this.playerBar.getTopLevelAncestor();
            if (container2 != null && container2 != this) {
                container2.setVisible(true);
            }
        } else {
            this.refreshOpenRecentMenu(this.recentMenu);
            this.setJMenuBar(this.defaultMenuBar);
        }
    }

    public int getTab(TrackerPanel trackerPanel) {
        int n = 0;
        while (n < this.getTabCount()) {
            Object[] objectArray = this.tabs.get(this.tabbedPane.getComponentAt(n));
            if (objectArray == null) {
                return -1;
            }
            MainTView mainTView = (MainTView)objectArray[0];
            if (mainTView.getTrackerPanel() == trackerPanel) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTab(File file) {
        if (file == null) {
            return -1;
        }
        try {
            String string = file.getCanonicalPath();
            int n = this.getTabCount() - 1;
            while (true) {
                if (n < 0) {
                    return -1;
                }
                Object[] objectArray = this.tabs.get(this.tabbedPane.getComponentAt(n));
                if (objectArray == null) {
                    return -1;
                }
                MainTView mainTView = (MainTView)objectArray[0];
                File file2 = mainTView.getTrackerPanel().getDataFile();
                if (file2 != null && string.equals(file2.getCanonicalPath())) {
                    return n;
                }
                --n;
            }
        }
        catch (IOException iOException) {}
        return -1;
    }

    public int getTabCount() {
        return this.tabbedPane.getComponentCount();
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public void setSelectedTab(int n) {
        if (n < 0 || n >= this.getTabCount()) {
            return;
        }
        this.tabbedPane.setSelectedIndex(n);
        TrackerPanel trackerPanel = this.getTrackerPanel(n);
        if (trackerPanel != null) {
            trackerPanel.refreshNotesDialog();
        }
    }

    public void setSelectedTab(TrackerPanel trackerPanel) {
        this.setSelectedTab(this.getTab(trackerPanel));
    }

    public TrackerPanel getTrackerPanel(int n) {
        if (n < 0 || n >= this.tabbedPane.getTabCount()) {
            return null;
        }
        Object[] objectArray = this.tabs.get(this.tabbedPane.getComponentAt(n));
        MainTView mainTView = (MainTView)objectArray[0];
        return mainTView.getTrackerPanel();
    }

    public String getTabTitle(int n) {
        return this.tabbedPane.getTitleAt(n);
    }

    public void refreshTab(TrackerPanel trackerPanel) {
        int n = this.getTab(trackerPanel);
        this.tabbedPane.setTitleAt(n, trackerPanel.getTitle());
        this.tabbedPane.setToolTipTextAt(n, trackerPanel.getToolTipPath());
    }

    public void setTabTitle(int n, String string) {
        this.tabbedPane.setTitleAt(n, string);
    }

    public void setView(TrackerPanel trackerPanel, Container container, int n) {
        if (container == null || n > 3) {
            return;
        }
        Container[] containerArray = this.getViews(trackerPanel);
        containerArray[n] = container;
        this.setViews(trackerPanel, containerArray);
    }

    public void setViews(TrackerPanel trackerPanel, Container[] containerArray) {
        if (containerArray == null) {
            containerArray = new Container[]{};
        }
        int n = this.getTab(trackerPanel);
        JPanel jPanel = (JPanel)this.tabbedPane.getComponentAt(n);
        jPanel.removeAll();
        Object[] objectArray = this.tabs.get(jPanel);
        Container[] containerArray2 = (Container[])objectArray[1];
        int n2 = 0;
        while (n2 < Math.min(containerArray.length, containerArray2.length)) {
            if (containerArray[n2] != null) {
                containerArray2[n2] = containerArray[n2];
            }
            ++n2;
        }
        objectArray[1] = containerArray2;
        MainTView mainTView = (MainTView)objectArray[0];
        JSplitPane[] jSplitPaneArray = (JSplitPane[])objectArray[2];
        jPanel.add((Component)jSplitPaneArray[0], "Center");
        jSplitPaneArray[0].setLeftComponent(jSplitPaneArray[2]);
        jSplitPaneArray[0].setRightComponent(jSplitPaneArray[1]);
        jSplitPaneArray[1].setTopComponent(containerArray2[0]);
        jSplitPaneArray[1].setBottomComponent(containerArray2[1]);
        jSplitPaneArray[2].setTopComponent(mainTView);
        jSplitPaneArray[2].setBottomComponent(jSplitPaneArray[3]);
        jSplitPaneArray[3].setRightComponent(containerArray2[2]);
        jSplitPaneArray[3].setLeftComponent(containerArray2[3]);
        Box box = Box.createVerticalBox();
        box.add((JToolBar)objectArray[3]);
        box.add((JToolBar)objectArray[5]);
        jPanel.add((Component)box, "North");
    }

    public Container[] getViews(TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray == null) {
            return new Container[4];
        }
        Container[] containerArray = (Container[])objectArray[1];
        return (Container[])containerArray.clone();
    }

    public TView[][] getTViews(TrackerPanel trackerPanel) {
        return this.getTViews(trackerPanel, false);
    }

    public TView[][] getTViews(TrackerPanel trackerPanel, boolean bl) {
        Container[] containerArray = this.getViews(trackerPanel);
        TView[][] tViewArray = new TView[containerArray.length][];
        int n = 0;
        while (n < tViewArray.length) {
            if (containerArray[n] instanceof TViewChooser) {
                TViewChooser tViewChooser = (TViewChooser)containerArray[n];
                Collection<TView> collection = tViewChooser.getViews();
                tViewArray[n] = new TView[collection.size()];
                boolean bl2 = true;
                Iterator<TView> iterator = collection.iterator();
                int n2 = 0;
                while (n2 < collection.size()) {
                    TView tView = iterator.next();
                    if (!bl || tView.isCustomState()) {
                        tViewArray[n][n2] = tView;
                        bl2 = false;
                    }
                    ++n2;
                }
                if (bl2) {
                    tViewArray[n] = null;
                }
            }
            ++n;
        }
        return tViewArray;
    }

    public String[] getSelectedTViews(TrackerPanel trackerPanel) {
        Container[] containerArray = this.getViews(trackerPanel);
        String[] stringArray = new String[containerArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (containerArray[n] instanceof TViewChooser) {
                TViewChooser tViewChooser = (TViewChooser)containerArray[n];
                stringArray[n] = tViewChooser.getSelectedView().getViewName();
            }
            ++n;
        }
        return stringArray;
    }

    public boolean isViewOpen(int n, TrackerPanel trackerPanel) {
        JSplitPane[] jSplitPaneArray = this.getSplitPanes(trackerPanel);
        double[] dArray = new double[jSplitPaneArray.length];
        int n2 = 0;
        while (n2 < jSplitPaneArray.length) {
            int n3 = jSplitPaneArray[n2].getMaximumDividerLocation();
            dArray[n2] = 1.0 * (double)jSplitPaneArray[n2].getDividerLocation() / (double)n3;
            ++n2;
        }
        switch (n) {
            case 0: {
                return dArray[0] < 0.95 && dArray[1] > 0.05;
            }
            case 1: {
                return dArray[0] < 0.95 && dArray[1] < 0.95;
            }
            case 2: {
                return dArray[2] < 0.95 && dArray[3] < 0.95;
            }
            case 3: {
                return dArray[2] < 0.95 && dArray[3] > 0.05;
            }
        }
        return false;
    }

    public void setDividerLocation(TrackerPanel trackerPanel, int n, double d) {
        JSplitPane[] jSplitPaneArray = this.getSplitPanes(trackerPanel);
        if (n < jSplitPaneArray.length) {
            jSplitPaneArray[n].setDividerLocation(d);
            this.validate();
        }
    }

    public void setDividerLocation(TrackerPanel trackerPanel, int n, int n2) {
        JSplitPane[] jSplitPaneArray = this.getSplitPanes(trackerPanel);
        if (n < jSplitPaneArray.length) {
            jSplitPaneArray[n].setDividerLocation(n2);
            this.validate();
        }
    }

    JSplitPane getSplitPane(TrackerPanel trackerPanel, int n) {
        JSplitPane[] jSplitPaneArray = this.getSplitPanes(trackerPanel);
        if (n < jSplitPaneArray.length) {
            return jSplitPaneArray[n];
        }
        return null;
    }

    public MainTView getMainView(TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray != null) {
            return (MainTView)objectArray[0];
        }
        return new MainTView(trackerPanel);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("progress")) {
            Object object = propertyChangeEvent.getNewValue();
            String string2 = XML.forwardSlash((String)propertyChangeEvent.getOldValue());
            try {
                this.framesLoaded = Integer.parseInt(object.toString());
            }
            catch (Exception exception) {}
            for (MonitorDialog monitorDialog : TrackerIO.monitors) {
                String string3 = XML.forwardSlash(monitorDialog.getName());
                if (!string3.endsWith(string2)) continue;
                int n = 20 + this.framesLoaded / 20 % 60;
                if (monitorDialog.getFrameCount() != Integer.MIN_VALUE) {
                    n = 20 + (int)((double)this.framesLoaded * 60.0 / (double)monitorDialog.getFrameCount());
                }
                monitorDialog.setProgress(n);
                break;
            }
        } else if (string.equals("stalled")) {
            void var4_10;
            String string4 = XML.getName((String)propertyChangeEvent.getNewValue());
            String string5 = String.valueOf(TrackerRes.getString("TFrame.Dialog.StalledVideo.Message0")) + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message1") + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message2") + "\n\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message3");
            if (VideoIO.getVideoType("QT", null) != null) {
                String object2 = String.valueOf(string5) + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.Message4");
            } else if (OSPRuntime.isMac()) {
                String string6 = String.valueOf(string5) + "\n" + TrackerRes.getString("TFrame.Dialog.StalledVideo.MessageMac");
            }
            String string7 = TrackerRes.getString("TFrame.Dialog.StalledVideo.Button.Stop");
            String string8 = TrackerRes.getString("TFrame.Dialog.StalledVideo.Button.Wait");
            int n = JOptionPane.showOptionDialog(this, var4_10, String.valueOf(TrackerRes.getString("TFrame.Dialog.StalledVideo.Title")) + ": " + string4, 0, 2, null, new String[]{string7, string8}, string7);
            if (n == 0) {
                VideoIO.setCanceled(true);
                MonitorDialog monitorDialog = null;
                for (MonitorDialog monitorDialog2 : TrackerIO.monitors) {
                    String string9;
                    String string10 = XML.forwardSlash(monitorDialog2.getName());
                    if (!string10.endsWith(string9 = XML.forwardSlash(string4))) continue;
                    monitorDialog = monitorDialog2;
                    break;
                }
                if (monitorDialog != null) {
                    monitorDialog.close();
                }
            }
        } else if (string.equals("locale")) {
            Container[] containerArray;
            JComponent jComponent;
            JComponent jComponent2;
            TMenuBar.clear();
            TActions.clear();
            Tracker.createActions();
            this.createDefaultMenuBar();
            for (Object[] objectArray : this.tabs.values()) {
                jComponent2 = (MainTView)objectArray[0];
                jComponent = ((MainTView)jComponent2).getTrackerPanel();
                boolean bl = ((TrackerPanel)jComponent).changed;
                objectArray[4] = TMenuBar.getMenuBar((TrackerPanel)jComponent);
                containerArray = ((TrackerPanel)jComponent).getAxes();
                if (containerArray != null) {
                    containerArray.setName(TrackerRes.getString("CoordAxes.New.Name"));
                }
                ((TrackerPanel)jComponent).changed = bl;
                TToolBar tToolBar = (TToolBar)objectArray[3];
                tToolBar.refresh(false);
                TTrackBar tTrackBar = (TTrackBar)objectArray[5];
                tTrackBar.refresh();
            }
            TrackerPanel trackerPanel = this.getTrackerPanel(this.getSelectedTab());
            if (trackerPanel != null) {
                jComponent2 = this.getMenuBar(trackerPanel);
                this.setJMenuBar((JMenuBar)jComponent2);
                ((TMenuBar)jComponent2).refresh();
                if (Tracker.startupHintShown) {
                    trackerPanel.setMessage(TrackerRes.getString("Tracker.Startup.Hint"));
                } else {
                    trackerPanel.setCursorForMarking(false, null);
                }
            } else {
                this.refreshOpenRecentMenu(this.recentMenu);
                this.setJMenuBar(this.defaultMenuBar);
            }
            int n = 0;
            while (n < this.tabbedPane.getTabCount()) {
                TrackerPanel trackerPanel2 = this.getTrackerPanel(n);
                this.tabbedPane.setTitleAt(n, trackerPanel2.getTitle());
                jComponent = trackerPanel2.getPlayer();
                ((VideoPlayer)jComponent).refresh();
                Video video = trackerPanel2.getVideo();
                if (video != null) {
                    video.getFilterStack().refresh();
                }
                TrackControl.getControl(trackerPanel2).refresh();
                this.getToolBar(trackerPanel2).refresh(false);
                this.getTrackBar(trackerPanel2).refresh();
                containerArray = this.getViews(trackerPanel2);
                int n2 = 0;
                while (n2 < containerArray.length) {
                    if (containerArray[n2] instanceof TViewChooser) {
                        ((TViewChooser)containerArray[n2]).refresh();
                    }
                    ++n2;
                }
                if (trackerPanel2.autoTracker != null) {
                    trackerPanel2.autoTracker.getWizard().textPaneSize = null;
                    trackerPanel2.autoTracker.getWizard().refreshGUI();
                    trackerPanel2.autoTracker.getWizard().pack();
                }
                if (this.prefsDialog != null && this.prefsDialog.isVisible()) {
                    this.prefsDialog.refreshGUI();
                }
                this.cancelNotesDialogButton.setText(TrackerRes.getString("Dialog.Button.Cancel"));
                this.closeNotesDialogButton.setText(TrackerRes.getString("Dialog.Button.Close"));
                this.displayWhenLoadedCheckbox.setText(TrackerRes.getString("TFrame.NotesDialog.Checkbox.ShowByDefault"));
                ++n;
            }
            TTrackBar.refreshMemoryButton();
            this.validate();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!Tracker.splash.isVisible()) {
            return;
        }
        Timer timer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Tracker.splash.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public void setAnglesInRadians(boolean bl) {
        if (this.anglesInRadians == bl) {
            return;
        }
        this.anglesInRadians = bl;
        this.firePropertyChange("radian_angles", null, (Object)bl);
    }

    public PrefsDialog getPrefsDialog() {
        TrackerPanel trackerPanel = this.getTrackerPanel(this.getSelectedTab());
        if (this.prefsDialog != null) {
            if (this.prefsDialog.trackerPanel != trackerPanel) {
                this.prefsDialog.trackerPanel = trackerPanel;
                this.prefsDialog.refreshGUI();
            }
        } else {
            this.prefsDialog = new PrefsDialog(trackerPanel, this);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - this.prefsDialog.getBounds().width) / 2;
            int n2 = (dimension.height - this.prefsDialog.getBounds().height) / 2;
            this.prefsDialog.setLocation(n, n2);
        }
        return this.prefsDialog;
    }

    public void showPrefsDialog() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PrefsDialog prefsDialog = TFrame.this.getPrefsDialog();
                prefsDialog.setVisible(true);
                prefsDialog.requestFocus();
            }
        };
        new Thread(runnable).start();
    }

    public void showPrefsDialog(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PrefsDialog prefsDialog = TFrame.this.getPrefsDialog();
                if (string != null) {
                    if (string.contains("runtime")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.runtimePanel);
                    } else if (string.contains("video")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.videoPanel);
                    } else if (string.contains("general")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.generalPanel);
                    } else if (string.contains("display")) {
                        prefsDialog.tabbedPane.setSelectedComponent(prefsDialog.displayPanel);
                    }
                }
                prefsDialog.setVisible(true);
                prefsDialog.requestFocus();
            }
        };
        new Thread(runnable).start();
    }

    private Container[] createViews(TrackerPanel trackerPanel) {
        TViewChooser tViewChooser = new TViewChooser(trackerPanel);
        tViewChooser.setSelectedView(tViewChooser.getView(TrackerRes.getString("TFrame.View.Plot")));
        TViewChooser tViewChooser2 = new TViewChooser(trackerPanel);
        tViewChooser2.setSelectedView(tViewChooser2.getView(TrackerRes.getString("TFrame.View.Table")));
        TViewChooser tViewChooser3 = new TViewChooser(trackerPanel);
        tViewChooser3.setSelectedView(tViewChooser3.getView(TrackerRes.getString("TFrame.View.World")));
        TViewChooser tViewChooser4 = new TViewChooser(trackerPanel);
        tViewChooser4.setSelectedView(tViewChooser4.getView(TrackerRes.getString("TFrame.View.Text")));
        return new Container[]{tViewChooser, tViewChooser2, tViewChooser3, tViewChooser4};
    }

    JSplitPane[] getSplitPanes(final TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray != null) {
            return (JSplitPane[])objectArray[2];
        }
        JSplitPane[] jSplitPaneArray = new JSplitPane[]{new JSplitPane(1){

            @Override
            public void setDividerLocation(int n) {
                int n2 = this.getDividerLocation();
                int n3 = this.getMaximumDividerLocation();
                if (n == n3) {
                    super.setDividerLocation(1.0);
                } else if (n != n2) {
                    super.setDividerLocation(n);
                }
                n2 = this.getDividerLocation();
                boolean bl = 1.0 * (double)n2 / (double)n3 < 0.98;
                TMenuBar.getMenuBar((TrackerPanel)trackerPanel).rightPaneItem.setSelected(bl);
            }
        }, new JSplitPane(0), new JSplitPane(0){

            @Override
            public void setDividerLocation(int n) {
                int n2 = this.getDividerLocation();
                int n3 = this.getMaximumDividerLocation();
                if (n == n3) {
                    super.setDividerLocation(1.0);
                } else if (n != n2) {
                    super.setDividerLocation(n);
                }
                n2 = this.getDividerLocation();
                boolean bl = 1.0 * (double)n2 / (double)n3 < 0.98;
                TMenuBar.getMenuBar((TrackerPanel)trackerPanel).bottomPaneItem.setSelected(bl);
            }
        }, new JSplitPane(1){

            @Override
            public void setDividerLocation(int n) {
                int n2 = this.getDividerLocation();
                int n3 = this.getMinimumDividerLocation();
                if (n == n3) {
                    if (n2 != 0) {
                        super.setDividerLocation(0);
                    }
                } else if (n != n2) {
                    super.setDividerLocation(n);
                }
            }
        }};
        jSplitPaneArray[0].setResizeWeight(1.0);
        jSplitPaneArray[1].setResizeWeight(0.5);
        jSplitPaneArray[2].setResizeWeight(1.0);
        jSplitPaneArray[3].setResizeWeight(0.5);
        jSplitPaneArray[0].setOneTouchExpandable(true);
        jSplitPaneArray[1].setOneTouchExpandable(true);
        jSplitPaneArray[2].setOneTouchExpandable(true);
        jSplitPaneArray[3].setOneTouchExpandable(true);
        return jSplitPaneArray;
    }

    public TToolBar getToolBar(TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray != null) {
            return (TToolBar)objectArray[3];
        }
        return TToolBar.getToolbar(trackerPanel);
    }

    public TMenuBar getMenuBar(TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray != null && objectArray[4] != null) {
            return (TMenuBar)objectArray[4];
        }
        return TMenuBar.getMenuBar(trackerPanel);
    }

    public TTrackBar getTrackBar(TrackerPanel trackerPanel) {
        Object[] objectArray = this.getArray(trackerPanel);
        if (objectArray != null) {
            return (TTrackBar)objectArray[5];
        }
        return TTrackBar.getTrackbar(trackerPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshOpenRecentMenu(JMenu jMenu) {
        ArrayList<String> arrayList = Tracker.recentFiles;
        synchronized (arrayList) {
            jMenu.setText(TrackerRes.getString("TMenuBar.Menu.OpenRecent"));
            jMenu.setEnabled(!Tracker.recentFiles.isEmpty());
            if (this.openRecentAction == null) {
                this.openRecentAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n;
                        String string = actionEvent.getActionCommand();
                        URL uRL = null;
                        File file = new File(string);
                        if (!file.exists() && (n = string.indexOf("!")) > -1) {
                            file = new File(string.substring(0, n));
                        }
                        if (!file.exists()) {
                            try {
                                uRL = new URL(actionEvent.getActionCommand());
                            }
                            catch (MalformedURLException malformedURLException) {}
                        }
                        if (!file.exists() && uRL == null) {
                            Tracker.recentFiles.remove(actionEvent.getActionCommand());
                            n = TFrame.this.getSelectedTab();
                            if (n > -1) {
                                TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(n);
                                TMenuBar.getMenuBar(trackerPanel).refresh();
                            } else {
                                TFrame.this.refreshOpenRecentMenu(TFrame.this.recentMenu);
                            }
                            JOptionPane.showMessageDialog(TFrame.this, String.valueOf(TrackerRes.getString("TFrame.Dialog.FileNotFound.Message")) + "\n" + MediaRes.getString("VideoIO.Dialog.Label.Path") + ": " + actionEvent.getActionCommand(), TrackerRes.getString("TFrame.Dialog.FileNotFound.Title"), 2);
                            return;
                        }
                        TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab());
                        if (trackerPanel != null) {
                            trackerPanel.setMouseCursor(Cursor.getPredefinedCursor(3));
                        }
                        TrackerIO.open(string, TFrame.this);
                        TFrame.this.setCursor(Cursor.getDefaultCursor());
                    }
                };
            }
            jMenu.removeAll();
            jMenu.setEnabled(!Tracker.recentFiles.isEmpty());
            for (String string : Tracker.recentFiles) {
                JMenuItem jMenuItem = new JMenuItem(XML.getName(string));
                jMenuItem.setActionCommand(string);
                jMenuItem.setToolTipText(string);
                jMenuItem.addActionListener(this.openRecentAction);
                jMenu.add(jMenuItem);
            }
        }
        FontSizer.setFonts(jMenu, FontSizer.getLevel());
    }

    public void refresh() {
        int n = this.getSelectedTab();
        if (n < 0) {
            return;
        }
        TrackerPanel trackerPanel = this.getTrackerPanel(n);
        this.getMenuBar(trackerPanel).refresh();
        this.getToolBar(trackerPanel).refresh(true);
        this.getTrackBar(trackerPanel).refresh();
        Container[] containerArray = this.getViews(trackerPanel);
        int n2 = containerArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Container container = containerArray[n3];
            if (container instanceof TViewChooser) {
                TViewChooser tViewChooser = (TViewChooser)container;
                tViewChooser.refreshMenus();
            }
            ++n3;
        }
        trackerPanel.refreshNotesDialog();
    }

    public void refreshWindowMenu(TrackerPanel trackerPanel) {
        JComponent jComponent;
        JSplitPane jSplitPane = this.getSplitPane(trackerPanel, 0);
        int n = jSplitPane.getMaximumDividerLocation();
        int n2 = jSplitPane.getDividerLocation();
        double d = 1.0 * (double)n2 / (double)n;
        TMenuBar tMenuBar = TMenuBar.getMenuBar(trackerPanel);
        tMenuBar.rightPaneItem.setSelected(d < 0.99);
        jSplitPane = this.getSplitPane(trackerPanel, 2);
        n = jSplitPane.getMaximumDividerLocation();
        n2 = jSplitPane.getDividerLocation();
        d = 1.0 * (double)n2 / (double)n;
        tMenuBar.bottomPaneItem.setSelected(d < 0.99);
        TrackControl trackControl = TrackControl.getControl(trackerPanel);
        tMenuBar.trackControlItem.setSelected(trackControl.isVisible());
        tMenuBar.trackControlItem.setEnabled(!trackControl.isEmpty());
        tMenuBar.notesItem.setSelected(this.notesDialog.isVisible());
        tMenuBar.dataBuilderItem.setSelected(trackerPanel.dataBuilder != null && trackerPanel.dataBuilder.isVisible());
        tMenuBar.dataToolItem.setSelected(DataTool.getTool().isVisible());
        tMenuBar.windowMenu.removeAll();
        boolean bl = false;
        Container[] containerArray = this.getViews(trackerPanel);
        int n3 = 0;
        while (n3 < containerArray.length) {
            if (containerArray[n3] instanceof TViewChooser) {
                jComponent = (TViewChooser)containerArray[n3];
                if (((TViewChooser)jComponent).maximized) {
                    bl = true;
                    break;
                }
            }
            ++n3;
        }
        if (bl) {
            tMenuBar.windowMenu.add(tMenuBar.restoreItem);
        } else {
            tMenuBar.windowMenu.add(tMenuBar.rightPaneItem);
            tMenuBar.windowMenu.add(tMenuBar.bottomPaneItem);
        }
        tMenuBar.windowMenu.addSeparator();
        tMenuBar.windowMenu.add(tMenuBar.trackControlItem);
        tMenuBar.windowMenu.add(tMenuBar.notesItem);
        if (trackerPanel.isEnabled("data.builder") || trackerPanel.isEnabled("data.tool")) {
            tMenuBar.windowMenu.addSeparator();
            if (trackerPanel.isEnabled("data.builder")) {
                tMenuBar.windowMenu.add(tMenuBar.dataBuilderItem);
            }
            if (trackerPanel.isEnabled("data.tool")) {
                tMenuBar.windowMenu.add(tMenuBar.dataToolItem);
            }
        }
        n3 = 0;
        while (n3 < this.getTabCount()) {
            if (n3 == 0) {
                tMenuBar.windowMenu.addSeparator();
            }
            jComponent = new JRadioButtonMenuItem(this.getTabTitle(n3));
            ((AbstractButton)jComponent).setActionCommand(String.valueOf(n3));
            ((AbstractButton)jComponent).setSelected(n3 == this.getSelectedTab());
            ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = Integer.parseInt(actionEvent.getActionCommand());
                    TFrame.this.setSelectedTab(n);
                }
            });
            tMenuBar.windowMenu.add((JMenuItem)jComponent);
            ++n3;
        }
        tMenuBar.windowMenu.revalidate();
    }

    @Override
    public void setFontLevel(int n) {
        Object object;
        super.setFontLevel(n);
        if (this.tabbedPane == null) {
            return;
        }
        Step.textLayoutFont = FontSizer.getResizedFont(Step.textLayoutFont, n);
        ExportZipDialog exportZipDialog = null;
        ExportVideoDialog exportVideoDialog = null;
        ThumbnailDialog thumbnailDialog = null;
        int n2 = 0;
        while (n2 < this.getTabCount()) {
            object = this.getTrackerPanel(n2);
            ((TrackerPanel)object).setFontLevel(n);
            if (exportZipDialog == null) {
                exportZipDialog = ExportZipDialog.getDialog((TrackerPanel)object);
            }
            if (exportVideoDialog == null) {
                exportVideoDialog = ExportVideoDialog.getDialog((TrackerPanel)object);
            }
            if (thumbnailDialog == null) {
                thumbnailDialog = ThumbnailDialog.getDialog((TrackerPanel)object, true);
            }
            ++n2;
        }
        if (exportZipDialog != null) {
            exportZipDialog.setFontLevel(n);
        }
        if (exportVideoDialog != null) {
            exportVideoDialog.setFontLevel(n);
        }
        if (thumbnailDialog != null) {
            FontSizer.setFonts(thumbnailDialog, n);
            thumbnailDialog.refreshGUI();
        }
        if (this.prefsDialog != null) {
            this.prefsDialog.refreshGUI();
        }
        if (this.libraryBrowser != null) {
            this.libraryBrowser.setFontLevel(n);
        }
        if (this.helpLauncher != null) {
            FontSizer.setFonts(this.helpLauncher, n);
        }
        FontSizer.setFonts(this.notesDialog, n);
        FontSizer.setFonts(OSPLog.getOSPLog(), n);
        if (Tracker.readmeDialog != null) {
            FontSizer.setFonts(Tracker.readmeDialog, n);
        }
        if (Tracker.startLogDialog != null) {
            FontSizer.setFonts(Tracker.startLogDialog, n);
        }
        FontSizer.setFonts(this.defaultMenuBar, n);
        if (this.helpLauncher != null && this.helpLauncher.getTabCount() > 0) {
            LaunchPanel launchPanel = this.helpLauncher.getTab(0);
            if (n > 0) {
                object = "help" + n + ".css";
                launchPanel.getHTMLSubstitutionMap().put("help.css", (String)object);
            } else {
                launchPanel.getHTMLSubstitutionMap().remove("help.css");
            }
            int n3 = 0;
            while (n3 < this.helpLauncher.getHTMLTabCount()) {
                Launcher.HTMLPane hTMLPane = this.helpLauncher.getHTMLTab(n3);
                hTMLPane.editorPane.getDocument().putProperty("stream", null);
                ++n3;
            }
            this.helpLauncher.setDivider((int)(175.0 * (1.0 + 0.36 * (double)n)));
            this.helpLauncher.refreshSelectedTab();
        }
    }

    protected LibraryBrowser getLibraryBrowser() {
        if (this.libraryBrowser == null) {
            JDialog jDialog = new JDialog((Frame)this, false);
            this.libraryBrowser = LibraryBrowser.getBrowser(jDialog);
            this.libraryBrowser.addOSPLibrary("http://physlets.org/tracker/library/tracker_library.xml");
            this.libraryBrowser.addOSPLibrary("http://physlets.org/tracker/library/shared_library.xml");
            this.libraryBrowser.addComPADRECollection("http://www.compadre.org/osp/services/REST/osp_tracker.cfm?verb=Identify&OSPType=Tracker&OSPPrimary=Subject");
            this.libraryBrowser.refreshCollectionsMenu();
            this.libraryBrowser.addPropertyChangeListener("target", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Object object;
                    boolean bl;
                    String string;
                    TFrame.this.libraryBrowser.setCursor(Cursor.getPredefinedCursor(3));
                    LibraryResource libraryResource = (LibraryResource)propertyChangeEvent.getNewValue();
                    String string2 = XML.getResolvedPath(libraryResource.getTarget(), libraryResource.getBasePath());
                    string2 = ResourceLoader.getURIPath(string2);
                    if (string2.indexOf("document/ServeFile.cfm?") > -1) {
                        string = libraryResource.getProperty("download_filename");
                        try {
                            File file = ResourceLoader.downloadToOSPCache(string2, string, false);
                            string2 = file.toURI().toString();
                        }
                        catch (Exception exception) {
                            String string3 = TrackerRes.getString("TFrame.Dialog.LibraryError.Message");
                            JOptionPane.showMessageDialog(TFrame.this.libraryBrowser, String.valueOf(string3) + " \"" + libraryResource.getName() + "\"", TrackerRes.getString("TFrame.Dialog.LibraryError.Title"), 2);
                            return;
                        }
                    }
                    bl = (bl = (string = string2.toLowerCase()).endsWith(".trk")) || string.endsWith(".zip");
                    bl = bl || string.endsWith(".trz");
                    String[] stringArray = VideoIO.getVideoExtensions();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = stringArray[n2];
                        bl = bl || string.endsWith("." + (String)object);
                        ++n2;
                    }
                    if (bl) {
                        TFrame.this.libraryBrowser.setVisible(false);
                        object = ResourceLoader.getResourceZipURLsOK(string2);
                        if (object != null) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            arrayList.add(string2);
                            TrackerIO.open(arrayList, TFrame.this, null);
                        } else {
                            String string4 = TrackerRes.getString("TFrame.Dialog.LibraryError.FileNotFound.Message");
                            JOptionPane.showMessageDialog(TFrame.this.libraryBrowser, String.valueOf(string4) + " \"" + XML.getName(string2) + "\"", TrackerRes.getString("TFrame.Dialog.LibraryError.FileNotFound.Title"), 2);
                            TFrame.this.libraryBrowser.setVisible(true);
                        }
                    }
                    TFrame.this.libraryBrowser.setCursor(Cursor.getDefaultCursor());
                    TFrame.this.requestFocus();
                }
            });
            LibraryBrowser.fireHelpEvent = true;
            this.libraryBrowser.addPropertyChangeListener("help", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    TFrame.this.showHelp("library", 0);
                }
            });
            this.libraryBrowser.setFontLevel(FontSizer.getLevel());
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (dimension.width - jDialog.getBounds().width) / 2;
            int n2 = (dimension.height - jDialog.getBounds().height) / 2;
            jDialog.setLocation(n, n2);
        }
        return this.libraryBrowser;
    }

    protected PropertiesDialog getPropertiesDialog(TrackerPanel trackerPanel) {
        PropertiesDialog propertiesDialog = new PropertiesDialog(trackerPanel);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - propertiesDialog.getBounds().width) / 2;
        int n2 = (dimension.height - propertiesDialog.getBounds().height) / 2;
        propertiesDialog.setLocation(n, n2);
        return propertiesDialog;
    }

    protected Component getHelpDialog() {
        if (this.helpDialog == null) {
            Object object;
            Component[] componentArray;
            this.helpDialog = new JDialog(this, TrackerRes.getString("TFrame.Dialog.Help.Title"), false);
            String string = String.valueOf(helpPath) + "help_set.xml";
            this.helpLauncher = new Launcher(string, false);
            int n = FontSizer.getLevel();
            if (this.helpLauncher.getTabCount() > 0) {
                componentArray = this.helpLauncher.getTab(0);
                if (n > 0) {
                    object = "help" + n + ".css";
                    componentArray.getHTMLSubstitutionMap().put("help.css", (String)object);
                } else {
                    componentArray.getHTMLSubstitutionMap().remove("help.css");
                }
            }
            this.helpLauncher.setDivider((int)(175.0 * (1.0 + 0.36 * (double)n)));
            this.helpLauncher.setNavigationVisible(true);
            componentArray = new Component[]{Tracker.pdfHelpButton};
            this.helpLauncher.setNavbarRightEndComponents(componentArray);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension = this.helpLauncher.getSize();
            dimension.width = Math.min(9 * ((Dimension)object).width / 10, (int)((1.0 + (double)n * 0.35) * (double)dimension.width));
            dimension.height = Math.min(9 * ((Dimension)object).height / 10, (int)((1.0 + (double)n * 0.35) * (double)dimension.height));
            this.helpLauncher.setSize(dimension);
            this.helpDialog.setContentPane(this.helpLauncher.getContentPane());
            FontSizer.setFonts(this.helpDialog, FontSizer.getLevel());
            this.helpDialog.pack();
            int n2 = (((Dimension)object).width - this.helpDialog.getBounds().width) / 2;
            int n3 = (((Dimension)object).height - this.helpDialog.getBounds().height) / 2;
            this.helpDialog.setLocation(n2, n3);
        }
        return this.helpDialog;
    }

    protected void showHelp(String string) {
        this.getHelpDialog();
        this.helpLauncher.setSelectedNode(string);
        this.helpDialog.setVisible(true);
    }

    protected void showHelp(String string, int n) {
        boolean bl = this.helpDialog == null;
        this.getHelpDialog();
        if (string == null && bl) {
            string = "help";
        }
        this.helpLauncher.setSelectedNodeByKey(string, n);
        if (bl) {
            this.helpLauncher.clearHistory();
        }
        this.helpDialog.setVisible(true);
    }

    protected void showTrackControl(final TrackerPanel trackerPanel) {
        if (trackerPanel.getUserTracks().size() > 0) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    TrackControl trackControl = TrackControl.getControl(trackerPanel);
                    if (trackControl.positioned && !trackControl.isEmpty()) {
                        trackControl.setVisible(true);
                    }
                }
            };
            EventQueue.invokeLater(runnable);
        }
    }

    protected void showNotes(final TrackerPanel trackerPanel) {
        final JButton jButton = this.getToolBar((TrackerPanel)trackerPanel).notesButton;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TTrack tTrack = trackerPanel.getSelectedTrack();
                if (!trackerPanel.hideDescriptionWhenLoaded && (tTrack != null && tTrack.getDescription() != null && !tTrack.getDescription().trim().equals("") || tTrack == null && trackerPanel.getDescription() != null && !trackerPanel.getDescription().trim().equals(""))) {
                    if (!jButton.isSelected()) {
                        jButton.doClick();
                    }
                } else if (jButton.isSelected()) {
                    jButton.doClick();
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    private Object[] getArray(TrackerPanel trackerPanel) {
        int n = this.getTab(trackerPanel);
        if (n >= 0) {
            return this.tabs.get(this.tabbedPane.getComponentAt(n));
        }
        return null;
    }

    private void createGUI() {
        this.saveNotesAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (TFrame.this.notesTextPane.getBackground() == Color.WHITE) {
                    return;
                }
                String string = TFrame.this.notesTextPane.getText();
                if (TFrame.this.getSelectedTab() > -1 && TFrame.this.notesDialog.getName() != "canceled") {
                    TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab());
                    trackerPanel.changed = true;
                    TTrack tTrack = trackerPanel.getTrack(TFrame.this.notesDialog.getName());
                    if (tTrack != null && !string.equals(tTrack.getDescription())) {
                        tTrack.setDescription(string);
                    } else if (!string.equals(trackerPanel.getDescription())) {
                        trackerPanel.setDescription(string);
                        trackerPanel.hideDescriptionWhenLoaded = !TFrame.this.displayWhenLoadedCheckbox.isSelected();
                    }
                }
                TFrame.this.notesTextPane.setBackground(Color.WHITE);
                TFrame.this.cancelNotesDialogButton.setEnabled(false);
                TFrame.this.closeNotesDialogButton.setEnabled(true);
                TFrame.this.closeNotesDialogButton.setText(TrackerRes.getString("Dialog.Button.Close"));
            }
        };
        this.notesDialog = new JDialog(this, false){

            @Override
            public void setVisible(boolean bl) {
                super.setVisible(bl);
                if (TFrame.this.getSelectedTab() > -1) {
                    TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab());
                    TToolBar tToolBar = TFrame.this.getToolBar(trackerPanel);
                    tToolBar.notesButton.setSelected(bl);
                }
            }
        };
        JPanel jPanel = new JPanel(new BorderLayout());
        this.notesDialog.setContentPane(jPanel);
        this.notesTextPane = new JTextPane();
        this.notesTextPane.setBackground(Color.WHITE);
        this.notesTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String string = hyperlinkEvent.getURL().toString();
                    OSPDesktop.displayURL(string);
                }
            }
        });
        this.notesTextPane.setPreferredSize(new Dimension(420, 200));
        this.notesTextPane.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab());
                if (!trackerPanel.isEnabled("notes.edit")) {
                    return;
                }
                TFrame.this.notesTextPane.setBackground(yellow);
                TFrame.this.closeNotesDialogButton.setText(TrackerRes.getString("PrefsDialog.Button.Save"));
                TFrame.this.cancelNotesDialogButton.setEnabled(true);
            }
        });
        this.notesTextPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != TFrame.this.cancelNotesDialogButton) {
                    TFrame.this.saveNotesAction.actionPerformed(null);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.notesTextPane);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout());
        jPanel.add((Component)jPanel2, "South");
        this.displayWhenLoadedCheckbox = new JCheckBox(TrackerRes.getString("TFrame.NotesDialog.Checkbox.ShowByDefault"));
        this.displayWhenLoadedCheckbox.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab());
                if (trackerPanel != null) {
                    trackerPanel.hideDescriptionWhenLoaded = !TFrame.this.displayWhenLoadedCheckbox.isSelected();
                }
            }
        });
        jPanel2.add(this.displayWhenLoadedCheckbox);
        jPanel2.add(Box.createHorizontalStrut(50));
        this.cancelNotesDialogButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
        this.cancelNotesDialogButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame.this.notesDialog.setName("canceled");
                TFrame.this.notesDialog.setVisible(false);
            }
        });
        jPanel2.add(this.cancelNotesDialogButton);
        this.closeNotesDialogButton = new JButton(TrackerRes.getString("Dialog.Button.Close"));
        this.closeNotesDialogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame.this.notesDialog.setVisible(false);
            }
        });
        jPanel2.add(this.closeNotesDialogButton);
        this.notesDialog.pack();
        this.tabbedPane = new JTabbedPane(3);
        this.setContentPane(new JPanel(new BorderLayout()));
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.createDefaultMenuBar();
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PropertyChangeListener propertyChangeListener;
                Object object;
                TrackerPanel trackerPanel = null;
                TrackerPanel trackerPanel2 = TFrame.this.prevPanel;
                if (TFrame.this.prefsDialog != null) {
                    TFrame.this.prefsDialog.trackerPanel = null;
                }
                if (TFrame.this.playerBar != null && (object = TFrame.this.playerBar.getTopLevelAncestor()) != null && object != TFrame.this) {
                    ((Component)object).setVisible(false);
                }
                if (TFrame.this.prevPanel != null) {
                    if (TFrame.this.prevPanel.dataBuilder != null) {
                        boolean bl = TFrame.this.prevPanel.dataToolVisible;
                        TFrame.this.prevPanel.dataBuilder.setVisible(false);
                        TFrame.this.prevPanel.dataToolVisible = bl;
                    }
                    if ((object = TFrame.this.prevPanel.getPlayer().getVideoClip().getClipInspector()) != null) {
                        ((Dialog)object).setVisible(false);
                    }
                    if ((propertyChangeListener = TFrame.this.prevPanel.getVideo()) != null) {
                        propertyChangeListener.getFilterStack().setInspectorsVisible(false);
                    }
                }
                if ((object = (Object[])TFrame.this.tabs.get(TFrame.this.tabbedPane.getSelectedComponent())) != null) {
                    Video video;
                    propertyChangeListener = (MainTView)object[0];
                    TFrame.this.prevPanel = trackerPanel = ((MainTView)propertyChangeListener).getTrackerPanel();
                    if (TFrame.this.prefsDialog != null) {
                        TFrame.this.prefsDialog.trackerPanel = trackerPanel;
                    }
                    trackerPanel.refreshNotesDialog();
                    JButton jButton = TFrame.this.getToolBar((TrackerPanel)trackerPanel).notesButton;
                    jButton.setSelected(TFrame.this.notesDialog.isVisible());
                    ((TTrackBar)object[5]).refresh();
                    TMenuBar tMenuBar = (TMenuBar)object[4];
                    TFrame.this.refreshOpenRecentMenu(tMenuBar.openRecentMenu);
                    TFrame.this.setJMenuBar(tMenuBar);
                    TFrame.this.playerBar = ((MainTView)propertyChangeListener).getPlayerBar();
                    Container container = TFrame.this.playerBar.getTopLevelAncestor();
                    if (container != null && container != TFrame.this) {
                        container.setVisible(true);
                    }
                    if (trackerPanel.dataBuilder != null) {
                        trackerPanel.dataBuilder.setVisible(trackerPanel.dataToolVisible);
                    }
                    if ((video = trackerPanel.getVideo()) != null) {
                        video.getFilterStack().setInspectorsVisible(true);
                    }
                } else {
                    TFrame.this.refreshOpenRecentMenu(TFrame.this.recentMenu);
                    TFrame.this.setJMenuBar(TFrame.this.defaultMenuBar);
                }
                if (TFrame.this.prefsDialog != null && TFrame.this.prefsDialog.isVisible()) {
                    TFrame.this.prefsDialog.refreshGUI();
                }
                TFrame.this.firePropertyChange("tab", trackerPanel2, trackerPanel);
            }
        });
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame.this.removeTab(TFrame.this.getTrackerPanel(TFrame.this.getSelectedTab()));
            }
        });
        this.popup.add(this.closeItem);
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = TFrame.this.getSelectedTab();
                if (n < 0) {
                    return;
                }
                TrackerPanel trackerPanel = TFrame.this.getTrackerPanel(n);
                if (!trackerPanel.isEnabled("file.close")) {
                    return;
                }
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    TFrame.this.closeItem.setText(String.valueOf(TrackerRes.getString("TActions.Action.Close")) + " \"" + TFrame.this.tabbedPane.getTitleAt(TFrame.this.getSelectedTab()) + "\"");
                    FontSizer.setFonts(TFrame.this.popup, FontSizer.getLevel());
                    TFrame.this.popup.show(TFrame.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private void createDefaultMenuBar() {
        JMenuItem jMenuItem;
        Serializable serializable;
        Serializable serializable2;
        JMenuItem jMenuItem2;
        Accessible accessible;
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.defaultMenuBar = new JMenuBar();
        this.setJMenuBar(this.defaultMenuBar);
        JMenu jMenu = new JMenu(TrackerRes.getString("TMenuBar.Menu.File"));
        this.defaultMenuBar.add(jMenu);
        JMenuItem jMenuItem3 = new JMenuItem(TrackerRes.getString("TActions.Action.NewTab"));
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(78, n));
        jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TrackerPanel trackerPanel = new TrackerPanel();
                trackerPanel.changed = false;
                TFrame.this.addTab(trackerPanel);
                TFrame.this.setSelectedTab(trackerPanel);
                JSplitPane jSplitPane = TFrame.this.getSplitPane(trackerPanel, 0);
                jSplitPane.setDividerLocation(TFrame.this.defaultRightDivider);
                TFrame.this.refresh();
            }
        });
        jMenu.add(jMenuItem3);
        if (OSPRuntime.applet == null) {
            jMenu.addSeparator();
            accessible = new ImageIcon(Tracker.class.getResource("resources/images/open.gif"));
            jMenuItem2 = new JMenuItem(TrackerRes.getString("TActions.Action.Open"), (Icon)((Object)accessible));
            jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(79, n));
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    TrackerIO.open(null, TFrame.this);
                    TFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            jMenu.add(jMenuItem2);
            serializable2 = new JMenuItem(TrackerRes.getString("TActions.Action.OpenURL"));
            ((AbstractButton)serializable2).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Object object = JOptionPane.showInputDialog(TFrame.this, String.valueOf(TrackerRes.getString("TActions.Dialog.OpenURL.Message")) + ":                             ", TrackerRes.getString("TActions.Dialog.OpenURL.Title"), -1, null, null, null);
                    if (object == null || object.toString().trim().equals("")) {
                        return;
                    }
                    Resource resource = ResourceLoader.getResource(object.toString().trim());
                    URL uRL = resource.getURL();
                    if (uRL == null) {
                        return;
                    }
                    TFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                    TrackerIO.open(uRL, TFrame.this);
                    TFrame.this.setCursor(Cursor.getDefaultCursor());
                }
            });
            jMenu.add((JMenuItem)serializable2);
            this.recentMenu = new JMenu();
            jMenu.add(this.recentMenu);
            this.refreshOpenRecentMenu(this.recentMenu);
            jMenu.addSeparator();
            accessible = new ImageIcon(Tracker.class.getResource("resources/images/open_catalog.gif"));
            serializable = new JMenuItem(TrackerRes.getString("TActions.Action.OpenBrowser"), (Icon)((Object)accessible));
            ((AbstractButton)serializable).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    TFrame.this.getLibraryBrowser().setVisible(true);
                }
            });
            jMenu.add((JMenuItem)serializable);
            jMenu.addSeparator();
            JMenuItem jMenuItem4 = new JMenuItem(TrackerRes.getString("TActions.Action.Exit"));
            jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(81, n));
            jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    System.exit(0);
                }
            });
            jMenu.add(jMenuItem4);
        }
        accessible = new JMenu(TrackerRes.getString("TMenuBar.Menu.Edit"));
        this.defaultMenuBar.add((JMenu)accessible);
        jMenuItem2 = new JMenu(TrackerRes.getString("TMenuBar.MenuItem.Language"));
        ((JMenu)accessible).add(jMenuItem2);
        serializable2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                int n = 0;
                while (n < Tracker.locales.length) {
                    if (string.equals(Tracker.locales[n].toString())) {
                        TrackerRes.setLocale(Tracker.locales[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        serializable = new ButtonGroup();
        int n2 = 0;
        while (n2 < Tracker.locales.length) {
            jMenuItem = new JRadioButtonMenuItem(OSPRuntime.getDisplayLanguage(Tracker.locales[n2]));
            jMenuItem.setActionCommand(Tracker.locales[n2].toString());
            jMenuItem.addActionListener((ActionListener)((Object)serializable2));
            jMenuItem2.add(jMenuItem);
            ((ButtonGroup)serializable).add(jMenuItem);
            if (Tracker.locales[n2].toString().equals(TrackerRes.locale.toString())) {
                jMenuItem.setSelected(true);
            }
            ++n2;
        }
        JMenuItem jMenuItem5 = new JMenuItem(TrackerRes.getString("TActions.Action.Config"));
        jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame.this.showPrefsDialog();
            }
        });
        ((JMenu)accessible).addSeparator();
        ((JMenu)accessible).add(jMenuItem5);
        jMenuItem = new JMenu(TrackerRes.getString("TMenuBar.Menu.Video"));
        jMenuItem.setEnabled(false);
        this.defaultMenuBar.add((JMenu)jMenuItem);
        JMenu jMenu2 = new JMenu(TrackerRes.getString("TMenuBar.Menu.Tracks"));
        jMenu2.setEnabled(false);
        this.defaultMenuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(TrackerRes.getString("TMenuBar.Menu.Coords"));
        jMenu3.setEnabled(false);
        this.defaultMenuBar.add(jMenu3);
        JMenu jMenu4 = TMenuBar.getTrackerHelpMenu();
        this.defaultMenuBar.add(jMenu4);
    }

    private void initialize(TrackerPanel trackerPanel) {
        int n;
        Object object;
        int n2;
        Object object2;
        if (trackerPanel.getDrawables(TMat.class).isEmpty()) {
            new TMat(trackerPanel);
        }
        if (trackerPanel.getAxes() == null) {
            Tracker.setProgress(80);
            object2 = new CoordAxes();
            ((CoordAxes)object2).setVisible(false);
            trackerPanel.addTrack((TTrack)object2);
        }
        trackerPanel.addFilter(DeinterlaceFilter.class);
        trackerPanel.addFilter(GhostFilter.class);
        trackerPanel.addFilter(DarkGhostFilter.class);
        trackerPanel.addFilter(NegativeFilter.class);
        trackerPanel.addFilter(GrayScaleFilter.class);
        trackerPanel.addFilter(BrightnessFilter.class);
        trackerPanel.addFilter(BaselineFilter.class);
        trackerPanel.addFilter(SumFilter.class);
        trackerPanel.addFilter(ResizeFilter.class);
        trackerPanel.addFilter(RotateFilter.class);
        trackerPanel.addFilter(PerspectiveFilter.class);
        trackerPanel.addFilter(RadialDistortionFilter.class);
        object2 = new TMouseHandler();
        trackerPanel.setInteractiveMouseHandler((InteractiveMouseHandler)object2);
        trackerPanel.setTransferHandler(this.fileDropHandler);
        this.validate();
        if (trackerPanel.dividerLocs != null) {
            int n3 = 0;
            n2 = 0;
            while (n2 < trackerPanel.dividerLocs.length) {
                object = this.getSplitPane(trackerPanel, n2);
                if (n2 == 0) {
                    n3 = ((JSplitPane)object).getMaximumDividerLocation();
                }
                n = n2 == 3 ? n3 : ((JSplitPane)object).getMaximumDividerLocation();
                int n4 = (int)(trackerPanel.dividerLocs[n2] * (double)n);
                ((JSplitPane)object).setDividerLocation(n4);
                ++n2;
            }
            trackerPanel.dividerLocs = null;
        } else {
            this.setDividerLocation(trackerPanel, 0, 1.0);
            this.setDividerLocation(trackerPanel, 0, this.defaultRightDivider);
            this.setDividerLocation(trackerPanel, 1, 0.5);
            this.setDividerLocation(trackerPanel, 2, this.defaultBottomDivider);
            this.setDividerLocation(trackerPanel, 2, 1.0);
            this.setDividerLocation(trackerPanel, 3, 1.0);
            JSplitPane jSplitPane = this.getSplitPane(trackerPanel, 0);
            n2 = jSplitPane.getMaximumDividerLocation();
            int n5 = (int)(0.5 * this.defaultRightDivider * (double)n2);
            jSplitPane = this.getSplitPane(trackerPanel, 3);
            jSplitPane.setDividerLocation(n5);
        }
        this.validate();
        if (trackerPanel.trackControlX != Integer.MIN_VALUE) {
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            TrackControl trackControl = TrackControl.getControl(trackerPanel);
            int n6 = Math.max(this.getLocation().x + trackerPanel.trackControlX, 0);
            n6 = Math.min(n6, dimension.width - trackControl.getWidth());
            n = Math.max(this.getLocation().y + trackerPanel.trackControlY, 0);
            n = Math.min(n, dimension.height - trackControl.getHeight());
            trackControl.setLocation(n6, n);
            trackControl.positioned = true;
        }
        if (trackerPanel.visibleFilters != null) {
            Iterator<Filter> iterator = trackerPanel.visibleFilters.keySet().iterator();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            while (iterator.hasNext()) {
                object = iterator.next();
                Point point = trackerPanel.visibleFilters.get(object);
                JDialog jDialog = ((Filter)object).getInspector();
                int n7 = Math.max(point.x + this.getLocation().x, 0);
                n7 = Math.min(n7, dimension.width - jDialog.getWidth());
                int n8 = Math.max(point.y + this.getLocation().y, 0);
                n8 = Math.min(n8, dimension.height - jDialog.getHeight());
                jDialog.setLocation(n7, n8);
                jDialog.setVisible(true);
            }
            trackerPanel.visibleFilters = null;
        }
        Tracker.setProgress(90);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            TFrame tFrame = (TFrame)object;
            String string = tFrame.tabsetFile != null ? XML.getDirectoryPath(XML.getAbsolutePath(tFrame.tabsetFile)) : XML.getUserDirectory();
            string = XML.forwardSlash(string);
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            int n = 0;
            while (n < tFrame.getTabCount()) {
                String string2;
                Object object2;
                TrackerPanel trackerPanel = tFrame.getTrackerPanel(n);
                File file = trackerPanel.getDataFile();
                if (file != null) {
                    object2 = XML.getAbsolutePath(file);
                    string2 = XML.getPathRelativeTo((String)object2, string);
                    arrayList.add(new String[]{object2, string2});
                } else {
                    object2 = trackerPanel.getVideo();
                    if (!trackerPanel.changed && object2 != null && (string2 = (String)object2.getProperty("absolutePath")) != null) {
                        string2 = XML.forwardSlash(string2);
                        String string3 = XML.getPathRelativeTo(string2, string);
                        arrayList.add(new String[]{string2, string3});
                    }
                }
                ++n;
            }
            String[][] stringArray = (String[][])arrayList.toArray((T[])new String[0][0]);
            xMLControl.setValue("tabs", stringArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            int n;
            File file;
            TFrame tFrame;
            block9: {
                tFrame = (TFrame)object;
                VideoFileFilter videoFileFilter = new VideoFileFilter();
                String[][] stringArray = (String[][])xMLControl.getObject("tabs");
                String string = xMLControl.getString("basepath");
                file = null;
                if (stringArray == null) break block9;
                n = TrackerIO.loadInSeparateThread;
                TrackerIO.loadInSeparateThread = false;
                String[][] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    block11: {
                        Resource resource;
                        File file2;
                        block10: {
                            String[] stringArray3 = stringArray2[n3];
                            file2 = null;
                            resource = null;
                            if (string != null) {
                                file2 = new File(string, stringArray3[1]);
                                resource = ResourceLoader.getResource(file2.getPath());
                            }
                            if (resource == null) {
                                file2 = new File(XML.getUserDirectory(), stringArray3[1]);
                                resource = ResourceLoader.getResource(file2.getPath());
                            }
                            if (resource == null && stringArray3[0] != null) {
                                file2 = new File(stringArray3[0]);
                                resource = ResourceLoader.getResource(file2.getPath());
                            }
                            if (resource != null) break block10;
                            int n4 = JOptionPane.showConfirmDialog(tFrame, "\"" + stringArray3[1] + "\" " + MediaRes.getString("VideoClip.Dialog.VideoNotFound.Message"), TrackerRes.getString("TFrame.Dialog.FileNotFound.Title"), 0, 2);
                            if (n4 != 0) break block11;
                            TrackerIO.getChooser().setSelectedFile(file2);
                            File[] fileArray = TrackerIO.getChooserFiles("open");
                            if (fileArray == null) break block11;
                            file2 = fileArray[0];
                        }
                        if (resource != null && !((FileFilter)videoFileFilter).accept(file2)) {
                            if (file == null) {
                                file = file2;
                            }
                            TrackerIO.open(file2, tFrame);
                        }
                    }
                    ++n3;
                }
                TrackerIO.loadInSeparateThread = n;
            }
            n = tFrame.getTab(file);
            OSPLog.finest("selecting first tabset tab at index " + n);
            tFrame.setSelectedTab(n);
            return object;
        }
    }
}

