/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class TButton
extends JButton {
    protected TTrack track;
    private boolean hidePopup = false;
    private JPopupMenu popup;

    public TButton() {
        this.setOpaque(false);
        this.setBorderPainted(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TButton.this.setBorderPainted(true);
                TButton.this.hidePopup = TButton.this.popup != null && TButton.this.popup.isVisible();
                if (Tracker.showHints && TButton.this.track != null && TButton.this.track.trackerPanel != null) {
                    if (TButton.this.track.trackerPanel.getSelectedTrack() == TButton.this.track) {
                        TButton.this.track.trackerPanel.setMessage(TButton.this.track.getMessage());
                    } else {
                        String string = String.valueOf(TButton.this.track.getClass().getSimpleName()) + " " + TButton.this.track.getName() + " (" + TrackerRes.getString("TTrack.Unselected.Hint") + ")";
                        TButton.this.track.trackerPanel.setMessage(string);
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TButton.this.setBorderPainted(false);
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (TButton.this.track != null && TButton.this.track.trackerPanel != null && TButton.this.track != TButton.this.track.trackerPanel.getSelectedTrack()) {
                    TButton.this.track.trackerPanel.setSelectedTrack(TButton.this.track);
                    TButton.this.track.trackerPanel.setSelectedPoint(null);
                    TButton.this.hidePopup = true;
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TButton.this.popup = TButton.this.getPopup();
                if (TButton.this.popup != null) {
                    if (mouseEvent.getClickCount() == 2) {
                        TButton.this.hidePopup = false;
                    }
                    if (TButton.this.hidePopup) {
                        TButton.this.hidePopup = false;
                        TButton.this.popup.setVisible(false);
                    } else {
                        TButton.this.hidePopup = true;
                        TButton.this.popup.show(TButton.this, 0, TButton.this.getHeight());
                    }
                }
            }
        });
    }

    public TButton(AbstractAction abstractAction) {
        this();
        this.addActionListener(abstractAction);
        this.setIcon((Icon)abstractAction.getValue("SmallIcon"));
    }

    public TButton(TTrack tTrack) {
        this();
        this.setTrack(tTrack);
    }

    public TButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    public TButton(Icon icon, Icon icon2) {
        this();
        this.setIcons(icon, icon2);
    }

    public void setIcons(Icon icon, Icon icon2) {
        super.setIcon(icon);
        this.setSelectedIcon(icon2);
    }

    public void setTrack(TTrack tTrack) {
        this.track = tTrack;
        if (tTrack != null) {
            this.setIcon(tTrack.getFootprint().getIcon(21, 16));
            this.setText(tTrack.getName());
            this.setToolTipText(String.valueOf(TrackerRes.getString("TButton.Track.ToolTip")) + " " + tTrack.getName());
            FontSizer.setFonts(this, FontSizer.getLevel());
        } else {
            this.setIcon(null);
            this.setText(" ");
            this.setToolTipText(null);
        }
    }

    public TTrack getTrack() {
        return this.track;
    }

    protected JPopupMenu getPopup() {
        if (this.track != null && this.track.trackerPanel != null) {
            JMenu jMenu = this.track.getMenu(this.track.trackerPanel);
            FontSizer.setFonts(jMenu, FontSizer.getLevel());
            return jMenu.getPopupMenu();
        }
        return null;
    }
}

