/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.RGBStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.IntegerField;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.FontSizer;

public class RGBRegion
extends TTrack {
    protected static final int MAX_RADIUS = 100;
    protected static int defaultRadius = 10;
    protected boolean fixedPosition = true;
    protected boolean fixedRadius = true;
    protected JCheckBoxMenuItem fixedPositionItem;
    protected JCheckBoxMenuItem fixedRadiusItem;
    protected JLabel radiusLabel;
    protected IntegerField radiusField;
    protected boolean firstTimeRadiusUnfixed = true;
    protected ArrayList<RGBStep> validSteps = new ArrayList();
    protected boolean dataHidden = false;
    protected boolean loading;
    protected TreeSet<Integer> radiusKeyFrames = new TreeSet();

    public RGBRegion() {
        this.defaultColors = new Color[]{Color.magenta};
        this.setName(TrackerRes.getString("RGBRegion.New.Name"));
        this.setProperty("yVarPlot0", "luma");
        this.setProperty("yMinPlot0", new Double(0.0));
        this.setProperty("yMaxPlot0", new Double(255.0));
        this.setProperty("tableVar0", "0");
        this.setProperty("tableVar1", "1");
        this.setProperty("tableVar2", "5");
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.Circle"), PointShapeFootprint.getFootprint("Footprint.BoldCircle")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("RGBRegion.Unmarked.Hint");
        this.radiusLabel = new JLabel();
        this.radiusField = new IntegerField(2);
        this.radiusField.setMinValue(1.0);
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (RGBRegion.this.radiusField.getBackground() == Color.yellow) {
                    RGBRegion.this.setRadius(RGBRegion.this.trackerPanel.getFrameNumber(), RGBRegion.this.radiusField.getIntValue());
                }
            }
        };
        this.radiusField.addFocusListener(focusAdapter);
        this.radiusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                focusAdapter.focusLost(null);
                RGBRegion.this.radiusField.selectAll();
                RGBRegion.this.radiusField.requestFocusInWindow();
            }
        });
        this.fixedPositionItem = new JCheckBoxMenuItem(TrackerRes.getString("RGBRegion.MenuItem.Fixed"));
        this.fixedPositionItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RGBRegion.this.setFixedPosition(RGBRegion.this.fixedPositionItem.isSelected());
            }
        });
        this.fixedRadiusItem = new JCheckBoxMenuItem(TrackerRes.getString("RGBRegion.MenuItem.FixedRadius"));
        this.fixedRadiusItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                RGBRegion.this.setFixedRadius(RGBRegion.this.fixedRadiusItem.isSelected());
            }
        });
        this.radiusField.setBorder(this.fieldBorder);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberField numberField = (NumberField)actionEvent.getSource();
                if (numberField.getBackground() == Color.yellow) {
                    RGBRegion.this.setPositionFromFields();
                }
                numberField.selectAll();
                numberField.requestFocusInWindow();
            }
        };
        FocusAdapter focusAdapter2 = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                NumberField numberField = (NumberField)focusEvent.getSource();
                if (numberField.getBackground() == Color.yellow) {
                    RGBRegion.this.setPositionFromFields();
                }
            }
        };
        this.xField.addActionListener(abstractAction);
        this.yField.addActionListener(abstractAction);
        this.xField.addFocusListener(focusAdapter2);
        this.yField.addFocusListener(focusAdapter2);
    }

    public void setFixedPosition(boolean bl) {
        if (this.fixedPosition == bl) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.fixedPosition = bl;
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            RGBStep rGBStep = (RGBStep)this.getStep(n);
            Step[] stepArray = this.steps.array;
            int n2 = this.steps.array.length;
            int n3 = 0;
            while (n3 < n2) {
                Step step = stepArray[n3];
                if (step != null) {
                    RGBStep rGBStep2 = (RGBStep)step;
                    rGBStep2.getPosition().setLocation(rGBStep.getPosition());
                }
                ++n3;
            }
        }
        this.fixedPosition = bl;
        if (bl) {
            this.keyFrames.clear();
            this.keyFrames.add(0);
            this.clearData();
            this.refreshData(this.data, this.trackerPanel);
            this.support.firePropertyChange("data", null, null);
        }
        if (!this.loading) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
        this.repaint();
    }

    public boolean isFixedPosition() {
        return this.fixedPosition;
    }

    public void setFixedRadius(boolean bl) {
        if (this.fixedRadius == bl) {
            return;
        }
        if (this.steps.isEmpty()) {
            this.fixedRadius = bl;
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            RGBStep rGBStep = (RGBStep)this.getStep(n);
            Step[] stepArray = this.steps.array;
            int n2 = this.steps.array.length;
            int n3 = 0;
            while (n3 < n2) {
                Step step = stepArray[n3];
                if (step != null) {
                    RGBStep rGBStep2 = (RGBStep)step;
                    rGBStep2.setRadius(rGBStep.radius);
                }
                ++n3;
            }
        }
        this.fixedRadius = bl;
        if (bl) {
            this.radiusKeyFrames.clear();
            this.radiusKeyFrames.add(0);
            this.clearData();
            this.refreshData(this.data, this.trackerPanel);
            this.support.firePropertyChange("data", null, null);
        }
        if (!this.loading) {
            Undo.postTrackEdit(this, xMLControlElement);
        }
        this.repaint();
    }

    public boolean isFixedRadius() {
        return this.fixedRadius;
    }

    protected void setRadius(int n, int n2) {
        RGBStep rGBStep;
        if (this.isLocked() || n2 == Integer.MIN_VALUE || this.trackerPanel == null) {
            return;
        }
        n2 = Math.max(n2, 0);
        n2 = Math.min(n2, 100);
        this.radiusField.setIntValue(n2);
        RGBStep rGBStep2 = rGBStep = (RGBStep)this.getStep(n);
        if (rGBStep != null && rGBStep.radius != n2) {
            TPoint tPoint = this.trackerPanel.getSelectedPoint();
            this.trackerPanel.setSelectedPoint(null);
            XMLControlElement xMLControlElement = new XMLControlElement(rGBStep);
            if (this.isFixedRadius()) {
                rGBStep2 = (RGBStep)this.steps.getStep(0);
                this.clearData();
                rGBStep2.setRadius(n2);
                this.refreshStep(rGBStep);
            } else {
                this.radiusKeyFrames.add(n);
                rGBStep.setRadius(n2);
                rGBStep.dataValid = false;
            }
            Undo.postStepEdit(rGBStep, xMLControlElement);
            this.trackerPanel.setSelectedPoint(tPoint);
            this.refreshData(this.data, this.trackerPanel);
            rGBStep.repaint();
            this.firePropertyChange("data", null, this);
        }
    }

    public int getRadius() {
        int n;
        RGBStep rGBStep;
        if (this.isFixedRadius()) {
            RGBStep rGBStep2 = (RGBStep)this.getStep(0);
            if (rGBStep2 != null) {
                return rGBStep2.radius;
            }
        } else if (this.trackerPanel != null && !this.fixedRadius && (rGBStep = (RGBStep)this.getStep(n = this.trackerPanel.getFrameNumber())) != null) {
            return rGBStep.radius;
        }
        return defaultRadius;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.isMarking && !(this.trackerPanel.getSelectedPoint() instanceof RGBStep.Position)) {
            return;
        }
        super.draw(drawingPanel, graphics);
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        if (interactive != null) {
            this.partName = TrackerRes.getString("RGBRegion.Position.Name");
            this.hint = TrackerRes.getString("RGBRegion.Position.Hint");
        } else {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = this.getStep(this.trackerPanel.getFrameNumber()) == null ? TrackerRes.getString("RGBRegion.Unmarked.Hint") : TrackerRes.getString("RGBRegion.Hint");
            if (this.trackerPanel.getVideo() == null) {
                this.hint = String.valueOf(this.hint) + ", " + TrackerRes.getString("TTrack.ImportVideo.Hint");
            }
        }
        return interactive;
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public boolean isAutoAdvance() {
        return !this.isFixedPosition();
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        if (this.isLocked()) {
            return null;
        }
        int n2 = this.isFixedPosition() ? 0 : n;
        RGBStep rGBStep = (RGBStep)this.steps.getStep(n2);
        if (rGBStep == null) {
            int n3 = (int)this.radiusField.getValue();
            rGBStep = new RGBStep(this, 0, d, d2, n3);
            rGBStep.setFootprint(this.getFootprint());
            this.steps = new TTrack.StepArray(this, rGBStep);
            this.keyFrames.add(0);
            this.radiusKeyFrames.add(0);
        } else {
            XMLControlElement xMLControlElement = new XMLControlElement(this);
            rGBStep.getPosition().setLocation(d, d2);
            this.keyFrames.add(n);
            Undo.postTrackEdit(this, xMLControlElement);
        }
        this.support.firePropertyChange("step", null, (Object)n);
        return this.getStep(n);
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        RGBStep rGBStep = (RGBStep)this.steps.getStep(n);
        this.refreshStep(rGBStep);
        return rGBStep;
    }

    @Override
    public int getStepLength() {
        return RGBStep.getLength();
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        this.setFixedPosition(false);
        return super.autoMarkAt(n, d, d2);
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    protected void clearData() {
        if (this.data == null) {
            return;
        }
        int n = 0;
        while (n < 7) {
            Dataset dataset = this.data.getDataset(n);
            dataset.clear();
            ++n;
        }
        Step[] stepArray = this.getSteps();
        int n2 = 0;
        while (n2 < stepArray.length) {
            if (stepArray[n2] != null) {
                stepArray[n2].dataVisible = false;
                ((RGBStep)stepArray[n2]).dataValid = false;
            }
            ++n2;
        }
    }

    protected void hideData() {
        Step[] stepArray = this.getSteps();
        int n = 0;
        while (n < stepArray.length) {
            if (stepArray[n] != null) {
                stepArray[n].dataVisible = false;
            }
            ++n;
        }
        this.dataHidden = true;
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n;
        Object object;
        int n2;
        if (trackerPanel == null || datasetManager == null) {
            return;
        }
        this.dataFrames.clear();
        int n3 = trackerPanel.getFrameNumber();
        Step step = this.getStep(n3);
        if (step != null) {
            ((RGBStep)step).getRGBData(trackerPanel);
        }
        int n4 = 0;
        Dataset dataset = datasetManager.getDataset(n4++);
        Dataset dataset2 = datasetManager.getDataset(n4++);
        Dataset dataset3 = datasetManager.getDataset(n4++);
        Dataset dataset4 = datasetManager.getDataset(n4++);
        Dataset dataset5 = datasetManager.getDataset(n4++);
        Dataset dataset6 = datasetManager.getDataset(n4++);
        Dataset dataset7 = datasetManager.getDataset(n4++);
        Dataset dataset8 = datasetManager.getDataset(n4++);
        Dataset dataset9 = datasetManager.getDataset(n4++);
        String string = "t";
        if (!dataset.getColumnName(0).equals(string)) {
            dataset.setXYColumnNames(string, "x");
            dataset2.setXYColumnNames(string, "y");
            dataset3.setXYColumnNames(string, "R");
            dataset4.setXYColumnNames(string, "G");
            dataset5.setXYColumnNames(string, "B");
            dataset6.setXYColumnNames(string, "luma");
            dataset7.setXYColumnNames(string, "pixels");
            dataset8.setXYColumnNames(string, "step");
            dataset9.setXYColumnNames(string, "frame");
        } else {
            n2 = 0;
            while (n2 < n4) {
                datasetManager.getDataset(n2).clear();
                ++n2;
            }
        }
        this.dataDescriptions = new String[n4 + 1];
        n2 = 0;
        while (n2 < this.dataDescriptions.length) {
            this.dataDescriptions[n2] = TrackerRes.getString("RGBRegion.Data.Description." + n2);
            ++n2;
        }
        Step[] stepArray = this.getSteps();
        this.validSteps.clear();
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        int n5 = 0;
        while (n5 < stepArray.length) {
            RGBStep rGBStep = (RGBStep)stepArray[n5];
            if (rGBStep != null && rGBStep.dataValid && rGBStep.getRGBData(trackerPanel) != null) {
                object = rGBStep.getPosition();
                n = ((TPoint)object).getFrameNumber(trackerPanel);
                if (videoClip.includesFrame(n)) {
                    this.validSteps.add(rGBStep);
                } else {
                    rGBStep.dataVisible = false;
                }
            }
            ++n5;
        }
        RGBStep[] rGBStepArray = this.validSteps.toArray(new RGBStep[0]);
        int n6 = rGBStepArray.length;
        object = new double[10][n6];
        n = 0;
        while (n < n6) {
            double[] dArray = rGBStepArray[n].getRGBData(trackerPanel);
            TPoint tPoint = rGBStepArray[n].getPosition();
            int n7 = tPoint.getFrameNumber(trackerPanel);
            this.dataFrames.add(new Integer(n7));
            int n8 = videoClip.frameToStep(n7);
            double d = videoPlayer.getStepTime(n8) / 1000.0;
            Point2D point2D = tPoint.getWorldPosition(trackerPanel);
            int n9 = 2;
            while (n9 < 7) {
                object[n9][n] = dArray[n9 - 2];
                ++n9;
            }
            object[0][n] = point2D.getX();
            object[1][n] = point2D.getY();
            object[7][n] = (double)n8;
            object[8][n] = (double)n7;
            object[9][n] = d;
            ++n;
        }
        dataset.append((double[])object[9], (double[])object[0]);
        dataset2.append((double[])object[9], (double[])object[1]);
        dataset3.append((double[])object[9], (double[])object[2]);
        dataset4.append((double[])object[9], (double[])object[3]);
        dataset5.append((double[])object[9], (double[])object[4]);
        dataset6.append((double[])object[9], (double[])object[5]);
        dataset7.append((double[])object[9], (double[])object[6]);
        dataset8.append((double[])object[9], (double[])object[7]);
        dataset9.append((double[])object[9], (double[])object[8]);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.fixedPositionItem.setText(TrackerRes.getString("RGBRegion.MenuItem.Fixed"));
        this.fixedPositionItem.setSelected(this.isFixedPosition());
        this.fixedRadiusItem.setText(TrackerRes.getString("RGBRegion.MenuItem.FixedRadius"));
        this.fixedRadiusItem.setSelected(this.isFixedRadius());
        jMenu.remove(this.deleteTrackItem);
        if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
            jMenu.addSeparator();
        }
        jMenu.add(this.fixedPositionItem);
        jMenu.add(this.fixedRadiusItem);
        if (trackerPanel.isEnabled("track.delete")) {
            if (jMenu.getItemCount() > 0 && jMenu.getItem(jMenu.getItemCount() - 1) != null) {
                jMenu.addSeparator();
            }
            jMenu.add(this.deleteTrackItem);
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        this.radiusLabel.setText(TrackerRes.getString("RGBRegion.Label.Radius"));
        Border border = BorderFactory.createEmptyBorder(0, 4, 0, 2);
        this.radiusLabel.setBorder(border);
        arrayList.add(this.radiusLabel);
        this.radiusField.setIntValue(this.getRadius());
        this.radiusField.setEnabled(!this.isLocked());
        arrayList.add(this.radiusField);
        return arrayList;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        Step step = this.getStep(tPoint, trackerPanel);
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        if (step == null) {
            return arrayList;
        }
        int n = step.getFrameNumber();
        n = trackerPanel.getPlayer().getVideoClip().frameToStep(n);
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        arrayList.add(this.stepSeparator);
        arrayList.add(this.stepLabel);
        arrayList.add(this.stepValueLabel);
        arrayList.add(this.tSeparator);
        arrayList.add(this.xLabel);
        arrayList.add(this.xField);
        arrayList.add(this.xSeparator);
        arrayList.add(this.yLabel);
        arrayList.add(this.yField);
        arrayList.add(this.ySeparator);
        return arrayList;
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.radiusLabel};
        FontSizer.setFonts(objectArray, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.trackerPanel != null) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("stepnumber")) {
                this.dataValid = false;
                int n = this.trackerPanel.getFrameNumber();
                RGBStep rGBStep = (RGBStep)this.getStep(n);
                if (rGBStep != null) {
                    this.radiusField.setIntValue(rGBStep.radius);
                }
                this.radiusField.setEnabled(!this.isLocked() && rGBStep != null);
                this.support.firePropertyChange(propertyChangeEvent);
            } else if (string.equals("image")) {
                this.dataValid = false;
                Video video = this.trackerPanel.getVideo();
                if (video == null) {
                    this.clearData();
                } else if (!video.isVisible()) {
                    this.hideData();
                } else if (!this.dataHidden && video.isVisible()) {
                    this.clearData();
                } else {
                    this.dataHidden = false;
                }
                this.support.firePropertyChange(propertyChangeEvent);
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public String toString() {
        return TrackerRes.getString("RGBRegion.Name");
    }

    private void setPositionFromFields() {
        double d = this.xField.getValue();
        double d2 = this.yField.getValue();
        TPoint tPoint = this.trackerPanel.getSelectedPoint();
        int n = this.trackerPanel.getFrameNumber();
        Step step = this.getStep(n);
        if (step != null && tPoint != null) {
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            double d3 = imageCoordSystem.worldToImageX(n, d, d2);
            double d4 = imageCoordSystem.worldToImageY(n, d, d2);
            tPoint.setXY(d3, d4);
            Point2D point2D = tPoint.getWorldPosition(this.trackerPanel);
            this.xField.setValue(point2D.getX());
            this.yField.setValue(point2D.getY());
        }
    }

    protected void refreshStep(RGBStep rGBStep) {
        boolean bl;
        int n;
        Object object;
        if (rGBStep == null) {
            return;
        }
        int n2 = 0;
        if (!this.isFixedPosition()) {
            object = this.keyFrames.iterator();
            while (object.hasNext()) {
                n = (Integer)object.next();
                if (n > rGBStep.n) continue;
                n2 = n;
            }
        }
        n = 0;
        if (!this.isFixedRadius()) {
            for (int n3 : this.radiusKeyFrames) {
                if (n3 > rGBStep.n) continue;
                n = n3;
            }
        }
        object = (RGBStep)this.steps.getStep(n2);
        double d = ((RGBStep)object).getPosition().getX();
        double d2 = ((RGBStep)object).getPosition().getY();
        boolean bl2 = bl = d != rGBStep.getPosition().getX() || d2 != rGBStep.getPosition().getY();
        if (bl) {
            rGBStep.getPosition().setLocation(d, d2);
            rGBStep.erase();
            rGBStep.dataValid = false;
        }
        RGBStep rGBStep2 = (RGBStep)this.steps.getStep(n);
        int n4 = rGBStep2.radius;
        if (n4 != rGBStep.radius) {
            rGBStep.setRadius(n4);
            rGBStep.erase();
            rGBStep.dataValid = false;
        }
    }

    public static double getLuma(double d, double d2, double d3) {
        return 0.299 * d + 0.587 * d2 + 0.114 * d3;
    }

    public static XML.ObjectLoader getLoader() {
        XML.setLoader(FrameData.class, new FrameDataLoader());
        return new Loader();
    }

    private static class FrameData {
        double x;
        double y;
        int r;

        FrameData() {
        }

        FrameData(RGBStep rGBStep) {
            this.x = rGBStep.getPosition().getX();
            this.y = rGBStep.getPosition().getY();
            this.r = rGBStep.radius;
        }
    }

    private static class FrameDataLoader
    implements XML.ObjectLoader {
        private FrameDataLoader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            xMLControl.setValue("x", frameData.x);
            xMLControl.setValue("y", frameData.y);
            xMLControl.setValue("r", frameData.r);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new FrameData();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            FrameData frameData = (FrameData)object;
            frameData.x = xMLControl.getDouble("x");
            frameData.y = xMLControl.getDouble("y");
            frameData.r = xMLControl.getInt("r");
            return object;
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            RGBRegion rGBRegion = (RGBRegion)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixed", rGBRegion.isFixedPosition());
            xMLControl.setValue("fixed_radius", rGBRegion.isFixedRadius());
            if (!rGBRegion.steps.isEmpty()) {
                Step[] stepArray = rGBRegion.getSteps();
                int n = rGBRegion.isFixedPosition() ? 1 : stepArray.length;
                FrameData[] frameDataArray = new FrameData[n];
                int n2 = 0;
                while (n2 < n) {
                    if (stepArray[n2] != null && rGBRegion.keyFrames.contains(n2)) {
                        frameDataArray[n2] = new FrameData((RGBStep)stepArray[n2]);
                    }
                    ++n2;
                }
                xMLControl.setValue("framedata", frameDataArray);
                n = rGBRegion.isFixedRadius() ? 1 : stepArray.length;
                Integer[] integerArray = new Integer[n];
                int n3 = 0;
                while (n3 < n) {
                    if (stepArray[n3] != null && rGBRegion.radiusKeyFrames.contains(n3)) {
                        integerArray[n3] = ((RGBStep)stepArray[n3]).radius;
                    }
                    ++n3;
                }
                xMLControl.setValue("radii", integerArray);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            RGBRegion rGBRegion = new RGBRegion();
            return rGBRegion;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Integer[] integerArray;
            RGBRegion rGBRegion = (RGBRegion)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = rGBRegion.isLocked();
            rGBRegion.setLocked(false);
            rGBRegion.loading = true;
            rGBRegion.fixedPosition = xMLControl.getBoolean("fixed");
            rGBRegion.fixedRadius = xMLControl.getBoolean("fixed_radius");
            rGBRegion.keyFrames.clear();
            rGBRegion.radiusKeyFrames.clear();
            Object object2 = xMLControl.getObject("framedata");
            FrameData[] frameDataArray = null;
            frameDataArray = object2 instanceof FrameData ? new FrameData[]{(FrameData)object2} : (FrameData[])object2;
            if (frameDataArray != null) {
                int n = 0;
                while (n < frameDataArray.length) {
                    if (frameDataArray[n] != null) {
                        RGBStep rGBStep = (RGBStep)rGBRegion.createStep(n, frameDataArray[n].x, frameDataArray[n].y);
                        if (frameDataArray[n].r != Integer.MIN_VALUE) {
                            rGBStep.radius = frameDataArray[n].r;
                            rGBRegion.radiusKeyFrames.add(n);
                        }
                    }
                    ++n;
                }
            }
            if ((integerArray = (Integer[])xMLControl.getObject("radii")) != null) {
                rGBRegion.radiusKeyFrames.clear();
                int n = 0;
                while (n < integerArray.length) {
                    if (integerArray[n] != null) {
                        RGBStep rGBStep = (RGBStep)rGBRegion.steps.getStep(n);
                        rGBStep.radius = integerArray[n];
                        rGBRegion.radiusKeyFrames.add(n);
                    }
                    ++n;
                }
            }
            rGBRegion.setLocked(bl);
            rGBRegion.loading = false;
            rGBRegion.repaint();
            return object;
        }
    }
}

