/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ProtractorFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.NumberField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.Trackable;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class ProtractorStep
extends Step {
    protected static AffineTransform transform = new AffineTransform();
    protected static TPoint endPoint1 = new TPoint();
    protected static TPoint endPoint2 = new TPoint();
    protected static TPoint middle = new TPoint();
    protected Protractor protractor;
    protected TPoint vertex;
    protected TPoint end1;
    protected TPoint end2;
    protected Handle handle;
    protected Rotator rotator;
    protected double line1Angle;
    protected double line2Angle;
    protected boolean endsEnabled = true;
    protected boolean drawLayoutBounds;
    protected boolean drawLayout1;
    protected boolean drawLayout2;
    protected Shape vertexCircle;
    protected Shape arcHighlight;
    protected Map<TrackerPanel, Shape> vertexShapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> end1Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> end2Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> line1Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> line2Shapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, Shape> rotatorShapes = new HashMap<TrackerPanel, Shape>();
    protected Map<TrackerPanel, TextLayout> textLayouts = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layoutBounds = new HashMap<TrackerPanel, Rectangle>();
    protected Map<TrackerPanel, TextLayout> textLayouts1 = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layout1Bounds = new HashMap<TrackerPanel, Rectangle>();
    protected Map<TrackerPanel, TextLayout> textLayouts2 = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layout2Bounds = new HashMap<TrackerPanel, Rectangle>();
    protected Shape selectedShape;
    protected NumberField lengthField = new NumberField(9);

    public ProtractorStep(Protractor protractor, int n, double d, double d2, double d3, double d4) {
        super(protractor, n);
        this.protractor = protractor;
        this.vertex = new Tip(d, d2);
        this.end1 = new Tip(d3, d4);
        double d5 = (d + d3) / 2.0;
        double d6 = d2 - (d3 - d) * Math.sin(1.0471975511965976);
        this.end2 = new Tip(d5, d6);
        this.handle = new Handle((d + d3) / 2.0, (d2 + d4) / 2.0);
        this.rotator = new Rotator();
        this.points = new TPoint[]{this.vertex, this.end1, this.end2, this.handle, this.rotator};
        this.screenPoints = new Point[ProtractorStep.getLength()];
    }

    public void setEndsEnabled(boolean bl) {
        this.endsEnabled = bl;
    }

    public boolean isEndsEnabled() {
        return this.endsEnabled;
    }

    @Override
    public void setFootprint(Footprint footprint) {
        if (footprint.getLength() >= 2) {
            super.setFootprint(footprint);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Cloneable cloneable;
        Shape shape;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        this.setHitRectCenter(n, n2);
        Trackable trackable = null;
        ProtractorFootprint protractorFootprint = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.protractor.getFootprint() != null && this.protractor.getFootprint() instanceof ProtractorFootprint) {
            protractorFootprint = (ProtractorFootprint)this.protractor.getFootprint();
        }
        if (this.endsEnabled) {
            shape = this.vertexShapes.get(trackerPanel);
            if (!this.vertex.isAttached() && shape != null && shape.intersects(hitRect)) {
                trackable = this.vertex;
                if (this.vertexCircle == null && protractorFootprint != null) {
                    this.vertexCircle = protractorFootprint.getCircleShape(this.vertex.getScreenPosition(trackerPanel));
                    this.repaint(trackerPanel);
                }
            }
            if (trackable == null && this.vertexCircle != null) {
                this.vertexCircle = null;
                this.repaint(trackerPanel);
            }
            shape = this.end1Shapes.get(trackerPanel);
            if (trackable == null && shape != null && shape.intersects(hitRect)) {
                trackable = this.end1;
                bl2 = true;
            }
            shape = this.end2Shapes.get(trackerPanel);
            if (trackable == null && shape != null && shape.intersects(hitRect)) {
                trackable = this.end2;
                bl3 = true;
            }
        }
        shape = this.rotatorShapes.get(trackerPanel);
        if (!this.end1.isAttached() && !this.end2.isAttached() && trackable == null && shape != null && shape.intersects(hitRect)) {
            trackable = this.rotator;
        }
        if (trackable == null && trackerPanel.getSelectedPoint() == this.rotator && this.selectedShape.intersects(hitRect)) {
            trackable = this.rotator;
        }
        if (trackable == this.rotator && trackerPanel.getSelectedPoint() != this.rotator && protractorFootprint != null) {
            this.rotator.setScreenCoords(n, n2);
            cloneable = this.vertex.getScreenPosition(trackerPanel);
            this.arcHighlight = protractorFootprint.getArcAdjustShape((Point)cloneable, null);
            this.repaint(trackerPanel);
        }
        if (trackable == null && this.arcHighlight != null && trackerPanel.getSelectedPoint() != this.rotator) {
            this.arcHighlight = null;
            this.repaint(trackerPanel);
        }
        shape = this.line1Shapes.get(trackerPanel);
        if (trackable == null && shape != null && shape.intersects(hitRect)) {
            trackable = this.handle;
            this.handle.setHandleEnd(this.end1);
            bl2 = true;
        }
        shape = this.line2Shapes.get(trackerPanel);
        if (trackable == null && shape != null && shape.intersects(hitRect)) {
            trackable = this.handle;
            this.handle.setHandleEnd(this.end2);
            bl3 = true;
        }
        cloneable = this.layoutBounds.get(trackerPanel);
        if (trackable == null && cloneable != null && ((Rectangle)cloneable).intersects(hitRect)) {
            bl = true;
            trackable = this.protractor;
        }
        boolean bl4 = false;
        if (bl != this.drawLayoutBounds) {
            this.drawLayoutBounds = bl;
            bl4 = true;
        }
        if (bl2 != this.drawLayout1) {
            this.drawLayout1 = bl2;
            bl4 = true;
        }
        if (bl3 != this.drawLayout2) {
            this.drawLayout2 = bl3;
            bl4 = true;
        }
        if (bl4) {
            this.repaint(trackerPanel);
        }
        if (this.end1.isAttached() && (trackable == this.end1 || trackable == this.handle || trackable == this.rotator)) {
            return null;
        }
        if (this.end2.isAttached() && (trackable == this.end2 || trackable == this.handle || trackable == this.rotator)) {
            return null;
        }
        if (this.vertex.isAttached() && (trackable == this.vertex || trackable == this.handle)) {
            return null;
        }
        return trackable;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Point point;
        TextLayout textLayout;
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.getMark(trackerPanel).draw(graphics2D, false);
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.footprint.getColor());
        Font font = graphics2D.getFont();
        graphics2D.setFont(textLayoutFont);
        if (!this.protractor.editing) {
            textLayout = this.textLayouts.get(trackerPanel);
            point = this.getLayoutPosition(trackerPanel, textLayout, this.vertex);
            textLayout.draw(graphics2D, point.x, point.y);
            if (this.drawLayoutBounds) {
                Rectangle rectangle = this.layoutBounds.get(trackerPanel);
                graphics2D.drawRect(rectangle.x - 2, rectangle.y - 3, rectangle.width + 5, rectangle.height + 5);
            }
        }
        if (trackerPanel.getSelectedPoint() == this.vertex) {
            this.vertexCircle = null;
        }
        if (this.vertexCircle != null) {
            graphics2D.fill(this.vertexCircle);
        }
        if (this.arcHighlight != null) {
            graphics2D.fill(this.arcHighlight);
        }
        if (this.drawLayout1) {
            textLayout = this.textLayouts1.get(trackerPanel);
            point = this.getLayoutPosition(trackerPanel, textLayout, this.end1);
            textLayout.draw(graphics2D, point.x, point.y);
        }
        if (this.drawLayout2) {
            textLayout = this.textLayouts2.get(trackerPanel);
            point = this.getLayoutPosition(trackerPanel, textLayout, this.end2);
            textLayout.draw(graphics2D, point.x, point.y);
        }
        graphics2D.setFont(font);
        graphics2D.setPaint(paint);
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Object object;
            this.getProtractorAngle();
            tPoint = trackerPanel.getSelectedPoint();
            Point point = null;
            int n = 0;
            while (n < this.points.length) {
                this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                if (tPoint == this.points[n]) {
                    point = this.screenPoints[n];
                }
                ++n;
            }
            if (tPoint == this.rotator) {
                this.arcHighlight = ((ProtractorFootprint)this.footprint).getArcAdjustShape(this.screenPoints[0], this.screenPoints[4]);
            }
            mark = this.footprint.getMark(this.screenPoints);
            if (point != null) {
                Color color = this.footprint.getColor();
                object = mark;
                transform.setToTranslation(point.x, point.y);
                int n2 = FontSizer.getIntegerFactor();
                if (n2 > 1) {
                    transform.scale(n2, n2);
                }
                this.selectedShape = transform.createTransformedShape(selectionShape);
                mark = new Mark((Mark)object, color){
                    private final /* synthetic */ Mark val$stepMark;
                    private final /* synthetic */ Color val$color;
                    {
                        this.val$stepMark = mark;
                        this.val$color = color;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        this.val$stepMark.draw(graphics2D, false);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(this.val$color);
                        if (ProtractorStep.this.selectedShape != null) {
                            graphics2D.fill(ProtractorStep.this.selectedShape);
                        }
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        Rectangle rectangle = this.val$stepMark.getBounds(false);
                        if (ProtractorStep.this.selectedShape != null) {
                            rectangle.add(ProtractorStep.this.selectedShape.getBounds());
                        }
                        if (ProtractorStep.this.vertexCircle != null) {
                            rectangle.add(ProtractorStep.this.vertexCircle.getBounds());
                        }
                        if (ProtractorStep.this.arcHighlight != null) {
                            rectangle.add(ProtractorStep.this.arcHighlight.getBounds());
                        }
                        return rectangle;
                    }
                };
            }
            this.marks.put(trackerPanel, mark);
            Shape[] shapeArray = this.footprint.getHitShapes();
            this.vertexShapes.put(trackerPanel, shapeArray[0]);
            this.end1Shapes.put(trackerPanel, shapeArray[1]);
            this.end2Shapes.put(trackerPanel, shapeArray[2]);
            this.line1Shapes.put(trackerPanel, shapeArray[3]);
            this.line2Shapes.put(trackerPanel, shapeArray[4]);
            this.rotatorShapes.put(trackerPanel, shapeArray[5]);
            object = this.protractor.angleField.getText();
            TextLayout textLayout = new TextLayout((String)object, textLayoutFont, frc);
            this.textLayouts.put(trackerPanel, textLayout);
            point = this.getLayoutPosition(trackerPanel, textLayout, this.vertex);
            Rectangle rectangle = this.layoutBounds.get(trackerPanel);
            if (rectangle == null) {
                rectangle = new Rectangle();
                this.layoutBounds.put(trackerPanel, rectangle);
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            rectangle.setRect(point.x, (double)point.y - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
            int n3 = 0;
            while (n3 < 2) {
                TPoint tPoint2 = n3 == 0 ? this.end1 : this.end2;
                Map<TrackerPanel, TextLayout> map = n3 == 0 ? this.textLayouts1 : this.textLayouts2;
                Map<TrackerPanel, Rectangle> map2 = n3 == 0 ? this.layout1Bounds : this.layout2Bounds;
                object = this.getFormattedLength(this.getArmLength(tPoint2));
                textLayout = new TextLayout((String)object, textLayoutFont, frc);
                map.put(trackerPanel, textLayout);
                point = this.getLayoutPosition(trackerPanel, textLayout, tPoint2);
                rectangle = map2.get(trackerPanel);
                if (rectangle == null) {
                    rectangle = new Rectangle();
                    map2.put(trackerPanel, rectangle);
                }
                rectangle2D = textLayout.getBounds();
                rectangle.setRect(point.x, (double)point.y - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
                ++n3;
            }
        }
        return mark;
    }

    public String getFormattedLength(double d) {
        this.lengthField.setFormatFor(d);
        return this.lengthField.getFormat().format(d);
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        rectangle.add(this.layoutBounds.get(trackerPanel));
        rectangle.add(this.layout1Bounds.get(trackerPanel));
        return rectangle;
    }

    public double getProtractorAngle() {
        this.line1Angle = -this.vertex.angle(this.end1);
        this.line2Angle = -this.vertex.angle(this.end2);
        double d = this.line2Angle - this.line1Angle;
        if (d > Math.PI) {
            d -= Math.PI * 2;
        }
        if (d < -Math.PI) {
            d += Math.PI * 2;
        }
        this.protractor.angleField.setValue(d);
        return d;
    }

    public void setProtractorAngle(double d) {
        if (this.protractor.isLocked() || this.protractor.trackerPanel == null) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this.protractor);
        double d2 = this.end2.distance(this.vertex);
        double d3 = d2 * Math.cos(d += this.line1Angle);
        double d4 = -d2 * Math.sin(d);
        this.end2.setLocation(this.vertex.x + d3, this.vertex.y + d4);
        this.repaint();
        Undo.postTrackEdit(this.protractor, xMLControlElement);
    }

    public double getArmLength(TPoint tPoint) {
        if (this.protractor.trackerPanel == null) {
            return 1.0;
        }
        double d = this.protractor.trackerPanel.getCoords().getScaleX(this.n);
        double d2 = this.protractor.trackerPanel.getCoords().getScaleY(this.n);
        double d3 = (this.vertex.getX() - tPoint.getX()) / d;
        double d4 = (tPoint.getY() - this.vertex.getY()) / d2;
        return Math.sqrt(d3 * d3 + d4 * d4);
    }

    @Override
    public Object clone() {
        ProtractorStep protractorStep = (ProtractorStep)super.clone();
        if (protractorStep != null) {
            TPoint[] tPointArray = protractorStep.points;
            ProtractorStep protractorStep2 = protractorStep;
            protractorStep2.getClass();
            tPointArray[0] = protractorStep.vertex = protractorStep2.new Tip(this.vertex.getX(), this.vertex.getY());
            TPoint[] tPointArray2 = protractorStep.points;
            ProtractorStep protractorStep3 = protractorStep;
            protractorStep3.getClass();
            tPointArray2[1] = protractorStep.end1 = protractorStep3.new Tip(this.end1.getX(), this.end1.getY());
            TPoint[] tPointArray3 = protractorStep.points;
            ProtractorStep protractorStep4 = protractorStep;
            protractorStep4.getClass();
            tPointArray3[2] = protractorStep.end2 = protractorStep4.new Tip(this.end2.getX(), this.end2.getY());
            TPoint[] tPointArray4 = protractorStep.points;
            ProtractorStep protractorStep5 = protractorStep;
            protractorStep5.getClass();
            protractorStep.handle = protractorStep5.new Handle(this.handle.getX(), this.handle.getY());
            tPointArray4[3] = protractorStep.handle;
            protractorStep.rotator = protractorStep.new Rotator();
            protractorStep.points[4] = protractorStep.rotator;
            protractorStep.vertex.setTrackEditTrigger(true);
            protractorStep.end1.setTrackEditTrigger(true);
            protractorStep.end2.setTrackEditTrigger(true);
            protractorStep.handle.setTrackEditTrigger(true);
            protractorStep.vertexShapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.end1Shapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.end2Shapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.line1Shapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.line2Shapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.rotatorShapes = new HashMap<TrackerPanel, Shape>();
            protractorStep.textLayouts = new HashMap<TrackerPanel, TextLayout>();
            protractorStep.layoutBounds = new HashMap<TrackerPanel, Rectangle>();
        }
        return protractorStep;
    }

    @Override
    public String toString() {
        return "ProtractorStep";
    }

    public int n() {
        if (this.protractor.isFixed() && this.protractor.trackerPanel != null) {
            return this.protractor.trackerPanel.getFrameNumber();
        }
        return this.n;
    }

    public static int getLength() {
        return 5;
    }

    private Point getLayoutPosition(TrackerPanel trackerPanel, TextLayout textLayout, TPoint tPoint) {
        int n = FontSizer.getIntegerFactor();
        if (tPoint == this.vertex) {
            Point point = this.vertex.getScreenPosition(trackerPanel);
            Rectangle2D rectangle2D = textLayout.getBounds();
            double d = rectangle2D.getWidth();
            double d2 = rectangle2D.getHeight();
            double d3 = (this.line1Angle + this.line2Angle) / 2.0;
            if (Math.abs(this.line1Angle - this.line2Angle) > Math.PI) {
                d3 += Math.PI;
            }
            double d4 = -Math.sin(d3);
            double d5 = -Math.cos(d3);
            double d6 = n * 24;
            point.setLocation((int)((double)point.x + d6 * d5 - d / 2.0), (int)((double)point.y - d6 * d4 + d2 / 2.0));
            return point;
        }
        middle.center(tPoint, this.vertex);
        Point point = middle.getScreenPosition(trackerPanel);
        Rectangle2D rectangle2D = textLayout.getBounds();
        double d = rectangle2D.getWidth();
        double d7 = rectangle2D.getHeight();
        endPoint1.setLocation(tPoint);
        endPoint2.setLocation(this.vertex);
        if (!trackerPanel.isDrawingInImageSpace()) {
            AffineTransform affineTransform = trackerPanel.getCoords().getToWorldTransform(this.n);
            affineTransform.transform(endPoint1, endPoint1);
            ProtractorStep.endPoint1.y = -ProtractorStep.endPoint1.y;
            affineTransform.transform(endPoint2, endPoint2);
            ProtractorStep.endPoint2.y = -ProtractorStep.endPoint2.y;
        }
        double d8 = endPoint2.cos(endPoint1);
        double d9 = endPoint2.sin(endPoint1);
        double d10 = (double)(n * 6) + Math.abs(d * d9 / 2.0) + Math.abs(d7 * d8 / 2.0);
        if (d8 >= 0.0) {
            point.setLocation((int)((double)point.x - d10 * d9 - d / 2.0), (int)((double)point.y - d10 * d8 + d7 / 2.0));
        } else {
            point.setLocation((int)((double)point.x + d10 * d9 - d / 2.0), (int)((double)point.y + d10 * d8 + d7 / 2.0));
        }
        return point;
    }

    class Handle
    extends Step.Handle {
        TPoint end;

        public Handle(double d, double d2) {
            super(d, d2);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            if (ProtractorStep.this.track.locked) {
                return;
            }
            double d3 = d - this.getX();
            double d4 = d2 - this.getY();
            this.setLocation(d, d2);
            if (ProtractorStep.this.protractor.isFixed()) {
                ProtractorStep protractorStep = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                protractorStep.vertex.setLocation(ProtractorStep.this.vertex.getX() + d3, ProtractorStep.this.vertex.getY() + d4);
                protractorStep.end2.setLocation(ProtractorStep.this.end2.getX() + d3, ProtractorStep.this.end2.getY() + d4);
                protractorStep.end1.setLocation(ProtractorStep.this.end1.getX() + d3, ProtractorStep.this.end1.getY() + d4);
                protractorStep.erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                ProtractorStep.this.vertex.setLocation(ProtractorStep.this.vertex.getX() + d3, ProtractorStep.this.vertex.getY() + d4);
                ProtractorStep.this.end2.setLocation(ProtractorStep.this.end2.getX() + d3, ProtractorStep.this.end2.getY() + d4);
                ProtractorStep.this.end1.setLocation(ProtractorStep.this.end1.getX() + d3, ProtractorStep.this.end1.getY() + d4);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            ProtractorStep.this.repaint();
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return ProtractorStep.this.n();
        }

        @Override
        public void setPositionOnLine(int n, int n2, TrackerPanel trackerPanel) {
            this.setPositionOnLine(n, n2, trackerPanel, ProtractorStep.this.vertex, this.end);
            ProtractorStep.this.repaint();
        }

        protected void setHandleEnd(TPoint tPoint) {
            this.end = tPoint;
        }
    }

    class Rotator
    extends TPoint {
        TPoint pt = new TPoint();

        public Rotator() {
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            Cloneable cloneable;
            if (ProtractorStep.this.track.locked) {
                return;
            }
            super.setXY(d, d2);
            double d3 = -ProtractorStep.this.vertex.angle(this);
            double d4 = ProtractorStep.this.line2Angle - ProtractorStep.this.line1Angle;
            if (d4 > Math.PI) {
                d4 -= Math.PI * 2;
            }
            if (d4 < -Math.PI) {
                d4 += Math.PI * 2;
            }
            double d5 = ProtractorStep.this.line1Angle + d4 / 2.0;
            transform.setToRotation(d5 - d3, ProtractorStep.this.vertex.x, ProtractorStep.this.vertex.y);
            if (ProtractorStep.this.protractor.isFixed()) {
                cloneable = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                transform.transform(((ProtractorStep)cloneable).end1, ((ProtractorStep)cloneable).end1);
                transform.transform(((ProtractorStep)cloneable).end2, ((ProtractorStep)cloneable).end2);
                ((Step)cloneable).erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                transform.transform(ProtractorStep.this.end1, ProtractorStep.this.end1);
                transform.transform(ProtractorStep.this.end2, ProtractorStep.this.end2);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            cloneable = null;
            if (ProtractorStep.this.protractor.getFootprint() != null && ProtractorStep.this.protractor.getFootprint() instanceof ProtractorFootprint) {
                cloneable = (ProtractorFootprint)ProtractorStep.this.protractor.getFootprint();
                Point point = ProtractorStep.this.vertex.getScreenPosition(ProtractorStep.this.track.trackerPanel);
                Point point2 = this.getScreenPosition(ProtractorStep.this.track.trackerPanel);
                ProtractorStep.this.arcHighlight = ((ProtractorFootprint)cloneable).getArcAdjustShape(point, point2);
                ProtractorStep.this.repaint();
            }
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return ProtractorStep.this.n();
        }

        protected void setScreenCoords(int n, int n2) {
            this.pt.setScreenPosition(n, n2, ProtractorStep.this.protractor.trackerPanel);
            this.setLocation(this.pt);
        }
    }

    class Tip
    extends TPoint {
        public Tip(double d, double d2) {
            super(d, d2);
            this.setTrackEditTrigger(true);
        }

        @Override
        public void setXY(double d, double d2) {
            int n;
            double d3;
            if (ProtractorStep.this.track.locked) {
                return;
            }
            if (this != ProtractorStep.this.vertex && (d3 = ProtractorStep.this.vertex.distance(d, d2)) > 0.01 && d3 < (double)(2 * (n = ProtractorFootprint.arcRadius))) {
                d = ProtractorStep.this.vertex.getX() + (double)(2 * n) * (d - ProtractorStep.this.vertex.getX()) / d3;
                d2 = ProtractorStep.this.vertex.getY() + (double)(2 * n) * (d2 - ProtractorStep.this.vertex.getY()) / d3;
            }
            if (ProtractorStep.this.protractor.isFixed()) {
                ProtractorStep protractorStep = (ProtractorStep)ProtractorStep.this.protractor.steps.getStep(0);
                TPoint tPoint = this == ProtractorStep.this.end1 ? protractorStep.end1 : (this == ProtractorStep.this.end2 ? protractorStep.end2 : protractorStep.vertex);
                tPoint.setLocation(d, d2);
                protractorStep.erase();
                ProtractorStep.this.protractor.refreshStep(ProtractorStep.this);
            } else {
                this.setLocation(d, d2);
                ProtractorStep.this.protractor.keyFrames.add(ProtractorStep.this.n);
            }
            ProtractorStep.this.repaint();
            ProtractorStep.this.protractor.dataValid = false;
            ProtractorStep.this.protractor.firePropertyChange("data", null, ProtractorStep.this.protractor);
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return ProtractorStep.this.n();
        }
    }
}

