/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.opensourcephysics.cabrillo.tracker.AttachmentDialog;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.ProtractorFootprint;
import org.opensourcephysics.cabrillo.tracker.ProtractorStep;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.Undo;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPlayer;

public class Protractor
extends TTrack {
    protected boolean fixedPosition = true;
    protected JCheckBoxMenuItem fixedItem;
    protected JMenuItem attachmentItem;
    protected boolean editing = false;
    protected final DecimalField inputField;
    protected JPanel inputPanel;
    protected JPanel glassPanel;
    protected NumberFormat format;
    protected MouseListener editListener;

    public Protractor() {
        this.defaultColors = new Color[]{new Color(0, 140, 40)};
        this.setName(TrackerRes.getString("Protractor.New.Name"));
        this.setFootprints(new Footprint[]{ProtractorFootprint.getFootprint("ProtractorFootprint.Circle3"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle5"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle3Bold"), ProtractorFootprint.getFootprint("ProtractorFootprint.Circle5Bold")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setProperty("tableVar0", "0");
        this.keyFrames.add(0);
        this.inputField = new DecimalField(4, 1);
        this.inputField.setBorder(null);
        this.format = this.inputField.getFormat();
        this.inputPanel = new JPanel(null);
        this.inputPanel.setOpaque(false);
        this.inputPanel.add(this.inputField);
        this.inputField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Protractor.this.editing) {
                    int n = Protractor.this.trackerPanel.getFrameNumber();
                    ProtractorStep protractorStep = (ProtractorStep)Protractor.this.getStep(n);
                    Protractor.this.setEditing(false, protractorStep);
                }
            }
        });
        this.inputField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Protractor.this.inputField.selectAll();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (Protractor.this.editing) {
                    int n = Protractor.this.trackerPanel.getFrameNumber();
                    ProtractorStep protractorStep = (ProtractorStep)Protractor.this.getStep(n);
                    Protractor.this.setEditing(false, protractorStep);
                }
            }
        });
        this.editListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (Protractor.this.editing) {
                    int n = Protractor.this.trackerPanel.getFrameNumber();
                    ProtractorStep protractorStep = (ProtractorStep)Protractor.this.getStep(n);
                    Protractor.this.setEditing(false, protractorStep);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (Protractor.this.isLocked()) {
                    return;
                }
                int n = Protractor.this.trackerPanel.getFrameNumber();
                ProtractorStep protractorStep = (ProtractorStep)Protractor.this.getStep(n);
                Rectangle rectangle = protractorStep.layoutBounds.get(Protractor.this.trackerPanel);
                if (rectangle != null && rectangle.contains(mouseEvent.getPoint())) {
                    Protractor.this.setEditing(true, protractorStep);
                }
            }
        };
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("Protractor.Hint");
        ProtractorStep protractorStep = new ProtractorStep(this, 0, 100.0, 150.0, 200.0, 150.0);
        protractorStep.setFootprint(this.getFootprint());
        this.steps = new TTrack.StepArray(this, protractorStep);
        this.fixedItem = new JCheckBoxMenuItem(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Protractor.this.setFixed(Protractor.this.fixedItem.isSelected());
            }
        });
        final FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (Protractor.this.angleField.getBackground() == Color.yellow) {
                    int n = Protractor.this.trackerPanel.getFrameNumber();
                    ProtractorStep protractorStep = (ProtractorStep)Protractor.this.getStep(n);
                    if (!Protractor.this.isFixed()) {
                        Protractor.this.keyFrames.add(n);
                    }
                    protractorStep = Protractor.this.getKeyStep(protractorStep);
                    double d = Protractor.this.angleField.getValue();
                    protractorStep.setProtractorAngle(d);
                    Protractor.this.dataValid = false;
                    Protractor.this.support.firePropertyChange("data", null, null);
                }
            }
        };
        this.angleField.addFocusListener(focusAdapter);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                focusAdapter.focusLost(null);
                Protractor.this.angleField.requestFocusInWindow();
            }
        });
    }

    public void setFixed(boolean bl) {
        if (this.fixedPosition == bl) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(this);
        if (this.trackerPanel != null) {
            this.trackerPanel.changed = true;
            int n = this.trackerPanel.getFrameNumber();
            this.steps = new TTrack.StepArray(this, this.getStep(n));
            this.trackerPanel.repaint();
        }
        this.fixedPosition = bl;
        if (bl) {
            this.dataValid = false;
            this.support.firePropertyChange("data", null, null);
            Undo.postTrackEdit(this, xMLControlElement);
        }
    }

    public boolean isFixed() {
        return this.fixedPosition;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (this.trackerPanel.getSelectedTrack() == this) {
            TPoint tPoint;
            if (string.equals("stepnumber")) {
                ProtractorStep protractorStep = (ProtractorStep)this.getStep(this.trackerPanel.getFrameNumber());
                protractorStep.getProtractorAngle();
                protractorStep.arcHighlight = null;
            } else if (string.equals("selectedpoint") && !((tPoint = this.trackerPanel.getSelectedPoint()) instanceof ProtractorStep.Rotator)) {
                ProtractorStep protractorStep = (ProtractorStep)this.getStep(this.trackerPanel.getFrameNumber());
                protractorStep.arcHighlight = null;
            }
        }
        if (string.equals("adjusting") && propertyChangeEvent.getSource() instanceof TrackerPanel) {
            this.refreshDataLater = (Boolean)propertyChangeEvent.getNewValue();
            if (!this.refreshDataLater) {
                this.support.firePropertyChange("data", null, null);
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        Step step = this.steps.getStep(n);
        ((ProtractorStep)step).end1.setLocation(d, d2);
        return step;
    }

    public Step createStep(int n, double d, double d2, double d3, double d4) {
        ProtractorStep protractorStep = (ProtractorStep)this.steps.getStep(n);
        protractorStep.end1.setLocation(d, d2);
        protractorStep.end2.setLocation(d3, d4);
        this.keyFrames.add(n);
        return protractorStep;
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        this.setFixed(false);
        ProtractorStep protractorStep = (ProtractorStep)this.steps.getStep(n);
        int n2 = this.getTargetIndex();
        if (n2 == 0) {
            protractorStep.vertex.setLocation(d, d2);
        } else if (n2 == 1) {
            protractorStep.end1.setLocation(d, d2);
        } else {
            protractorStep.end2.setLocation(d, d2);
        }
        this.keyFrames.add(n);
        protractorStep.repaint();
        return this.getMarkedPoint(n, n2);
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        ProtractorStep protractorStep = (ProtractorStep)this.steps.getStep(n);
        this.refreshStep(protractorStep);
        return protractorStep;
    }

    @Override
    public int getStepLength() {
        return ProtractorStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable(int n) {
        return n < 3;
    }

    @Override
    protected String getTargetDescription(int n) {
        if (n == 0) {
            return TrackerRes.getString("Protractor.Vertex.Name");
        }
        String string = TrackerRes.getString("Protractor.End.Name");
        return String.valueOf(string) + " " + n;
    }

    @Override
    public int getFootprintLength() {
        return 3;
    }

    @Override
    protected void refreshData(DatasetManager datasetManager, TrackerPanel trackerPanel) {
        int n;
        if (this.refreshDataLater || trackerPanel == null || datasetManager == null) {
            return;
        }
        this.dataFrames.clear();
        int n2 = 0;
        Dataset dataset = datasetManager.getDataset(n2++);
        Dataset dataset2 = datasetManager.getDataset(n2++);
        Dataset dataset3 = datasetManager.getDataset(n2++);
        Dataset dataset4 = datasetManager.getDataset(n2++);
        Dataset dataset5 = datasetManager.getDataset(n2++);
        String string = "t";
        if (!dataset.getColumnName(0).equals(string)) {
            dataset.setXYColumnNames(string, Tracker.THETA);
            dataset2.setXYColumnNames(string, "L_{1}");
            dataset3.setXYColumnNames(string, "L_{2}");
            dataset4.setXYColumnNames(string, "step");
            dataset5.setXYColumnNames(string, "frame");
        } else {
            n = 0;
            while (n < n2) {
                datasetManager.getDataset(n).clear();
                ++n;
            }
        }
        this.dataDescriptions = new String[n2 + 1];
        n = 0;
        while (n < this.dataDescriptions.length) {
            this.dataDescriptions[n] = TrackerRes.getString("Protractor.Data.Description." + n);
            ++n;
        }
        VideoPlayer videoPlayer = trackerPanel.getPlayer();
        VideoClip videoClip = videoPlayer.getVideoClip();
        int n3 = videoClip.getStepCount();
        double[][] dArray = new double[datasetManager.getDatasets().size() + 1][n3];
        int n4 = 0;
        while (n4 < n3) {
            double d;
            int n5 = videoClip.stepToFrame(n4);
            ProtractorStep protractorStep = (ProtractorStep)this.getStep(n5);
            protractorStep.dataVisible = true;
            dArray[0][n4] = d = videoPlayer.getStepTime(n4) / 1000.0;
            dArray[1][n4] = protractorStep.getProtractorAngle();
            dArray[2][n4] = protractorStep.getArmLength(protractorStep.end1);
            dArray[3][n4] = protractorStep.getArmLength(protractorStep.end2);
            dArray[4][n4] = n4;
            dArray[5][n4] = n5;
            this.dataFrames.add(n5);
            ++n4;
        }
        dataset.append(dArray[0], dArray[1]);
        dataset2.append(dArray[0], dArray[2]);
        dataset3.append(dArray[0], dArray[3]);
        dataset4.append(dArray[0], dArray[4]);
        dataset5.append(dArray[0], dArray[5]);
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        this.fixedItem.setText(TrackerRes.getString("TapeMeasure.MenuItem.Fixed"));
        this.fixedItem.setSelected(this.isFixed());
        this.fixedItem.setEnabled(this.attachments == null || this.attachments[0] == null && this.attachments[1] == null && this.attachments[2] == null);
        jMenu.remove(this.deleteTrackItem);
        jMenu.remove(jMenu.getMenuComponent(jMenu.getMenuComponentCount() - 1));
        jMenu.add(this.fixedItem);
        this.attachmentItem = new JMenuItem(TrackerRes.getString("MeasuringTool.MenuItem.Attach"));
        this.attachmentItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentDialog attachmentDialog = Protractor.this.trackerPanel.getAttachmentDialog(Protractor.this);
                attachmentDialog.setVisible(true);
            }
        });
        jMenu.addSeparator();
        jMenu.add(this.attachmentItem);
        jMenu.addSeparator();
        jMenu.add(this.deleteTrackItem);
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        arrayList.add(this.stepSeparator);
        this.angleLabel.setText(TrackerRes.getString("Protractor.Label.Angle"));
        this.angleField.setToolTipText(TrackerRes.getString("Protractor.Field.Angle.Tooltip"));
        this.angleField.setEnabled(!this.isLocked());
        arrayList.add(this.angleLabel);
        arrayList.add(this.angleField);
        return arrayList;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel) || !this.isVisible()) {
            return null;
        }
        TrackerPanel trackerPanel = (TrackerPanel)drawingPanel;
        int n3 = trackerPanel.getFrameNumber();
        ProtractorStep protractorStep = (ProtractorStep)this.getStep(n3);
        if (trackerPanel.getPlayer().getVideoClip().includesFrame(n3)) {
            Interactive interactive = protractorStep.findInteractive(trackerPanel, n, n2);
            if (interactive == null) {
                this.partName = TrackerRes.getString("TTrack.Selected.Hint");
                this.hint = TrackerRes.getString("Protractor.Hint");
                return null;
            }
            if (interactive == protractorStep.vertex) {
                this.partName = TrackerRes.getString("Protractor.Vertex.Name");
                this.hint = TrackerRes.getString("Protractor.Vertex.Hint");
            } else if (interactive instanceof ProtractorStep.Tip) {
                this.partName = TrackerRes.getString("Protractor.End.Name");
                this.hint = TrackerRes.getString("Protractor.End.Hint");
            } else if (interactive == protractorStep.handle) {
                this.partName = TrackerRes.getString("Protractor.Handle.Name");
                this.hint = TrackerRes.getString("Protractor.Handle.Hint");
            } else if (interactive == protractorStep.rotator) {
                this.partName = TrackerRes.getString("Protractor.Rotator.Name");
                this.hint = TrackerRes.getString("Protractor.Rotator.Hint");
            } else if (interactive == this) {
                this.partName = TrackerRes.getString("Protractor.Readout.Name");
                this.hint = TrackerRes.getString("Protractor.Readout.Hint");
                trackerPanel.setMessage(this.getMessage());
            }
            return interactive;
        }
        return null;
    }

    @Override
    public String toString() {
        return TrackerRes.getString("Protractor.Name");
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        if (this.trackerPanel != null) {
            this.trackerPanel.removeMouseListener(this.editListener);
            this.trackerPanel.removePropertyChangeListener("stepnumber", this);
        }
        super.setTrackerPanel(trackerPanel);
        if (this.trackerPanel != null) {
            this.trackerPanel.addMouseListener(this.editListener);
            this.trackerPanel.addPropertyChangeListener("stepnumber", this);
        }
        this.setFixed(this.isFixed());
    }

    @Override
    protected void setAnglesInRadians(boolean bl) {
        super.setAnglesInRadians(bl);
        this.inputField.setDecimalPlaces(bl ? 3 : 1);
        this.inputField.setConversionFactor(bl ? 1.0 : 57.29577951308232);
        ProtractorStep protractorStep = (ProtractorStep)this.getStep(this.trackerPanel.getFrameNumber());
        protractorStep.repaint();
    }

    protected void refreshStep(ProtractorStep protractorStep) {
        boolean bl;
        ProtractorStep protractorStep2 = this.getKeyStep(protractorStep);
        boolean bl2 = bl = protractorStep2.vertex.getX() != protractorStep.vertex.getX() || protractorStep2.vertex.getY() != protractorStep.vertex.getY() || protractorStep2.end1.getX() != protractorStep.end1.getX() || protractorStep2.end1.getY() != protractorStep.end1.getY() || protractorStep2.end2.getX() != protractorStep.end2.getX() || protractorStep2.end2.getY() != protractorStep.end2.getY();
        if (bl) {
            protractorStep.vertex.setLocation(protractorStep2.vertex);
            protractorStep.end1.setLocation(protractorStep2.end1);
            protractorStep.end2.setLocation(protractorStep2.end2);
            protractorStep.erase();
        }
    }

    private ProtractorStep getKeyStep(ProtractorStep protractorStep) {
        int n = 0;
        if (!this.isFixed()) {
            Iterator iterator = this.keyFrames.iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 > protractorStep.n) continue;
                n = n2;
            }
        }
        return (ProtractorStep)this.steps.getStep(n);
    }

    private void setEditing(boolean bl, ProtractorStep protractorStep) {
        this.editing = bl;
        if (!this.editing) {
            if (!this.isFixed()) {
                this.keyFrames.add(protractorStep.n);
            }
            protractorStep = this.getKeyStep(protractorStep);
        }
        final ProtractorStep protractorStep2 = protractorStep;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (Protractor.this.editing) {
                    Object object;
                    Protractor.this.trackerPanel.setSelectedTrack(Protractor.this);
                    Protractor.this.inputField.setForeground(Protractor.this.footprint.getColor());
                    Rectangle rectangle = protractorStep2.layoutBounds.get(Protractor.this.trackerPanel);
                    rectangle.grow(3, 3);
                    rectangle.setLocation(rectangle.x + 1, rectangle.y);
                    Component[] componentArray = Protractor.this.trackerPanel.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        object = componentArray[n2];
                        if (object == Protractor.this.trackerPanel.noData) {
                            rectangle.setLocation(rectangle.x, rectangle.y - ((Component)object).getHeight());
                        }
                        ++n2;
                    }
                    Protractor.this.inputField.setBounds(rectangle);
                    Protractor.this.glassPanel = Protractor.this.trackerPanel.getGlassPanel();
                    Protractor.this.trackerPanel.remove(Protractor.this.glassPanel);
                    Protractor.this.trackerPanel.add((Component)Protractor.this.inputPanel, "Center");
                    object = BorderFactory.createEmptyBorder(0, 1, 1, 0);
                    Color color = Protractor.this.getFootprint().getColor();
                    Border border = BorderFactory.createLineBorder(color);
                    Protractor.this.inputField.setBorder(BorderFactory.createCompoundBorder(border, (Border)object));
                    Protractor.this.inputField.setValue(protractorStep2.getProtractorAngle());
                    Protractor.this.trackerPanel.revalidate();
                    Protractor.this.trackerPanel.repaint();
                    Protractor.this.inputField.requestFocus();
                } else {
                    protractorStep2.drawLayoutBounds = false;
                    protractorStep2.setProtractorAngle(Protractor.this.inputField.getValue());
                    Protractor.this.inputField.setSigFigs(4);
                    Protractor.this.trackerPanel.add((Component)Protractor.this.glassPanel, "Center");
                    Protractor.this.trackerPanel.remove(Protractor.this.inputPanel);
                    Protractor.this.dataValid = false;
                    Protractor.this.support.firePropertyChange("data", null, null);
                    Protractor.this.trackerPanel.revalidate();
                    Protractor.this.trackerPanel.repaint();
                }
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            Protractor protractor = (Protractor)object;
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("fixed", protractor.isFixed());
            Step[] stepArray = protractor.getSteps();
            int n = stepArray.length;
            if (protractor.isFixed()) {
                n = 1;
            }
            double[][] dArrayArray = new double[n][];
            int n2 = 0;
            while (n2 < n) {
                if (stepArray[n2] != null && protractor.keyFrames.contains(n2)) {
                    ProtractorStep protractorStep = (ProtractorStep)stepArray[n2];
                    double[] dArray = new double[]{protractorStep.end1.getX(), protractorStep.end1.getY(), protractorStep.end2.getX(), protractorStep.end2.getY(), protractorStep.vertex.getX(), protractorStep.vertex.getY()};
                    dArrayArray[n2] = dArray;
                }
                ++n2;
            }
            xMLControl.setValue("framedata", dArrayArray);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new Protractor();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Protractor protractor = (Protractor)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            boolean bl = protractor.isLocked();
            protractor.setLocked(false);
            protractor.fixedPosition = xMLControl.getBoolean("fixed");
            protractor.keyFrames.clear();
            double[][] dArray = (double[][])xMLControl.getObject("framedata");
            int n = 0;
            while (n < dArray.length) {
                if (dArray[n] != null) {
                    Step step = protractor.createStep(n, dArray[n][0], dArray[n][1], dArray[n][2], dArray[n][3]);
                    ProtractorStep protractorStep = (ProtractorStep)step;
                    protractorStep.vertex.setLocation(dArray[n][4], dArray[n][5]);
                    protractorStep.erase();
                }
                ++n;
            }
            protractor.setLocked(bl);
            return object;
        }
    }
}

