/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class PropertiesDialog
extends JDialog {
    static final Color DARK_RED = new Color(220, 0, 0);
    static final Color MEDIUM_RED = new Color(255, 120, 140);
    static final Color LIGHT_RED = new Color(255, 180, 200);
    protected TrackerPanel trackerPanel;
    protected JButton okButton;
    protected JButton cancelButton;
    protected JTextField authorField;
    protected JTextField contactField;
    protected JLabel authorLabel;
    protected JLabel contactLabel;
    protected JTabbedPane tabbedPane;
    protected JPanel metaPanel;
    protected JPanel videoPanel;
    protected JPanel trkPanel;
    protected JTable videoTable;
    protected JTable trkTable;
    protected PropertyCellRenderer cellRenderer = new PropertyCellRenderer();
    protected String[] vidProps = new String[6];
    protected String[] vidValues = new String[6];
    protected ArrayList<String> trkProps = new ArrayList();
    protected ArrayList<String> trkValues = new ArrayList();
    protected boolean hasVid;

    public PropertiesDialog(TrackerPanel trackerPanel) {
        super((Frame)trackerPanel.getTFrame(), true);
        this.trackerPanel = trackerPanel;
        this.createGUI();
        this.setFontLevel(FontSizer.getLevel());
        this.setLabelSizes();
        this.pack();
        this.okButton.requestFocusInWindow();
    }

    public void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        Font font = this.cellRenderer.getFont();
        font = FontSizer.getResizedFont(font, n);
        if (this.videoTable != null) {
            this.videoTable.setRowHeight(font.getSize() + 4);
        }
        this.trkTable.setRowHeight(font.getSize() + 4);
    }

    private void createGUI() {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        this.setTitle(TrackerRes.getString("PropertiesDialog.Title"));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        this.tabbedPane = new JTabbedPane();
        jPanel.add((Component)this.tabbedPane, "Center");
        this.trkPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(TrackerRes.getString("PropertiesDialog.Tab.TrackerFile"), this.trkPanel);
        this.trkProps.add(TrackerRes.getString("TActions.Dialog.AboutVideo.Name"));
        this.trkProps.add(TrackerRes.getString("TActions.Dialog.AboutVideo.Path"));
        String string = XML.forwardSlash(this.trackerPanel.openedFromPath);
        string = ResourceLoader.getNonURIPath(string);
        String string2 = XML.getName(string);
        this.trkValues.add(string2);
        this.trkValues.add(string);
        AbstractTableModel abstractTableModel = new TRKTableModel();
        this.trkTable = new JTable(abstractTableModel);
        this.trkTable.setBackground(this.trkPanel.getBackground());
        this.trkTable.setDefaultRenderer(String.class, this.cellRenderer);
        this.trkTable.setSelectionMode(0);
        this.trkTable.setColumnSelectionAllowed(true);
        this.trkTable.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.trkTable.getColumnModel().getColumn(1).setPreferredWidth(250);
        this.trkPanel.add((Component)this.trkTable.getTableHeader(), "North");
        this.trkPanel.add((Component)this.trkTable, "Center");
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(20000);
        ToolTipManager.sharedInstance().registerComponent(this.trkTable);
        JButton jButton = new JButton(TrackerRes.getString("PropertiesDialog.Button.CopyFilePath"));
        jButton.setForeground(new Color(0, 0, 102));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.trkTable.setRowSelectionInterval(1, 1);
                PropertiesDialog.this.trkTable.setColumnSelectionInterval(1, 1);
                String string = PropertiesDialog.this.trkTable.getValueAt(1, 1).toString();
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, stringSelection);
            }
        });
        jButton.setEnabled(this.trackerPanel.openedFromPath != null);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        this.trkPanel.add((Component)jPanel2, "South");
        Video video = this.trackerPanel.getVideo();
        this.hasVid = video != null;
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        if (this.hasVid || videoClip.getVideoPath() != null) {
            this.videoPanel = new JPanel(new BorderLayout());
            this.tabbedPane.addTab(TrackerRes.getString("TMenuBar.Menu.Video"), this.videoPanel);
            serializable = NumberFormat.getNumberInstance();
            ((NumberFormat)serializable).setMinimumIntegerDigits(1);
            ((NumberFormat)serializable).setMinimumFractionDigits(1);
            ((NumberFormat)serializable).setMaximumFractionDigits(1);
            string2 = this.hasVid ? XML.getName((String)video.getProperty("name")) : null;
            string = videoClip.getVideoPath();
            string = XML.forwardSlash(string);
            string = ResourceLoader.getNonURIPath(string);
            object3 = null;
            object2 = null;
            object = null;
            String string3 = null;
            if (this.hasVid) {
                ArrayList<Integer> arrayList;
                VideoType videoType = (VideoType)video.getProperty("video_type");
                object3 = videoType == null ? video.getClass().getSimpleName() : videoType.getDescription();
                int n = ((String)object3).lastIndexOf("(");
                if (n > -1) {
                    object3 = ((String)object3).substring(0, n);
                    if (video.getClass().getSimpleName().contains("Xuggle")) {
                        object3 = String.valueOf(object3) + "(Xuggle)";
                    } else if (video.getClass().getSimpleName().contains("QT")) {
                        object3 = String.valueOf(object3) + "(QuickTime)";
                    }
                }
                object2 = String.valueOf(video.getImage().getWidth()) + " x " + video.getImage().getHeight();
                object = String.valueOf(video.getFrameCount()) + " ";
                object = String.valueOf(object) + TrackerRes.getString("TActions.Dialog.AboutVideo.Frames");
                double d = this.trackerPanel.getPlayer().getClipControl().getMeanFrameDuration();
                double d2 = video.getFrameCount() <= 1 ? 0.0 : 1000.0 / d;
                String string4 = string3 = d2 == 0.0 ? "" : String.valueOf(((NumberFormat)serializable).format(d2)) + " ";
                if (d2 > 0.0) {
                    string3 = String.valueOf(string3) + TrackerRes.getString("TActions.Dialog.AboutVideo.FramesPerSecond");
                }
                if (!(arrayList = TrackerIO.findBadVideoFrames(this.trackerPanel, TrackerIO.defaultBadFrameTolerance, false, false, false)).isEmpty()) {
                    string3 = String.valueOf(string3) + " (" + TrackerRes.getString("TActions.Dialog.AboutVideo.FramesPerSecond.NotConstant") + ")";
                }
            }
            this.vidProps[0] = TrackerRes.getString("TActions.Dialog.AboutVideo.Name");
            this.vidProps[1] = TrackerRes.getString("TActions.Dialog.AboutVideo.Path");
            this.vidProps[2] = TrackerRes.getString("TActions.Dialog.AboutVideo.Type");
            this.vidProps[3] = TrackerRes.getString("TActions.Dialog.AboutVideo.Size");
            this.vidProps[4] = TrackerRes.getString("TActions.Dialog.AboutVideo.Length");
            this.vidProps[5] = TrackerRes.getString("TActions.Dialog.AboutVideo.FrameRate");
            this.vidValues[0] = string2;
            this.vidValues[1] = string;
            this.vidValues[2] = object3;
            this.vidValues[3] = object2;
            this.vidValues[4] = object;
            this.vidValues[5] = string3;
            abstractTableModel = new VideoTableModel();
            this.videoTable = new JTable(abstractTableModel);
            this.videoTable.setBackground(this.videoPanel.getBackground());
            this.videoTable.setDefaultRenderer(String.class, this.cellRenderer);
            this.videoTable.setSelectionMode(0);
            this.videoTable.setColumnSelectionAllowed(true);
            this.videoTable.getColumnModel().getColumn(0).setPreferredWidth(50);
            this.videoTable.getColumnModel().getColumn(1).setPreferredWidth(250);
            this.videoPanel.add((Component)this.videoTable.getTableHeader(), "North");
            this.videoPanel.add((Component)this.videoTable, "Center");
            ToolTipManager.sharedInstance().registerComponent(this.videoTable);
            jButton = new JButton(TrackerRes.getString("PropertiesDialog.Button.CopyVideoPath"));
            jButton.setForeground(new Color(0, 0, 102));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PropertiesDialog.this.videoTable.setRowSelectionInterval(1, 1);
                    PropertiesDialog.this.videoTable.setColumnSelectionInterval(1, 1);
                    String string = PropertiesDialog.this.videoTable.getValueAt(1, 1).toString();
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection stringSelection = new StringSelection(string);
                    clipboard.setContents(stringSelection, stringSelection);
                }
            });
            jButton.setEnabled(!string.equals(""));
            jPanel2 = new JPanel();
            jPanel2.add(jButton);
            this.videoPanel.add((Component)jPanel2, "South");
        }
        this.metaPanel = new JPanel(new BorderLayout());
        this.tabbedPane.addTab(TrackerRes.getString("PropertiesDialog.Tab.Metadata"), this.metaPanel);
        this.authorLabel = new JLabel(TrackerRes.getString("PropertiesDialog.Label.Author"));
        this.authorField = new JTextField(30);
        this.authorField.setText(this.trackerPanel.author);
        serializable = new JToolBar();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(6, 4, 2, 4));
        ((JToolBar)serializable).setFloatable(false);
        ((JComponent)serializable).setOpaque(false);
        ((Container)serializable).add(this.authorLabel);
        ((Container)serializable).add(this.authorField);
        this.contactLabel = new JLabel(TrackerRes.getString("PropertiesDialog.Label.Contact"));
        this.contactField = new JTextField(30);
        this.contactField.setText(this.trackerPanel.contact);
        object3 = new JToolBar();
        ((JComponent)object3).setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        ((JToolBar)object3).setFloatable(false);
        ((JComponent)object3).setOpaque(false);
        ((Container)object3).add(this.contactLabel);
        ((Container)object3).add(this.contactField);
        object2 = Box.createVerticalBox();
        ((Container)object2).add((Component)serializable);
        ((Container)object2).add((Component)object3);
        this.metaPanel.add((Component)object2, "North");
        this.okButton = new JButton(TrackerRes.getString("Dialog.Button.OK"));
        this.okButton.setForeground(new Color(0, 0, 102));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PropertiesDialog.this.authorField.getText();
                PropertiesDialog.this.trackerPanel.author = "".equals(string) ? null : string;
                string = PropertiesDialog.this.contactField.getText();
                PropertiesDialog.this.trackerPanel.contact = "".equals(string) ? null : string;
                PropertiesDialog.this.setVisible(false);
            }
        });
        this.cancelButton = new JButton(TrackerRes.getString("Dialog.Button.Cancel"));
        this.cancelButton.setForeground(new Color(0, 0, 102));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PropertiesDialog.this.setVisible(false);
            }
        });
        object = new JPanel();
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(1, 0, 3, 0));
        jPanel.add((Component)object, "South");
        ((Container)object).add(this.okButton);
        ((Container)object).add(this.cancelButton);
    }

    private void setLabelSizes() {
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        arrayList.add(this.authorLabel);
        arrayList.add(this.contactLabel);
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        Font font = this.authorLabel.getFont();
        int n = 0;
        for (JLabel jLabel : arrayList) {
            Rectangle2D rectangle2D = font.getStringBounds(String.valueOf(jLabel.getText()) + " ", fontRenderContext);
            n = Math.max(n, (int)rectangle2D.getWidth() + 1);
        }
        Dimension dimension = new Dimension(n, 20);
        for (JLabel jLabel : arrayList) {
            jLabel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 2));
            jLabel.setPreferredSize(dimension);
            jLabel.setHorizontalAlignment(11);
        }
    }

    class PropertyCellRenderer
    extends DefaultTableCellRenderer {
        PropertyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setToolTipText(n == 1 && n2 == 1 && object != null ? object.toString() : null);
            this.setBackground(Color.white);
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = n2 == 1 && jTable == PropertiesDialog.this.videoTable && !PropertiesDialog.this.hasVid && object != null;
            this.setForeground(bl3 ? DARK_RED : Color.black);
            if (bl3) {
                this.setBackground(bl ? MEDIUM_RED : LIGHT_RED);
            }
            return component;
        }
    }

    class TRKTableModel
    extends AbstractTableModel {
        TRKTableModel() {
        }

        @Override
        public int getRowCount() {
            return PropertiesDialog.this.trkProps.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? PropertiesDialog.this.trkProps.get(n) : PropertiesDialog.this.trkValues.get(n);
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? TrackerRes.getString("PropertiesDialog.Header.Property") : TrackerRes.getString("PropertiesDialog.Header.Value");
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }

    class VideoTableModel
    extends AbstractTableModel {
        VideoTableModel() {
        }

        @Override
        public int getRowCount() {
            return PropertiesDialog.this.vidProps.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? PropertiesDialog.this.vidProps[n] : PropertiesDialog.this.vidValues[n];
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? TrackerRes.getString("PropertiesDialog.Header.Property") : TrackerRes.getString("PropertiesDialog.Header.Value");
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return String.class;
        }
    }
}

