/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionVectorFootprint;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FontSizer;

public class PositionStep
extends Step {
    private static Point[] twoPoints = new Point[2];
    protected Position p;
    protected boolean labelVisible = true;
    protected boolean rolloverVisible = false;
    protected Map<TrackerPanel, TextLayout> textLayouts = new HashMap<TrackerPanel, TextLayout>();
    protected Map<TrackerPanel, Rectangle> layoutBounds = new HashMap<TrackerPanel, Rectangle>();

    public PositionStep(PointMass pointMass, int n, double d, double d2) {
        super(pointMass, n);
        this.p = new Position(d, d2);
        this.p.setTrackEditTrigger(true);
        this.points = new TPoint[]{this.p};
        this.screenPoints = new Point[PositionStep.getLength()];
    }

    public Position getPosition() {
        return this.p;
    }

    public boolean isLabelVisible() {
        return this.labelVisible;
    }

    public void setLabelVisible(boolean bl) {
        this.labelVisible = bl;
    }

    public boolean isRolloverVisible() {
        return this.rolloverVisible;
    }

    public void setRolloverVisible(boolean bl) {
        this.rolloverVisible = bl;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        PropertyChangeListener propertyChangeListener;
        if (this.track.trackerPanel == drawingPanel && (propertyChangeListener = this.track.trackerPanel.getAutoTracker()).isInteracting(this.track)) {
            return;
        }
        if (drawingPanel instanceof TrackerPanel) {
            propertyChangeListener = (TrackerPanel)drawingPanel;
            super.draw((DrawingPanel)((Object)propertyChangeListener), graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.isLabelVisible()) {
                TextLayout textLayout = this.textLayouts.get(propertyChangeListener);
                if (textLayout == null) {
                    return;
                }
                Point point = this.getLayoutPosition((TrackerPanel)propertyChangeListener);
                Paint paint = graphics2D.getPaint();
                Font font = graphics2D.getFont();
                graphics2D.setPaint(this.footprint.getColor());
                graphics2D.setFont(textLayoutFont);
                textLayout.draw(graphics2D, point.x, point.y);
                graphics2D.setPaint(paint);
                graphics2D.setFont(font);
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        if (this.rolloverVisible) {
            if (interactive != null && !this.labelVisible) {
                this.labelVisible = true;
                this.repaint();
            }
            if (interactive == null && this.labelVisible) {
                this.labelVisible = false;
                this.repaint();
            }
        }
        return interactive;
    }

    @Override
    protected Mark getMark(TrackerPanel trackerPanel) {
        Mark mark = (Mark)this.marks.get(trackerPanel);
        TPoint tPoint = null;
        if (mark == null) {
            Object object;
            Object object2;
            tPoint = trackerPanel.getSelectedPoint();
            Point point = null;
            this.valid = true;
            int n = 0;
            while (n < this.points.length) {
                if (this.valid) {
                    this.valid = this.valid && !Double.isNaN(this.points[n].getX()) && !Double.isNaN(this.points[n].getY());
                    this.screenPoints[n] = this.points[n].getScreenPosition(trackerPanel);
                    if (this.valid && (tPoint == this.points[n] || trackerPanel.selectedSteps.contains(this))) {
                        point = this.screenPoints[n];
                    }
                }
                ++n;
            }
            if (point == null) {
                if (this.footprint instanceof PositionVectorFootprint) {
                    PositionStep.twoPoints[0] = this.screenPoints[0];
                    PositionStep.twoPoints[1] = trackerPanel.getSnapPoint().getScreenPosition(trackerPanel);
                    mark = this.footprint.getMark(twoPoints);
                } else {
                    mark = this.footprint.getMark(this.screenPoints);
                }
            } else {
                transform.setToTranslation(point.x, point.y);
                n = FontSizer.getIntegerFactor();
                if (n > 1) {
                    transform.scale(n, n);
                }
                object2 = this.footprint.getColor();
                object = transform.createTransformedShape(selectionShape);
                mark = new Mark((Color)object2, (Shape)object){
                    private final /* synthetic */ Color val$color;
                    private final /* synthetic */ Shape val$selectedShape;
                    {
                        this.val$color = color;
                        this.val$selectedShape = shape;
                    }

                    @Override
                    public void draw(Graphics2D graphics2D, boolean bl) {
                        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        Paint paint = graphics2D.getPaint();
                        graphics2D.setPaint(this.val$color);
                        graphics2D.fill(this.val$selectedShape);
                        graphics2D.setPaint(paint);
                    }

                    @Override
                    public Rectangle getBounds(boolean bl) {
                        return this.val$selectedShape.getBounds();
                    }
                };
            }
            final Mark mark2 = mark;
            mark = new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                    if (!PositionStep.this.valid) {
                        return;
                    }
                    mark2.draw(graphics2D, bl);
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return mark2.getBounds(bl);
                }
            };
            this.marks.put(trackerPanel, mark);
            object2 = "";
            object = trackerPanel.getPlayer().getVideoClip();
            if (((VideoClip)object).getStepCount() != 1) {
                object2 = String.valueOf(object2) + ((VideoClip)object).frameToStep(this.getFrameNumber());
            }
            if (((String)object2).length() == 0) {
                object2 = " ";
            }
            TextLayout textLayout = new TextLayout((String)object2, textLayoutFont, frc);
            this.textLayouts.put(trackerPanel, textLayout);
            point = this.getLayoutPosition(trackerPanel);
            Rectangle rectangle = this.layoutBounds.get(trackerPanel);
            if (rectangle == null) {
                rectangle = new Rectangle();
                this.layoutBounds.put(trackerPanel, rectangle);
            }
            Rectangle2D rectangle2D = textLayout.getBounds();
            rectangle.setRect(point.x, (double)point.y - rectangle2D.getHeight(), rectangle2D.getWidth(), rectangle2D.getHeight());
        }
        return mark;
    }

    @Override
    public Rectangle getBounds(TrackerPanel trackerPanel) {
        Rectangle rectangle = this.getMark(trackerPanel).getBounds(false);
        Rectangle rectangle2 = this.layoutBounds.get(trackerPanel);
        if (rectangle2 != null) {
            rectangle.add(rectangle2);
        }
        return rectangle;
    }

    @Override
    public Object clone() {
        PositionStep positionStep = (PositionStep)super.clone();
        if (positionStep != null) {
            TPoint[] tPointArray = positionStep.points;
            PositionStep positionStep2 = positionStep;
            positionStep2.getClass();
            positionStep.p = positionStep2.new Position(this.p.getX(), this.p.getY());
            tPointArray[0] = positionStep.p;
        }
        positionStep.textLayouts = new HashMap<TrackerPanel, TextLayout>();
        positionStep.layoutBounds = new HashMap<TrackerPanel, Rectangle>();
        return positionStep;
    }

    @Override
    public String toString() {
        return "PositionStep " + this.n + " [" + format.format(this.p.x) + ", " + format.format(this.p.y) + "]";
    }

    protected Point getLayoutPosition(TrackerPanel trackerPanel) {
        Point point = this.p.getScreenPosition(trackerPanel);
        point.setLocation(point.x - 4 - textLayoutFont.getSize(), point.y - 6);
        return point;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            PositionStep positionStep = (PositionStep)object;
            xMLControl.setValue("x", positionStep.p.x);
            xMLControl.setValue("y", positionStep.p.y);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            PositionStep positionStep = (PositionStep)object;
            double d = xMLControl.getDouble("x");
            double d2 = xMLControl.getDouble("y");
            positionStep.p.setXY(d, d2);
            return object;
        }
    }

    protected class Position
    extends TPoint {
        public Position(double d, double d2) {
            super(d, d2);
        }

        @Override
        public void setXY(double d, double d2) {
            if (PositionStep.this.track.isLocked()) {
                return;
            }
            super.setXY(d, d2);
            PositionStep.this.repaint();
            ((PointMass)PositionStep.this.track).updateDerivatives(PositionStep.this.n);
            PositionStep.this.track.support.firePropertyChange("step", null, new Integer(PositionStep.this.n));
        }

        @Override
        public void showCoordinates(VideoPanel videoPanel) {
            Point2D point2D = this.getWorldPosition(videoPanel);
            PositionStep.this.track.xField.setValue(point2D.getX());
            PositionStep.this.track.yField.setValue(point2D.getY());
            PositionStep.this.track.magField.setValue(point2D.distance(0.0, 0.0));
            double d = Math.atan2(point2D.getY(), point2D.getX());
            PositionStep.this.track.angleField.setValue(d);
            super.showCoordinates(videoPanel);
        }

        @Override
        public int getFrameNumber(VideoPanel videoPanel) {
            return PositionStep.this.n;
        }

        void setPosition(Point2D point2D) {
            this.x = point2D.getX();
            this.y = point2D.getY();
        }

        @Override
        public void setAdjusting(boolean bl) {
            super.setAdjusting(bl);
            PositionStep.this.track.support.firePropertyChange("adjusting", null, (Object)bl);
        }
    }
}

