/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.opensourcephysics.cabrillo.tracker.PlotTrackView;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackChooserTView;
import org.opensourcephysics.cabrillo.tracker.TrackPlottingPanel;
import org.opensourcephysics.cabrillo.tracker.TrackView;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLProperty;

public class PlotTView
extends TrackChooserTView {
    protected Icon icon = new ImageIcon(Tracker.class.getResource("resources/images/plot.gif"));

    public PlotTView(TrackerPanel trackerPanel) {
        super(trackerPanel);
    }

    @Override
    public String getViewName() {
        return TrackerRes.getString("TFrame.View.Plot");
    }

    @Override
    public Icon getViewIcon() {
        return this.icon;
    }

    @Override
    protected TrackView createTrackView(TTrack tTrack) {
        return new PlotTrackView(tTrack, this.trackerPanel);
    }

    @Override
    protected void refreshMenus() {
        for (TrackView trackView : this.trackViews.values()) {
            PlotTrackView plotTrackView = (PlotTrackView)trackView;
            TrackPlottingPanel[] trackPlottingPanelArray = plotTrackView.plots;
            int n = plotTrackView.plots.length;
            int n2 = 0;
            while (n2 < n) {
                TrackPlottingPanel trackPlottingPanel = trackPlottingPanelArray[n2];
                trackPlottingPanel.buildPopupmenu();
                ++n2;
            }
        }
    }

    @Override
    public void setSelectedTrack(TTrack tTrack) {
        if (tTrack == null) {
            this.noDataLabel.setText(TrackerRes.getString("PlotTView.Label.NoData"));
        }
        super.setSelectedTrack(tTrack);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            PlotTView plotTView = (PlotTView)object;
            TTrack tTrack = plotTView.getSelectedTrack();
            if (tTrack != null) {
                xMLControl.setValue("selected_track", tTrack.getName());
                ArrayList<TrackView> arrayList = new ArrayList<TrackView>();
                for (TrackView trackView : plotTView.trackViews.values()) {
                    if (!trackView.isCustomState()) continue;
                    arrayList.add(trackView);
                }
                if (!arrayList.isEmpty()) {
                    xMLControl.setValue("track_views", arrayList);
                }
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            Object object2;
            Object object3;
            PlotTView plotTView = (PlotTView)object;
            TTrack tTrack = plotTView.getTrack(xMLControl.getString("selected_track"));
            if (tTrack != null) {
                plotTView.setSelectedTrack(tTrack);
                object3 = (PlotTrackView)plotTView.getTrackView(tTrack);
                TrackPlottingPanel[] trackPlottingPanelArray = ((PlotTrackView)object3).plots;
                int n = 0;
                while (n < trackPlottingPanelArray.length) {
                    object2 = xMLControl.getChildControl("plot" + n);
                    if (object2 == null) {
                        ((PlotTrackView)object3).setPlotCount(Math.max(1, n));
                        break;
                    }
                    object2.loadObject(trackPlottingPanelArray[n]);
                    ++n;
                }
            }
            object3 = xMLControl.getPropertyContent();
            int n = 0;
            while (n < object3.size()) {
                XMLProperty xMLProperty = (XMLProperty)object3.get(n);
                if (xMLProperty.getPropertyName().equals("track_views")) {
                    object2 = xMLProperty.getChildControls();
                    int n2 = 0;
                    while (n2 < ((XMLControl[])object2).length) {
                        String string = object2[n2].getString("track");
                        tTrack = plotTView.getTrack(string);
                        if (tTrack != null) {
                            PlotTrackView plotTrackView = (PlotTrackView)plotTView.getTrackView(tTrack);
                            object2[n2].loadObject(plotTrackView);
                        }
                        ++n2;
                    }
                    break;
                }
                ++n;
            }
            return object;
        }
    }
}

