/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.opensourcephysics.cabrillo.tracker.CircleFootprint;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldTView;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.InitialValueEditor;
import org.opensourcephysics.tools.ParamEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public abstract class ParticleModel
extends PointMass {
    protected static int tracePtsPerStep = 10;
    protected static boolean loading = false;
    protected static Point2D nan = new Point2D.Double(Double.NaN, Double.NaN);
    protected static double xLimit = 4000.0;
    protected static double yLimit = 3000.0;
    protected static NumberFormat timeFormat = NumberFormat.getNumberInstance();
    protected FunctionTool inspector;
    protected ModelFunctionPanel functionPanel;
    protected UserFunctionEditor functionEditor;
    protected int inspectorX = Integer.MIN_VALUE;
    protected int inspectorY;
    protected int inspectorH = Integer.MIN_VALUE;
    protected boolean showInspector;
    protected boolean refreshing = false;
    protected double[] traceX = new double[0];
    protected double[] traceY = new double[0];
    protected double[] prevX;
    protected double[] prevY;
    protected TPoint tracePt = new TPoint();
    protected int lastValidFrame = -1;
    protected double t0;
    protected double dt = 0.1;
    protected double time;
    protected boolean refreshDerivsLater;
    protected boolean refreshStepsLater;
    protected boolean invalidWarningShown;
    protected boolean startFrameUndefined;
    protected int startFrame;
    protected int endFrame = Integer.MAX_VALUE;
    protected boolean useDefaultReferenceFrame;
    protected JMenuItem inspectorItem;
    protected JMenuItem useDefaultRefFrameItem;

    static {
        timeFormat.setMinimumIntegerDigits(1);
        timeFormat.setMaximumFractionDigits(3);
        timeFormat.setMinimumFractionDigits(3);
        timeFormat.setGroupingUsed(false);
    }

    public ParticleModel() {
        Footprint[] footprintArray = super.getFootprints();
        Footprint[] footprintArray2 = new Footprint[footprintArray.length + 1];
        footprintArray2[0] = CircleFootprint.getFootprint("CircleFootprint.FilledCircle");
        int n = 0;
        while (n < footprintArray.length) {
            footprintArray2[n + 1] = footprintArray[n];
            ++n;
        }
        this.setFootprints(footprintArray2);
        this.defaultFootprint = footprintArray2[0];
        this.setFootprint(this.defaultFootprint.getName());
        this.setName(TrackerRes.getString("ParticleModel.New.Name"));
        this.initializeFunctionPanel();
        this.hint = TrackerRes.getString("ParticleModel.Hint");
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!(drawingPanel instanceof TrackerPanel) || this.trackerPanel == null) {
            return;
        }
        if (this.isVisible() && this.trackerPanel.getFrameNumber() > this.lastValidFrame) {
            this.refreshSteps();
        }
        this.drawMe(drawingPanel, graphics);
    }

    public void drawMe(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (this.inspectorX != Integer.MIN_VALUE && this.trackerPanel != null && this.trackerPanel.getTFrame() != null) {
            this.positionInspector();
            object = new Runnable(){

                @Override
                public void run() {
                    ParticleModel.this.showInspector = false;
                    ParticleModel.this.inspector.setVisible(true);
                }
            };
            if (this.showInspector) {
                SwingUtilities.invokeLater((Runnable)object);
            }
        }
        if (this.isVisible() && this.isTraceVisible()) {
            boolean bl;
            object = (TrackerPanel)drawingPanel;
            ImageCoordSystem imageCoordSystem = ((VideoPanel)object).getCoords();
            boolean bl2 = imageCoordSystem instanceof ReferenceFrame;
            if (bl2) {
                imageCoordSystem = ((ReferenceFrame)imageCoordSystem).getCoords();
            }
            boolean bl3 = bl = imageCoordSystem.isFixedAngle() && imageCoordSystem.isFixedOrigin() && imageCoordSystem.isFixedScale();
            if (!(!bl || object instanceof WorldTView && bl2)) {
                Serializable serializable;
                this.trace.reset();
                int n = 0;
                while (n < this.traceX.length) {
                    if (!Double.isNaN(this.traceX[n])) {
                        this.tracePt.setLocation(this.traceX[n], this.traceY[n]);
                        serializable = this.tracePt.getScreenPosition((VideoPanel)object);
                        if (this.trace.getCurrentPoint() == null) {
                            this.trace.moveTo((float)((Point)serializable).getX(), (float)((Point)serializable).getY());
                        } else {
                            this.trace.lineTo((float)((Point)serializable).getX(), (float)((Point)serializable).getY());
                        }
                    }
                    ++n;
                }
                Graphics2D graphics2D = (Graphics2D)graphics;
                serializable = graphics2D.getColor();
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setColor(this.getFootprint().getColor());
                graphics2D.setStroke(this.traceStroke);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                graphics2D.draw(this.trace);
                graphics2D.setColor((Color)serializable);
                graphics2D.setStroke(stroke);
            }
        }
        super.draw(drawingPanel, graphics);
    }

    @Override
    public void delete() {
        ArrayList<ParticleModel> arrayList;
        FunctionTool functionTool = null;
        if (this.trackerPanel != null && this.trackerPanel.modelBuilder != null && (arrayList = this.trackerPanel.getDrawables(ParticleModel.class)).size() == 1) {
            functionTool = this.trackerPanel.modelBuilder;
        }
        super.delete();
        if (functionTool != null) {
            functionTool.setVisible(false);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ImageCoordSystem imageCoordSystem;
        super.propertyChange(propertyChangeEvent);
        if (this.trackerPanel == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function") && !loading) {
            this.trackerPanel.changed = true;
        } else if (string.equals("tab") && this.inspector != null) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel && this.trackerPanel.isModelBuilderVisible) {
                this.inspector.setVisible(true);
            } else if (this.inspector.isVisible()) {
                this.inspector.setVisible(false);
                this.trackerPanel.isModelBuilderVisible = true;
            }
        } else if (string.equals("selectedtrack") && propertyChangeEvent.getNewValue() == this && this.inspector != null && !this.inspector.getSelectedName().equals(this.getName())) {
            this.inspector.setSelectedPanel(this.getName());
        }
        if (string.equals("function") || string.equals("starttime") || string.equals("frameduration") || string.equals("startframe") || string.equals("stepsize")) {
            this.lastValidFrame = -1;
        }
        if (string.equals("transform") && (!((imageCoordSystem = this.trackerPanel.getCoords()) instanceof ReferenceFrame) || ((ReferenceFrame)imageCoordSystem).getOriginTrack() != this)) {
            this.lastValidFrame = -1;
        }
        if (!this.refreshing && this.isModelsVisible()) {
            if (string.equals("function")) {
                this.repaint();
            } else if (string.equals("adjusting")) {
                this.refreshStepsLater = (Boolean)propertyChangeEvent.getNewValue();
                if (!this.refreshStepsLater) {
                    this.refreshSteps();
                }
            }
            if (string.equals("transform")) {
                imageCoordSystem = this.trackerPanel.getCoords();
                if (!(imageCoordSystem instanceof ReferenceFrame) || ((ReferenceFrame)imageCoordSystem).getOriginTrack() != this) {
                    this.refreshSteps();
                }
            } else if (string.equals("starttime") || string.equals("frameduration") || string.equals("startframe")) {
                this.refreshInitialTime();
                this.refreshSteps();
            } else if (string.equals("stepsize")) {
                this.refreshSteps();
            }
        }
    }

    @Override
    public double getMass() {
        Parameter parameter = (Parameter)this.getParamEditor().getObject("m");
        if (parameter != null) {
            return parameter.getValue();
        }
        return super.getMass();
    }

    @Override
    public void setMass(double d) {
        super.setMass(d);
        d = super.getMass();
        this.massField.setValue(d);
        Parameter parameter = (Parameter)this.getParamEditor().getObject("m");
        if (parameter.getValue() != d) {
            this.functionPanel.getParamEditor().setExpression("m", String.valueOf(d), false);
            this.refreshSteps();
        }
    }

    @Override
    public void setName(String string) {
        String string2 = this.getName();
        super.setName(string);
        if (this.inspector != null) {
            this.inspector.renamePanel(string2, string);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    @Override
    protected boolean isAutoTrackable() {
        return false;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        Interactive interactive = super.findInteractive(drawingPanel, n, n2);
        if (interactive instanceof PositionStep.Position) {
            this.hint = TrackerRes.getString("PointMass.Position.Locked.Hint");
        } else if (interactive == null) {
            this.hint = TrackerRes.getString("ParticleModel.Hint");
        }
        return interactive;
    }

    @Override
    public void setLocked(boolean bl) {
    }

    @Override
    public boolean isDependent() {
        return true;
    }

    @Override
    public boolean isStepComplete(int n) {
        return true;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        if (this.inspectorItem == null) {
            this.inspectorItem = new JMenuItem();
            this.inspectorItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParticleModel.this.positionInspector();
                    ParticleModel.this.getInspector().setVisible(true);
                }
            });
            this.useDefaultRefFrameItem = new JCheckBoxMenuItem();
            this.useDefaultRefFrameItem.setSelected(!this.useDefaultReferenceFrame);
            this.useDefaultRefFrameItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ParticleModel.this.setUseDefaultReferenceFrame(!ParticleModel.this.useDefaultRefFrameItem.isSelected());
                    if (ParticleModel.this.trackerPanel.getCoords() instanceof ReferenceFrame) {
                        ParticleModel.this.lastValidFrame = -1;
                        ParticleModel.this.refreshSteps();
                    }
                }
            });
        }
        this.inspectorItem.setText(TrackerRes.getString("ParticleModel.MenuItem.InspectModel"));
        this.useDefaultRefFrameItem.setText(TrackerRes.getString("ParticleModel.MenuItem.UseDefaultReferenceFrame"));
        JMenu jMenu = super.getMenu(trackerPanel);
        jMenu.remove(this.autotrackItem);
        jMenu.remove(this.deleteStepItem);
        jMenu.remove(this.clearStepsItem);
        jMenu.remove(this.lockedItem);
        jMenu.remove(this.autoAdvanceItem);
        jMenu.remove(this.markByDefaultItem);
        jMenu.insert(this.inspectorItem, 0);
        if (jMenu.getItemCount() > 1) {
            jMenu.insertSeparator(1);
        }
        JMenuItem jMenuItem = this.inspectorItem;
        int n = jMenu.getItemCount();
        int n2 = 1;
        while (n2 < n) {
            JMenuItem jMenuItem2 = jMenu.getItem(n2);
            if (jMenuItem2 == null && jMenuItem == null) {
                jMenu.remove(n2 - 1);
                --n2;
                --n;
            }
            jMenuItem = jMenuItem2;
            ++n2;
        }
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarPointComponents(TrackerPanel trackerPanel, TPoint tPoint) {
        ArrayList<Component> arrayList = super.getToolbarPointComponents(trackerPanel, tPoint);
        this.xField.setEnabled(false);
        this.yField.setEnabled(false);
        this.magField.setEnabled(false);
        this.angleField.setEnabled(false);
        return arrayList;
    }

    public void setStartFrame(int n) {
        if (n == this.getStartFrame()) {
            return;
        }
        n = Math.max(n, 0);
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n2 = videoClip.getFrameCount() - 1;
        n = Math.min(n, n2);
        this.startFrame = n = Math.min(n, this.getEndFrame());
        this.refreshInitialTime();
        this.lastValidFrame = -1;
        this.refreshSteps();
        this.trackerPanel.repaint();
        this.firePropertyChange("model_start", null, this.getStartFrame());
    }

    public int getStartFrame() {
        return this.startFrame;
    }

    public void setEndFrame(int n) {
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n2 = videoClip.getFrameCount() - 1;
        n = Math.max(n, 0);
        if ((n = Math.max(n, this.getStartFrame())) == this.getEndFrame()) {
            return;
        }
        int n3 = this.endFrame = n < n2 ? n : Integer.MAX_VALUE;
        if (n < this.lastValidFrame) {
            this.trimSteps();
        } else {
            this.refreshSteps();
        }
        this.trackerPanel.repaint();
        this.firePropertyChange("model_end", null, this.getEndFrame());
    }

    public int getEndFrame() {
        return this.endFrame;
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        super.setTrackerPanel(trackerPanel);
        if (trackerPanel != null) {
            int n;
            if (this.startFrameUndefined) {
                n = trackerPanel.getPlayer().getVideoClip().getStartFrameNumber();
                this.setStartFrame(n);
                this.startFrameUndefined = false;
            }
            if (trackerPanel.getTFrame() != null) {
                n = trackerPanel.getTFrame().anglesInRadians ? 1 : 0;
                this.functionPanel.initEditor.setAnglesInDegrees(n == 0);
            }
        }
    }

    @Override
    protected void setAnglesInRadians(boolean bl) {
        super.setAnglesInRadians(bl);
        this.functionPanel.initEditor.setAnglesInDegrees(!bl);
        String string = String.valueOf(TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description")) + " ";
        string = String.valueOf(string) + (bl ? TrackerRes.getString("TableTrackView.Radians.Tooltip") : TrackerRes.getString("TableTrackView.Degrees.Tooltip"));
        this.functionPanel.initEditor.setDescription(FunctionEditor.THETA, string);
        string = String.valueOf(TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description")) + " ";
        string = String.valueOf(string) + (bl ? TrackerRes.getString("TableTrackView.RadiansPerSecond.Tooltip") : TrackerRes.getString("TableTrackView.DegreesPerSecond.Tooltip"));
        this.functionPanel.initEditor.setDescription(FunctionEditor.OMEGA, string);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        if (this.inspector != null) {
            this.trackerPanel.removePropertyChangeListener("data", this);
            this.inspector.removePanel(this.getName());
            this.inspector.removePropertyChangeListener(this);
            if (this.trackerPanel.getTFrame() != null) {
                this.trackerPanel.getTFrame().removePropertyChangeListener("tab", this);
            }
            if (this.inspector.isEmpty()) {
                this.inspector.setVisible(false);
            }
        }
    }

    abstract Point2D[] getNextTracePositions();

    protected void reset() {
    }

    protected ParticleModel[] getModels() {
        return new ParticleModel[]{this};
    }

    protected boolean isModelsVisible() {
        ParticleModel[] particleModelArray = this.getModels();
        int n = particleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleModel particleModel = particleModelArray[n2];
            if (particleModel.isTraceVisible() || particleModel.isVisible() && (particleModel.isPositionVisible(this.trackerPanel) || particleModel.isVVisible(this.trackerPanel) || particleModel.isAVisible(this.trackerPanel))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void refreshInitialTime() {
        if (this.trackerPanel == null) {
            return;
        }
        double d = this.trackerPanel.getPlayer().getFrameTime(this.getStartFrame()) / 1000.0;
        String string = timeFormat.format(d);
        Parameter parameter = (Parameter)this.getInitEditor().getObject("t");
        if (parameter.getValue() != d) {
            boolean bl = this.refreshing;
            this.refreshing = true;
            this.getInitEditor().setExpression("t", string, false);
            this.refreshing = bl;
        }
    }

    protected void refreshSteps() {
        if (this.refreshStepsLater) {
            return;
        }
        if (this instanceof DynamicSystem) {
            DynamicSystem dynamicSystem = (DynamicSystem)this;
            if (dynamicSystem.particles.length == 0) {
                return;
            }
        }
        if (this.trackerPanel != null) {
            boolean bl;
            int n;
            this.refreshDerivsLater = this.trackerPanel.getPlayer().getClipControl().isPlaying();
            int n2 = this.trackerPanel.getFrameNumber();
            VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
            int n3 = Math.min(this.getEndFrame(), n2);
            while (n3 > this.getStartFrame() && !videoClip.includesFrame(n3)) {
                --n3;
            }
            if (n3 <= this.lastValidFrame) {
                return;
            }
            if (this.lastValidFrame == -1) {
                this.reset();
                if (this.lastValidFrame == -1 || n3 <= this.lastValidFrame) {
                    return;
                }
            }
            int n4 = this.lastValidFrame;
            Tracker.logTime(String.valueOf(this.getClass().getSimpleName()) + this.hashCode() + " refreshing steps " + n4 + " to " + n3);
            boolean bl2 = n3 - n4 == 1;
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            boolean bl3 = this.isUseDefaultReferenceFrame();
            while (bl3 && imageCoordSystem instanceof ReferenceFrame) {
                imageCoordSystem = ((ReferenceFrame)imageCoordSystem).getCoords();
            }
            double d = this.t0 + this.dt * (double)tracePtsPerStep * (double)(n4 - this.getStartFrame()) / (double)videoClip.getStepSize();
            double d2 = 1.0 * (double)videoClip.getStepSize() / (double)tracePtsPerStep;
            int n5 = tracePtsPerStep * (n3 - n4) / videoClip.getStepSize();
            ParticleModel[] particleModelArray = this.getModels();
            Object[] objectArray = particleModelArray;
            int n6 = particleModelArray.length;
            int n7 = 0;
            while (n7 < n6) {
                ParticleModel particleModel = objectArray[n7];
                particleModel.locked = false;
                n = particleModel.traceX.length + n5;
                particleModel.prevX = particleModel.traceX;
                particleModel.prevY = particleModel.traceY;
                particleModel.traceX = new double[n];
                particleModel.traceY = new double[n];
                System.arraycopy(particleModel.prevX, 0, particleModel.traceX, 0, particleModel.prevX.length);
                System.arraycopy(particleModel.prevY, 0, particleModel.traceY, 0, particleModel.prevY.length);
                ++n7;
            }
            int n8 = 0;
            while (n8 < n5) {
                n7 = n8 + 1;
                n6 = n4 + (int)((double)n7 * d2);
                this.time = d + (double)n7 * this.dt;
                objectArray = this.getNextTracePositions();
                if (objectArray != null) {
                    AffineTransform affineTransform = imageCoordSystem.getToImageTransform(n6);
                    int n9 = 0;
                    while (n9 < particleModelArray.length) {
                        Object object;
                        affineTransform.transform((Point2D)objectArray[n9], (Point2D)objectArray[n9]);
                        boolean bl4 = bl = Math.abs(((Point2D)objectArray[n9]).getX()) < xLimit && Math.abs(((Point2D)objectArray[n9]).getY()) < yLimit;
                        if (!bl && !this.invalidWarningShown) {
                            this.invalidWarningShown = true;
                            object = new Runnable(){

                                @Override
                                public void run() {
                                    JOptionPane.showMessageDialog(ParticleModel.this.trackerPanel, String.valueOf(TrackerRes.getString("ParticleModel.Dialog.Offscreen.Message1")) + XML.NEW_LINE + TrackerRes.getString("ParticleModel.Dialog.Offscreen.Message2"), TrackerRes.getString("ParticleModel.Dialog.Offscreen.Title"), 2);
                                }
                            };
                            SwingUtilities.invokeLater((Runnable)object);
                        }
                        particleModelArray[n9].traceX[particleModelArray[n9].prevX.length + n8] = bl ? ((Point2D)objectArray[n9]).getX() : Double.NaN;
                        double d3 = particleModelArray[n9].traceY[particleModelArray[n9].prevY.length + n8] = bl ? ((Point2D)objectArray[n9]).getY() : Double.NaN;
                        if (n7 % tracePtsPerStep == 0) {
                            this.saveState(n6);
                            object = (PositionStep)particleModelArray[n9].getStep(n6);
                            if (object == null) {
                                object = new PositionStep(particleModelArray[n9], n6, 0.0, 0.0);
                                ((Step)object).setFootprint(particleModelArray[n9].getFootprint());
                                particleModelArray[n9].steps.setStep(n6, (Step)object);
                            }
                            ((PositionStep)object).getPosition().setPosition((Point2D)(bl ? objectArray[n9] : nan));
                        }
                        ++n9;
                    }
                }
                ++n8;
            }
            n8 = 4 + (n3 - n4);
            n7 = n4;
            if (n7 > videoClip.getStepSize()) {
                n7 -= videoClip.getStepSize();
            }
            if (n7 > videoClip.getStepSize()) {
                n7 -= videoClip.getStepSize();
            }
            this.lastValidFrame = n3;
            ParticleModel[] particleModelArray2 = particleModelArray;
            n = particleModelArray.length;
            int n10 = 0;
            while (n10 < n) {
                ParticleModel particleModel = particleModelArray2[n10];
                particleModel.steps.setLength(n3 + 1);
                imageCoordSystem = this.trackerPanel.getCoords();
                if (imageCoordSystem instanceof ReferenceFrame && ((ReferenceFrame)imageCoordSystem).getOriginTrack() == particleModel) {
                    bl = particleModel.refreshing;
                    particleModel.refreshing = true;
                    ((ReferenceFrame)imageCoordSystem).setOrigins();
                    int n11 = 0;
                    while (n11 < videoClip.getStepCount()) {
                        int n12 = videoClip.stepToFrame(n11);
                        PositionStep positionStep = (PositionStep)particleModel.getStep(n12);
                        if (positionStep != null) {
                            AffineTransform affineTransform = imageCoordSystem.getToImageTransform(n12);
                            particleModel.point.setLocation(0.0, 0.0);
                            affineTransform.transform(particleModel.point, particleModel.point);
                            positionStep.getPosition().setPosition(particleModel.point);
                        }
                        ++n11;
                    }
                    particleModel.refreshing = bl;
                    if (!this.refreshDerivsLater) {
                        particleModel.updateDerivatives(n7, n8);
                    }
                } else if (!this.refreshDerivsLater) {
                    particleModel.updateDerivatives(n7, n8);
                }
                if (particleModel.vAtOrigin) {
                    particleModel.vTailsToOriginItem.doClick();
                }
                if (particleModel.aAtOrigin) {
                    particleModel.aTailsToOriginItem.doClick();
                }
                if (!this.refreshDerivsLater) {
                    if (bl2) {
                        particleModel.support.firePropertyChange("step", null, new Integer(n2));
                    } else {
                        particleModel.support.firePropertyChange("steps", null, null);
                    }
                }
                particleModel.repaint();
                particleModel.locked = true;
                ++n10;
            }
            this.trackerPanel.repaint();
        }
    }

    protected void refreshDerivsIfNeeded() {
        if (!this.refreshDerivsLater) {
            return;
        }
        this.refreshDerivsLater = false;
        ParticleModel[] particleModelArray = this.getModels();
        int n = particleModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParticleModel particleModel = particleModelArray[n2];
            particleModel.updateDerivatives();
            particleModel.firePropertyChange("steps", null, null);
            ++n2;
        }
    }

    protected void trimSteps() {
        ParticleModel[] particleModelArray;
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n = videoClip.getFrameCount() - 1;
        int n2 = this.getEndFrame() == Integer.MAX_VALUE ? n : this.getEndFrame();
        while (n2 > this.getStartFrame() && !videoClip.includesFrame(n2)) {
            --n2;
        }
        if (n2 >= this.lastValidFrame) {
            return;
        }
        int n3 = tracePtsPerStep * (this.lastValidFrame - n2) / videoClip.getStepSize();
        ParticleModel[] particleModelArray2 = particleModelArray = this.getModels();
        int n4 = particleModelArray.length;
        int n5 = 0;
        while (n5 < n4) {
            ParticleModel particleModel = particleModelArray2[n5];
            particleModel.locked = false;
            int n6 = particleModel.traceX.length - n3;
            if (n6 < 0) {
                return;
            }
            particleModel.prevX = particleModel.traceX;
            particleModel.prevY = particleModel.traceY;
            particleModel.traceX = new double[n6];
            particleModel.traceY = new double[n6];
            System.arraycopy(particleModel.prevX, 0, particleModel.traceX, 0, n6);
            System.arraycopy(particleModel.prevY, 0, particleModel.traceY, 0, n6);
            particleModel.steps.setLength(n2 + 1);
            particleModel.updateDerivatives(n2 - 2, this.lastValidFrame - n2 + 2);
            this.restoreState(n2);
            particleModel.support.firePropertyChange("steps", null, null);
            particleModel.locked = true;
            ++n5;
        }
        this.lastValidFrame = n2;
        this.repaint();
    }

    protected void saveState(int n) {
    }

    protected boolean restoreState(int n) {
        return false;
    }

    protected boolean isUseDefaultReferenceFrame() {
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        if (imageCoordSystem instanceof ReferenceFrame && ((ReferenceFrame)imageCoordSystem).getOriginTrack() == this) {
            return true;
        }
        return this.useDefaultReferenceFrame;
    }

    public void setUseDefaultReferenceFrame(boolean bl) {
        this.useDefaultReferenceFrame = bl;
    }

    public FunctionTool getInspector() {
        if (this.trackerPanel == null) {
            return null;
        }
        if (this.inspector == null) {
            this.inspector = this.trackerPanel.getModelBuilder();
            this.inspector.addPanel(this.getName(), this.functionPanel);
            this.inspector.addPropertyChangeListener(this);
            if (this.trackerPanel.getTFrame() != null) {
                this.trackerPanel.getTFrame().addPropertyChangeListener("tab", this);
            }
            if (this.getInitEditor().getValues()[0] == 0.0) {
                this.refreshInitialTime();
                this.getInitEditor().getTable().clearSelection();
            }
        }
        return this.inspector;
    }

    protected void initializeFunctionPanel() {
        this.createMassAndTimeParameters();
    }

    protected void createMassAndTimeParameters() {
        Parameter parameter = new Parameter("m", String.valueOf(this.getMass()));
        parameter.setNameEditable(false);
        parameter.setDescription(TrackerRes.getString("ParticleModel.Parameter.Mass.Description"));
        this.getParamEditor().addObject(parameter, false);
        parameter = new Parameter("t", "0");
        parameter.setNameEditable(false);
        parameter.setDescription(TrackerRes.getString("ParticleModel.Parameter.InitialTime.Description"));
        this.functionPanel.getInitEditor().addObject(parameter, false);
        this.getParamEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("m".equals(propertyChangeEvent.getOldValue())) {
                    Parameter parameter = (Parameter)ParticleModel.this.getParamEditor().getObject("m");
                    if (ParticleModel.super.getMass() != parameter.getValue()) {
                        ParticleModel.this.setMass(parameter.getValue());
                    }
                }
            }
        });
        this.getInitEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ParticleModel.this.refreshing) {
                    return;
                }
                if ("t".equals(propertyChangeEvent.getOldValue()) && ParticleModel.this.trackerPanel != null) {
                    Parameter parameter = (Parameter)ParticleModel.this.getInitEditor().getObject("t");
                    VideoClip videoClip = ParticleModel.this.trackerPanel.getPlayer().getVideoClip();
                    double d = parameter.getValue() * 1000.0 - videoClip.getStartTime();
                    double d2 = ParticleModel.this.trackerPanel.getPlayer().getMeanStepDuration();
                    int n = videoClip.getStartFrameNumber();
                    boolean bl = d % d2 > 0.0;
                    ParticleModel.this.setStartFrame(n += videoClip.getStepSize() * (int)Math.round(d / d2));
                    if (ParticleModel.this.getStartFrame() != n || bl) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
    }

    public double[] getInitialValues() {
        return this.functionPanel.getInitEditor().getValues();
    }

    public ParamEditor getParamEditor() {
        return this.functionPanel.getParamEditor();
    }

    public InitialValueEditor getInitEditor() {
        return this.functionPanel.getInitEditor();
    }

    public UserFunctionEditor getFunctionEditor() {
        return this.functionPanel.getUserFunctionEditor();
    }

    private void positionInspector() {
        if (this.inspectorX != Integer.MIN_VALUE) {
            this.refreshing = !this.showInspector;
            loading = true;
            this.getInspector();
            loading = false;
            this.refreshing = false;
            TFrame tFrame = this.trackerPanel.getTFrame();
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            if (this.inspectorH != Integer.MIN_VALUE) {
                this.inspector.setSize(this.inspector.getWidth(), Math.min(this.inspectorH, dimension.height));
            }
            int n = Math.max(tFrame.getLocation().x + this.inspectorX, 0);
            n = Math.min(n, dimension.width - this.inspector.getWidth());
            int n2 = Math.max(tFrame.getLocation().y + this.inspectorY, 0);
            n2 = Math.min(n2, dimension.height - this.inspector.getHeight());
            this.inspector.setLocation(n, n2);
            this.inspectorX = Integer.MIN_VALUE;
        }
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ParticleModel particleModel = (ParticleModel)object;
            xMLControl.setValue("mass", particleModel.getMass());
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            Parameter[] parameterArray = particleModel.getParamEditor().getParameters();
            xMLControl.setValue("user_parameters", parameterArray);
            Parameter[] parameterArray2 = particleModel.getInitEditor().getParameters();
            xMLControl.setValue("initial_values", parameterArray2);
            UserFunction[] userFunctionArray = particleModel.getFunctionEditor().getMainFunctions();
            xMLControl.setValue("main_functions", userFunctionArray);
            userFunctionArray = particleModel.getFunctionEditor().getSupportFunctions();
            if (userFunctionArray.length > 0) {
                xMLControl.setValue("support_functions", userFunctionArray);
            }
            if (particleModel.startFrame > 0) {
                xMLControl.setValue("start_frame", particleModel.startFrame);
            }
            if (particleModel.endFrame < Integer.MAX_VALUE) {
                xMLControl.setValue("end_frame", particleModel.endFrame);
            }
            if (particleModel.inspector != null && particleModel.trackerPanel != null && particleModel.trackerPanel.getTFrame() != null) {
                TFrame tFrame = particleModel.trackerPanel.getTFrame();
                int n = particleModel.inspector.getLocation().x - tFrame.getLocation().x;
                int n2 = particleModel.inspector.getLocation().y - tFrame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
                xMLControl.setValue("inspector_h", particleModel.inspector.getHeight());
                xMLControl.setValue("inspector_visible", particleModel.inspector.isVisible());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            ParticleModel particleModel = (ParticleModel)object;
            particleModel.mass = xMLControl.getDouble("mass");
            particleModel.inspectorX = xMLControl.getInt("inspector_x");
            particleModel.inspectorY = xMLControl.getInt("inspector_y");
            particleModel.inspectorH = xMLControl.getInt("inspector_h");
            particleModel.showInspector = xMLControl.getBoolean("inspector_visible");
            Parameter[] parameterArray = (Parameter[])xMLControl.getObject("user_parameters");
            particleModel.getParamEditor().setParameters(parameterArray);
            parameterArray = (Parameter[])xMLControl.getObject("initial_values");
            int n = 0;
            while (n < parameterArray.length) {
                Parameter parameter = parameterArray[n];
                String string = parameter.getName();
                int n2 = string.lastIndexOf("0");
                if (n2 > -1) {
                    string = string.substring(0, n2);
                    Parameter parameter2 = new Parameter(string, parameter.getExpression());
                    parameter2.setDescription(parameter.getDescription());
                    parameter2.setNameEditable(false);
                    parameterArray[n] = parameter2;
                }
                ++n;
            }
            particleModel.getInitEditor().setParameters(parameterArray);
            UserFunction[] userFunctionArray = (UserFunction[])xMLControl.getObject("main_functions");
            particleModel.getFunctionEditor().setMainFunctions(userFunctionArray);
            userFunctionArray = (UserFunction[])xMLControl.getObject("support_functions");
            if (userFunctionArray != null) {
                int n3 = 0;
                while (n3 < userFunctionArray.length) {
                    particleModel.getFunctionEditor().addObject(userFunctionArray[n3], false);
                    ++n3;
                }
            }
            particleModel.functionPanel.refreshFunctions();
            int n4 = xMLControl.getInt("start_frame");
            if (n4 != Integer.MIN_VALUE) {
                particleModel.startFrame = n4;
            } else {
                particleModel.startFrameUndefined = true;
            }
            n4 = xMLControl.getInt("end_frame");
            if (n4 != Integer.MIN_VALUE) {
                particleModel.endFrame = n4;
            }
            return object;
        }
    }
}

