/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.text.Style;
import javax.swing.text.StyledDocument;
import org.opensourcephysics.cabrillo.tracker.DataTrackClipControl;
import org.opensourcephysics.cabrillo.tracker.DataTrackTimeControl;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.UserFunctionEditor;

public class ParticleDataTrackFunctionPanel
extends ModelFunctionPanel {
    private DataTrackClipControl clipControl;
    private DataTrackTimeControl timeControl;
    private JPanel customControl;
    private JPanel customTitle;

    public ParticleDataTrackFunctionPanel(ParticleDataTrack particleDataTrack) {
        super(new UserFunctionEditor(), particleDataTrack);
        this.model = particleDataTrack;
        this.setName(particleDataTrack.getName());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ParticleDataTrackFunctionPanel.this.clearSelection();
            }
        };
        this.clipControl = new DataTrackClipControl(particleDataTrack);
        this.clipControl.addMouseListenerToAll(mouseAdapter);
        this.timeControl = new DataTrackTimeControl(particleDataTrack);
        this.timeControl.addMouseListener(mouseAdapter);
        this.box.remove(this.paramEditor);
        this.box.remove(this.functionEditor);
        this.box.add((Component)this.clipControl, 1);
        this.box.add((Component)this.timeControl, 2);
    }

    public void setCustomControl(JPanel jPanel) {
        if (jPanel == this.customControl) {
            return;
        }
        if (this.customControl != null) {
            this.customTitle.remove(this.customControl);
            this.box.remove(this.customTitle);
        }
        this.customControl = jPanel;
        if (this.customControl != null) {
            if (this.customTitle == null) {
                this.customTitle = new JPanel(new BorderLayout());
            }
            this.customTitle.add((Component)this.customControl, "Center");
            this.box.add((Component)this.customTitle, 3);
            this.refreshGUI();
        }
    }

    @Override
    protected void refreshGUI() {
        Object object;
        Object object2;
        super.refreshGUI();
        if (this.model != null && (object2 = ((ParticleDataTrack)(object = (ParticleDataTrack)this.model)).getSource()) != null && object2 instanceof JPanel) {
            this.setCustomControl((JPanel)object2);
        }
        if (this.customControl != null) {
            object = TrackerRes.getString("ParticleDataTrackFunctionPanel.Border.Title");
            this.customTitle.setBorder(BorderFactory.createTitledBorder((String)object));
        }
    }

    @Override
    protected void refreshInstructions(FunctionEditor functionEditor, boolean bl, int n) {
        StyledDocument styledDocument = this.instructions.getStyledDocument();
        Style style = styledDocument.getStyle("blue");
        String string = TrackerRes.getString("ParticleDataTrackFunctionPanel.Instructions.General");
        if (!bl && this.hasInvalidExpressions()) {
            string = ToolsRes.getString("FunctionPanel.Instructions.BadCell");
            style = styledDocument.getStyle("red");
        }
        this.instructions.setText(string);
        int n2 = this.instructions.getText().length();
        styledDocument.setCharacterAttributes(0, n2, style, false);
        this.revalidate();
    }

    @Override
    protected void tabToNext(FunctionEditor functionEditor) {
        this.clipControl.requestFocusInWindow();
    }
}

