/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrackFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataClip;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.Parameter;

public class ParticleDataTrack
extends ParticleModel
implements DataTrack {
    private DataClip dataClip;
    private Data sourceData;
    private double[] xData = new double[]{0.0};
    private double[] yData = new double[]{0.0};
    private double[] tData = new double[]{0.0};
    private Point2D[] tracePosition;
    private int stepCounter;
    private Object dataSource;
    private boolean useDataTime;

    ParticleDataTrack(Data data, Object object) throws Exception {
        this.dataSource = object;
        this.getDataClip().addPropertyChangeListener(this);
        this.tracePosition = new Point2D[]{this.point};
        tracePtsPerStep = 1;
        this.setData(data);
    }

    private ParticleDataTrack(double[] dArray, double[] dArray2, double[] dArray3) {
        this.getDataClip().addPropertyChangeListener(this);
        this.tracePosition = new Point2D[]{this.point};
        tracePtsPerStep = 1;
        try {
            this.setData(new double[][]{dArray, dArray2, dArray3}, true);
        }
        catch (Exception exception) {}
    }

    public void setData(Data data) throws Exception {
        double[][] dArray = ParticleDataTrack.getDataArray(data);
        OSPLog.fine("Setting new data");
        this.sourceData = data;
        this.setData(dArray, true);
    }

    @Override
    public Data getData() {
        return this.sourceData;
    }

    @Override
    public Object getSource() {
        return this.dataSource;
    }

    public void setSource(Object object) {
        this.dataSource = object;
    }

    @Override
    public DataClip getDataClip() {
        if (this.dataClip == null) {
            this.dataClip = new DataClip();
        }
        return this.dataClip;
    }

    public VideoClip getVideoClip() {
        if (this.trackerPanel == null) {
            return null;
        }
        return this.trackerPanel.getPlayer().getVideoClip();
    }

    public int getEndIndex() {
        int n = this.getEndFrame() - this.getStartFrame();
        int n2 = this.dataClip.getStartIndex() + n * this.dataClip.getStride();
        return Math.min(n2, this.dataClip.getDataLength() - 1);
    }

    public double getStepTime(int n) {
        if (this.tData == null) {
            return Double.NaN;
        }
        int n2 = this.getDataClip().stepToIndex(n);
        if (n2 < this.tData.length) {
            return this.tData[n2];
        }
        return Double.NaN;
    }

    @Override
    public boolean isTimeDataAvailable() {
        if (this.dataClip == null || this.getVideoClip() == null) {
            return false;
        }
        int n = Math.max(this.dataClip.getStride(), this.dataClip.getStartIndex());
        return this.tData != null && this.tData.length > n;
    }

    @Override
    public double getVideoStartTime() {
        if (!this.isTimeDataAvailable()) {
            return Double.NaN;
        }
        double d = this.tData[this.dataClip.getStartIndex()];
        double d2 = this.getFrameDuration();
        return d - d2 * (double)(this.getStartFrame() - this.getVideoClip().getStartFrameNumber());
    }

    @Override
    public double getFrameDuration() {
        if (!this.isTimeDataAvailable()) {
            return Double.NaN;
        }
        return this.tData[this.dataClip.getStride()] - this.tData[0];
    }

    @Override
    public void setStartFrame(int n) {
        if (n == this.getStartFrame()) {
            return;
        }
        n = Math.max(n, 0);
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n2 = videoClip.getFrameCount() - 1;
        this.startFrame = n = Math.min(n, n2);
        this.refreshInitialTime();
        this.extendVideoClip();
        this.lastValidFrame = -1;
        this.trackerPanel.repaint();
        this.firePropertyChange("startframe", null, this.getStartFrame());
        if (this.trackerPanel != null) {
            this.trackerPanel.getModelBuilder().refreshSpinners();
            Video video = this.trackerPanel.getVideo();
            if (video != null) {
                video.setFrameNumber(this.getStartFrame());
            }
        }
    }

    @Override
    public void setEndFrame(int n) {
        this.dataClip.setClipLength(n - this.getStartFrame() + 1);
        this.trackerPanel.getModelBuilder().refreshSpinners();
    }

    @Override
    protected void refreshInitialTime() {
        if (this.trackerPanel == null || this.trackerPanel.getPlayer() == null) {
            super.refreshInitialTime();
            return;
        }
        if (!ClipControl.isTimeSource(this) || !this.isTimeDataAvailable()) {
            super.refreshInitialTime();
            return;
        }
        ClipControl clipControl = this.trackerPanel.getPlayer().getClipControl();
        clipControl.setTimeSource(this);
        Parameter parameter = (Parameter)this.getInitEditor().getObject("t");
        double d = this.tData[this.dataClip.getStartIndex()];
        String string = timeFormat.format(d);
        if (!timeFormat.format(parameter.getValue()).equals(string)) {
            boolean bl = this.refreshing;
            this.refreshing = true;
            this.getInitEditor().setExpression("t", string, false);
            this.refreshing = bl;
        }
    }

    @Override
    public int getEndFrame() {
        int n = this.getStartFrame() + this.dataClip.getClipLength() - 1;
        int n2 = this.trackerPanel.getPlayer().getVideoClip().getLastFrameNumber();
        return Math.min(n, n2);
    }

    @Override
    Point2D[] getNextTracePositions() {
        ++this.stepCounter;
        int n = this.trackerPanel.getPlayer().getVideoClip().getStepSize();
        int n2 = this.stepCounter * n;
        int n3 = this.dataClip.stepToIndex(n2);
        if (n3 >= this.xData.length || n3 >= this.yData.length) {
            return null;
        }
        this.point.setLocation(this.xData[n3], this.yData[n3]);
        return this.tracePosition;
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        super.setTrackerPanel(trackerPanel);
        if (trackerPanel == null) {
            return;
        }
        VideoClip videoClip = trackerPanel.getPlayer().getVideoClip();
        videoClip.addPropertyChangeListener(this);
        int n = videoClip.getLastFrameNumber() - videoClip.getFirstFrameNumber() + 1;
        this.dataClip.setClipLength(Math.min(n, this.dataClip.getClipLength()));
        this.firePropertyChange("videoclip", null, null);
        if (this.useDataTime) {
            trackerPanel.getPlayer().getClipControl().setTimeSource(this);
            this.firePropertyChange("timedata", null, null);
        }
    }

    @Override
    public DatasetManager getData(TrackerPanel trackerPanel) {
        DatasetManager datasetManager = super.getData(trackerPanel);
        return datasetManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() instanceof VideoClip || propertyChangeEvent.getPropertyName().equals("video")) {
            if (propertyChangeEvent.getPropertyName().equals("frameshift")) {
                VideoClip videoClip = this.getVideoPanel().getPlayer().getVideoClip();
                int n = this.getStartFrame();
                n = Math.max(n, videoClip.getFirstFrameNumber());
                n = Math.min(n, videoClip.getLastFrameNumber());
                this.setStartFrame(n);
            }
            this.firePropertyChange("videoclip", null, null);
            this.lastValidFrame = -1;
            this.repaint();
        } else if (propertyChangeEvent.getSource() == this.dataClip) {
            this.refreshInitialTime();
            this.extendVideoClip();
            this.firePropertyChange("dataclip", null, null);
            this.lastValidFrame = -1;
            this.repaint();
        }
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionPanel = new ParticleDataTrackFunctionPanel(this);
        this.createTimeParameter();
    }

    @Override
    protected void reset() {
        Object object;
        int n = 0;
        while (n < this.steps.length) {
            object = this.steps.getStep(n);
            if (object != null) {
                ((Step)object).erase();
            }
            this.steps.setStep(n, null);
            ++n;
        }
        n = this.dataClip.stepToIndex(0);
        this.point.setLocation(this.xData[n], this.yData[n]);
        object = this.trackerPanel.getCoords();
        boolean bl = this.isUseDefaultReferenceFrame();
        while (bl && object instanceof ReferenceFrame) {
            object = ((ReferenceFrame)object).getCoords();
        }
        int n2 = this.getStartFrame();
        AffineTransform affineTransform = ((ImageCoordSystem)object).getToImageTransform(n2);
        affineTransform.transform(this.point, this.point);
        this.steps.setLength(n2 + 1);
        int n3 = 0;
        while (n3 < this.steps.length) {
            if (n3 < n2 || this.dataClip.getClipLength() == 0) {
                this.steps.setStep(n3, null);
            } else {
                PositionStep positionStep = new PositionStep(this, n2, this.point.getX(), this.point.getY());
                positionStep.setFootprint(this.getFootprint());
                this.steps.setStep(n2, positionStep);
            }
            ++n3;
        }
        this.getVArray(this.trackerPanel).setLength(0);
        this.getAArray(this.trackerPanel).setLength(0);
        this.traceX = new double[]{this.point.getX()};
        this.traceY = new double[]{this.point.getY()};
        this.lastValidFrame = n2;
        this.stepCounter = 0;
    }

    @Override
    public void setData(Data data, Object object) throws Exception {
        this.setData(data);
        this.setSource(object);
    }

    @Override
    public VideoPanel getVideoPanel() {
        return this.trackerPanel;
    }

    public double[][] getDataArray() {
        return new double[][]{this.xData, this.yData, this.tData};
    }

    public void appendData(Data data) throws Exception {
        double[][] dArray;
        int n;
        double[][] dArray2 = ParticleDataTrack.getDataArray(data);
        if (dArray2[0].length <= (n = (dArray = this.getDataArray())[0].length)) {
            TFrame tFrame = this.trackerPanel != null ? this.trackerPanel.getTFrame() : null;
            JOptionPane.showMessageDialog(tFrame, TrackerRes.getString("ParticleDataTrack.Dialog.NoNewData.Message"), TrackerRes.getString("ParticleDataTrack.Dialog.NoNewData.Title"), 2);
            return;
        }
        int n2 = 0;
        while (n2 < dArray2.length) {
            if (dArray2[n2] != null && dArray[n2] != null) {
                System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            }
            ++n2;
        }
        this.sourceData = data;
        this.setData(dArray2, false);
    }

    public static double[][] getDataArray(Data data) throws Exception {
        if (data == null) {
            throw new Exception("Data is null");
        }
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList == null) {
            throw new Exception("Data contains no datasets");
        }
        double[][] dArrayArray = new double[3][];
        for (Dataset dataset : arrayList) {
            if (dArrayArray[0] == null) {
                if (dataset.getXColumnName().equals("x")) {
                    dArrayArray[0] = dataset.getXPoints();
                } else if (dataset.getYColumnName().equals("x")) {
                    dArrayArray[0] = dataset.getYPoints();
                }
            }
            if (dArrayArray[1] == null) {
                if (dataset.getXColumnName().equals("y")) {
                    dArrayArray[1] = dataset.getXPoints();
                } else if (dataset.getYColumnName().equals("y")) {
                    dArrayArray[1] = dataset.getYPoints();
                }
            }
            if (dArrayArray[2] != null) continue;
            if (dataset.getXColumnName().equals("t")) {
                dArrayArray[2] = dataset.getXPoints();
                continue;
            }
            if (!dataset.getYColumnName().equals("t")) continue;
            dArrayArray[2] = dataset.getYPoints();
        }
        if (dArrayArray[0] == null || dArrayArray[1] == null) {
            throw new Exception("Position data (x, y) not defined");
        }
        if (dArrayArray[0].length == 0 || dArrayArray[1].length == 0) {
            throw new Exception("Position data is empty");
        }
        if (dArrayArray[0].length != dArrayArray[1].length) {
            throw new Exception("X and Y data have different array lengths");
        }
        if (dArrayArray[2] != null && dArrayArray[0].length != dArrayArray[2].length) {
            throw new Exception("Time data has incorrect array length");
        }
        return dArrayArray;
    }

    private void createTimeParameter() {
        Parameter parameter = new Parameter("t", "0");
        parameter.setNameEditable(false);
        parameter.setDescription(TrackerRes.getString("ParticleModel.Parameter.InitialTime.Description"));
        this.functionPanel.getInitEditor().addObject(parameter, false);
        this.getInitEditor().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ParticleDataTrack.this.refreshing) {
                    return;
                }
                if ("t".equals(propertyChangeEvent.getOldValue()) && ParticleDataTrack.this.trackerPanel != null) {
                    Parameter parameter = (Parameter)ParticleDataTrack.this.getInitEditor().getObject("t");
                    VideoClip videoClip = ParticleDataTrack.this.trackerPanel.getPlayer().getVideoClip();
                    double d = parameter.getValue() * 1000.0 - videoClip.getStartTime();
                    double d2 = ParticleDataTrack.this.trackerPanel.getPlayer().getMeanStepDuration();
                    int n = videoClip.getStartFrameNumber();
                    boolean bl = d % d2 > 0.0;
                    ParticleDataTrack.this.setStartFrame(n += videoClip.getStepSize() * (int)Math.round(d / d2));
                    if (ParticleDataTrack.this.getStartFrame() != n || bl) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
    }

    private void setData(double[][] dArray, boolean bl) {
        this.xData = dArray[0];
        this.yData = dArray[1];
        this.tData = dArray[2];
        this.dataClip.setDataLength(dArray[0].length);
        this.firePropertyChange("dataclip", null, this.dataClip);
        this.extendVideoClip();
        if (bl) {
            this.lastValidFrame = -1;
            this.refreshSteps();
            this.firePropertyChange("steps", null, null);
        }
        this.repaint();
    }

    private boolean extendVideoClip() {
        if (this.trackerPanel == null) {
            return false;
        }
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n = videoClip.getEndFrameNumber();
        boolean bl = n == videoClip.getLastFrameNumber();
        int n2 = this.getStartFrame() + this.dataClip.getAvailableClipLength() - 1;
        if (bl && n2 > n) {
            videoClip.extendEndFrameNumber(n2);
        }
        return false;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    /* synthetic */ ParticleDataTrack(double[] dArray, double[] dArray2, double[] dArray3, ParticleDataTrack particleDataTrack) {
        this(dArray, dArray2, dArray3);
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            ParticleDataTrack particleDataTrack = (ParticleDataTrack)object;
            xMLControl.setValue("mass", particleDataTrack.getMass());
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            xMLControl.setValue("x", particleDataTrack.xData);
            xMLControl.setValue("y", particleDataTrack.yData);
            xMLControl.setValue("t", particleDataTrack.tData);
            xMLControl.setValue("dataclip", particleDataTrack.getDataClip());
            if (particleDataTrack.getStartFrame() > 0) {
                xMLControl.setValue("start_frame", particleDataTrack.getStartFrame());
            }
            xMLControl.setValue("use_data_time", ClipControl.isTimeSource(particleDataTrack));
            if (particleDataTrack.inspector != null && particleDataTrack.trackerPanel != null && particleDataTrack.trackerPanel.getTFrame() != null) {
                TFrame tFrame = particleDataTrack.trackerPanel.getTFrame();
                int n = particleDataTrack.inspector.getLocation().x - tFrame.getLocation().x;
                int n2 = particleDataTrack.inspector.getLocation().y - tFrame.getLocation().y;
                xMLControl.setValue("inspector_x", n);
                xMLControl.setValue("inspector_y", n2);
                xMLControl.setValue("inspector_h", particleDataTrack.inspector.getHeight());
                xMLControl.setValue("inspector_visible", particleDataTrack.inspector.isVisible());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            double[] dArray = (double[])xMLControl.getObject("x");
            double[] dArray2 = (double[])xMLControl.getObject("y");
            double[] dArray3 = (double[])xMLControl.getObject("t");
            return new ParticleDataTrack(dArray, dArray2, dArray3, null);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            ParticleDataTrack particleDataTrack = (ParticleDataTrack)object;
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            particleDataTrack.mass = xMLControl.getDouble("mass");
            XMLControl xMLControl2 = xMLControl.getChildControl("dataclip");
            if (xMLControl2 != null) {
                xMLControl2.loadObject(particleDataTrack.getDataClip());
            }
            particleDataTrack.useDataTime = xMLControl.getBoolean("use_data_time");
            int n = xMLControl.getInt("start_frame");
            if (n != Integer.MIN_VALUE) {
                particleDataTrack.startFrame = n;
            } else {
                particleDataTrack.startFrameUndefined = true;
            }
            particleDataTrack.inspectorX = xMLControl.getInt("inspector_x");
            particleDataTrack.inspectorY = xMLControl.getInt("inspector_y");
            particleDataTrack.inspectorH = xMLControl.getInt("inspector_h");
            particleDataTrack.showInspector = xMLControl.getBoolean("inspector_visible");
            return particleDataTrack;
        }
    }
}

