/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ModelFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrackFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.PositionStep;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;

public class ModelBuilder
extends FunctionTool {
    private TrackerPanel trackerPanel;
    private JLabel startFrameLabel;
    private JLabel endFrameLabel;
    private JLabel boosterLabel;
    private ModelFrameSpinner startFrameSpinner;
    private ModelFrameSpinner endFrameSpinner;
    private JComboBox boosterDropdown;

    protected ModelBuilder(TrackerPanel trackerPanel) {
        super(trackerPanel);
        this.trackerPanel = trackerPanel;
        this.createToolbarComponents();
        this.setToolbarComponents(new Component[]{this.startFrameLabel, this.startFrameSpinner, this.endFrameLabel, this.endFrameSpinner, this.boosterLabel, this.boosterDropdown});
    }

    protected void createToolbarComponents() {
        this.startFrameLabel = new JLabel();
        this.startFrameLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
        this.endFrameLabel = new JLabel();
        this.endFrameLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        int n = this.trackerPanel.getPlayer().getVideoClip().getFrameCount() - 1;
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, n, 1);
        this.startFrameSpinner = new ModelFrameSpinner(spinnerNumberModel);
        spinnerNumberModel = new SpinnerNumberModel(n, 0, n, 1);
        this.endFrameSpinner = new ModelFrameSpinner(spinnerNumberModel);
        this.boosterLabel = new JLabel();
        this.boosterLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 2));
        this.boosterDropdown = new JComboBox();
        this.boosterDropdown.setBorder(BorderFactory.createEmptyBorder(0, 0, 1, 0));
        this.boosterDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ModelBuilder.this.boosterDropdown.isEnabled()) {
                    return;
                }
                FunctionPanel functionPanel = ModelBuilder.this.getSelectedPanel();
                if (functionPanel != null) {
                    ParticleModel particleModel = ((ModelFunctionPanel)functionPanel).model;
                    if (!(particleModel instanceof DynamicParticle)) {
                        return;
                    }
                    DynamicParticle dynamicParticle = (DynamicParticle)particleModel;
                    Object object = ModelBuilder.this.boosterDropdown.getSelectedItem();
                    if (object != null) {
                        PointMass pointMass;
                        Step step;
                        Object[] objectArray = (Object[])object;
                        PointMass pointMass2 = (PointMass)objectArray[1];
                        dynamicParticle.setBooster(pointMass2);
                        if (pointMass2 != null && (step = ModelBuilder.this.trackerPanel.getSelectedStep()) != null && step instanceof PositionStep && (pointMass = (PointMass)((PositionStep)step).track) == pointMass2) {
                            dynamicParticle.setStartFrame(step.getFrameNumber());
                        }
                    }
                }
            }
        });
        FunctionTool.DropdownRenderer dropdownRenderer = new FunctionTool.DropdownRenderer(this);
        this.boosterDropdown.setRenderer(dropdownRenderer);
        this.refreshBoosterDropdown();
        this.trackerPanel.addPropertyChangeListener("track", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModelBuilder.this.refreshBoosterDropdown();
                ModelBuilder.this.refreshLayout();
            }
        });
        this.setHelpAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TFrame tFrame = ModelBuilder.this.trackerPanel.getTFrame();
                if (tFrame != null) {
                    ModelFunctionPanel modelFunctionPanel = (ModelFunctionPanel)ModelBuilder.this.getSelectedPanel();
                    if (modelFunctionPanel instanceof ParticleDataTrackFunctionPanel) {
                        tFrame.showHelp("datatrack", 0);
                    } else if (modelFunctionPanel.model instanceof DynamicSystem) {
                        tFrame.showHelp("system", 0);
                    } else {
                        tFrame.showHelp("particle", 0);
                    }
                }
            }
        });
    }

    @Override
    protected void refreshGUI() {
        TTrack tTrack;
        super.refreshGUI();
        this.dropdown.setToolTipText(TrackerRes.getString("TrackerPanel.ModelBuilder.Spinner.Tooltip"));
        String string = TrackerRes.getString("TrackerPanel.ModelBuilder.Title");
        FunctionPanel functionPanel = this.getSelectedPanel();
        if (functionPanel != null && (tTrack = this.trackerPanel.getTrack(functionPanel.getName())) != null) {
            String string2 = tTrack.getClass().getSimpleName();
            string = String.valueOf(string) + ": " + TrackerRes.getString(String.valueOf(string2) + ".Builder.Title");
        }
        this.setTitle(string);
        if (this.boosterDropdown != null) {
            this.boosterDropdown.setToolTipText(TrackerRes.getString("TrackerPanel.Dropdown.Booster.Tooltip"));
            this.boosterLabel.setText(TrackerRes.getString("TrackerPanel.Label.Booster"));
            this.startFrameLabel.setText(TrackerRes.getString("TrackerPanel.Label.ModelStart"));
            this.endFrameLabel.setText(TrackerRes.getString("TrackerPanel.Label.ModelEnd"));
            this.startFrameSpinner.setToolTipText(TrackerRes.getString("TrackerPanel.Spinner.ModelStart.Tooltip"));
            this.endFrameSpinner.setToolTipText(TrackerRes.getString("TrackerPanel.Spinner.ModelEnd.Tooltip"));
            this.refreshBoosterDropdown();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.trackerPanel.isModelBuilderVisible = bl;
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        this.refreshBoosterDropdown();
        this.refreshLayout();
        this.validate();
    }

    public TrackerPanel getTrackerPanel() {
        return this.trackerPanel;
    }

    protected void refreshLayout() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ModelBuilder.this.validate();
                ModelBuilder.this.refreshGUI();
                Dimension dimension = ModelBuilder.this.getSize();
                int n = Toolkit.getDefaultToolkit().getScreenSize().height;
                dimension.height = n = Math.min((int)(0.95 * (double)n), (int)(550.0 * (1.0 + (double)ModelBuilder.this.fontLevel / 4.0)));
                ModelBuilder.this.setSize(dimension);
                ModelBuilder.this.repaint();
            }
        });
    }

    protected void refreshSpinners() {
        int n = this.trackerPanel.getPlayer().getVideoClip().getFrameCount() - 1;
        FunctionPanel functionPanel = this.getSelectedPanel();
        this.startFrameSpinner.setEnabled(functionPanel != null);
        this.endFrameSpinner.setEnabled(functionPanel != null);
        this.startFrameLabel.setEnabled(functionPanel != null);
        this.endFrameLabel.setEnabled(functionPanel != null);
        int n2 = n;
        ParticleModel particleModel = null;
        if (functionPanel != null) {
            particleModel = ((ModelFunctionPanel)functionPanel).model;
            n2 = Math.min(n, particleModel.getEndFrame());
        }
        ((SpinnerNumberModel)this.startFrameSpinner.getModel()).setMaximum(Integer.valueOf(n));
        ((SpinnerNumberModel)this.endFrameSpinner.getModel()).setMaximum(Integer.valueOf(n));
        if (particleModel != null) {
            this.startFrameSpinner.setValue(particleModel.getStartFrame());
            this.endFrameSpinner.setValue(n2);
        } else {
            this.startFrameSpinner.setValue(0);
            this.endFrameSpinner.setValue(n);
        }
        this.validate();
    }

    protected void refreshBoosterDropdown() {
        FunctionPanel functionPanel = this.getSelectedPanel();
        DynamicParticle dynamicParticle = null;
        if (functionPanel != null) {
            Object[] objectArray;
            ParticleModel particleModel = ((ModelFunctionPanel)functionPanel).model;
            if (particleModel instanceof DynamicParticle) {
                dynamicParticle = (DynamicParticle)particleModel;
            }
            this.boosterDropdown.setEnabled(false);
            String string = TrackerRes.getString("TrackerPanel.Booster.None");
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = new ShapeIcon(new Rectangle(), 21, 16);
            objectArray2[2] = string;
            Object[] objectArray3 = objectArray = objectArray2;
            boolean bl = false;
            this.boosterDropdown.removeAllItems();
            ArrayList<PointMass> arrayList = this.trackerPanel.getDrawables(PointMass.class);
            block0: for (PointMass pointMass : arrayList) {
                PointMass pointMass2;
                if (pointMass == particleModel || pointMass instanceof DynamicSystem) continue;
                String string2 = pointMass.getName();
                Object[] objectArray4 = new Object[]{pointMass.getFootprint().getIcon(21, 16), pointMass, string2};
                if (pointMass instanceof DynamicParticle) {
                    pointMass2 = (DynamicParticle)pointMass;
                    if (pointMass2.isBoostedBy(particleModel)) continue;
                    if (pointMass2.system != null) {
                        DynamicParticle[] dynamicParticleArray = pointMass2.system.particles;
                        int n = pointMass2.system.particles.length;
                        int n2 = 0;
                        while (n2 < n) {
                            DynamicParticle dynamicParticle2 = dynamicParticleArray[n2];
                            if (dynamicParticle2.isBoostedBy(particleModel)) continue block0;
                            ++n2;
                        }
                    }
                }
                if (dynamicParticle != null) {
                    if (dynamicParticle.system != null && pointMass instanceof DynamicParticle) {
                        pointMass2 = (DynamicParticle)pointMass;
                        if (pointMass2.system == dynamicParticle.system) continue;
                    }
                    if (dynamicParticle.modelBooster != null && (pointMass2 = dynamicParticle.modelBooster.booster) == pointMass) {
                        objectArray3 = objectArray4;
                        bl = true;
                    }
                }
                this.boosterDropdown.addItem(objectArray4);
            }
            this.boosterDropdown.addItem(objectArray);
            this.boosterDropdown.setSelectedItem(objectArray3);
            if (dynamicParticle != null && !bl) {
                dynamicParticle.setBooster(null);
            }
            boolean bl2 = dynamicParticle != null && !(dynamicParticle instanceof DynamicSystem);
            this.boosterLabel.setEnabled(bl2);
            this.boosterDropdown.setEnabled(bl2);
        }
        this.validate();
    }

    protected void setSpinnerStartFrame(Object object) {
        this.startFrameSpinner.setValue(object);
    }

    protected void setSpinnerEndFrame(Object object) {
        this.endFrameSpinner.setValue(object);
    }

    class ModelFrameSpinner
    extends JSpinner {
        Integer prevMax;
        SpinnerNumberModel spinModel;

        ModelFrameSpinner(SpinnerNumberModel spinnerNumberModel) {
            super(spinnerNumberModel);
            this.spinModel = spinnerNumberModel;
            this.prevMax = (Integer)this.spinModel.getMaximum();
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ModelFunctionPanel modelFunctionPanel = (ModelFunctionPanel)ModelBuilder.this.getSelectedPanel();
                    if (modelFunctionPanel == null || modelFunctionPanel.model == null || modelFunctionPanel.model.refreshing) {
                        return;
                    }
                    if (ModelFrameSpinner.this.prevMax != ModelFrameSpinner.this.spinModel.getMaximum()) {
                        ModelFrameSpinner.this.prevMax = (Integer)ModelFrameSpinner.this.spinModel.getMaximum();
                        return;
                    }
                    int n = (Integer)ModelFrameSpinner.this.getValue();
                    if (ModelFrameSpinner.this == ModelBuilder.this.startFrameSpinner) {
                        modelFunctionPanel.model.setStartFrame(n);
                    } else {
                        modelFunctionPanel.model.setEndFrame(n);
                    }
                }
            });
        }

        @Override
        public Dimension getMinimumSize() {
            Dimension dimension = super.getMinimumSize();
            dimension.width += (int)(FontSizer.getFactor() * 4.0);
            return dimension;
        }
    }
}

