/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.DynamicFunctionPanel;
import org.opensourcephysics.cabrillo.tracker.DynamicParticle;
import org.opensourcephysics.cabrillo.tracker.DynamicSystem;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.tools.FunctionEditor;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.UserFunction;
import org.opensourcephysics.tools.UserFunctionEditor;

public class DynamicParticlePolar
extends DynamicParticle {
    @Override
    public double[] getInitialState() {
        double[] dArray = this.getInitialValues();
        double d = Math.cos(dArray[2]);
        double d2 = Math.sin(dArray[2]);
        if (Math.abs(d) < 1.0E-7) {
            d = 0.0;
        }
        if (Math.abs(d2) < 1.0E-7) {
            d2 = 0.0;
        }
        double d3 = dArray[1] * dArray[4];
        this.initialState[0] = dArray[1] * d;
        this.initialState[1] = dArray[3] * d - d3 * d2;
        this.initialState[2] = dArray[1] * d2;
        this.initialState[3] = dArray[3] * d2 + d3 * d;
        this.initialState[4] = dArray[0];
        return this.initialState;
    }

    @Override
    protected double[] getXYForces(double[] dArray) {
        UserFunction[] userFunctionArray = this.getFunctionEditor().getMainFunctions();
        double[] dArray2 = this.getPolarState(dArray);
        double d = userFunctionArray[0].evaluate(dArray2);
        double d2 = userFunctionArray[1].evaluate(dArray2);
        double d3 = Math.cos(dArray2[2]);
        double d4 = Math.sin(dArray2[2]);
        double d5 = d * d3 - d2 * d4;
        double d6 = d * d4 + d2 * d3;
        return new double[]{d5, d6};
    }

    @Override
    protected void initializeFunctionPanel() {
        this.functionEditor = new UserFunctionEditor();
        this.functionPanel = new DynamicFunctionPanel(this.functionEditor, this);
        UserFunction[] userFunctionArray = new UserFunction[2];
        String[] stringArray = new String[]{"r", "vr", FunctionEditor.THETA, FunctionEditor.OMEGA, "t"};
        userFunctionArray[0] = new UserFunction("fr");
        userFunctionArray[0].setNameEditable(false);
        userFunctionArray[0].setExpression("0", stringArray);
        userFunctionArray[0].setDescription(TrackerRes.getString("DynamicParticle.ForceFunction.R.Description"));
        String string = "f" + FunctionEditor.THETA;
        userFunctionArray[1] = new UserFunction(string);
        userFunctionArray[1].setNameEditable(false);
        userFunctionArray[1].setExpression("0", stringArray);
        userFunctionArray[1].setDescription(TrackerRes.getString("DynamicParticle.ForceFunction.Theta.Description"));
        this.functionEditor.setMainFunctions(userFunctionArray);
        this.createMassAndTimeParameters();
    }

    @Override
    protected void initializeInitEditor() {
        Parameter parameter = (Parameter)this.getInitEditor().getObject("t");
        Parameter parameter2 = new Parameter("r", "0.0");
        parameter2.setNameEditable(false);
        parameter2.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialR.Description"));
        Parameter parameter3 = new Parameter(FunctionEditor.THETA, "0.0");
        parameter3.setNameEditable(false);
        parameter3.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialTheta.Description"));
        Parameter parameter4 = new Parameter("vr", "0.0");
        parameter4.setNameEditable(false);
        parameter4.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialVelocityR.Description"));
        Parameter parameter5 = new Parameter(FunctionEditor.OMEGA, "0.0");
        parameter5.setNameEditable(false);
        parameter5.setDescription(TrackerRes.getString("DynamicParticle.Parameter.InitialOmega.Description"));
        this.getInitEditor().setParameters(new Parameter[]{parameter, parameter2, parameter3, parameter4, parameter5});
    }

    protected double[] getPolarState(double[] dArray) {
        double[] dArray2 = new double[5];
        double d = dArray[0];
        double d2 = dArray[2];
        double d3 = dArray[1];
        double d4 = dArray[3];
        double d5 = Math.sqrt(d * d + d2 * d2);
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        double d7 = Math.atan2(d2, d);
        double d8 = Math.atan2(d4, d3);
        double d9 = d8 - d7;
        dArray2[0] = d5;
        dArray2[1] = d5 == 0.0 ? d6 : d6 * Math.cos(d9);
        dArray2[2] = d5 == 0.0 ? d8 : d7;
        dArray2[3] = d5 == 0.0 ? 0.0 : d6 * Math.sin(d9) / d5;
        dArray2[4] = dArray[4];
        return dArray2;
    }

    @Override
    protected void boost() {
        if (this instanceof DynamicSystem) {
            return;
        }
        if (this.modelBooster == null || this.modelBooster.booster == null) {
            return;
        }
        int n = this.getStartFrame();
        double[] dArray = this.getCartesianState(this.modelBooster.booster, n);
        if (dArray == null) {
            return;
        }
        double[] dArray2 = this.getPolarState(dArray);
        Parameter[] parameterArray = this.getInitEditor().getParameters();
        int n2 = 0;
        while (n2 < parameterArray.length) {
            Parameter parameter = parameterArray[n2];
            String string = parameter.getName();
            double d = Double.NaN;
            if (string.equals("r")) {
                d = dArray2[0];
            } else if (string.equals("vr")) {
                d = dArray2[1];
            } else if (string.equals(FunctionEditor.THETA)) {
                d = dArray2[2];
            } else if (string.equals(FunctionEditor.OMEGA)) {
                d = dArray2[3];
            }
            if (!Double.isNaN(d)) {
                Parameter parameter2 = new Parameter(string, String.valueOf(d));
                parameter2.setDescription(parameter.getDescription());
                parameter2.setNameEditable(false);
                parameterArray[n2] = parameter2;
            }
            ++n2;
        }
        this.getInitEditor().setParameters(parameterArray);
        if (this.system != null) {
            this.system.refreshSystemParameters();
            this.system.lastValidFrame = -1;
            this.system.refreshSteps();
        } else {
            this.reset();
        }
        this.repaint();
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            DynamicParticle dynamicParticle = (DynamicParticle)object;
            XML.getLoader(ParticleModel.class).saveObject(xMLControl, object);
            if (dynamicParticle.system != null) {
                xMLControl.setValue("in_system", true);
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new DynamicParticlePolar();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            DynamicParticle dynamicParticle = (DynamicParticle)object;
            XML.getLoader(ParticleModel.class).loadObject(xMLControl, object);
            dynamicParticle.inSystem = xMLControl.getBoolean("in_system");
            return object;
        }
    }
}

