/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Area;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.tools.FontSizer;

public class DoubleArrowFootprint
extends LineFootprint {
    protected int tipLength = 16;
    protected int tipWidth = 4;
    boolean openHead = true;
    protected BasicStroke headStroke = new BasicStroke();

    public DoubleArrowFootprint(String string) {
        super(string);
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        Point[] pointArray = new Point[]{new Point(), new Point((n *= n3) - 2, 2 - (n2 *= n3))};
        Shape shape = this.getShape(pointArray, false);
        ShapeIcon shapeIcon = new ShapeIcon(shape, n, n2);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    public void setTipLength(int n) {
        n = Math.max(8, n);
        this.tipWidth = n / 4;
        this.tipLength = 4 * this.tipWidth;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        super.setStroke(basicStroke);
        this.headStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, null, basicStroke.getDashPhase());
    }

    public void setSolidHead(boolean bl) {
        this.openHead = !bl;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        return this.getShape(pointArray, true);
    }

    private Shape getShape(Point[] pointArray, boolean bl) {
        float f;
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        double d = Math.atan2(point.y - point2.y, point.x - point2.x);
        this.transform.setToRotation(d, point2.x, point2.y);
        this.transform.translate(point2.x, point2.y);
        float f2 = (float)point.distance(point2);
        int n = FontSizer.getIntegerFactor();
        int n2 = this.tipLength * n;
        if (bl) {
            n2 = Math.min(n2, Math.round(f2 / 2.0f - 3.0f));
        }
        n2 = Math.max(8, n2);
        int n3 = Math.max(n2 / 4, 3);
        float f3 = (float)n * this.baseStroke.getLineWidth();
        float f4 = f = f3 < (float)(n2 / 4) ? f3 : Math.max((float)(n2 / 4), 0.8f);
        if (this.stroke == null || this.stroke.getLineWidth() != f) {
            this.stroke = new BasicStroke(f, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
            this.headStroke = new BasicStroke(f, 0, 0, 8.0f, null, this.stroke.getDashPhase());
        }
        this.path.reset();
        this.path.moveTo(f2 - 4.0f, 0.0f);
        this.path.lineTo(f2 - 6.0f, -2.0f);
        this.path.lineTo(f2, 0.0f);
        this.path.lineTo(f2 - 6.0f, 2.0f);
        this.path.closePath();
        this.hitShapes[0] = this.transform.createTransformedShape(this.path);
        this.path.reset();
        this.path.moveTo(4.0f, 0.0f);
        this.path.lineTo(6.0f, -2.0f);
        this.path.lineTo(0.0f, 0.0f);
        this.path.lineTo(6.0f, 2.0f);
        this.path.closePath();
        this.hitShapes[1] = this.transform.createTransformedShape(this.path);
        float f5 = f2 / 2.0f;
        float f6 = f2 - (float)(2 * n2);
        this.path.reset();
        this.path.moveTo(f5 - 0.45f * f6, 0.0f);
        this.path.lineTo(f5 + 0.45f * f6, 0.0f);
        this.hitShapes[2] = this.transform.createTransformedShape(this.path);
        float f7 = (float)((double)this.stroke.getLineWidth() * 1.58) - 1.0f;
        this.path.reset();
        this.path.moveTo((float)n2 + f7 - (float)n3, 0.0f);
        this.path.lineTo(bl ? f2 - (float)n2 + (float)n3 : (f2 -= f7), 0.0f);
        Shape shape = this.transform.createTransformedShape(this.path);
        shape = this.stroke.createStrokedShape(shape);
        Area area = new Area(shape);
        this.path.reset();
        this.path.moveTo(f7 + (float)n2 - (float)n3, 0.0f);
        this.path.lineTo(f7 + (float)n2, n3);
        this.path.lineTo(f7, 0.0f);
        this.path.lineTo(f7 + (float)n2, -n3);
        this.path.closePath();
        Shape shape2 = this.transform.createTransformedShape(this.path);
        if (this.openHead) {
            shape2 = this.headStroke.createStrokedShape(shape2);
        }
        area.add(new Area(shape2));
        if (!this.openHead) {
            area.add(new Area(this.headStroke.createStrokedShape(shape2)));
        }
        if (bl) {
            this.path.reset();
            this.path.moveTo(f2 - (float)n2 + (float)n3, 0.0f);
            this.path.lineTo(f2 - (float)n2, -n3);
            this.path.lineTo(f2, 0.0f);
            this.path.lineTo(f2 - (float)n2, n3);
            this.path.closePath();
            Shape shape3 = this.transform.createTransformedShape(this.path);
            if (this.openHead) {
                shape3 = this.headStroke.createStrokedShape(shape3);
            }
            area.add(new Area(shape3));
            if (!this.openHead) {
                area.add(new Area(this.headStroke.createStrokedShape(shape3)));
            }
        }
        return area;
    }
}

