/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JOptionPane;
import org.opensourcephysics.cabrillo.tracker.ParticleDataTrack;
import org.opensourcephysics.cabrillo.tracker.ParticleModel;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerIO;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataClip;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.DataTrackSupport;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoIO;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.media.core.VideoPlayer;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;

public class DataTrackTool
extends UnicastRemoteObject
implements Tool {
    private static final long serialVersionUID = 1L;
    private TFrame frame;
    private TreeMap<Integer, Tool> replyToTools = new TreeMap();
    private TreeMap<Integer, String> jarPaths = new TreeMap();

    public DataTrackTool(TFrame tFrame) throws RemoteException {
        this.frame = tFrame;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        int n;
        String string;
        boolean bl;
        Data data;
        DataTrack dataTrack;
        Object object;
        Object object2;
        int n2;
        Object object3;
        XMLControlElement xMLControlElement = new XMLControlElement();
        xMLControlElement.readXML(job.getXML());
        if (xMLControlElement.failedToRead()) {
            return;
        }
        int n3 = xMLControlElement.getInt("sourceID");
        if (xMLControlElement.getBoolean("handshake")) {
            this.replyToTools.put(n3, tool);
            this.jarPaths.put(n3, xMLControlElement.getString("jar_path"));
            job.setXML(xMLControlElement.toXML());
            tool.send(job, null);
            return;
        }
        String string2 = xMLControlElement.getString("video");
        File file = null;
        if (string2 != null) {
            file = this.findFile(string2, n3);
        }
        boolean bl2 = false;
        if (xMLControlElement.getPropertyNames().contains("trk")) {
            File[] fileArray;
            object3 = xMLControlElement.getString("trk");
            File file2 = this.findFile((String)object3, n3);
            if (!(file2 != null && file2.exists() || (n2 = JOptionPane.showConfirmDialog(this.frame, String.valueOf(TrackerRes.getString("DataTrackTool.Dialog.FileNotFound.Message1")) + " \"" + (String)object3 + "\"" + "\n" + TrackerRes.getString("DataTrackTool.Dialog.VideoNotFound.Message2"), TrackerRes.getString("DataTrackTool.Dialog.FileNotFound.Title"), 0)) != 0 || (fileArray = TrackerIO.getChooserFiles("open trk")) == null || fileArray.length <= 0)) {
                file2 = fileArray[0];
            }
            if (file2 != null) {
                XMLControlElement xMLControlElement2 = new XMLControlElement(file2.getAbsolutePath());
                fileArray = xMLControlElement2.getObjectClass();
                if (!TrackerPanel.class.equals(fileArray)) {
                    JOptionPane.showMessageDialog(this.frame, String.valueOf(TrackerRes.getString("DataTrackTool.Dialog.InvalidTRK.Message")) + ": \"" + file2.getAbsolutePath() + "\"", TrackerRes.getString("DataTrackTool.Dialog.InvalidTRK.Title"), 2);
                } else {
                    OSPLog.fine("loading TRK file " + file2.getAbsolutePath());
                    XMLControl xMLControl = xMLControlElement2.getChildControl("videoclip");
                    if (xMLControl != null) {
                        xMLControl = xMLControl.getChildControl("video");
                    }
                    if (xMLControl != null) {
                        Object object4;
                        object2 = xMLControl.getString("path");
                        object = null;
                        if (string2 != null && ((File)(object = new File(string2))).exists()) {
                            object4 = ((File)object).getParentFile();
                            while (object4 != null) {
                                String string3 = ((File)object4).getAbsolutePath();
                                String string4 = XML.getResolvedPath((String)object2, string3);
                                if (new File(string4).exists()) {
                                    bl2 = true;
                                    ResourceLoader.addSearchPath(string3);
                                    break;
                                }
                                object4 = ((File)object4).getParentFile();
                            }
                        }
                        if (object == null && (object = this.findFile((String)object2, n3)) != null && (object4 = this.jarPaths.get(n3)) != null) {
                            ResourceLoader.addSearchPath(XML.getDirectoryPath((String)object4));
                        }
                    }
                    object2 = new TrackerPanel();
                    xMLControlElement2.loadObject(object2);
                    ((TrackerPanel)object2).defaultFileName = XML.getName((String)object3);
                    ((TrackerPanel)object2).openedFromPath = file2.getAbsolutePath();
                    ((VideoPanel)object2).setDataFile(file2);
                    this.frame.addTab((TrackerPanel)object2);
                    this.frame.setSelectedTab((TrackerPanel)object2);
                    Tracker.addRecent(file2.getAbsolutePath(), false);
                }
            }
        }
        if ((object3 = this.frame.getTrackerPanel(this.frame.getSelectedTab())) == null) {
            object3 = new TrackerPanel();
            this.frame.addTab((TrackerPanel)object3);
        }
        if (!bl2 && string2 != null) {
            File[] fileArray;
            int n4;
            if (!(file != null && file.exists() || (n4 = JOptionPane.showConfirmDialog((Component)object3, String.valueOf(TrackerRes.getString("DataTrackTool.Dialog.VideoNotFound.Message1")) + " \"" + string2 + "\"" + "\n" + TrackerRes.getString("DataTrackTool.Dialog.VideoNotFound.Message2"), TrackerRes.getString("DataTrackTool.Dialog.VideoNotFound.Title"), 0)) != 0 || (fileArray = VideoIO.getChooserFiles("open video")) == null || fileArray.length <= 0)) {
                file = fileArray[0];
            }
            if (file != null) {
                OSPLog.fine("importing video file " + file.getAbsolutePath());
                TrackerIO.importVideo(file, (TrackerPanel)object3, null);
            }
        }
        if (xMLControlElement.getPropertyNames().contains("videoStartFrame")) {
            int n5 = xMLControlElement.getInt("videoStartFrame");
            OSPLog.fine("setting start frame to " + n5);
            ((VideoPanel)object3).getPlayer().getVideoClip().setStartFrameNumber(n5);
        }
        if (xMLControlElement.getPropertyNames().contains("videoEndFrame")) {
            int n6 = xMLControlElement.getInt("videoEndFrame");
            OSPLog.fine("setting end frame to " + n6);
            ((VideoPanel)object3).getPlayer().getVideoClip().setEndFrameNumber(n6);
        }
        if (xMLControlElement.getPropertyNames().contains("videoStepSize")) {
            int n7 = xMLControlElement.getInt("videoStepSize");
            ((VideoPanel)object3).getPlayer().getVideoClip().setStepSize(n7);
        }
        if (xMLControlElement.getPropertyNames().contains("stepNumber")) {
            int n8 = xMLControlElement.getInt("stepNumber");
            OSPLog.fine("setting step size to " + n8);
            ((VideoPanel)object3).getPlayer().setStepNumber(n8);
        }
        if (xMLControlElement.getPropertyNames().contains("frameNumber")) {
            int n9 = xMLControlElement.getInt("frameNumber");
            n2 = ((VideoPanel)object3).getPlayer().getVideoClip().frameToStep(n9);
            OSPLog.fine("setting step number to " + n2);
            ((VideoPanel)object3).getPlayer().setStepNumber(n2);
        }
        if (xMLControlElement.getPropertyNames().contains("deleteTracks")) {
            String[] stringArray = (String[])xMLControlElement.getObject("deleteTracks");
            object2 = stringArray;
            int n10 = stringArray.length;
            int n11 = 0;
            while (n11 < n10) {
                String string5 = object2[n11];
                object = this.findParticleDataTrack((TrackerPanel)object3, string5, -1);
                if (object != null) {
                    OSPLog.fine("deleting track " + ((TTrack)object).getName());
                    ((ParticleModel)object).delete();
                }
                ++n11;
            }
        }
        if ((dataTrack = this.loadData((TrackerPanel)object3, data = (Data)xMLControlElement.getObject("data"), bl = xMLControlElement.getBoolean("append"))) == null && data != null) {
            dataTrack = ((TrackerPanel)object3).importData(data, (Object)tool);
        }
        if (dataTrack == null && (dataTrack = this.findParticleDataTrack((TrackerPanel)object3, string = xMLControlElement.getString("dataName"), n = xMLControlElement.getInt("dataID"))) != null) {
            try {
                dataTrack.setData(data, tool);
            }
            catch (Exception exception) {}
        }
        if (dataTrack != null && xMLControlElement.getPropertyNames().contains("useDataTime") && dataTrack.getVideoPanel() != null) {
            boolean bl3 = xMLControlElement.getBoolean("useDataTime");
            VideoPlayer videoPlayer = dataTrack.getVideoPanel().getPlayer();
            videoPlayer.getClipControl().setTimeSource(bl3 ? dataTrack : null);
            videoPlayer.refresh();
            if (dataTrack instanceof ParticleDataTrack) {
                ((ParticleDataTrack)dataTrack).refreshInitialTime();
            }
        }
    }

    public boolean reply(int n, Map<String, String> map) {
        Tool tool = this.replyToTools.get(n);
        if (tool == null) {
            return false;
        }
        XMLControl xMLControl = DataTrackSupport.getMessageControl(n);
        for (String string : map.keySet()) {
            xMLControl.setValue(string, map.get(string));
        }
        try {
            tool.send(new LocalJob(xMLControl.toXML()), null);
        }
        catch (RemoteException remoteException) {
            return false;
        }
        return true;
    }

    protected void trackerExiting() {
        XMLControlElement xMLControlElement = new XMLControlElement();
        xMLControlElement.setValue("exiting", true);
        LocalJob localJob = new LocalJob(xMLControlElement.toXML());
        try {
            for (Tool tool : this.replyToTools.values()) {
                tool.send(localJob, this);
            }
        }
        catch (RemoteException remoteException) {}
    }

    private File findFile(String string, int n) {
        String string2;
        String string3;
        File file = null;
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null && (string3 = this.jarPaths.get(n)) != null && (resource = ResourceLoader.getResource(string2 = XML.getResolvedPath(string, XML.getDirectoryPath(string3)))) == null) {
            Object object;
            String string4 = XML.getName(string);
            ZipEntry zipEntry = null;
            try {
                object = new JarFile(string3);
                Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(string4)) continue;
                    zipEntry = jarEntry;
                    break;
                }
                ((ZipFile)object).close();
            }
            catch (Exception exception) {}
            if (zipEntry != null) {
                object = String.valueOf(string3) + "!/" + zipEntry.getName();
                object = ResourceLoader.getURIPath((String)object);
                file = ResourceLoader.extractFileFromZIP((String)object, new File(string2), false);
            }
        }
        if (file == null && resource != null && resource.getFile() != null) {
            file = resource.getFile();
        }
        OSPLog.fine("file found for path \"" + string + "\": " + file);
        return file;
    }

    private ParticleDataTrack findParticleDataTrack(TrackerPanel trackerPanel, String string, int n) {
        if (trackerPanel != null) {
            TTrack tTrack;
            if (string == null || string.trim().equals("")) {
                string = TrackerRes.getString("ParticleDataTrack.New.Name");
            }
            if ((tTrack = trackerPanel.getTrack(string = string.replaceAll("_", " "))) != null && tTrack instanceof ParticleDataTrack) {
                return (ParticleDataTrack)tTrack;
            }
            for (ParticleDataTrack particleDataTrack : trackerPanel.getDrawables(ParticleDataTrack.class)) {
                Data data = particleDataTrack.getData();
                if (data == null || n != data.getID()) continue;
                return particleDataTrack;
            }
        }
        return null;
    }

    private DataTrack loadData(TrackerPanel trackerPanel, Data data, boolean bl) {
        if (data == null || trackerPanel == null) {
            return null;
        }
        ParticleDataTrack particleDataTrack = this.findParticleDataTrack(trackerPanel, data.getName(), data.getID());
        if (particleDataTrack != null) {
            try {
                if (bl) {
                    particleDataTrack.appendData(data);
                    VideoPlayer videoPlayer = trackerPanel.getPlayer();
                    VideoClip videoClip = videoPlayer.getVideoClip();
                    DataClip dataClip = particleDataTrack.getDataClip();
                    dataClip.setClipLength(-1);
                    int n = particleDataTrack.getStartFrame() + dataClip.getDataLength() - 1;
                    videoPlayer.setStepNumber(videoClip.frameToStep(n));
                } else {
                    particleDataTrack.setData(data);
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.frame, TrackerRes.getString("DataTrackTool.Dialog.InvalidData.Message"), TrackerRes.getString("DataTrackTool.Dialog.InvalidData.Title"), 2);
            }
        }
        return particleDataTrack;
    }

    public static boolean isDataSource(String string) {
        try {
            JarFile jarFile = new JarFile(string);
            String string2 = DataTrackSupport.class.getName().replace(".", "/");
            JarEntry jarEntry = jarFile.getJarEntry(String.valueOf(string2) + ".class");
            jarFile.close();
            return jarEntry != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static void launchDataSource(String string, boolean bl) {
        Object object;
        if (!DataTrackTool.isDataSource(string)) {
            String string2 = String.valueOf(TrackerRes.getString("TActions.Action.DataTrack.Unsupported.JarFile")) + " \"" + XML.getName(string) + "\" ";
            JOptionPane.showMessageDialog(null, String.valueOf(string2) + TrackerRes.getString("TActions.Action.DataTrack.Unsupported.Message") + ".", TrackerRes.getString("TActions.Action.DataTrack.Unsupported.Title"), 2);
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("java");
        arrayList.add("-jar");
        arrayList.add(string);
        ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
        if (bl) {
            object = processBuilder.environment();
            object.put("DATA_REQUESTED", "true");
        }
        object = "";
        for (String string3 : arrayList) {
            object = String.valueOf(object) + string3 + " ";
        }
        OSPLog.config((String)object);
        DataTrackTool.startProcess(processBuilder);
    }

    private static void startProcess(final ProcessBuilder processBuilder) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String string;
                    Process process = processBuilder.start();
                    InputStream inputStream = process.getInputStream();
                    InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                    BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                    while ((string = bufferedReader.readLine()) != null) {
                        System.out.println(string);
                    }
                    bufferedReader.close();
                    int n = process.waitFor();
                    if (n > 0) {
                        inputStreamReader = new InputStreamReader(process.getErrorStream());
                        bufferedReader = new BufferedReader(inputStreamReader);
                        while ((string = bufferedReader.readLine()) != null) {
                            System.err.println(string);
                        }
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        new Thread(runnable).start();
    }
}

