/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ModelBuilder;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.DataClip;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DataTrack;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoPanel;

public class DataTrackClipControl
extends JPanel
implements PropertyChangeListener {
    static Color videoColor;
    static Color dataColor;
    static Color dataClipColor;
    static Color unavailableDataColor;
    static Color availableDataColor;
    static int graphicHeight;
    protected DataTrack dataTrack;
    protected DrawingPanel drawingPanel;
    protected JPanel spinnerPanel;
    protected Interactive mappingGraphic;
    protected JLabel videoInLabel;
    protected JLabel dataInLabel;
    protected JLabel dataClipLengthLabel;
    protected JLabel dataStrideLabel;
    protected JSpinner videoInSpinner;
    protected JSpinner dataInSpinner;
    protected JSpinner dataClipLengthSpinner;
    protected JSpinner dataStrideSpinner;
    protected boolean refreshing;
    protected boolean drawVideoClip = false;

    static {
        dataColor = videoColor = Color.WHITE;
        dataClipColor = new Color(51, 200, 51);
        availableDataColor = unavailableDataColor = new Color(51, 200, 51, 127);
        graphicHeight = 100;
    }

    public DataTrackClipControl(DataTrack dataTrack) {
        super(new BorderLayout());
        this.dataTrack = dataTrack;
        this.dataTrack.addPropertyChangeListener(this);
        this.createGUI();
        this.refreshSpinners();
        this.refreshGUI();
    }

    protected void createGUI() {
        this.videoInLabel = new JLabel();
        this.videoInLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataInLabel = new JLabel();
        this.dataInLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataClipLengthLabel = new JLabel();
        this.dataClipLengthLabel.setBorder(BorderFactory.createEmptyBorder());
        this.dataStrideLabel = new JLabel();
        this.dataStrideLabel.setBorder(BorderFactory.createEmptyBorder());
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(0, 0, 20, 1);
        this.videoInSpinner = new MySpinner(spinnerNumberModel);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DataTrackClipControl.this.refreshing) {
                    return;
                }
                int n = (Integer)DataTrackClipControl.this.videoInSpinner.getValue();
                if (n == DataTrackClipControl.this.dataTrack.getStartFrame()) {
                    return;
                }
                DataTrackClipControl.this.dataTrack.setStartFrame(n);
                DataTrackClipControl.this.videoInSpinner.setValue(DataTrackClipControl.this.dataTrack.getStartFrame());
                DataTrackClipControl.this.repaint();
                DataTrackClipControl.this.videoInSpinner.requestFocusInWindow();
            }
        };
        this.videoInSpinner.addChangeListener(changeListener);
        spinnerNumberModel = new SpinnerNumberModel(0, 0, 20, 1);
        this.dataInSpinner = new MySpinner(spinnerNumberModel);
        changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DataTrackClipControl.this.refreshing) {
                    return;
                }
                int n = (Integer)DataTrackClipControl.this.dataInSpinner.getValue();
                if (n == DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex()) {
                    return;
                }
                DataTrackClipControl.this.dataTrack.getDataClip().setStartIndex(n);
                DataTrackClipControl.this.dataInSpinner.setValue(DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex());
                DataTrackClipControl.this.repaint();
                DataTrackClipControl.this.dataInSpinner.requestFocusInWindow();
            }
        };
        this.dataInSpinner.addChangeListener(changeListener);
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 20, 1);
        this.dataClipLengthSpinner = new MySpinner(spinnerNumberModel);
        changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DataTrackClipControl.this.refreshing) {
                    return;
                }
                int n = (Integer)DataTrackClipControl.this.dataClipLengthSpinner.getValue();
                if (n == DataTrackClipControl.this.dataTrack.getDataClip().getClipLength()) {
                    return;
                }
                DataTrackClipControl.this.dataTrack.getDataClip().setClipLength(n);
                DataTrackClipControl.this.dataClipLengthSpinner.setValue(DataTrackClipControl.this.dataTrack.getDataClip().getClipLength());
                DataTrackClipControl.this.repaint();
                DataTrackClipControl.this.dataClipLengthSpinner.requestFocusInWindow();
            }
        };
        this.dataClipLengthSpinner.addChangeListener(changeListener);
        spinnerNumberModel = new SpinnerNumberModel(1, 1, 10, 1);
        this.dataStrideSpinner = new MySpinner(spinnerNumberModel);
        changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (DataTrackClipControl.this.refreshing) {
                    return;
                }
                int n = (Integer)DataTrackClipControl.this.dataStrideSpinner.getValue();
                if (n == DataTrackClipControl.this.dataTrack.getDataClip().getStride()) {
                    return;
                }
                DataTrackClipControl.this.dataTrack.getDataClip().setStride(n);
                DataTrackClipControl.this.dataStrideSpinner.setValue(DataTrackClipControl.this.dataTrack.getDataClip().getStride());
                DataTrackClipControl.this.repaint();
                DataTrackClipControl.this.dataStrideSpinner.requestFocusInWindow();
            }
        };
        this.dataStrideSpinner.addChangeListener(changeListener);
        this.drawingPanel = new GraphicPanel();
        this.drawingPanel.setBorder(BorderFactory.createEtchedBorder());
        this.drawingPanel.addDrawable(new MappingGraphic());
        this.add((Component)this.drawingPanel, "Center");
        this.spinnerPanel = new JPanel(new GridLayout(1, 4));
        this.add((Component)this.spinnerPanel, "South");
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.videoInSpinner);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(this.videoInLabel);
        jPanel.add((Component)jPanel2, "South");
        this.spinnerPanel.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel();
        jPanel2.add(this.dataClipLengthSpinner);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(this.dataClipLengthLabel);
        jPanel.add((Component)jPanel2, "South");
        this.spinnerPanel.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel();
        jPanel2.add(this.dataInSpinner);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(this.dataInLabel);
        jPanel.add((Component)jPanel2, "South");
        this.spinnerPanel.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel2 = new JPanel();
        jPanel2.add(this.dataStrideSpinner);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        jPanel2.add(this.dataStrideLabel);
        jPanel.add((Component)jPanel2, "South");
        this.spinnerPanel.add(jPanel);
    }

    protected void refreshSpinners() {
        VideoPanel videoPanel = this.dataTrack.getVideoPanel();
        if (videoPanel == null) {
            return;
        }
        DataClip dataClip = this.dataTrack.getDataClip();
        VideoClip videoClip = videoPanel.getPlayer().getVideoClip();
        int n = dataClip.getClipLength();
        int n2 = dataClip.getDataLength();
        int n3 = Math.max(0, n2 - 1);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(dataClip.getStartIndex(), 0, n3, 1);
        this.dataInSpinner.setModel(spinnerNumberModel);
        n3 = Math.max(1, n2 - 1);
        n3 = Math.max(n3, dataClip.getStride());
        spinnerNumberModel = new SpinnerNumberModel(dataClip.getStride(), 1, n3, 1);
        this.dataStrideSpinner.setModel(spinnerNumberModel);
        if (videoClip != null) {
            int n4 = videoClip.getFirstFrameNumber();
            int n5 = videoClip.getLastFrameNumber();
            int n6 = this.dataTrack.getStartFrame();
            spinnerNumberModel = new SpinnerNumberModel(n6, n4, n5, 1);
            this.videoInSpinner.setModel(spinnerNumberModel);
        }
        n3 = Math.max(1, n2);
        spinnerNumberModel = new SpinnerNumberModel(n, 1, n3, 1);
        this.dataClipLengthSpinner.setModel(spinnerNumberModel);
        Container container = this.getTopLevelAncestor();
        if (container instanceof ModelBuilder) {
            ModelBuilder modelBuilder = (ModelBuilder)container;
            modelBuilder.refreshSpinners();
        }
    }

    protected void refreshGUI() {
        this.setBorder(BorderFactory.createTitledBorder(TrackerRes.getString("DataTrackClipControl.Border.Title")));
        this.videoInLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.VideoStart"));
        this.dataClipLengthLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.FrameCount"));
        this.dataInLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.DataStart"));
        this.dataStrideLabel.setText(TrackerRes.getString("DataTrackClipControl.Label.Stride"));
    }

    protected void addMouseListenerToAll(MouseListener mouseListener) {
        this.addMouseListener(mouseListener);
        this.drawingPanel.addMouseListener(mouseListener);
        this.spinnerPanel.addMouseListener(mouseListener);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dimension = super.getMaximumSize();
        dimension.height = this.getPreferredSize().height;
        return dimension;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refreshSpinners();
    }

    private int getLastDisplayedClipIndex() {
        int n = this.dataTrack.getDataClip().getClipLength();
        VideoPanel videoPanel = this.dataTrack.getVideoPanel();
        if (videoPanel == null) {
            return n;
        }
        VideoClip videoClip = videoPanel.getPlayer().getVideoClip();
        int n2 = videoClip.getLastFrameNumber();
        int n3 = n - 1;
        while (n3 > 0) {
            int n4 = this.dataTrack.getStartFrame() + n3;
            int n5 = this.dataTrack.getDataClip().stepToIndex(n3);
            if (n4 <= n2 && n5 < this.dataTrack.getDataClip().getDataLength()) {
                return n5;
            }
            --n3;
        }
        return this.dataTrack.getDataClip().stepToIndex(0);
    }

    public void setGraphic(Interactive interactive) {
        if (interactive == null) {
            return;
        }
        if (this.mappingGraphic != null) {
            this.drawingPanel.removeDrawable(this.mappingGraphic);
        }
        this.mappingGraphic = interactive;
        this.drawingPanel.addDrawable(this.mappingGraphic);
    }

    class GraphicPanel
    extends DrawingPanel {
        GraphicPanel() {
            this.removeMouseListener(this.mouseController);
            this.removeMouseMotionListener(this.mouseController);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height = graphicHeight;
            return dimension;
        }
    }

    class MappingGraphic
    implements Interactive {
        GeneralPath path = new GeneralPath();

        MappingGraphic() {
        }

        @Override
        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            int n;
            VideoPanel videoPanel = DataTrackClipControl.this.dataTrack.getVideoPanel();
            if (videoPanel == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            int n2 = 8;
            graphics2D.setStroke(new BasicStroke(n2, 0, 1));
            Rectangle rectangle = new Rectangle(DataTrackClipControl.this.drawingPanel.getSize());
            graphics2D.setColor(new Color(200, 200, 200));
            graphics2D.fill(rectangle);
            int n3 = 30;
            int n4 = 70;
            graphics2D.setColor(Color.DARK_GRAY);
            graphics2D.setFont(DataTrackClipControl.this.videoInLabel.getFont());
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n5 = 10;
            int n6 = 4;
            int n7 = graphics2D.getFontMetrics().getHeight() / 4;
            String string = TrackerRes.getString("DataTrackClipControl.Label.Video");
            int n8 = graphics2D.getFontMetrics().stringWidth(string);
            graphics2D.drawString(string, n5, n3 + n7);
            string = TrackerRes.getString("DataTrackClipControl.Label.Data");
            n8 = Math.max(n8, graphics2D.getFontMetrics().stringWidth(string));
            graphics2D.drawString(string, n5, n4 + n7);
            n8 += 6;
            VideoClip videoClip = videoPanel.getPlayer().getVideoClip();
            DataClip dataClip = DataTrackClipControl.this.dataTrack.getDataClip();
            string = "0";
            int n9 = graphics2D.getFontMetrics().stringWidth(string);
            n9 = Math.max(n9, graphics2D.getFontMetrics().stringWidth(string));
            string = String.valueOf(videoClip.getLastFrameNumber());
            int n10 = graphics2D.getFontMetrics().stringWidth(string);
            string = String.valueOf(dataClip.getDataLength() - 1);
            n10 = Math.max(n10, graphics2D.getFontMetrics().stringWidth(string));
            int n11 = videoClip.getLastFrameNumber() - videoClip.getFirstFrameNumber() + 1;
            if (DataTrackClipControl.this.drawVideoClip) {
                n11 = videoClip.getFrameCount();
            }
            int n12 = dataClip.getDataLength();
            int n13 = Math.max(n11, n12);
            double d = drawingPanel.getWidth() - n8 - n9 - n10 - 3 * n5 - 2 * n6;
            double d2 = d / (double)n13;
            double d3 = d * (double)n11 / (double)n13;
            double d4 = n8 + 2 * n5 + n9;
            double d5 = d4 + d3;
            this.path.reset();
            this.path.moveTo(d4, (double)n3);
            this.path.lineTo(d5, (double)n3);
            graphics2D.setColor(videoColor);
            graphics2D.draw(this.path);
            double d6 = d2 * (double)dataClip.getClipLength();
            int n14 = DataTrackClipControl.this.drawVideoClip ? videoClip.getStartFrameNumber() : videoClip.getFirstFrameNumber();
            double d7 = d4 + d2 * (double)(DataTrackClipControl.this.dataTrack.getStartFrame() - n14);
            double d8 = d7 + d6;
            d7 = Math.max(d7, d4);
            d8 = Math.min(d8, d4 + d3);
            this.path.reset();
            this.path.moveTo(d7, (double)n3);
            this.path.lineTo(d8, (double)n3);
            graphics2D.setColor(unavailableDataColor);
            graphics2D.draw(this.path);
            d7 = d4 + d2 * (double)(DataTrackClipControl.this.dataTrack.getStartFrame() - n14);
            double d9 = d2 * (double)dataClip.getAvailableClipLength();
            d8 = d7 + d9;
            d7 = Math.max(d7, d4);
            d8 = Math.min(d8, d4 + d3);
            d9 = d8 - d7;
            this.path.reset();
            this.path.moveTo(d7, (double)n3);
            this.path.lineTo(d8, (double)n3);
            graphics2D.setColor(dataClipColor);
            graphics2D.draw(this.path);
            d3 = d * (double)n12 / (double)n13;
            double d10 = d4 + d3;
            this.path.reset();
            this.path.moveTo(d4, (double)n4);
            this.path.lineTo(d10, (double)n4);
            graphics2D.setColor(dataColor);
            graphics2D.draw(this.path);
            if (dataClip.getStride() > 1) {
                float f = Math.max(1.0f, (float)d2);
                graphics2D.setStroke(new BasicStroke(n2, 0, 1, 8.0f, new float[]{f, f * (float)(dataClip.getStride() - 1)}, 0.0f));
            }
            double d11 = d4 + d2 * (double)dataClip.getStartIndex();
            double d12 = d11 + d6 * (double)dataClip.getStride();
            d12 = Math.min(d12, d4 + d3);
            this.path.reset();
            this.path.moveTo(d11, (double)n4);
            this.path.lineTo(d12, (double)n4);
            graphics2D.setColor(availableDataColor);
            graphics2D.draw(this.path);
            d12 = d11 + d9 * (double)dataClip.getStride();
            this.path.reset();
            this.path.moveTo(d11, (double)n4);
            this.path.lineTo(d12, (double)n4);
            graphics2D.setColor(dataClipColor);
            graphics2D.draw(this.path);
            d12 -= (double)(dataClip.getStride() - 1) * d2;
            graphics2D.setColor(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f, 0, 1));
            this.path.reset();
            this.path.moveTo(d11, (double)(n4 - n2 / 2));
            this.path.lineTo(d7, (double)(n3 + n2 / 2));
            graphics2D.draw(this.path);
            this.path.reset();
            this.path.moveTo(d12, (double)(n4 - n2 / 2));
            this.path.lineTo(d8, (double)(n3 + n2 / 2));
            graphics2D.draw(this.path);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0));
            int n15 = n7;
            string = "0";
            graphics2D.drawString(string, (int)(d4 - (double)n9 - (double)n6), n4 + n15);
            string = String.valueOf(n12 - 1);
            graphics2D.drawString(string, (int)(d10 + (double)n6), n4 + n15);
            string = String.valueOf(videoClip.getFirstFrameNumber());
            graphics2D.drawString(string, (int)(d4 - (double)n9 - (double)n6), n3 + n15);
            string = String.valueOf(videoClip.getLastFrameNumber());
            graphics2D.drawString(string, (int)(d5 + (double)n6), n3 + n15);
            n15 = -2 - n2 / 2;
            string = String.valueOf(DataTrackClipControl.this.dataTrack.getStartFrame());
            graphics2D.drawString(string, (int)d7, n3 + n15);
            int n16 = DataTrackClipControl.this.dataTrack.getStartFrame() + dataClip.getAvailableClipLength() - 1;
            n16 = Math.min(n16, videoClip.getLastFrameNumber());
            if (DataTrackClipControl.this.dataTrack.getStartFrame() != n16) {
                string = String.valueOf(n16);
                n = graphics2D.getFontMetrics().stringWidth(string);
                graphics2D.drawString(string, (int)(d8 - (double)n), n3 + n15);
            }
            n15 = n7 + n2 + 3;
            string = String.valueOf(DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex());
            graphics2D.drawString(string, (int)d11, n4 + n15);
            n16 = DataTrackClipControl.this.getLastDisplayedClipIndex();
            if (n16 - DataTrackClipControl.this.dataTrack.getDataClip().getStartIndex() > 0) {
                string = String.valueOf(n16);
                n = graphics2D.getFontMetrics().stringWidth(string);
                graphics2D.drawString(string, (int)(d12 - (double)n), n4 + n15);
            }
        }

        public Shape[] getHitShapes() {
            return null;
        }

        public Mark getMark(Point[] pointArray) {
            return new Mark(){

                @Override
                public void draw(Graphics2D graphics2D, boolean bl) {
                }

                @Override
                public Rectangle getBounds(boolean bl) {
                    return null;
                }
            };
        }

        @Override
        public double getXMin() {
            return 0.0;
        }

        @Override
        public double getXMax() {
            return 100.0;
        }

        @Override
        public double getYMin() {
            return 0.0;
        }

        @Override
        public double getYMax() {
            return 100.0;
        }

        @Override
        public boolean isMeasured() {
            return true;
        }

        @Override
        public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
            return null;
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void setXY(double d, double d2) {
        }

        @Override
        public void setX(double d) {
        }

        @Override
        public void setY(double d) {
        }

        @Override
        public double getX() {
            return 0.0;
        }

        @Override
        public double getY() {
            return 0.0;
        }
    }

    class MySpinner
    extends JSpinner {
        public MySpinner(SpinnerModel spinnerModel) {
            super(spinnerModel);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            dimension.height += 6;
            dimension.width += 6;
            return dimension;
        }
    }
}

