/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.cabrillo.tracker.CoordAxesStep;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.PointShapeFootprint;
import org.opensourcephysics.cabrillo.tracker.ReferenceFrame;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TButton;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TTrackBar;
import org.opensourcephysics.cabrillo.tracker.Tracker;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.cabrillo.tracker.WorldGrid;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.media.core.DecimalField;
import org.opensourcephysics.media.core.ImageCoordSystem;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.tools.FontSizer;

public class CoordAxes
extends TTrack {
    protected static Icon gridOptionsIcon = new ImageIcon(Tracker.class.getResource("resources/images/restore.gif"));
    protected boolean notyetShown = true;
    protected JLabel originLabel;
    protected WorldGrid grid;
    protected JCheckBox gridCheckbox;
    protected TButton gridButton;
    protected Component gridSeparator;
    protected boolean gridVisible;

    public CoordAxes() {
        this.defaultColors = new Color[]{new Color(200, 0, 200)};
        this.setName(TrackerRes.getString("CoordAxes.New.Name"));
        this.setFootprints(new Footprint[]{PointShapeFootprint.getFootprint("Footprint.BoldSimpleAxes"), PointShapeFootprint.getFootprint("Footprint.SimpleAxes")});
        this.defaultFootprint = this.getFootprint();
        this.setColor(this.defaultColors[0]);
        this.setViewable(false);
        this.partName = TrackerRes.getString("TTrack.Selected.Hint");
        this.hint = TrackerRes.getString("CoordAxes.Hint");
        CoordAxesStep coordAxesStep = new CoordAxesStep(this, 0);
        coordAxesStep.setFootprint(this.getFootprint());
        this.steps.setStep(0, coordAxesStep);
        this.angleField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CoordAxes.this.trackerPanel == null) {
                    return;
                }
                double d = CoordAxes.this.angleField.getValue();
                int n = CoordAxes.this.trackerPanel.getFrameNumber();
                CoordAxesStep coordAxesStep = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint tPoint = coordAxesStep.getOrigin();
                TPoint tPoint2 = coordAxesStep.getHandle();
                double d2 = tPoint.distance(tPoint2);
                double d3 = tPoint.getX() + d2 * Math.cos(d);
                double d4 = tPoint.getY() - d2 * Math.sin(d);
                tPoint2.setXY(d3, d4);
                CoordAxes.this.angleField.setValue(CoordAxes.this.trackerPanel.getCoords().getAngle(n));
                CoordAxes.this.angleField.requestFocusInWindow();
            }
        });
        this.angleField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (CoordAxes.this.trackerPanel == null) {
                    return;
                }
                double d = CoordAxes.this.angleField.getValue();
                int n = CoordAxes.this.trackerPanel.getFrameNumber();
                CoordAxesStep coordAxesStep = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint tPoint = coordAxesStep.getOrigin();
                TPoint tPoint2 = coordAxesStep.getHandle();
                double d2 = tPoint.distance(tPoint2);
                double d3 = tPoint.getX() + d2 * Math.cos(d);
                double d4 = tPoint.getY() - d2 * Math.sin(d);
                tPoint2.setXY(d3, d4);
                CoordAxes.this.angleField.setValue(CoordAxes.this.trackerPanel.getCoords().getAngle(n));
            }
        });
        this.originLabel = new JLabel();
        final AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CoordAxes.this.trackerPanel == null) {
                    return;
                }
                double d = CoordAxes.this.xField.getValue();
                double d2 = CoordAxes.this.yField.getValue();
                ImageCoordSystem imageCoordSystem = CoordAxes.this.trackerPanel.getCoords();
                int n = CoordAxes.this.trackerPanel.getFrameNumber();
                imageCoordSystem.setOriginXY(n, d, d2);
                CoordAxes.this.xField.setValue(imageCoordSystem.getOriginX(n));
                CoordAxes.this.yField.setValue(imageCoordSystem.getOriginY(n));
                CoordAxesStep coordAxesStep = (CoordAxesStep)CoordAxes.this.getStep(n);
                TPoint tPoint = coordAxesStep.getHandle();
                if (tPoint == CoordAxes.this.trackerPanel.getSelectedPoint()) {
                    CoordAxes.this.trackerPanel.setSelectedPoint(null);
                }
            }
        };
        this.xField = new DecimalField(5, 2);
        this.yField = new DecimalField(5, 2);
        this.xField.addActionListener(abstractAction);
        this.yField.addActionListener(abstractAction);
        this.xField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        this.yField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                abstractAction.actionPerformed(null);
            }
        });
        this.grid = new WorldGrid();
        this.grid.setVisible(this.gridVisible);
        this.gridSeparator = Box.createRigidArea(new Dimension(4, 4));
        this.gridCheckbox = new JCheckBox();
        this.gridCheckbox.setBorder(BorderFactory.createEmptyBorder());
        this.gridCheckbox.setOpaque(false);
        this.gridCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CoordAxes.this.setGridVisible(CoordAxes.this.gridCheckbox.isSelected());
            }
        });
        this.gridButton = new TButton(gridOptionsIcon){

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = TTrackBar.getTrackbar((TrackerPanel)CoordAxes.this.trackerPanel).toolbarComponentHeight;
                return dimension;
            }

            @Override
            protected JPopupMenu getPopup() {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(TrackerRes.getString("CoordAxes.MenuItem.GridColor"));
                jMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!(this).CoordAxes.this.grid.isVisible()) {
                            (this).CoordAxes.this.gridCheckbox.doClick(0);
                        }
                        Color color = (this).CoordAxes.this.grid.getColor();
                        Color color2 = CoordAxes.this.chooseColor(color, TrackerRes.getString("CoordAxes.Dialog.GridColor.Title"));
                        if (color2 != color) {
                            (this).CoordAxes.this.grid.setColor(color2);
                            for (TrackerPanel trackerPanel : (this).CoordAxes.this.panels) {
                                trackerPanel.repaint();
                            }
                        }
                    }
                });
                jPopupMenu.add(jMenuItem);
                JMenuItem jMenuItem2 = new JMenuItem(TrackerRes.getString("CoordAxes.MenuItem.GridOpacity"));
                jMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (!(this).CoordAxes.this.grid.isVisible()) {
                            (this).CoordAxes.this.gridCheckbox.doClick(0);
                        }
                        int n = (this).CoordAxes.this.grid.getAlpha();
                        final JSlider jSlider = new JSlider(0, 255, n);
                        jSlider.setMaximum(255);
                        jSlider.setMinimum(0);
                        jSlider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
                        jSlider.addChangeListener(new ChangeListener(){

                            @Override
                            public void stateChanged(ChangeEvent changeEvent) {
                                ((this).this).CoordAxes.this.grid.setAlpha(jSlider.getValue());
                                for (TrackerPanel trackerPanel : ((this).this).CoordAxes.this.panels) {
                                    trackerPanel.repaint();
                                }
                            }
                        });
                        int n2 = JOptionPane.showConfirmDialog((this).CoordAxes.this.trackerPanel, jSlider, TrackerRes.getString("CoordAxes.Dialog.GridOpacity.Title"), 2, -1);
                        if (n2 == 2) {
                            (this).CoordAxes.this.grid.setAlpha(n);
                            for (TrackerPanel trackerPanel : (this).CoordAxes.this.panels) {
                                trackerPanel.repaint();
                            }
                        }
                    }
                });
                jPopupMenu.add(jMenuItem2);
                FontSizer.setFonts(jPopupMenu, FontSizer.getLevel());
                return jPopupMenu;
            }
        };
    }

    public TPoint getOrigin() {
        return ((CoordAxesStep)this.getStep(0)).getOrigin();
    }

    @Override
    public boolean isLocked() {
        boolean bl = super.isLocked();
        if (this.trackerPanel != null) {
            bl = bl || this.trackerPanel.getCoords().isLocked();
        }
        return bl;
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.notyetShown = false;
            if (this.grid != null) {
                this.grid.setVisible(this.gridVisible);
            }
        } else if (this.grid != null) {
            this.grid.setVisible(false);
        }
    }

    public void setGridVisible(boolean bl) {
        if (this.gridVisible == bl) {
            return;
        }
        this.gridVisible = bl;
        this.grid.setVisible(this.gridVisible);
        this.gridCheckbox.setSelected(this.gridVisible);
        for (TrackerPanel trackerPanel : this.panels) {
            trackerPanel.repaint();
        }
    }

    @Override
    public void setTrailVisible(boolean bl) {
    }

    @Override
    public Step createStep(int n, double d, double d2) {
        Step step = this.getStep(0);
        if (this.trackerPanel.getSelectedPoint() instanceof CoordAxesStep.Handle) {
            ((CoordAxesStep)step).getHandle().setXY(d, d2);
        } else {
            ((CoordAxesStep)step).getOrigin().setXY(d, d2);
        }
        return step;
    }

    @Override
    public Step deleteStep(int n) {
        return null;
    }

    @Override
    public Step getStep(int n) {
        Step step = this.steps.getStep(0);
        step.erase();
        return step;
    }

    @Override
    public int getStepLength() {
        return CoordAxesStep.getLength();
    }

    @Override
    protected boolean isAutoTrackable() {
        return true;
    }

    @Override
    protected boolean isAutoTrackable(int n) {
        return true;
    }

    @Override
    protected String getTargetDescription(int n) {
        if (n == 0) {
            return TrackerRes.getString("CoordAxes.Origin.Name");
        }
        return TrackerRes.getString("CoordAxes.Handle.Name");
    }

    @Override
    protected void setTrackerPanel(TrackerPanel trackerPanel) {
        super.setTrackerPanel(trackerPanel);
        this.trackerPanel.addDrawable(this.grid);
    }

    @Override
    public TPoint autoMarkAt(int n, double d, double d2) {
        ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
        if (this.getTargetIndex() == 0) {
            if (imageCoordSystem.isFixedOrigin()) {
                imageCoordSystem.setFixedOrigin(false);
            }
            TPoint tPoint = this.getOrigin();
            tPoint.setXY(d, d2);
        } else {
            if (imageCoordSystem.isFixedAngle()) {
                imageCoordSystem.setFixedAngle(false);
            }
            TPoint tPoint = ((CoordAxesStep)this.getStep(0)).getHandle();
            tPoint.setXY(d, d2);
        }
        this.firePropertyChange("step", null, n);
        return this.getMarkedPoint(n, this.getTargetIndex());
    }

    @Override
    public TPoint getMarkedPoint(int n, int n2) {
        if (n2 == 0) {
            return new OriginPoint(n);
        }
        TPoint tPoint = ((CoordAxesStep)this.getStep(0)).getHandle();
        return new AnglePoint(tPoint.getX(), tPoint.getY(), n);
    }

    @Override
    public int getFootprintLength() {
        return 1;
    }

    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!(drawingPanel instanceof TrackerPanel && this.isVisible() && this.isEnabled())) {
            return null;
        }
        ImageCoordSystem imageCoordSystem = ((TrackerPanel)drawingPanel).getCoords();
        if (imageCoordSystem instanceof ReferenceFrame) {
            return null;
        }
        Interactive interactive = this.getStep(0).findInteractive(this.trackerPanel, n, n2);
        if (interactive == null) {
            this.partName = TrackerRes.getString("TTrack.Selected.Hint");
            this.hint = TrackerRes.getString("CoordAxes.Hint");
            return null;
        }
        if (interactive instanceof CoordAxesStep.Handle) {
            this.partName = TrackerRes.getString("CoordAxes.Handle.Name");
            this.hint = TrackerRes.getString("CoordAxes.Handle.Hint");
        } else {
            this.partName = TrackerRes.getString("CoordAxes.Origin.Name");
            this.hint = TrackerRes.getString("CoordAxes.Origin.Hint");
        }
        return interactive;
    }

    @Override
    public JMenu getMenu(TrackerPanel trackerPanel) {
        JMenu jMenu = super.getMenu(trackerPanel);
        jMenu.remove(this.deleteTrackItem);
        if (jMenu.getItemCount() > 0) {
            jMenu.remove(jMenu.getItemCount() - 1);
        }
        this.lockedItem.setEnabled(!trackerPanel.getCoords().isLocked());
        return jMenu;
    }

    @Override
    public ArrayList<Component> getToolbarTrackComponents(TrackerPanel trackerPanel) {
        ArrayList<Component> arrayList = super.getToolbarTrackComponents(trackerPanel);
        int n = trackerPanel.getFrameNumber();
        ImageCoordSystem imageCoordSystem = trackerPanel.getCoords();
        this.originLabel.setText(TrackerRes.getString("CoordAxes.Origin.Label"));
        this.xField.setToolTipText(TrackerRes.getString("CoordAxes.Origin.Field.Tooltip"));
        this.yField.setToolTipText(TrackerRes.getString("CoordAxes.Origin.Field.Tooltip"));
        this.gridCheckbox.setText(TrackerRes.getString("CoordAxes.Checkbox.Grid"));
        this.gridCheckbox.setToolTipText(TrackerRes.getString("CoordAxes.Checkbox.Grid.Tooltip"));
        this.gridButton.setToolTipText(TrackerRes.getString("CoordAxes.Button.Grid.Tooltip"));
        arrayList.add(this.gridSeparator);
        arrayList.add(this.gridCheckbox);
        arrayList.add(this.gridButton);
        arrayList.add(this.magSeparator);
        arrayList.add(this.originLabel);
        arrayList.add(this.xSeparator);
        arrayList.add(this.xLabel);
        arrayList.add(this.xField);
        arrayList.add(this.ySeparator);
        arrayList.add(this.yLabel);
        arrayList.add(this.yField);
        this.xField.setValue(imageCoordSystem.getOriginX(n));
        this.yField.setValue(imageCoordSystem.getOriginY(n));
        this.angleLabel.setText(TrackerRes.getString("CoordAxes.Label.Angle"));
        arrayList.add(this.stepSeparator);
        arrayList.add(this.angleLabel);
        arrayList.add(this.angleField);
        this.angleField.setValue(imageCoordSystem.getAngle(n));
        this.xField.setEnabled(!this.isLocked());
        this.yField.setEnabled(!this.isLocked());
        this.angleField.setEnabled(!this.isLocked());
        return arrayList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            int n = this.trackerPanel.getFrameNumber();
            ImageCoordSystem imageCoordSystem = this.trackerPanel.getCoords();
            this.angleField.setValue(imageCoordSystem.getAngle(n));
            this.xField.setValue(imageCoordSystem.getOriginX(n));
            this.yField.setValue(imageCoordSystem.getOriginY(n));
        } else {
            super.propertyChange(propertyChangeEvent);
        }
    }

    @Override
    public void setFontLevel(int n) {
        super.setFontLevel(n);
        Object[] objectArray = new Object[]{this.originLabel, this.gridCheckbox};
        FontSizer.setFonts(objectArray, n);
    }

    @Override
    public String toString() {
        return "Coordinate Axes";
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected class AnglePoint
    extends TPoint {
        int frameNum;

        public AnglePoint(double d, double d2, int n) {
            super(d, d2);
            this.frameNum = n;
        }

        public double getAngle() {
            TPoint tPoint = CoordAxes.this.getOrigin();
            return -tPoint.angle(this);
        }
    }

    static class Loader
    implements XML.ObjectLoader {
        Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            XML.getLoader(TTrack.class).saveObject(xMLControl, object);
            CoordAxes coordAxes = (CoordAxes)object;
            if (coordAxes.gridVisible) {
                xMLControl.setValue("grid_visible", true);
            }
            if (coordAxes.grid.isCustom()) {
                xMLControl.setValue("grid_alpha", coordAxes.grid.getAlpha());
                xMLControl.setValue("grid_RGB", coordAxes.grid.getColor().getRGB());
            }
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new CoordAxes();
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            XML.getLoader(TTrack.class).loadObject(xMLControl, object);
            CoordAxes coordAxes = (CoordAxes)object;
            coordAxes.notyetShown = false;
            if (xMLControl.getPropertyNames().contains("grid_visible")) {
                coordAxes.setGridVisible(xMLControl.getBoolean("grid_visible"));
            }
            if (xMLControl.getPropertyNames().contains("grid_alpha")) {
                coordAxes.grid.setAlpha(xMLControl.getInt("grid_alpha"));
            }
            if (xMLControl.getPropertyNames().contains("grid_RGB")) {
                Color color = new Color(xMLControl.getInt("grid_RGB"));
                coordAxes.grid.setColor(color);
            }
            return object;
        }
    }

    protected class OriginPoint
    extends TPoint {
        int frameNum;

        OriginPoint(int n) {
            this.frameNum = n;
        }

        @Override
        public double getX() {
            ImageCoordSystem imageCoordSystem = CoordAxes.this.trackerPanel.getCoords();
            return imageCoordSystem.getOriginX(this.frameNum);
        }

        @Override
        public double getY() {
            ImageCoordSystem imageCoordSystem = CoordAxes.this.trackerPanel.getCoords();
            return imageCoordSystem.getOriginY(this.frameNum);
        }
    }
}

