/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.Footprint;
import org.opensourcephysics.cabrillo.tracker.Mark;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.tools.FontSizer;

public class CircleFitterFootprint
implements Footprint,
Cloneable {
    private static BasicStroke hitStroke = new BasicStroke(4.0f);
    private static final CircleFitterFootprint CIRCLE_4;
    private static final CircleFitterFootprint CIRCLE_7;
    private static final CircleFitterFootprint CIRCLE_4_BOLD;
    private static final CircleFitterFootprint CIRCLE_7_BOLD;
    protected static final int MAX_RADIUS = 100000;
    private static Collection<CircleFitterFootprint> footprints;
    private static Shape hitShape;
    private static Shape emptyHitShape;
    private static Line2D line;
    private static AffineTransform transform;
    private static Arc2D.Float iconArc;
    protected String name;
    protected BasicStroke baseStroke;
    protected BasicStroke stroke;
    protected Color color = Color.black;
    protected ArrayList<Shape> hitShapes = new ArrayList();
    protected Ellipse2D circle;
    protected double radius;
    protected Shape marker;
    protected Shape crosshatch;
    protected int markerSize;
    protected Point selectedPoint;
    protected boolean drawRadius;

    static {
        footprints = new HashSet<CircleFitterFootprint>();
        hitShape = new Ellipse2D.Double(-6.0, -6.0, 12.0, 12.0);
        emptyHitShape = new Rectangle();
        line = new Line2D.Double();
        transform = new AffineTransform();
        iconArc = new Arc2D.Float();
        BasicStroke basicStroke = new BasicStroke(1.0f);
        CIRCLE_4 = new CircleFitterFootprint("CircleFitterFootprint.Circle4", 4);
        CIRCLE_4.setStroke(basicStroke);
        footprints.add(CIRCLE_4);
        CIRCLE_7 = new CircleFitterFootprint("CircleFitterFootprint.Circle7", 7);
        CIRCLE_7.setStroke(basicStroke);
        footprints.add(CIRCLE_7);
        basicStroke = new BasicStroke(2.0f);
        CIRCLE_4_BOLD = new CircleFitterFootprint("CircleFitterFootprint.Circle4Bold", 4);
        CIRCLE_4_BOLD.setStroke(basicStroke);
        footprints.add(CIRCLE_4_BOLD);
        CIRCLE_7_BOLD = new CircleFitterFootprint("CircleFitterFootprint.Circle7Bold", 7);
        CIRCLE_7_BOLD.setStroke(basicStroke);
        footprints.add(CIRCLE_7_BOLD);
    }

    public CircleFitterFootprint(String string, int n) {
        this.name = string;
        this.markerSize = n;
        this.circle = new Ellipse2D.Double();
        this.marker = new Ellipse2D.Double(-n, -n, 2 * n, 2 * n);
        double d = (double)n * 0.707;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(-d, -d);
        generalPath.lineTo(d, d);
        generalPath.moveTo(-d, d);
        generalPath.lineTo(d, -d);
        this.crosshatch = generalPath;
        this.setStroke(new BasicStroke());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        return TrackerRes.getString(this.name);
    }

    @Override
    public int getLength() {
        return 3;
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        n *= n3;
        n2 *= n3;
        int n4 = this.markerSize / 2;
        iconArc.setArc(0.0, 0.0, n3 * 20, n3 * 20, 200.0, 140.0, 0);
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n3 * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n3 * this.baseStroke.getLineWidth());
        }
        Shape shape = this.stroke.createStrokedShape(iconArc);
        Area area = new Area(shape);
        this.circle.setFrameFromCenter(n3 * 10, n3 * 20, n3 * (10 + n4), n3 * (20 + n4));
        shape = this.stroke.createStrokedShape(this.circle);
        area.add(new Area(shape));
        ShapeIcon shapeIcon = new ShapeIcon(area, n, n2);
        shapeIcon.setColor(this.color);
        return shapeIcon;
    }

    @Override
    public Mark getMark(Point[] pointArray) {
        final Shape shape = this.getShape(pointArray);
        final Color color = this.color;
        return new Mark(){

            @Override
            public void draw(Graphics2D graphics2D, boolean bl) {
                Color color2 = graphics2D.getColor();
                graphics2D.setColor(color);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.fill(shape);
                graphics2D.setColor(color2);
            }

            @Override
            public Rectangle getBounds(boolean bl) {
                return shape.getBounds();
            }
        };
    }

    @Override
    public Shape[] getHitShapes() {
        return this.hitShapes.toArray(new Shape[this.hitShapes.size()]);
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        this.baseStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, basicStroke.getDashArray(), basicStroke.getDashPhase());
    }

    @Override
    public BasicStroke getStroke() {
        return this.baseStroke;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    protected void setDrawRadialLine(boolean bl) {
        this.drawRadius = bl;
    }

    protected void setPixelRadius(double d) {
        this.radius = d;
    }

    protected void setSelectedPoint(Point point) {
        this.selectedPoint = point;
    }

    @Override
    public Shape getShape(Point[] pointArray) {
        Object object;
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        this.hitShapes.clear();
        Area area = new Area();
        int n = FontSizer.getIntegerFactor();
        if (this.stroke == null || this.stroke.getLineWidth() != (float)n * this.baseStroke.getLineWidth()) {
            this.stroke = new BasicStroke((float)n * this.baseStroke.getLineWidth());
        }
        if (pointArray.length < 6) {
            this.hitShapes.add(emptyHitShape);
        } else if (Double.isInfinite(this.radius) || this.radius > 100000.0) {
            double d = point2.getX();
            double d2 = point2.getY();
            double d3 = pointArray[4].getX() - pointArray[3].getX();
            double d4 = pointArray[4].getY() - pointArray[3].getY();
            double d5 = d4 / d3;
            double d6 = 10000.0;
            if (d3 == 0.0) {
                line.setLine(d, d2 - d6, d, d2 + d6);
            } else if (Math.abs(d3) > Math.abs(d4)) {
                line.setLine(d - d6, d2 - d5 * d6, d + d6, d2 + d5 * d6);
            } else {
                line.setLine(d - d6 / d5, d2 - d6, d + d6 / d5, d2 + d6);
            }
            area.add(new Area(this.stroke.createStrokedShape(line)));
            this.hitShapes.add(hitStroke.createStrokedShape(line));
            if (this.drawRadius) {
                Point point3 = pointArray[2];
                transform.setToRotation(1.5707963267948966, point3.x, point3.y);
                area.add(new Area(this.stroke.createStrokedShape(transform.createTransformedShape(line))));
            }
        } else {
            this.circle.setFrameFromCenter(point.x, point.y, (double)point.x + this.radius, (double)point.y + this.radius);
            area.add(new Area(this.stroke.createStrokedShape(this.circle)));
            transform.setToTranslation(pointArray[0].x, pointArray[0].y);
            if (n > 1) {
                transform.scale(n, n);
            }
            Shape shape = transform.createTransformedShape(this.marker);
            area.add(new Area(this.stroke.createStrokedShape(shape)));
            shape = transform.createTransformedShape(this.crosshatch);
            area.add(new Area(this.stroke.createStrokedShape(shape)));
            object = pointArray[2];
            int n2 = ((Point)object).x - point.x;
            int n3 = ((Point)object).y - point.y;
            line.setLine(point.x + n2 / 4, point.y + n3 / 4, ((Point)object).x, ((Point)object).y);
            this.hitShapes.add(hitStroke.createStrokedShape(line));
            if (this.drawRadius) {
                line.setLine(point, (Point2D)object);
                area.add(new Area(this.stroke.createStrokedShape(line)));
            }
        }
        int n4 = 3;
        while (n4 < pointArray.length) {
            transform.setToTranslation(pointArray[n4].x, pointArray[n4].y);
            if (n > 1) {
                transform.scale(n, n);
            }
            if (pointArray[n4] != this.selectedPoint) {
                object = transform.createTransformedShape(this.marker);
                area.add(new Area(this.stroke.createStrokedShape((Shape)object)));
            }
            this.hitShapes.add(transform.createTransformedShape(hitShape));
            ++n4;
        }
        return area;
    }

    public static Footprint getFootprint(String string) {
        for (CircleFitterFootprint circleFitterFootprint : footprints) {
            if (string != circleFitterFootprint.getName()) continue;
            try {
                return (CircleFitterFootprint)circleFitterFootprint.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                cloneNotSupportedException.printStackTrace();
            }
        }
        return null;
    }
}

