/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import org.opensourcephysics.cabrillo.tracker.BounceMatrix;
import org.opensourcephysics.cabrillo.tracker.BounceParameters;

public class BounceModel {
    private final BounceMatrix model;
    private final BounceMatrix inverse_model;
    private final double step_at;
    private final boolean use_step;
    private final boolean use_unknown_step;
    private final int degree;
    private final int num_params;

    public BounceModel(int n, int n2, double d) {
        this.degree = n2;
        this.use_unknown_step = Double.isNaN(d);
        if (this.use_unknown_step) {
            this.use_step = false;
            this.step_at = (n + 1) / 2;
        } else {
            this.use_step = d > 0.0 && d < (double)(n - 1);
            double d2 = this.step_at = this.use_step ? d : 0.0;
        }
        this.num_params = this.degree + 1 + (this.use_unknown_step ? 2 : (this.use_step ? 1 : 0));
        double[][] dArray = new double[n][this.num_params];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 1;
            int n5 = 0;
            while (n5 <= this.degree) {
                dArray[n3][n5] = n4;
                n4 *= n3;
                ++n5;
            }
            if (this.usesStep()) {
                double d3 = dArray[n3][this.degree + 1] = (double)n3 >= this.step_at ? (double)n3 - this.step_at : 0.0;
            }
            if (this.use_unknown_step) {
                dArray[n3][this.degree + 2] = (double)n3 >= this.step_at ? 1 : 0;
            }
            ++n3;
        }
        this.model = new BounceMatrix(dArray);
        this.inverse_model = this.model.inverse();
    }

    public double getStepAt() {
        if (this.use_unknown_step) {
            return Double.NaN;
        }
        return this.step_at;
    }

    public double getStepAt(BounceMatrix bounceMatrix) {
        if (!this.use_unknown_step) {
            return this.step_at;
        }
        double[][] dArray = bounceMatrix.getArray();
        int n = bounceMatrix.getColumnDimension();
        double d = 0.0;
        double d2 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d3 = dArray[this.degree + 1][n2];
            double d4 = dArray[this.degree + 2][n2];
            if (d3 != 0.0) {
                d += d3 * d4;
                d2 += d3 * d3;
            }
            ++n2;
        }
        if (d2 > 0.0) {
            d /= d2;
        }
        return this.step_at - d;
    }

    public BounceParameters fit_xy(double[] dArray, double[] dArray2, int n, int n2) {
        int n3 = this.model.getRowDimension();
        int n4 = n + (n3 - 1) * n2;
        if (n < 0 || n4 >= dArray.length || n4 >= dArray2.length) {
            return null;
        }
        BounceMatrix bounceMatrix = new BounceMatrix(n3, 2);
        double[][] dArray3 = bounceMatrix.getArray();
        int n5 = 0;
        while (n5 < n3) {
            dArray3[n5][0] = dArray[n + n2 * n5];
            dArray3[n5][1] = dArray2[n + n2 * n5];
            if (Double.isNaN(dArray3[n5][0]) || Double.isNaN(dArray3[n5][1])) {
                return null;
            }
            ++n5;
        }
        BounceMatrix bounceMatrix2 = this.inverse_model.times(bounceMatrix);
        double[][] dArray4 = this.model.times(bounceMatrix2).minus(bounceMatrix).getArray();
        double d = 0.0;
        int n6 = 0;
        while (n6 < n3) {
            d += dArray4[n6][0] * dArray4[n6][0];
            d += dArray4[n6][1] * dArray4[n6][1];
            ++n6;
        }
        if (!this.use_unknown_step) {
            return new BounceParameters(this, bounceMatrix2, d);
        }
        BounceParameters bounceParameters = null;
        double[][] dArray5 = bounceMatrix2.getArray();
        double d2 = 0.0;
        double d3 = 0.0;
        int n7 = 0;
        while (n7 < 2) {
            double d4 = dArray5[this.degree + 1][n7];
            double d5 = dArray5[this.degree + 2][n7];
            if (d4 != 0.0) {
                double d6 = this.step_at - d5 / d4;
                if (d6 < 0.0) {
                    d6 = 0.001;
                } else if (d6 >= (double)(n3 - 1)) {
                    d6 = (double)n3 - 1.001;
                }
                BounceModel bounceModel = new BounceModel(n3, this.degree, d6);
                BounceParameters bounceParameters2 = bounceModel.fit_xy(dArray, dArray2, n, n2);
                if (bounceParameters == null || bounceParameters.getError() > bounceParameters2.getError()) {
                    bounceParameters = bounceParameters2;
                }
                d2 += d4 * d4 * d6;
                d3 += d4 * d4;
            }
            ++n7;
        }
        if (d3 > 0.0) {
            d2 /= d3;
        }
        BounceModel bounceModel = new BounceModel(n3, this.degree, d2);
        BounceParameters bounceParameters3 = bounceModel.fit_xy(dArray, dArray2, n, n2);
        if (bounceParameters == null || bounceParameters.getError() > bounceParameters3.getError()) {
            bounceParameters = bounceParameters3;
        }
        return bounceParameters;
    }

    public BounceParameters fit_xy(double[] dArray, double[] dArray2, int n, int n2, double d, double[] dArray3) {
        if (this.use_unknown_step || this.use_step && this.step_at != d) {
            throw new RuntimeException("Can't fit with an initial step if the model already tries to fit a step");
        }
        int n3 = this.model.getRowDimension();
        int n4 = n + (n3 - 1) * n2;
        if (n < 0 || n4 >= dArray.length || n4 >= dArray2.length) {
            return null;
        }
        BounceMatrix bounceMatrix = new BounceMatrix(n3, 2);
        double[][] dArray4 = bounceMatrix.getArray();
        int n5 = 0;
        while (n5 < n3) {
            dArray4[n5][0] = dArray[n + n2 * n5] - ((double)n5 > d ? dArray3[0] * ((double)n5 - d) : 0.0);
            dArray4[n5][1] = dArray2[n + n2 * n5] - ((double)n5 > d ? dArray3[1] * ((double)n5 - d) : 0.0);
            if (Double.isNaN(dArray4[n5][0]) || Double.isNaN(dArray4[n5][1])) {
                return null;
            }
            ++n5;
        }
        BounceMatrix bounceMatrix2 = this.inverse_model.times(bounceMatrix);
        double[][] dArray5 = this.model.times(bounceMatrix2).minus(bounceMatrix).getArray();
        double d2 = 0.0;
        int n6 = 0;
        while (n6 < n3) {
            d2 += dArray5[n6][0] * dArray5[n6][0];
            d2 += dArray5[n6][1] * dArray5[n6][1];
            ++n6;
        }
        return new BounceParameters(this, bounceMatrix2, d2, d, dArray3);
    }

    public double[] first_deriv(BounceMatrix bounceMatrix, double d) {
        int n = bounceMatrix.getColumnDimension();
        double[] dArray = new double[n];
        double[][] dArray2 = bounceMatrix.getArray();
        double d2 = 1.0;
        int n2 = 1;
        while (n2 <= this.degree) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + d2 * (double)n2 * dArray2[n2][n3];
                ++n3;
            }
            d2 *= d;
            ++n2;
        }
        double d3 = this.getStepAt(bounceMatrix);
        if (this.usesStep() && d >= d3) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5;
                dArray[n6] = dArray[n6] + dArray2[this.degree + 1][n5];
                ++n5;
            }
        }
        return dArray;
    }

    public double[] second_deriv(BounceMatrix bounceMatrix, double d) {
        int n = bounceMatrix.getColumnDimension();
        double[] dArray = new double[n];
        double[][] dArray2 = bounceMatrix.getArray();
        double d2 = 1.0;
        int n2 = 2;
        while (n2 <= this.degree) {
            int n3 = 0;
            while (n3 < n) {
                int n4 = n3;
                dArray[n4] = dArray[n4] + d2 * (double)n2 * (double)(n2 - 1) * dArray2[n2][n3];
                ++n3;
            }
            d2 *= d;
            ++n2;
        }
        double d3 = this.getStepAt(bounceMatrix);
        if (this.usesStep() && d3 - 0.5 < d && d <= d3 + 0.5) {
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5;
                dArray[n6] = dArray[n6] + dArray2[this.degree + 1][n5];
                ++n5;
            }
        }
        return dArray;
    }

    public boolean usesStep() {
        return this.use_step || this.use_unknown_step;
    }

    public double[] getStepSize(BounceMatrix bounceMatrix) {
        int n = bounceMatrix.getColumnDimension();
        double[] dArray = new double[n];
        if (!this.usesStep()) {
            return dArray;
        }
        double[][] dArray2 = bounceMatrix.getArray();
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = dArray2[this.degree + 1][n2];
            ++n2;
        }
        return dArray;
    }
}

