/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.opensourcephysics.cabrillo.tracker.PointMass;
import org.opensourcephysics.cabrillo.tracker.Protractor;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.cabrillo.tracker.Step;
import org.opensourcephysics.cabrillo.tracker.TFrame;
import org.opensourcephysics.cabrillo.tracker.TTrack;
import org.opensourcephysics.cabrillo.tracker.TapeMeasure;
import org.opensourcephysics.cabrillo.tracker.TrackerPanel;
import org.opensourcephysics.cabrillo.tracker.TrackerRes;
import org.opensourcephysics.display.ResizableIcon;
import org.opensourcephysics.media.core.TPoint;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.tools.FontSizer;

public class AttachmentDialog
extends JDialog
implements PropertyChangeListener {
    protected TTrack measuringTool;
    protected int endPointCount;
    protected TTrack[] attachedMass;
    protected String[] endPointName;
    protected TrackerPanel trackerPanel;
    protected boolean isVisible;
    protected JButton closeButton;
    protected JButton helpButton;
    protected ArrayList<? extends TTrack> masses;
    protected PointMass dummyMass;
    protected JTable table;
    protected int cellheight = 28;
    protected JComboBox rendererDropdown;
    protected JComboBox editorDropdown;
    protected JComboBox measuringToolDropdown;
    protected Icon dummyIcon = new ShapeIcon(null, 21, 16);
    protected JScrollPane scrollPane;
    protected AttachmentCellRenderer attachmentCellRenderer = new AttachmentCellRenderer();
    protected TTrackRenderer trackRenderer = new TTrackRenderer();

    public AttachmentDialog(TTrack tTrack) {
        super(JOptionPane.getFrameForComponent(tTrack.trackerPanel), false);
        this.createGUI();
        this.setMeasuringTool(tTrack);
        this.refreshDropdowns();
        this.trackerPanel.addPropertyChangeListener("track", this);
        TFrame tFrame = this.trackerPanel.getTFrame();
        tFrame.addPropertyChangeListener("tab", this);
        this.refreshDisplay();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("tab")) {
            if (this.trackerPanel != null && propertyChangeEvent.getNewValue() == this.trackerPanel) {
                this.setVisible(this.isVisible);
            } else {
                boolean bl = this.isVisible;
                this.setVisible(false);
                this.isVisible = bl;
            }
        } else if (propertyChangeEvent.getPropertyName().equals("track")) {
            TTrack tTrack = (TTrack)propertyChangeEvent.getOldValue();
            if (tTrack != null) {
                tTrack.removePropertyChangeListener("step", this);
                tTrack.removePropertyChangeListener("steps", this);
                tTrack.removePropertyChangeListener("name", this);
                tTrack.removePropertyChangeListener("color", this);
                tTrack.removePropertyChangeListener("footprint", this);
                int n = 0;
                while (n < this.endPointCount) {
                    if (tTrack == this.attachedMass[n] || tTrack == this.measuringTool) {
                        this.attachedMass[n] = null;
                    }
                    ++n;
                }
                this.refreshMeasuringTool();
            }
            this.refreshDropdowns();
            this.refreshDisplay();
        } else if (propertyChangeEvent.getPropertyName().equals("step") || propertyChangeEvent.getPropertyName().equals("steps")) {
            this.refreshMeasuringTool();
        } else {
            this.refreshDisplay();
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.isVisible = bl;
    }

    @Override
    public void dispose() {
        if (this.trackerPanel != null) {
            this.trackerPanel.removePropertyChangeListener("track", this);
            for (TTrack propertyChangeListener2 : this.masses) {
                propertyChangeListener2.removePropertyChangeListener("name", this);
                propertyChangeListener2.removePropertyChangeListener("color", this);
                propertyChangeListener2.removePropertyChangeListener("footprint", this);
            }
            TFrame tFrame = this.trackerPanel.getTFrame();
            if (tFrame != null) {
                tFrame.removePropertyChangeListener("tab", this);
            }
        }
        super.dispose();
    }

    private void createGUI() {
        this.setResizable(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
        this.measuringToolDropdown = new JComboBox();
        this.measuringToolDropdown.setRenderer(this.trackRenderer);
        this.measuringToolDropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TTrack tTrack = (TTrack)AttachmentDialog.this.measuringToolDropdown.getSelectedItem();
                if (tTrack == AttachmentDialog.this.measuringTool) {
                    return;
                }
                AttachmentDialog.this.setMeasuringTool(tTrack);
            }
        });
        jPanel2.add(this.measuringToolDropdown);
        jPanel.add((Component)jPanel2, "North");
        this.dummyMass = new PointMass();
        this.rendererDropdown = new JComboBox(new AttachmentComboBoxModel());
        this.rendererDropdown.setRenderer(this.trackRenderer);
        this.editorDropdown = new JComboBox(new AttachmentComboBoxModel());
        this.editorDropdown.setRenderer(this.trackRenderer);
        this.table = new JTable(new AttachmentTableModel()){

            @Override
            public void setFont(Font font) {
                super.setFont(font);
                AttachmentDialog.this.cellheight = font.getSize() + 16;
                this.setRowHeight(AttachmentDialog.this.cellheight);
                int n = (int)(60.0 * (1.0 + (double)FontSizer.getLevel() * 0.3));
                this.getColumnModel().getColumn(0).setPreferredWidth(n);
                this.getColumnModel().getColumn(1).setPreferredWidth(2 * n);
                this.getTableHeader().setPreferredSize(new Dimension(n, AttachmentDialog.this.cellheight));
            }
        };
        this.attachmentCellRenderer = new AttachmentCellRenderer();
        this.table.setDefaultRenderer(PointMass.class, this.attachmentCellRenderer);
        this.table.setDefaultRenderer(String.class, this.attachmentCellRenderer);
        this.table.setRowHeight(this.cellheight);
        AttachmentCellEditor attachmentCellEditor = new AttachmentCellEditor();
        this.table.getColumnModel().getColumn(1).setCellEditor(attachmentCellEditor);
        this.scrollPane = new JScrollPane(this.table){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = 3 * AttachmentDialog.this.cellheight + 8;
                dimension.width = AttachmentDialog.this.table.getPreferredSize().width;
                return dimension;
            }
        };
        JPanel jPanel3 = new JPanel(new GridLayout(1, 1));
        jPanel.add((Component)jPanel3, "Center");
        jPanel3.add(this.scrollPane);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.helpButton = new JButton();
        this.helpButton.setForeground(new Color(0, 0, 102));
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = AttachmentDialog.this.measuringTool instanceof Protractor ? "protractor" : "tape";
                AttachmentDialog.this.trackerPanel.getTFrame().showHelp(String.valueOf(string) + "#attach", 0);
            }
        });
        this.closeButton = new JButton();
        this.closeButton.setForeground(new Color(0, 0, 102));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AttachmentDialog.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel.add((Component)jPanel4, "South");
        jPanel4.add(this.helpButton);
        jPanel4.add(this.closeButton);
    }

    protected void setMeasuringTool(TTrack tTrack) {
        this.measuringTool = tTrack;
        if (tTrack != null) {
            this.trackerPanel = this.measuringTool.trackerPanel;
            this.endPointCount = tTrack instanceof TapeMeasure ? 2 : 3;
            this.endPointName = new String[this.endPointCount];
            this.attachedMass = this.measuringTool.attachments == null ? new TTrack[this.endPointCount] : this.measuringTool.attachments;
        } else {
            this.endPointCount = 0;
            this.endPointName = new String[0];
            this.attachedMass = new TTrack[0];
        }
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.table.getModel();
        defaultTableModel.fireTableDataChanged();
        this.refreshDisplay();
    }

    private void refreshMeasuringTool() {
        this.measuringTool.attachments = this.attachedMass;
        VideoClip videoClip = this.trackerPanel.getPlayer().getVideoClip();
        int n = 0;
        while (n < this.endPointCount) {
            Cloneable cloneable;
            int n2;
            if (this.attachedMass[n] != null) {
                if (this.measuringTool instanceof TapeMeasure) {
                    ((TapeMeasure)this.measuringTool).setFixedPosition(false);
                } else if (this.measuringTool instanceof Protractor) {
                    ((Protractor)this.measuringTool).setFixed(false);
                }
                n2 = videoClip.getStartFrameNumber();
                while (n2 <= videoClip.getEndFrameNumber()) {
                    cloneable = this.attachedMass[n].getStep(n2);
                    TPoint tPoint = this.measuringTool.getStep(n2).getPoints()[n];
                    if (cloneable == null) {
                        tPoint.detach();
                    } else {
                        TPoint tPoint2 = ((Step)cloneable).getPoints()[0];
                        tPoint.attachTo(tPoint2);
                    }
                    ++n2;
                }
            } else {
                n2 = videoClip.getStartFrameNumber();
                while (n2 <= videoClip.getEndFrameNumber()) {
                    cloneable = this.measuringTool.getStep(n2).getPoints()[n];
                    ((TPoint)cloneable).detach();
                    ++n2;
                }
            }
            ++n;
        }
        this.measuringTool.getToolbarTrackComponents(this.trackerPanel);
    }

    protected void refreshDropdowns() {
        this.masses = this.trackerPanel.getDrawables(PointMass.class);
        for (TTrack object2 : this.masses) {
            object2.removePropertyChangeListener("step", this);
            object2.removePropertyChangeListener("steps", this);
            object2.removePropertyChangeListener("name", this);
            object2.removePropertyChangeListener("color", this);
            object2.removePropertyChangeListener("footprint", this);
            object2.addPropertyChangeListener("step", this);
            object2.addPropertyChangeListener("steps", this);
            object2.addPropertyChangeListener("name", this);
            object2.addPropertyChangeListener("color", this);
            object2.addPropertyChangeListener("footprint", this);
        }
        FontSizer.setFonts(this.rendererDropdown, FontSizer.getLevel());
        this.rendererDropdown.setModel(new AttachmentComboBoxModel());
        FontSizer.setFonts(this.editorDropdown, FontSizer.getLevel());
        this.editorDropdown.setModel(new AttachmentComboBoxModel());
        FontSizer.setFonts(this.measuringToolDropdown, FontSizer.getLevel());
        Object object = this.measuringToolDropdown.getSelectedItem();
        Vector vector = new Vector();
        for (TTrack tTrack : this.trackerPanel.getTracks()) {
            if (tTrack instanceof TapeMeasure) {
                TapeMeasure tapeMeasure = (TapeMeasure)tTrack;
                vector.add(tapeMeasure);
                continue;
            }
            if (!(tTrack instanceof Protractor)) continue;
            vector.add(tTrack);
        }
        Iterator<TTrack> iterator = vector.iterator();
        while (iterator.hasNext()) {
            TTrack tTrack;
            tTrack = iterator.next();
            tTrack.removePropertyChangeListener("name", this);
            tTrack.removePropertyChangeListener("color", this);
            tTrack.removePropertyChangeListener("footprint", this);
            tTrack.addPropertyChangeListener("name", this);
            tTrack.addPropertyChangeListener("color", this);
            tTrack.addPropertyChangeListener("footprint", this);
        }
        this.measuringToolDropdown.setModel(new DefaultComboBoxModel(vector));
        if (object == this.measuringTool) {
            this.setMeasuringTool(vector.isEmpty() ? null : (TTrack)vector.get(0));
        }
    }

    protected void refreshDisplay() {
        this.setTitle(TrackerRes.getString("AttachmentInspector.Title"));
        this.helpButton.setText(TrackerRes.getString("Dialog.Button.Help"));
        this.closeButton.setText(TrackerRes.getString("Dialog.Button.OK"));
        this.dummyMass.setName(TrackerRes.getString("DynamicSystemInspector.ParticleName.None"));
        if (this.endPointCount > 0 && this.measuringTool != null) {
            if (this.measuringTool instanceof Protractor) {
                this.endPointName[0] = TrackerRes.getString("AttachmentInspector.Label.Vertex");
                this.endPointName[1] = String.valueOf(TrackerRes.getString("AttachmentInspector.Label.End")) + " 1";
                this.endPointName[2] = String.valueOf(TrackerRes.getString("AttachmentInspector.Label.End")) + " 2";
            } else {
                this.endPointName[0] = String.valueOf(TrackerRes.getString("AttachmentInspector.Label.End")) + " 1";
                this.endPointName[1] = String.valueOf(TrackerRes.getString("AttachmentInspector.Label.End")) + " 2";
            }
            this.measuringToolDropdown.setSelectedItem(this.measuringTool);
        }
        this.pack();
        this.repaint();
    }

    public void setFontLevel(int n) {
        FontSizer.setFonts(this, n);
        FontSizer.setFonts(this.attachmentCellRenderer.label, n);
        FontSizer.setFonts(this.table, n);
        this.refreshDropdowns();
        this.pack();
    }

    class AttachmentCellEditor
    extends DefaultCellEditor {
        AttachmentCellEditor() {
            super(AttachmentDialog.this.editorDropdown);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            AttachmentDialog.this.editorDropdown.setSelectedItem(object == null ? AttachmentDialog.this.dummyMass : object);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            Object object = super.getCellEditorValue();
            int n = AttachmentDialog.this.table.getSelectedRow();
            if (n < 0) {
                return null;
            }
            AttachmentDialog.this.attachedMass[n] = object == AttachmentDialog.this.dummyMass ? null : (PointMass)object;
            AttachmentDialog.this.refreshMeasuringTool();
            return object;
        }
    }

    class AttachmentCellRenderer
    implements TableCellRenderer {
        JLabel label = new JLabel();

        AttachmentCellRenderer() {
            this.label.setHorizontalAlignment(0);
            this.label.setBackground(Color.white);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.label.setText((String)object);
                this.label.validate();
                return this.label;
            }
            AttachmentDialog.this.rendererDropdown.setSelectedItem(object == null ? AttachmentDialog.this.dummyMass : object);
            return AttachmentDialog.this.rendererDropdown;
        }
    }

    class AttachmentComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Object selected;

        AttachmentComboBoxModel() {
            this.selected = AttachmentDialog.this.dummyMass;
        }

        @Override
        public int getSize() {
            return AttachmentDialog.this.masses == null ? 1 : AttachmentDialog.this.masses.size() + 1;
        }

        @Override
        public Object getElementAt(int n) {
            return n == 0 ? AttachmentDialog.this.dummyMass : AttachmentDialog.this.masses.get(n - 1);
        }

        @Override
        public void setSelectedItem(Object object) {
            this.selected = object;
        }

        @Override
        public Object getSelectedItem() {
            return this.selected == null ? AttachmentDialog.this.dummyMass : this.selected;
        }
    }

    class AttachmentTableModel
    extends DefaultTableModel {
        AttachmentTableModel() {
        }

        @Override
        public int getRowCount() {
            return AttachmentDialog.this.endPointCount;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? AttachmentDialog.this.endPointName[n] : AttachmentDialog.this.attachedMass[n];
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? TrackerRes.getString("AttachmentInspector.Header.PointName") : TrackerRes.getString("AttachmentInspector.Header.AttachedTo");
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return n == 0 ? String.class : PointMass.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
        }
    }

    class TTrackRenderer
    extends JLabel
    implements ListCellRenderer {
        TTrackRenderer() {
            this.setOpaque(true);
            this.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 0));
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (object != null) {
                TTrack tTrack = (TTrack)object;
                this.setText(tTrack.getName());
                Icon icon = tTrack == AttachmentDialog.this.dummyMass ? new ResizableIcon(AttachmentDialog.this.dummyIcon) : tTrack.getFootprint().getIcon(21, 16);
                int n2 = FontSizer.getIntegerFactor();
                if (icon instanceof ResizableIcon) {
                    ((ResizableIcon)icon).resize(n2);
                }
                this.setIcon(icon);
            }
            return this;
        }
    }
}

