/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.cabrillo.tracker;

import java.awt.BasicStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import javax.swing.Icon;
import org.opensourcephysics.cabrillo.tracker.LineFootprint;
import org.opensourcephysics.cabrillo.tracker.ShapeIcon;
import org.opensourcephysics.tools.FontSizer;

public class ArrowFootprint
extends LineFootprint {
    protected double stretch = 1.0;
    protected int tipLength = 16;
    protected int tipWidth = 4;
    boolean openHead = true;
    protected BasicStroke headStroke = new BasicStroke();
    protected BasicStroke tipStroke;

    public ArrowFootprint(String string) {
        super(string);
    }

    public void setStretch(double d) {
        this.stretch = d;
    }

    public double getStretch() {
        return this.stretch;
    }

    public void setTipLength(int n) {
        n = Math.max(32, n);
        this.tipWidth = n / 4;
        this.tipLength = 4 * this.tipWidth;
    }

    public void setSolidHead(boolean bl) {
        this.openHead = !bl;
    }

    @Override
    public void setStroke(BasicStroke basicStroke) {
        if (basicStroke == null) {
            return;
        }
        super.setStroke(basicStroke);
        this.headStroke = new BasicStroke(basicStroke.getLineWidth(), 0, 0, 8.0f, null, basicStroke.getDashPhase());
    }

    @Override
    public Icon getIcon(int n, int n2) {
        int n3 = FontSizer.getIntegerFactor();
        Point[] pointArray = new Point[]{new Point(), new Point((n *= n3) - 2, 2 - (n2 *= n3))};
        double d = this.stretch;
        this.stretch = 1.0;
        Shape shape = this.getShape(pointArray);
        ShapeIcon shapeIcon = new ShapeIcon(shape, n, n2);
        shapeIcon.setColor(this.color);
        this.stretch = d;
        return shapeIcon;
    }

    @Override
    public synchronized Shape getShape(Point[] pointArray) {
        float f;
        Point point = pointArray[0];
        Point point2 = pointArray[1];
        double d = Math.atan2(point.y - point2.y, point.x - point2.x);
        this.transform.setToRotation(d, point.x, point.y);
        this.transform.translate(point.x, point.y);
        int n = FontSizer.getIntegerFactor();
        if (n > 1) {
            this.transform.scale(n, n);
        }
        this.highlight = this.transform.createTransformedShape(HIGHLIGHT);
        this.transform.setToRotation(d, point2.x, point2.y);
        this.transform.translate(point2.x, point2.y);
        float f2 = (float)(this.stretch * point.distance(point2));
        int n2 = this.tipLength * n;
        int n3 = Math.min(n2, Math.round(f2 - 4.0f));
        n3 = Math.max(8, n3);
        int n4 = Math.max(n3 / 4, 2);
        float f3 = (float)n * this.baseStroke.getLineWidth();
        float f4 = f = f3 < (float)(n3 / 4) ? f3 : Math.max((float)(n3 / 4), 0.8f);
        if (this.stroke == null || this.stroke.getLineWidth() != f) {
            this.stroke = new BasicStroke(f, 0, 0, 8.0f, this.baseStroke.getDashArray(), this.baseStroke.getDashPhase());
            this.headStroke = new BasicStroke(f, 0, 0, 8.0f, null, this.stroke.getDashPhase());
        }
        try {
            this.path.reset();
            this.path.moveTo(f2 - 4.0f, 0.0f);
            this.path.lineTo(f2 - 6.0f, -2.0f);
            this.path.lineTo(f2, 0.0f);
            this.path.lineTo(f2 - 6.0f, 2.0f);
            this.path.closePath();
            this.hitShapes[0] = this.transform.createTransformedShape(this.path);
            f2 = f2 - (float)((double)this.stroke.getLineWidth() * 1.58) + 1.0f;
            this.path.reset();
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(f2 - (float)n3, 0.0f);
            this.hitShapes[2] = this.transform.createTransformedShape(this.path);
            this.hitShapes[1] = new Rectangle(point2.x - 1, point2.y - 1, 2, 2);
            this.path.reset();
            this.path.moveTo(0.0f, 0.0f);
            this.path.lineTo(f2 - (float)n3 + (float)n4, 0.0f);
            Shape shape = this.transform.createTransformedShape(this.path);
            shape = this.stroke.createStrokedShape(shape);
            Area area = new Area(shape);
            this.path.reset();
            this.path.moveTo(f2 - (float)n3 + (float)n4, 0.0f);
            this.path.lineTo(f2 - (float)n3, -n4);
            this.path.lineTo(f2, 0.0f);
            this.path.lineTo(f2 - (float)n3, n4);
            this.path.closePath();
            Shape shape2 = this.transform.createTransformedShape(this.path);
            if (this.openHead) {
                shape2 = this.headStroke.createStrokedShape(shape2);
            }
            area.add(new Area(shape2));
            if (!this.openHead) {
                area.add(new Area(this.headStroke.createStrokedShape(shape2)));
            }
            return area;
        }
        catch (Exception exception) {
            f2 = (float)(this.stretch * point.distance(point2));
            Line2D.Double double_ = new Line2D.Double(0.0, 0.0, f2, 0.0);
            return this.stroke.createStrokedShape(this.transform.createTransformedShape(double_));
        }
    }
}

