/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.writer;

import com.sun.xml.internal.txw2.TypedXmlWriter;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.CheckedException;
import com.sun.xml.internal.ws.api.model.JavaMethod;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGenExtnContext;
import com.sun.xml.internal.ws.api.wsdl.writer.WSDLGeneratorExtension;
import com.sun.xml.internal.ws.wsdl.writer.UsingAddressing;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLGeneratorExtension
extends WSDLGeneratorExtension {
    private boolean enabled;
    private boolean required = false;
    private static final Logger LOGGER = Logger.getLogger(W3CAddressingWSDLGeneratorExtension.class.getName());

    @Override
    public void start(WSDLGenExtnContext wSDLGenExtnContext) {
        WSBinding wSBinding = wSDLGenExtnContext.getBinding();
        TypedXmlWriter typedXmlWriter = wSDLGenExtnContext.getRoot();
        this.enabled = wSBinding.isFeatureEnabled(AddressingFeature.class);
        if (!this.enabled) {
            return;
        }
        AddressingFeature addressingFeature = wSBinding.getFeature(AddressingFeature.class);
        this.required = addressingFeature.isRequired();
        typedXmlWriter._namespace(AddressingVersion.W3C.wsdlNsUri, AddressingVersion.W3C.getWsdlPrefix());
    }

    @Override
    public void addOperationInputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        if (action != null && !action.input().equals("")) {
            this.addAttribute(typedXmlWriter, action.input());
        } else {
            String string = javaMethod.getBinding().getSOAPAction();
            if (string == null || string.equals("")) {
                String string2 = W3CAddressingWSDLGeneratorExtension.getDefaultAction(javaMethod);
                this.addAttribute(typedXmlWriter, string2);
            }
        }
    }

    protected static final String getDefaultAction(JavaMethod javaMethod) {
        Object object;
        String string = javaMethod.getOwner().getTargetNamespace();
        String string2 = "/";
        try {
            object = new URI(string);
            if (((URI)object).getScheme().equalsIgnoreCase("urn")) {
                string2 = ":";
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warning("TargetNamespace of WebService is not a valid URI");
        }
        if (string.endsWith(string2)) {
            string = string.substring(0, string.length() - 1);
        }
        object = javaMethod.getMEP().isOneWay() ? javaMethod.getOperationName() : javaMethod.getOperationName() + "Request";
        return string + string2 + javaMethod.getOwner().getPortTypeName().getLocalPart() + string2 + (String)object;
    }

    @Override
    public void addOperationOutputExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        if (action != null && !action.output().equals("")) {
            this.addAttribute(typedXmlWriter, action.output());
        }
    }

    @Override
    public void addOperationFaultExtension(TypedXmlWriter typedXmlWriter, JavaMethod javaMethod, CheckedException checkedException) {
        if (!this.enabled) {
            return;
        }
        Action action = javaMethod.getSEIMethod().getAnnotation(Action.class);
        Class<?>[] classArray = javaMethod.getSEIMethod().getExceptionTypes();
        if (classArray == null) {
            return;
        }
        if (action != null && action.fault() != null) {
            for (FaultAction faultAction : action.fault()) {
                if (!faultAction.className().getName().equals(checkedException.getExceptionClass().getName())) continue;
                if (faultAction.value().equals("")) {
                    return;
                }
                this.addAttribute(typedXmlWriter, faultAction.value());
                return;
            }
        }
    }

    private void addAttribute(TypedXmlWriter typedXmlWriter, String string) {
        typedXmlWriter._attribute(AddressingVersion.W3C.wsdlActionTag, (Object)string);
    }

    @Override
    public void addBindingExtension(TypedXmlWriter typedXmlWriter) {
        if (!this.enabled) {
            return;
        }
        typedXmlWriter._element(AddressingVersion.W3C.wsdlExtensionTag, UsingAddressing.class);
    }
}

