/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.xml.internal.ws.api.message.Headers;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.message.ByteArrayAttachment;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import com.sun.xml.internal.ws.message.JAXBAttachment;
import com.sun.xml.internal.ws.model.ParameterImpl;
import com.sun.xml.internal.ws.server.sei.ValueGetter;
import com.sun.xml.internal.ws.spi.db.XMLBridge;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;

public abstract class MessageFiller {
    protected final int methodPos;

    protected MessageFiller(int n) {
        this.methodPos = n;
    }

    public abstract void fillIn(Object[] var1, Object var2, Message var3);

    private static boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    public static abstract class AttachmentFiller
    extends MessageFiller {
        protected final ParameterImpl param;
        protected final ValueGetter getter;
        protected final String mimeType;
        private final String contentIdPart;

        protected AttachmentFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl.getIndex());
            this.param = parameterImpl;
            this.getter = valueGetter;
            this.mimeType = parameterImpl.getBinding().getMimeType();
            try {
                this.contentIdPart = URLEncoder.encode(parameterImpl.getPartName(), "UTF-8") + '=';
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new WebServiceException(unsupportedEncodingException);
            }
        }

        public static MessageFiller createAttachmentFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            Class clazz = (Class)parameterImpl.getTypeInfo().type;
            if (DataHandler.class.isAssignableFrom(clazz) || Source.class.isAssignableFrom(clazz)) {
                return new DataHandlerFiller(parameterImpl, valueGetter);
            }
            if (byte[].class == clazz) {
                return new ByteArrayFiller(parameterImpl, valueGetter);
            }
            if (MessageFiller.isXMLMimeType(parameterImpl.getBinding().getMimeType())) {
                return new JAXBFiller(parameterImpl, valueGetter);
            }
            return new DataHandlerFiller(parameterImpl, valueGetter);
        }

        String getContentId() {
            return this.contentIdPart + UUID.randomUUID() + "@jaxws.sun.com";
        }
    }

    private static class ByteArrayFiller
    extends AttachmentFiller {
        protected ByteArrayFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        @Override
        public void fillIn(Object[] objectArray, Object object, Message message) {
            Object object2;
            String string = this.getContentId();
            Object object3 = object2 = this.methodPos == -1 ? object : this.getter.get(objectArray[this.methodPos]);
            if (object2 != null) {
                ByteArrayAttachment byteArrayAttachment = new ByteArrayAttachment(string, (byte[])object2, this.mimeType);
                message.getAttachments().add(byteArrayAttachment);
            }
        }
    }

    private static class DataHandlerFiller
    extends AttachmentFiller {
        protected DataHandlerFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        @Override
        public void fillIn(Object[] objectArray, Object object, Message message) {
            String string = this.getContentId();
            Object object2 = this.methodPos == -1 ? object : this.getter.get(objectArray[this.methodPos]);
            DataHandler dataHandler = object2 instanceof DataHandler ? (DataHandler)object2 : new DataHandler(object2, this.mimeType);
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, dataHandler);
            message.getAttachments().add(dataHandlerAttachment);
        }
    }

    public static final class Header
    extends MessageFiller {
        private final XMLBridge bridge;
        private final ValueGetter getter;

        public Header(int n, XMLBridge xMLBridge, ValueGetter valueGetter) {
            super(n);
            this.bridge = xMLBridge;
            this.getter = valueGetter;
        }

        @Override
        public void fillIn(Object[] objectArray, Object object, Message message) {
            Object object2 = this.methodPos == -1 ? object : this.getter.get(objectArray[this.methodPos]);
            message.getHeaders().add(Headers.create(this.bridge, object2));
        }
    }

    private static class JAXBFiller
    extends AttachmentFiller {
        protected JAXBFiller(ParameterImpl parameterImpl, ValueGetter valueGetter) {
            super(parameterImpl, valueGetter);
        }

        @Override
        public void fillIn(Object[] objectArray, Object object, Message message) {
            String string = this.getContentId();
            Object object2 = this.methodPos == -1 ? object : this.getter.get(objectArray[this.methodPos]);
            JAXBAttachment jAXBAttachment = new JAXBAttachment(string, object2, this.param.getXMLBridge(), this.mimeType);
            message.getAttachments().add(jAXBAttachment);
        }
    }
}

