/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model;

import com.oracle.xmlns.internal.webservices.jaxws_databinding.ExistingAnnotationsType;
import com.oracle.xmlns.internal.webservices.jaxws_databinding.JavaMethod;
import com.oracle.xmlns.internal.webservices.jaxws_databinding.JavaParam;
import com.oracle.xmlns.internal.webservices.jaxws_databinding.JavaWsdlMappingType;
import com.oracle.xmlns.internal.webservices.jaxws_databinding.ObjectFactory;
import com.sun.xml.internal.ws.model.ReflectAnnotationReader;
import com.sun.xml.internal.ws.model.RuntimeModelerException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.util.JAXBResult;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class ExternalMetadataReader
extends ReflectAnnotationReader {
    private static final String NAMESPACE_WEBLOGIC_WSEE_DATABINDING = "http://xmlns.oracle.com/weblogic/weblogic-wsee-databinding";
    private static final String NAMESPACE_JAXWS_RI_EXTERNAL_METADATA = "http://xmlns.oracle.com/webservices/jaxws-databinding";
    private Map<String, JavaWsdlMappingType> readers = new HashMap<String, JavaWsdlMappingType>();

    public ExternalMetadataReader(Collection<File> collection, Collection<String> collection2, ClassLoader classLoader, boolean bl, boolean bl2) {
        JavaWsdlMappingType javaWsdlMappingType;
        String exception;
        if (collection != null) {
            for (File object : collection) {
                try {
                    exception = Util.documentRootNamespace(this.newSource(object), bl2);
                    javaWsdlMappingType = this.parseMetadata(bl, this.newSource(object), exception, bl2);
                    this.readers.put(javaWsdlMappingType.getJavaTypeName(), javaWsdlMappingType);
                }
                catch (Exception exception2) {
                    throw new RuntimeModelerException("runtime.modeler.external.metadata.unable.to.read", object.getAbsolutePath());
                }
            }
        }
        if (collection2 != null) {
            for (String string : collection2) {
                try {
                    exception = Util.documentRootNamespace(this.newSource(string, classLoader), bl2);
                    javaWsdlMappingType = this.parseMetadata(bl, this.newSource(string, classLoader), exception, bl2);
                    this.readers.put(javaWsdlMappingType.getJavaTypeName(), javaWsdlMappingType);
                }
                catch (Exception exception3) {
                    throw new RuntimeModelerException("runtime.modeler.external.metadata.unable.to.read", string);
                }
            }
        }
    }

    private StreamSource newSource(String string, ClassLoader classLoader) {
        InputStream inputStream = classLoader.getResourceAsStream(string);
        return new StreamSource(inputStream);
    }

    private JavaWsdlMappingType parseMetadata(boolean bl, StreamSource streamSource, String string, boolean bl2) throws JAXBException, IOException, TransformerException {
        if (NAMESPACE_WEBLOGIC_WSEE_DATABINDING.equals(string)) {
            return Util.transformAndRead(streamSource, bl2);
        }
        if (NAMESPACE_JAXWS_RI_EXTERNAL_METADATA.equals(string)) {
            return Util.read(streamSource, bl, bl2);
        }
        throw new RuntimeModelerException("runtime.modeler.external.metadata.unsupported.schema", string, Arrays.asList(NAMESPACE_WEBLOGIC_WSEE_DATABINDING, NAMESPACE_JAXWS_RI_EXTERNAL_METADATA).toString());
    }

    private StreamSource newSource(File file) {
        try {
            return new StreamSource(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeModelerException("runtime.modeler.external.metadata.unable.to.read", file.getAbsolutePath());
        }
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz, Class<?> clazz2) {
        JavaWsdlMappingType javaWsdlMappingType = this.reader(clazz2);
        return (A)(javaWsdlMappingType == null ? super.getAnnotation(clazz, clazz2) : (Annotation)Util.annotation(javaWsdlMappingType, clazz));
    }

    private JavaWsdlMappingType reader(Class<?> clazz) {
        return this.readers.get(clazz.getName());
    }

    Annotation[] getAnnotations(List<Object> list) {
        ArrayList arrayList = new ArrayList();
        for (Object object : list) {
            if (!Annotation.class.isInstance(object)) continue;
            arrayList.add(Annotation.class.cast(object));
        }
        return arrayList.toArray(new Annotation[arrayList.size()]);
    }

    @Override
    public Annotation[] getAnnotations(final Class<?> clazz) {
        Merger<Annotation[]> merger = new Merger<Annotation[]>(this.reader(clazz)){

            @Override
            Annotation[] reflection() {
                return ExternalMetadataReader.super.getAnnotations(clazz);
            }

            @Override
            Annotation[] external() {
                return ExternalMetadataReader.this.getAnnotations(this.reader.getClassAnnotation());
            }
        };
        return (Annotation[])merger.merge();
    }

    @Override
    public Annotation[] getAnnotations(final Method method) {
        Merger<Annotation[]> merger = new Merger<Annotation[]>(this.reader(method.getDeclaringClass())){

            @Override
            Annotation[] reflection() {
                return ExternalMetadataReader.super.getAnnotations(method);
            }

            @Override
            Annotation[] external() {
                JavaMethod javaMethod = ExternalMetadataReader.this.getJavaMethod(method, this.reader);
                return javaMethod == null ? new Annotation[]{} : ExternalMetadataReader.this.getAnnotations(javaMethod.getMethodAnnotation());
            }
        };
        return (Annotation[])merger.merge();
    }

    @Override
    public <A extends Annotation> A getAnnotation(final Class<A> clazz, final Method method) {
        Merger<Annotation> merger = new Merger<Annotation>(this.reader(method.getDeclaringClass())){

            @Override
            Annotation reflection() {
                return ExternalMetadataReader.super.getAnnotation(clazz, method);
            }

            @Override
            Annotation external() {
                JavaMethod javaMethod = ExternalMetadataReader.this.getJavaMethod(method, this.reader);
                return (Annotation)Util.annotation(javaMethod, clazz);
            }
        };
        return (A)((Annotation)merger.merge());
    }

    @Override
    public Annotation[][] getParameterAnnotations(final Method method) {
        Merger<Annotation[][]> merger = new Merger<Annotation[][]>(this.reader(method.getDeclaringClass())){

            @Override
            Annotation[][] reflection() {
                return ExternalMetadataReader.super.getParameterAnnotations(method);
            }

            @Override
            Annotation[][] external() {
                JavaMethod javaMethod = ExternalMetadataReader.this.getJavaMethod(method, this.reader);
                Annotation[][] annotationArray = method.getParameterAnnotations();
                for (int i = 0; i < method.getParameterTypes().length; ++i) {
                    if (javaMethod == null) continue;
                    JavaParam javaParam = javaMethod.getJavaParams().getJavaParam().get(i);
                    annotationArray[i] = ExternalMetadataReader.this.getAnnotations(javaParam.getParamAnnotation());
                }
                return annotationArray;
            }
        };
        return (Annotation[][])merger.merge();
    }

    @Override
    public void getProperties(Map<String, Object> map, Class<?> clazz) {
        JavaWsdlMappingType javaWsdlMappingType = this.reader(clazz);
        if (javaWsdlMappingType == null || ExistingAnnotationsType.MERGE.equals((Object)javaWsdlMappingType.getExistingAnnotations())) {
            super.getProperties(map, clazz);
        }
    }

    @Override
    public void getProperties(Map<String, Object> map, Method method) {
        JavaWsdlMappingType javaWsdlMappingType = this.reader(method.getDeclaringClass());
        if (javaWsdlMappingType == null || ExistingAnnotationsType.MERGE.equals((Object)javaWsdlMappingType.getExistingAnnotations())) {
            super.getProperties(map, method);
        }
        if (javaWsdlMappingType != null) {
            JavaMethod javaMethod = this.getJavaMethod(method, javaWsdlMappingType);
            Element[] elementArray = Util.annotation(javaMethod);
            map.put("eclipselink-oxm-xml.xml-element", this.findXmlElement(elementArray));
        }
    }

    @Override
    public void getProperties(Map<String, Object> map, Method method, int n) {
        JavaWsdlMappingType javaWsdlMappingType = this.reader(method.getDeclaringClass());
        if (javaWsdlMappingType == null || ExistingAnnotationsType.MERGE.equals((Object)javaWsdlMappingType.getExistingAnnotations())) {
            super.getProperties(map, method, n);
        }
        if (javaWsdlMappingType != null) {
            JavaMethod javaMethod = this.getJavaMethod(method, javaWsdlMappingType);
            if (javaMethod == null) {
                return;
            }
            JavaParam javaParam = javaMethod.getJavaParams().getJavaParam().get(n);
            Element[] elementArray = Util.annotation(javaParam);
            map.put("eclipselink-oxm-xml.xml-element", this.findXmlElement(elementArray));
        }
    }

    JavaMethod getJavaMethod(Method method, JavaWsdlMappingType javaWsdlMappingType) {
        JavaWsdlMappingType.JavaMethods javaMethods = javaWsdlMappingType.getJavaMethods();
        if (javaMethods == null) {
            return null;
        }
        ArrayList<JavaMethod> arrayList = new ArrayList<JavaMethod>();
        for (JavaMethod object : javaMethods.getJavaMethod()) {
            if (!method.getName().equals(object.getName())) continue;
            arrayList.add(object);
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        if (arrayList.size() == 1) {
            return (JavaMethod)arrayList.get(0);
        }
        Class<?>[] classArray = method.getParameterTypes();
        for (JavaMethod javaMethod : arrayList) {
            JavaMethod.JavaParams javaParams = javaMethod.getJavaParams();
            if (javaParams == null || javaParams.getJavaParam() == null || javaParams.getJavaParam().size() != classArray.length) continue;
            int n = 0;
            for (int i = 0; i < classArray.length; ++i) {
                JavaParam javaParam = javaParams.getJavaParam().get(i);
                if (!classArray[i].getName().equals(javaParam.getJavaType())) continue;
                ++n;
            }
            if (n != classArray.length) continue;
            return javaMethod;
        }
        return null;
    }

    Element findXmlElement(Element[] elementArray) {
        if (elementArray == null) {
            return null;
        }
        for (Element element : elementArray) {
            if (element.getLocalName().equals("java-type")) {
                return element;
            }
            if (!element.getLocalName().equals("xml-element")) continue;
            return element;
        }
        return null;
    }

    static abstract class Merger<T> {
        JavaWsdlMappingType reader;

        Merger(JavaWsdlMappingType javaWsdlMappingType) {
            this.reader = javaWsdlMappingType;
        }

        abstract T reflection();

        abstract T external();

        T merge() {
            T t = this.reflection();
            if (this.reader == null) {
                return t;
            }
            T t2 = this.external();
            if (!ExistingAnnotationsType.MERGE.equals((Object)this.reader.getExistingAnnotations())) {
                return t2;
            }
            if (t instanceof Annotation) {
                return (T)this.doMerge((Annotation)t, (Annotation)t2);
            }
            if (t instanceof Annotation[][]) {
                return (T)this.doMerge((Annotation[][])t, (Annotation[][])t2);
            }
            return (T)this.doMerge((Annotation[])t, (Annotation[])t2);
        }

        private Annotation doMerge(Annotation annotation, Annotation annotation2) {
            return annotation2 != null ? annotation2 : annotation;
        }

        private Annotation[][] doMerge(Annotation[][] annotationArray, Annotation[][] annotationArray2) {
            for (int i = 0; i < annotationArray.length; ++i) {
                annotationArray[i] = this.doMerge(annotationArray[i], annotationArray2.length > i ? annotationArray2[i] : null);
            }
            return annotationArray;
        }

        private Annotation[] doMerge(Annotation[] annotationArray, Annotation[] annotationArray2) {
            Object object;
            int n;
            int n2;
            Object object2;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            if (annotationArray != null) {
                object2 = annotationArray;
                n2 = ((Annotation[])object2).length;
                for (n = 0; n < n2; ++n) {
                    object = object2[n];
                    hashMap.put(object.annotationType().getName(), object);
                }
            }
            if (annotationArray2 != null) {
                object2 = annotationArray2;
                n2 = ((Annotation[])object2).length;
                for (n = 0; n < n2; ++n) {
                    object = object2[n];
                    hashMap.put(object.annotationType().getName(), object);
                }
            }
            return (n2 = (object2 = hashMap.values()).size()) == 0 ? null : object2.toArray(new Annotation[n2]);
        }
    }

    static class Util {
        private static final String DATABINDING_XSD = "jaxws-databinding.xsd";
        private static final String TRANSLATE_NAMESPACES_XSL = "jaxws-databinding-translate-namespaces.xml";
        static Schema schema;
        static JAXBContext jaxbContext;

        Util() {
        }

        private static URL getResource() {
            ClassLoader classLoader = Util.class.getClassLoader();
            return classLoader != null ? classLoader.getResource(DATABINDING_XSD) : ClassLoader.getSystemResource(DATABINDING_XSD);
        }

        private static JAXBContext createJaxbContext(boolean bl) {
            Class[] classArray = new Class[]{ObjectFactory.class};
            try {
                if (bl) {
                    HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
                    hashMap.put("com.sun.xml.internal.bind.disableXmlSecurity", bl);
                    return JAXBContext.newInstance(classArray, hashMap);
                }
                return JAXBContext.newInstance(classArray);
            }
            catch (JAXBException jAXBException) {
                jAXBException.printStackTrace();
                return null;
            }
        }

        public static JavaWsdlMappingType read(Source source, boolean bl, boolean bl2) throws IOException, JAXBException {
            JAXBContext jAXBContext = Util.jaxbContext(bl2);
            try {
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                if (bl) {
                    if (schema == null) {
                        // empty if block
                    }
                    unmarshaller.setSchema(schema);
                }
                Object object = unmarshaller.unmarshal(source);
                return Util.getJavaWsdlMapping(object);
            }
            catch (JAXBException jAXBException) {
                URL uRL = new URL(source.getSystemId());
                StreamSource streamSource = new StreamSource(uRL.openStream());
                Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
                if (bl) {
                    if (schema == null) {
                        // empty if block
                    }
                    unmarshaller.setSchema(schema);
                }
                Object object = unmarshaller.unmarshal(streamSource);
                return Util.getJavaWsdlMapping(object);
            }
        }

        private static JAXBContext jaxbContext(boolean bl) {
            return bl ? Util.createJaxbContext(true) : jaxbContext;
        }

        public static JavaWsdlMappingType transformAndRead(Source source, boolean bl) throws TransformerException, JAXBException {
            StreamSource streamSource = new StreamSource(Util.class.getResourceAsStream(TRANSLATE_NAMESPACES_XSL));
            JAXBResult jAXBResult = new JAXBResult(Util.jaxbContext(bl));
            TransformerFactory transformerFactory = XmlUtil.newTransformerFactory(!bl);
            Transformer transformer = transformerFactory.newTemplates(streamSource).newTransformer();
            transformer.transform(source, jAXBResult);
            return Util.getJavaWsdlMapping(jAXBResult.getResult());
        }

        static JavaWsdlMappingType getJavaWsdlMapping(Object object) {
            Object object2;
            Object object3 = object2 = object instanceof JAXBElement ? ((JAXBElement)object).getValue() : object;
            if (object2 instanceof JavaWsdlMappingType) {
                return (JavaWsdlMappingType)object2;
            }
            return null;
        }

        static <T> T findInstanceOf(Class<T> clazz, List<Object> list) {
            for (Object object : list) {
                if (!clazz.isInstance(object)) continue;
                return clazz.cast(object);
            }
            return null;
        }

        public static <T> T annotation(JavaWsdlMappingType javaWsdlMappingType, Class<T> clazz) {
            if (javaWsdlMappingType == null || javaWsdlMappingType.getClassAnnotation() == null) {
                return null;
            }
            return Util.findInstanceOf(clazz, javaWsdlMappingType.getClassAnnotation());
        }

        public static <T> T annotation(JavaMethod javaMethod, Class<T> clazz) {
            if (javaMethod == null || javaMethod.getMethodAnnotation() == null) {
                return null;
            }
            return Util.findInstanceOf(clazz, javaMethod.getMethodAnnotation());
        }

        public static <T> T annotation(JavaParam javaParam, Class<T> clazz) {
            if (javaParam == null || javaParam.getParamAnnotation() == null) {
                return null;
            }
            return Util.findInstanceOf(clazz, javaParam.getParamAnnotation());
        }

        public static Element[] annotation(JavaMethod javaMethod) {
            if (javaMethod == null || javaMethod.getMethodAnnotation() == null) {
                return null;
            }
            return Util.findElements(javaMethod.getMethodAnnotation());
        }

        public static Element[] annotation(JavaParam javaParam) {
            if (javaParam == null || javaParam.getParamAnnotation() == null) {
                return null;
            }
            return Util.findElements(javaParam.getParamAnnotation());
        }

        private static Element[] findElements(List<Object> list) {
            ArrayList<Element> arrayList = new ArrayList<Element>();
            for (Object object : list) {
                if (!(object instanceof Element)) continue;
                arrayList.add((Element)object);
            }
            return arrayList.toArray(new Element[arrayList.size()]);
        }

        static String documentRootNamespace(Source source, boolean bl) throws XMLStreamException {
            XMLInputFactory xMLInputFactory = XmlUtil.newXMLInputFactory(!bl);
            XMLStreamReader xMLStreamReader = xMLInputFactory.createXMLStreamReader(source);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            String string = xMLStreamReader.getName().getNamespaceURI();
            XMLStreamReaderUtil.close(xMLStreamReader);
            return string;
        }

        static {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            try {
                URL uRL = Util.getResource();
                if (uRL != null) {
                    schema = schemaFactory.newSchema(uRL);
                }
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            jaxbContext = Util.createJaxbContext(false);
        }
    }
}

