/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.api.pipe;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.Cancelable;
import com.sun.xml.internal.ws.api.Component;
import com.sun.xml.internal.ws.api.ComponentRegistry;
import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.message.AddressingUtils;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Engine;
import com.sun.xml.internal.ws.api.pipe.FiberContextSwitchInterceptor;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.pipe.ThrowableContainerPropertySet;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.internal.ws.api.server.Container;
import com.sun.xml.internal.ws.api.server.ContainerResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.ws.Holder;
import javax.xml.ws.WebServiceException;

public final class Fiber
implements Runnable,
Cancelable,
ComponentRegistry {
    private final List<Listener> _listeners = new ArrayList<Listener>();
    private Tube[] conts = new Tube[16];
    private int contsSize;
    private Tube next;
    private Packet packet;
    private Throwable throwable;
    public final Engine owner;
    private volatile int suspendedCount = 0;
    private volatile boolean isInsideSuspendCallbacks = false;
    private boolean synchronous;
    private boolean interrupted;
    private final int id;
    private List<FiberContextSwitchInterceptor> interceptors;
    @Nullable
    private ClassLoader contextClassLoader;
    @Nullable
    private CompletionCallback completionCallback;
    private boolean isDeliverThrowableInPacket = false;
    private Thread currentThread;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private volatile boolean isCanceled;
    private boolean started;
    private boolean startedSync;
    private static final PlaceholderTube PLACEHOLDER = new PlaceholderTube();
    private static final ThreadLocal<Fiber> CURRENT_FIBER = new ThreadLocal();
    private static final AtomicInteger iotaGen = new AtomicInteger();
    private static final Logger LOGGER = Logger.getLogger(Fiber.class.getName());
    private static final ReentrantLock serializedExecutionLock = new ReentrantLock();
    public static volatile boolean serializeExecution = Boolean.getBoolean(Fiber.class.getName() + ".serialize");
    private final Set<Component> components = new CopyOnWriteArraySet<Component>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener listener) {
        List<Listener> list = this._listeners;
        synchronized (list) {
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener listener) {
        List<Listener> list = this._listeners;
        synchronized (list) {
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Listener> getCurrentListeners() {
        List<Listener> list = this._listeners;
        synchronized (list) {
            return new ArrayList<Listener>(this._listeners);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListeners() {
        List<Listener> list = this._listeners;
        synchronized (list) {
            this._listeners.clear();
        }
    }

    public void setDeliverThrowableInPacket(boolean bl) {
        this.isDeliverThrowableInPacket = bl;
    }

    Fiber(Engine engine) {
        this.owner = engine;
        this.id = iotaGen.incrementAndGet();
        if (Fiber.isTraceEnabled()) {
            LOGGER.log(Level.FINE, "{0} created", this.getName());
        }
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void start(@NotNull Tube tube, @NotNull Packet packet, @Nullable CompletionCallback completionCallback) {
        this.start(tube, packet, completionCallback, false);
    }

    /*
     * WARNING - void declaration
     */
    private void dumpFiberContext(String string) {
        if (Fiber.isTraceEnabled()) {
            void var4_7;
            String string2 = null;
            String string3 = null;
            if (this.packet != null) {
                for (SOAPVersion sOAPVersion : SOAPVersion.values()) {
                    for (AddressingVersion addressingVersion : AddressingVersion.values()) {
                        string2 = this.packet.getMessage() != null ? AddressingUtils.getAction(this.packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                        String string4 = string3 = this.packet.getMessage() != null ? AddressingUtils.getMessageID(this.packet.getMessage().getHeaders(), addressingVersion, sOAPVersion) : null;
                        if (string2 != null || string3 != null) break;
                    }
                    if (string2 != null || string3 != null) break;
                }
            }
            if (string2 == null && string3 == null) {
                String string5 = "NO ACTION or MSG ID";
            } else {
                String string6 = "'" + string2 + "' and msgId '" + string3 + "'";
            }
            String string7 = this.next != null ? this.next.toString() + ".processRequest()" : this.peekCont() + ".processResponse()";
            LOGGER.log(Level.FINE, "{0} {1} with {2} and ''current'' tube {3} from thread {4} with Packet: {5}", new Object[]{this.getName(), string, var4_7, string7, Thread.currentThread().getName(), this.packet != null ? this.packet.toShortString() : null});
        }
    }

    public void start(@NotNull Tube tube, @NotNull Packet packet, @Nullable CompletionCallback completionCallback, boolean bl) {
        this.next = tube;
        this.packet = packet;
        this.completionCallback = completionCallback;
        if (bl) {
            this.startedSync = true;
            this.dumpFiberContext("starting (sync)");
            this.run();
        } else {
            this.started = true;
            this.dumpFiberContext("starting (async)");
            this.owner.addRunnable(this);
        }
    }

    public void resume(@NotNull Packet packet) {
        this.resume(packet, false);
    }

    public void resume(@NotNull Packet packet, boolean bl) {
        this.resume(packet, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(@NotNull Packet packet, boolean bl, CompletionCallback completionCallback) {
        this.lock.lock();
        try {
            if (completionCallback != null) {
                this.setCompletionCallback(completionCallback);
            }
            if (Fiber.isTraceEnabled()) {
                LOGGER.log(Level.FINE, "{0} resuming. Will have suspendedCount={1}", new Object[]{this.getName(), this.suspendedCount - 1});
            }
            this.packet = packet;
            if (--this.suspendedCount == 0) {
                if (!this.isInsideSuspendCallbacks) {
                    List<Listener> list = this.getCurrentListeners();
                    for (Listener listener : list) {
                        try {
                            listener.fiberResumed(this);
                        }
                        catch (Throwable throwable) {
                            if (!Fiber.isTraceEnabled()) continue;
                            LOGGER.log(Level.FINE, "Listener {0} threw exception: {1}", new Object[]{listener, throwable.getMessage()});
                        }
                    }
                    if (this.synchronous) {
                        this.condition.signalAll();
                    } else if (bl || this.startedSync) {
                        this.run();
                    } else {
                        this.dumpFiberContext("resuming (async)");
                        this.owner.addRunnable(this);
                    }
                }
            } else if (Fiber.isTraceEnabled()) {
                LOGGER.log(Level.FINE, "{0} taking no action on resume because suspendedCount != 0: {1}", new Object[]{this.getName(), this.suspendedCount});
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resumeAndReturn(@NotNull Packet packet, boolean bl) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.log(Level.FINE, "{0} resumed with Return Packet", this.getName());
        }
        this.next = null;
        this.resume(packet, bl);
    }

    public void resume(@NotNull Throwable throwable) {
        this.resume(throwable, this.packet, false);
    }

    public void resume(@NotNull Throwable throwable, @NotNull Packet packet) {
        this.resume(throwable, packet, false);
    }

    public void resume(@NotNull Throwable throwable, boolean bl) {
        this.resume(throwable, this.packet, bl);
    }

    public void resume(@NotNull Throwable throwable, @NotNull Packet packet, boolean bl) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.log(Level.FINE, "{0} resumed with Return Throwable", this.getName());
        }
        this.next = null;
        this.throwable = throwable;
        this.resume(packet, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(boolean bl) {
        this.isCanceled = true;
        if (bl) {
            Fiber fiber = this;
            synchronized (fiber) {
                if (this.currentThread != null) {
                    this.currentThread.interrupt();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean suspend(Holder<Boolean> holder, Runnable runnable) {
        if (Fiber.isTraceEnabled()) {
            LOGGER.log(Level.FINE, "{0} suspending. Will have suspendedCount={1}", new Object[]{this.getName(), this.suspendedCount + 1});
            if (this.suspendedCount > 0) {
                LOGGER.log(Level.FINE, "WARNING - {0} suspended more than resumed. Will require more than one resume to actually resume this fiber.", this.getName());
            }
        }
        List<Listener> list = this.getCurrentListeners();
        if (++this.suspendedCount == 1) {
            this.isInsideSuspendCallbacks = true;
            try {
                for (Listener listener : list) {
                    try {
                        listener.fiberSuspended(this);
                    }
                    catch (Throwable throwable) {
                        if (!Fiber.isTraceEnabled()) continue;
                        LOGGER.log(Level.FINE, "Listener {0} threw exception: {1}", new Object[]{listener, throwable.getMessage()});
                    }
                }
            }
            finally {
                this.isInsideSuspendCallbacks = false;
            }
        }
        if (this.suspendedCount <= 0) {
            for (Listener listener : list) {
                try {
                    listener.fiberResumed(this);
                }
                catch (Throwable throwable) {
                    if (!Fiber.isTraceEnabled()) continue;
                    LOGGER.log(Level.FINE, "Listener {0} threw exception: {1}", new Object[]{listener, throwable.getMessage()});
                }
            }
        } else if (runnable != null) {
            if (!this.synchronous) {
                Fiber fiber = this;
                synchronized (fiber) {
                    this.currentThread = null;
                }
                this.lock.unlock();
                assert (!this.lock.isHeldByCurrentThread());
                holder.value = Boolean.FALSE;
                try {
                    runnable.run();
                }
                catch (Throwable throwable) {
                    throw new OnExitRunnableException(throwable);
                }
                return true;
            }
            if (Fiber.isTraceEnabled()) {
                LOGGER.fine("onExitRunnable used with synchronous Fiber execution -- not exiting current thread");
            }
            runnable.run();
        }
        return false;
    }

    public synchronized void addInterceptor(@NotNull FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<FiberContextSwitchInterceptor>();
        } else {
            ArrayList<FiberContextSwitchInterceptor> arrayList = new ArrayList<FiberContextSwitchInterceptor>();
            arrayList.addAll(this.interceptors);
            this.interceptors = arrayList;
        }
        this.interceptors.add(fiberContextSwitchInterceptor);
    }

    public synchronized boolean removeInterceptor(@NotNull FiberContextSwitchInterceptor fiberContextSwitchInterceptor) {
        if (this.interceptors != null) {
            boolean bl = this.interceptors.remove(fiberContextSwitchInterceptor);
            if (this.interceptors.isEmpty()) {
                this.interceptors = null;
            } else {
                ArrayList<FiberContextSwitchInterceptor> arrayList = new ArrayList<FiberContextSwitchInterceptor>();
                arrayList.addAll(this.interceptors);
                this.interceptors = arrayList;
            }
            return bl;
        }
        return false;
    }

    @Nullable
    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public ClassLoader setContextClassLoader(@Nullable ClassLoader classLoader) {
        ClassLoader classLoader2 = this.contextClassLoader;
        this.contextClassLoader = classLoader;
        return classLoader2;
    }

    @Override
    @Deprecated
    public void run() {
        Container container = ContainerResolver.getDefault().enterContainer(this.owner.getContainer());
        try {
            assert (!this.synchronous);
            if (!this.doRun()) {
                if (this.startedSync && this.suspendedCount == 0 && (this.next != null || this.contsSize > 0)) {
                    this.startedSync = false;
                    this.dumpFiberContext("restarting (async) after startSync");
                    this.owner.addRunnable(this);
                } else {
                    this.completionCheck();
                }
            }
        }
        finally {
            ContainerResolver.getDefault().exitContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Packet runSync(@NotNull Tube tube, @NotNull Packet packet) {
        this.lock.lock();
        try {
            Tube[] tubeArray = this.conts;
            int n = this.contsSize;
            boolean bl = this.synchronous;
            Tube tube2 = this.next;
            if (n > 0) {
                this.conts = new Tube[16];
                this.contsSize = 0;
            }
            try {
                this.synchronous = true;
                this.packet = packet;
                this.next = tube;
                this.doRun();
                if (this.throwable != null) {
                    if (this.isDeliverThrowableInPacket) {
                        this.packet.addSatellite(new ThrowableContainerPropertySet(this.throwable));
                    } else {
                        if (this.throwable instanceof RuntimeException) {
                            throw (RuntimeException)this.throwable;
                        }
                        if (this.throwable instanceof Error) {
                            throw (Error)this.throwable;
                        }
                        throw new AssertionError((Object)this.throwable);
                    }
                }
                Packet packet2 = this.packet;
                this.conts = tubeArray;
                this.contsSize = n;
                this.synchronous = bl;
                this.next = tube2;
                if (this.interrupted) {
                    Thread.currentThread().interrupt();
                    this.interrupted = false;
                }
                if (!this.started && !this.startedSync) {
                    this.completionCheck();
                }
                return packet2;
            }
            catch (Throwable throwable) {
                this.conts = tubeArray;
                this.contsSize = n;
                this.synchronous = bl;
                this.next = tube2;
                if (this.interrupted) {
                    Thread.currentThread().interrupt();
                    this.interrupted = false;
                }
                if (!this.started && !this.startedSync) {
                    this.completionCheck();
                }
                throw throwable;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completionCheck() {
        this.lock.lock();
        try {
            if (!this.isCanceled && this.contsSize == 0 && this.suspendedCount == 0) {
                if (Fiber.isTraceEnabled()) {
                    LOGGER.log(Level.FINE, "{0} completed", this.getName());
                }
                this.clearListeners();
                this.condition.signalAll();
                if (this.completionCallback != null) {
                    if (this.throwable != null) {
                        if (this.isDeliverThrowableInPacket) {
                            this.packet.addSatellite(new ThrowableContainerPropertySet(this.throwable));
                            this.completionCallback.onCompletion(this.packet);
                        } else {
                            this.completionCallback.onCompletion(this.throwable);
                        }
                    } else {
                        this.completionCallback.onCompletion(this.packet);
                    }
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean doRun() {
        this.dumpFiberContext("running");
        if (serializeExecution) {
            serializedExecutionLock.lock();
            try {
                boolean bl = this._doRun(this.next);
                return bl;
            }
            finally {
                serializedExecutionLock.unlock();
            }
        }
        return this._doRun(this.next);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _doRun(Tube tube) {
        Holder<Boolean> holder = new Holder<Boolean>(Boolean.TRUE);
        this.lock.lock();
        try {
            Object object;
            ClassLoader classLoader;
            List<FiberContextSwitchInterceptor> list;
            Fiber fiber = this;
            synchronized (fiber) {
                list = this.interceptors;
                this.currentThread = Thread.currentThread();
                if (Fiber.isTraceEnabled()) {
                    LOGGER.log(Level.FINE, "Thread entering _doRun(): {0}", this.currentThread);
                }
                classLoader = this.currentThread.getContextClassLoader();
                this.currentThread.setContextClassLoader(this.contextClassLoader);
            }
            try {
                boolean bl;
                do {
                    if (list == null) {
                        this.next = tube;
                        if (this.__doRun(holder, null)) {
                            boolean bl2 = true;
                            return bl2;
                        }
                    } else if ((tube = new InterceptorHandler(holder, list).invoke(tube)) == PLACEHOLDER) {
                        boolean bl3 = true;
                        return bl3;
                    }
                    object = this;
                    synchronized (object) {
                        boolean bl4 = bl = list != this.interceptors;
                        if (bl) {
                            list = this.interceptors;
                        }
                    }
                } while (bl);
            }
            catch (OnExitRunnableException onExitRunnableException) {
                object = onExitRunnableException.target;
                if (!(object instanceof WebServiceException)) throw new WebServiceException((Throwable)object);
                throw (WebServiceException)object;
            }
            finally {
                Thread thread = Thread.currentThread();
                thread.setContextClassLoader(classLoader);
                if (Fiber.isTraceEnabled()) {
                    LOGGER.log(Level.FINE, "Thread leaving _doRun(): {0}", thread);
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (((Boolean)holder.value).booleanValue()) {
                Runnable runnable = this;
                synchronized (runnable) {
                    this.currentThread = null;
                }
                this.lock.unlock();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private boolean __doRun(Holder<Boolean> var1_1, List<FiberContextSwitchInterceptor> var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void pushCont(Tube tube) {
        this.conts[this.contsSize++] = tube;
        int n = this.conts.length;
        if (this.contsSize == n) {
            Tube[] tubeArray = new Tube[n * 2];
            System.arraycopy(this.conts, 0, tubeArray, 0, n);
            this.conts = tubeArray;
        }
    }

    private Tube popCont() {
        return this.conts[--this.contsSize];
    }

    private Tube peekCont() {
        int n = this.contsSize - 1;
        if (n >= 0 && n < this.conts.length) {
            return this.conts[n];
        }
        return null;
    }

    public void resetCont(Tube[] tubeArray, int n) {
        this.conts = tubeArray;
        this.contsSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isReady(List<FiberContextSwitchInterceptor> list) {
        if (this.synchronous) {
            while (this.suspendedCount == 1) {
                try {
                    if (Fiber.isTraceEnabled()) {
                        LOGGER.log(Level.FINE, "{0} is blocking thread {1}", new Object[]{this.getName(), Thread.currentThread().getName()});
                    }
                    this.condition.await();
                }
                catch (InterruptedException interruptedException) {
                    this.interrupted = true;
                }
            }
            Fiber fiber = this;
            synchronized (fiber) {
                return this.interceptors == list;
            }
        }
        if (this.suspendedCount > 0) {
            return false;
        }
        Fiber fiber = this;
        synchronized (fiber) {
            return this.interceptors == list;
        }
    }

    private String getName() {
        return "engine-" + this.owner.id + "fiber-" + this.id;
    }

    public String toString() {
        return this.getName();
    }

    @Nullable
    public Packet getPacket() {
        return this.packet;
    }

    public CompletionCallback getCompletionCallback() {
        return this.completionCallback;
    }

    public void setCompletionCallback(CompletionCallback completionCallback) {
        this.completionCallback = completionCallback;
    }

    public static boolean isSynchronous() {
        return Fiber.current().synchronous;
    }

    public boolean isStartedSync() {
        return this.startedSync;
    }

    @NotNull
    public static Fiber current() {
        Fiber fiber = CURRENT_FIBER.get();
        if (fiber == null) {
            throw new IllegalStateException("Can be only used from fibers");
        }
        return fiber;
    }

    public static Fiber getCurrentIfSet() {
        return CURRENT_FIBER.get();
    }

    private static boolean isTraceEnabled() {
        return LOGGER.isLoggable(Level.FINE);
    }

    @Override
    public <S> S getSPI(Class<S> clazz) {
        for (Component component : this.components) {
            S s = component.getSPI(clazz);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Override
    public Set<Component> getComponents() {
        return this.components;
    }

    public static interface CompletionCallback {
        public void onCompletion(@NotNull Packet var1);

        public void onCompletion(@NotNull Throwable var1);
    }

    private class InterceptorHandler
    implements FiberContextSwitchInterceptor.Work<Tube, Tube> {
        private final Holder<Boolean> isUnlockRequired;
        private final List<FiberContextSwitchInterceptor> ints;
        private int idx;

        public InterceptorHandler(Holder<Boolean> holder, List<FiberContextSwitchInterceptor> list) {
            this.isUnlockRequired = holder;
            this.ints = list;
        }

        Tube invoke(Tube tube) {
            this.idx = 0;
            return this.execute(tube);
        }

        @Override
        public Tube execute(Tube tube) {
            if (this.idx == this.ints.size()) {
                Fiber.this.next = tube;
                if (Fiber.this.__doRun(this.isUnlockRequired, this.ints)) {
                    return PLACEHOLDER;
                }
            } else {
                FiberContextSwitchInterceptor fiberContextSwitchInterceptor = this.ints.get(this.idx++);
                return fiberContextSwitchInterceptor.execute(Fiber.this, tube, this);
            }
            return Fiber.this.next;
        }
    }

    public static interface Listener {
        public void fiberSuspended(Fiber var1);

        public void fiberResumed(Fiber var1);
    }

    private static final class OnExitRunnableException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        Throwable target;

        public OnExitRunnableException(Throwable throwable) {
            super((Throwable)null);
            this.target = throwable;
        }
    }

    private static class PlaceholderTube
    extends AbstractTubeImpl {
        private PlaceholderTube() {
        }

        @Override
        public NextAction processRequest(Packet packet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NextAction processResponse(Packet packet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public NextAction processException(Throwable throwable) {
            return this.doThrow(throwable);
        }

        @Override
        public void preDestroy() {
        }

        @Override
        public PlaceholderTube copy(TubeCloner tubeCloner) {
            throw new UnsupportedOperationException();
        }
    }
}

