/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import com.sun.jndi.toolkit.url.UrlUtil;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CannotProceedException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ResolveResult;

public abstract class GenericURLContext
implements Context {
    protected Hashtable<String, Object> myEnv = null;

    public GenericURLContext(Hashtable<?, ?> hashtable) {
        this.myEnv = (Hashtable)(hashtable == null ? null : hashtable.clone());
    }

    @Override
    public void close() throws NamingException {
        this.myEnv = null;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    protected abstract ResolveResult getRootURLContext(String var1, Hashtable<?, ?> var2) throws NamingException;

    protected Name getURLSuffix(String string, String string2) throws NamingException {
        String string3 = string2.substring(string.length());
        if (string3.length() == 0) {
            return new CompositeName();
        }
        if (string3.charAt(0) == '/') {
            string3 = string3.substring(1);
        }
        try {
            return new CompositeName().add(UrlUtil.decode(string3));
        }
        catch (MalformedURLException malformedURLException) {
            throw new InvalidNameException(malformedURLException.getMessage());
        }
    }

    protected String getURLPrefix(String string) throws NamingException {
        int n = string.indexOf(":");
        if (n < 0) {
            throw new OperationNotSupportedException("Invalid URL: " + string);
        }
        if (string.startsWith("//", ++n)) {
            int n2 = string.indexOf("/", n += 2);
            n = n2 >= 0 ? n2 : string.length();
        }
        return string.substring(0, n);
    }

    protected boolean urlEquals(String string, String string2) {
        return string.equals(string2);
    }

    protected Context getContinuationContext(Name name) throws NamingException {
        Object object = this.lookup(name.get(0));
        CannotProceedException cannotProceedException = new CannotProceedException();
        cannotProceedException.setResolvedObj(object);
        cannotProceedException.setEnvironment(this.myEnv);
        return NamingManager.getContinuationContext(cannotProceedException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            Object object = context.lookup(resolveResult.getRemainingName());
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookup(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookup(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            Object object = context.lookup(name.getSuffix(1));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            context.bind(resolveResult.getRemainingName(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.bind(name.get(0), object);
        } else {
            try (Context context = this.getContinuationContext(name);){
                context.bind(name.getSuffix(1), object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(String string, Object object) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            context.rebind(resolveResult.getRemainingName(), object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (name.size() == 1) {
            this.rebind(name.get(0), object);
        } else {
            try (Context context = this.getContinuationContext(name);){
                context.rebind(name.getSuffix(1), object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbind(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            context.unbind(resolveResult.getRemainingName());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (name.size() == 1) {
            this.unbind(name.get(0));
        } else {
            try (Context context = this.getContinuationContext(name);){
                context.unbind(name.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(String string, String string2) throws NamingException {
        String string3;
        String string4 = this.getURLPrefix(string);
        if (!this.urlEquals(string4, string3 = this.getURLPrefix(string2))) {
            throw new OperationNotSupportedException("Renaming using different URL prefixes not supported : " + string + " " + string2);
        }
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            context.rename(resolveResult.getRemainingName(), this.getURLSuffix(string3, string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (name.size() == 1) {
            if (name2.size() != 1) {
                throw new OperationNotSupportedException("Renaming to a Name with more components not supported: " + name2);
            }
            this.rename(name.get(0), name2.get(0));
        } else {
            if (!this.urlEquals(name.get(0), name2.get(0))) {
                throw new OperationNotSupportedException("Renaming using different URLs as first components not supported: " + name + " " + name2);
            }
            try (Context context = this.getContinuationContext(name);){
                context.rename(name.getSuffix(1), name2.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(resolveResult.getRemainingName());
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.list(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            NamingEnumeration<NameClassPair> namingEnumeration = context.list(name.getSuffix(1));
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(resolveResult.getRemainingName());
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.listBindings(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            NamingEnumeration<Binding> namingEnumeration = context.listBindings(name.getSuffix(1));
            return namingEnumeration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroySubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            context.destroySubcontext(resolveResult.getRemainingName());
        }
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            this.destroySubcontext(name.get(0));
        } else {
            try (Context context = this.getContinuationContext(name);){
                context.destroySubcontext(name.getSuffix(1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            Context context2 = context.createSubcontext(resolveResult.getRemainingName());
            return context2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.createSubcontext(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            Context context2 = context.createSubcontext(name.getSuffix(1));
            return context2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            Object object = context.lookupLink(resolveResult.getRemainingName());
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.lookupLink(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            Object object = context.lookupLink(name.getSuffix(1));
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(String string) throws NamingException {
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (Context context = (Context)resolveResult.getResolvedObj();){
            NameParser nameParser = context.getNameParser(resolveResult.getRemainingName());
            return nameParser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (name.size() == 1) {
            return this.getNameParser(name.get(0));
        }
        try (Context context = this.getContinuationContext(name);){
            NameParser nameParser = context.getNameParser(name.getSuffix(1));
            return nameParser;
        }
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        if (string2.equals("")) {
            return string;
        }
        if (string.equals("")) {
            return string2;
        }
        return string2 + "/" + string;
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(string);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (this.myEnv == null) {
            this.myEnv = new Hashtable(11, 0.75f);
        }
        return this.myEnv.put(string, object);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        if (this.myEnv == null) {
            return new Hashtable<String, Object>(5, 0.75f);
        }
        return (Hashtable)this.myEnv.clone();
    }
}

