/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.Builder;
import sun.security.provider.certpath.CertPathHelper;
import sun.security.provider.certpath.CrlRevocationChecker;
import sun.security.provider.certpath.ForwardState;
import sun.security.provider.certpath.KeyChecker;
import sun.security.provider.certpath.LDAPCertStore;
import sun.security.provider.certpath.State;
import sun.security.util.Debug;
import sun.security.x509.AccessDescription;
import sun.security.x509.AuthorityInfoAccessExtension;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ForwardBuilder
extends Builder {
    private static final Debug debug = Debug.getInstance("certpath");
    private Date date;
    private final Set<X509Certificate> trustedCerts;
    private final Set<X500Principal> trustedSubjectDNs;
    private final Set<TrustAnchor> trustAnchors;
    private X509CertSelector eeSelector;
    private LDAPCertStore.LDAPCertSelector caSelector;
    private X509CertSelector caTargetSelector;
    TrustAnchor trustAnchor;
    private Comparator<X509Certificate> comparator;
    private boolean searchAllCertStores = true;

    ForwardBuilder(PKIXBuilderParameters pKIXBuilderParameters, X500Principal x500Principal, boolean bl) {
        super(pKIXBuilderParameters, x500Principal);
        this.date = pKIXBuilderParameters.getDate();
        if (this.date == null) {
            this.date = new Date();
        }
        this.trustAnchors = pKIXBuilderParameters.getTrustAnchors();
        this.trustedCerts = new HashSet<X509Certificate>(this.trustAnchors.size());
        this.trustedSubjectDNs = new HashSet<X500Principal>(this.trustAnchors.size());
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            X509Certificate x509Certificate = trustAnchor.getTrustedCert();
            if (x509Certificate != null) {
                this.trustedCerts.add(x509Certificate);
                this.trustedSubjectDNs.add(x509Certificate.getSubjectX500Principal());
                continue;
            }
            this.trustedSubjectDNs.add(CertPathHelper.getCA(trustAnchor));
        }
        this.comparator = new PKIXCertComparator(this.trustedSubjectDNs);
        this.searchAllCertStores = bl;
    }

    @Override
    Collection<X509Certificate> getMatchingCerts(State state, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCerts()...");
        }
        ForwardState forwardState = (ForwardState)state;
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        if (forwardState.isInitial()) {
            arrayList.addAll(this.getMatchingEECerts(forwardState, list));
        }
        arrayList.addAll(this.getMatchingCACerts(forwardState, list));
        Collections.sort(arrayList, this.comparator);
        return arrayList;
    }

    private Collection<X509Certificate> getMatchingEECerts(ForwardState forwardState, List<CertStore> list) throws CertStoreException, CertificateException, IOException {
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingEECerts()...");
        }
        if (this.eeSelector == null) {
            this.eeSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
            this.eeSelector.setCertificateValid(this.date);
            if (this.buildParams.isExplicitPolicyRequired()) {
                this.eeSelector.setPolicy(this.getMatchingPolicies());
            }
            this.eeSelector.setBasicConstraints(-2);
        }
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        this.addMatchingCerts(this.eeSelector, list, hashSet, this.searchAllCertStores);
        return hashSet;
    }

    private Collection<X509Certificate> getMatchingCACerts(ForwardState forwardState, List<CertStore> list) throws CertificateException, CertStoreException, IOException {
        X509CertSelector x509CertSelector;
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts()...");
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        X509CertSelector x509CertSelector2 = null;
        if (forwardState.isInitial()) {
            x509CertSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
            if (x509CertSelector.getBasicConstraints() == -2) {
                return arrayList;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts(): ca is target");
            }
            if (this.caTargetSelector == null) {
                this.caTargetSelector = x509CertSelector;
                this.caTargetSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caTargetSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            this.caTargetSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector2 = this.caTargetSelector;
        } else {
            if (this.caSelector == null) {
                this.caSelector = new LDAPCertStore.LDAPCertSelector();
                this.caSelector.setCertificateValid(this.date);
                if (this.buildParams.isExplicitPolicyRequired()) {
                    this.caSelector.setPolicy(this.getMatchingPolicies());
                }
            }
            CertPathHelper.setSubject(this.caSelector, forwardState.issuerDN);
            CertPathHelper.setPathToNames(this.caSelector, forwardState.subjectNamesTraversed);
            this.caSelector.setBasicConstraints(forwardState.traversedCACerts);
            x509CertSelector2 = this.caSelector;
        }
        x509CertSelector = new X509CertSelector();
        if (forwardState.isInitial()) {
            x509CertSelector = (X509CertSelector)this.buildParams.getTargetCertConstraints();
        } else {
            CertPathHelper.setSubject(x509CertSelector, forwardState.issuerDN);
        }
        Object object = this.trustedCerts.iterator();
        while (object.hasNext()) {
            X509Certificate x509Certificate = object.next();
            if (!x509CertSelector.match(x509Certificate)) continue;
            if (debug != null) {
                debug.println("ForwardBuilder.getMatchingCACerts: found matching trust anchor");
            }
            arrayList.add(x509Certificate);
        }
        if (!this.searchAllCertStores && !arrayList.isEmpty()) {
            return arrayList;
        }
        if (forwardState.isInitial() || this.buildParams.getMaxPathLength() == -1 || this.buildParams.getMaxPathLength() > forwardState.traversedCACerts) {
            this.addMatchingCerts(x509CertSelector2, list, arrayList, this.searchAllCertStores);
        }
        if (!this.searchAllCertStores && !arrayList.isEmpty()) {
            return arrayList;
        }
        if (!forwardState.isInitial() && (object = forwardState.cert.getAuthorityInfoAccessExtension()) != null) {
            arrayList.addAll(this.getCerts((AuthorityInfoAccessExtension)object));
        }
        if (debug != null) {
            debug.println("ForwardBuilder.getMatchingCACerts: found " + arrayList.size() + " forward certs");
        }
        return arrayList;
    }

    private Collection<X509Certificate> getCerts(AuthorityInfoAccessExtension authorityInfoAccessExtension) {
        if (debug != null) {
            debug.println("ForwardBuilder.getCerts: checking AIA ext");
        }
        if (!Builder.USE_AIA) {
            return Collections.emptyList();
        }
        List<AccessDescription> list = authorityInfoAccessExtension.getAccessDescriptions();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (AccessDescription accessDescription : list) {
            Collection<? extends Certificate> collection;
            block8: {
                URI uRI;
                GeneralNameInterface generalNameInterface;
                if (!accessDescription.getAccessMethod().equals(AccessDescription.Ad_CAISSUERS_Id) || !((generalNameInterface = accessDescription.getAccessLocation().getName()) instanceof URIName) || !(uRI = ((URIName)generalNameInterface).getURI()).getScheme().equals("ldap")) continue;
                String string = uRI.getPath();
                if (debug != null) {
                    debug.println("ForwardBuilder.getCerts: AIA ext URIName:");
                    debug.println("authority: " + uRI.getAuthority());
                    debug.println("path: " + string);
                }
                if (string.charAt(0) == '/') {
                    string = string.substring(1);
                }
                collection = null;
                try {
                    CertStore certStore = LDAPCertStore.getInstance(LDAPCertStore.getParameters(uRI));
                    LDAPCertStore.LDAPCertSelector lDAPCertSelector = (LDAPCertStore.LDAPCertSelector)this.caSelector.clone();
                    lDAPCertSelector.setCertSubject(lDAPCertSelector.getSubject());
                    lDAPCertSelector.setSubject(string);
                    collection = certStore.getCertificates(lDAPCertSelector);
                    if (debug == null) break block8;
                    debug.println("ForwardBuilder.getCerts(AIA): found " + collection.size() + " certs");
                }
                catch (Exception exception) {
                    if (debug == null) continue;
                    debug.println("ForwardBuilder.getCerts(AIA): exception while fetching certs from CertStore: " + exception);
                    exception.printStackTrace();
                    continue;
                }
            }
            arrayList.addAll(collection);
            if (this.searchAllCertStores || arrayList.isEmpty()) continue;
            return arrayList;
        }
        return arrayList;
    }

    @Override
    void verifyCert(X509Certificate x509Certificate, State state, List<X509Certificate> list) throws GeneralSecurityException {
        Object object;
        boolean bl;
        if (debug != null) {
            debug.println("ForwardBuilder.verifyCert(SN: " + Debug.toHexString(x509Certificate.getSerialNumber()) + "\n  Issuer: " + x509Certificate.getIssuerX500Principal() + ")" + "\n  Subject: " + x509Certificate.getSubjectX500Principal() + ")");
        }
        ForwardState forwardState = (ForwardState)state;
        forwardState.untrustedChecker.check(x509Certificate, Collections.<String>emptySet());
        if (list != null) {
            bl = false;
            for (X509Certificate object2 : list) {
                X509CertImpl x509CertImpl = X509CertImpl.toImpl(object2);
                object = x509CertImpl.getPolicyMappingsExtension();
                if (object != null) {
                    bl = true;
                }
                if (debug != null) {
                    debug.println("policyMappingFound = " + bl);
                }
                if (!x509Certificate.equals(object2) || !this.buildParams.isPolicyMappingInhibited() && bl) continue;
                if (debug != null) {
                    debug.println("loop detected!!");
                }
                throw new CertPathValidatorException("loop detected");
            }
        }
        if (!(bl = this.isTrustedCert(x509Certificate))) {
            AlgorithmChecker.check(x509Certificate);
            Set<String> set = x509Certificate.getCriticalExtensionOIDs();
            if (set == null) {
                set = Collections.emptySet();
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : forwardState.forwardCheckers) {
                pKIXCertPathChecker.check(x509Certificate, set);
            }
            for (PKIXCertPathChecker pKIXCertPathChecker : this.buildParams.getCertPathCheckers()) {
                if (pKIXCertPathChecker.isForwardCheckingSupported() || (object = pKIXCertPathChecker.getSupportedExtensions()) == null) continue;
                set.removeAll((Collection<?>)object);
            }
            if (!set.isEmpty()) {
                set.remove(PKIXExtensions.BasicConstraints_Id.toString());
                set.remove(PKIXExtensions.NameConstraints_Id.toString());
                set.remove(PKIXExtensions.CertificatePolicies_Id.toString());
                set.remove(PKIXExtensions.PolicyMappings_Id.toString());
                set.remove(PKIXExtensions.PolicyConstraints_Id.toString());
                set.remove(PKIXExtensions.InhibitAnyPolicy_Id.toString());
                set.remove(PKIXExtensions.SubjectAlternativeName_Id.toString());
                set.remove(PKIXExtensions.KeyUsage_Id.toString());
                set.remove(PKIXExtensions.ExtendedKeyUsage_Id.toString());
                if (!set.isEmpty()) {
                    throw new CertificateException("Unrecognized critical extension(s)");
                }
            }
        }
        if (forwardState.isInitial()) {
            return;
        }
        if (!bl) {
            if (x509Certificate.getBasicConstraints() == -1) {
                throw new CertificateException("cert is NOT a CA cert");
            }
            KeyChecker.verifyCAKeyUsage(x509Certificate);
        }
        if (this.buildParams.isRevocationEnabled() && forwardState.crlChecker.certCanSignCrl(x509Certificate) && !forwardState.keyParamsNeeded()) {
            forwardState.crlChecker.check(forwardState.cert, x509Certificate.getPublicKey(), true);
        }
        if (!forwardState.keyParamsNeeded()) {
            forwardState.cert.verify(x509Certificate.getPublicKey(), this.buildParams.getSigProvider());
        }
    }

    @Override
    boolean isPathCompleted(X509Certificate x509Certificate) {
        for (TrustAnchor trustAnchor : this.trustAnchors) {
            if (trustAnchor.getTrustedCert() != null) {
                if (!x509Certificate.equals(trustAnchor.getTrustedCert())) continue;
                this.trustAnchor = trustAnchor;
                return true;
            }
            X500Principal x500Principal = CertPathHelper.getCA(trustAnchor);
            if (!x500Principal.equals(x509Certificate.getIssuerX500Principal())) continue;
            if (this.buildParams.isRevocationEnabled()) {
                try {
                    CrlRevocationChecker crlRevocationChecker = new CrlRevocationChecker(trustAnchor.getCAPublicKey(), this.buildParams);
                    crlRevocationChecker.check(x509Certificate, trustAnchor.getCAPublicKey(), true);
                }
                catch (CertPathValidatorException certPathValidatorException) {
                    if (debug == null) continue;
                    debug.println("ForwardBuilder.isPathCompleted() cpve");
                    certPathValidatorException.printStackTrace();
                    continue;
                }
                catch (Exception exception) {
                    if (debug == null) continue;
                    debug.println("ForwardBuilder.isPathCompleted() unexpected exception");
                    exception.printStackTrace();
                    continue;
                }
            }
            try {
                x509Certificate.verify(trustAnchor.getCAPublicKey(), this.buildParams.getSigProvider());
            }
            catch (InvalidKeyException invalidKeyException) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() invalid DSA key found");
                continue;
            }
            catch (Exception exception) {
                if (debug == null) continue;
                debug.println("ForwardBuilder.isPathCompleted() 2 unexpected exception");
                exception.printStackTrace();
                continue;
            }
            this.trustAnchor = trustAnchor;
            return true;
        }
        return false;
    }

    boolean isTrustedCert(X509Certificate x509Certificate) {
        return this.trustedCerts.contains(x509Certificate);
    }

    @Override
    void addCertToPath(X509Certificate x509Certificate, LinkedList<X509Certificate> linkedList) {
        linkedList.addFirst(x509Certificate);
    }

    @Override
    void removeFinalCertFromPath(LinkedList<X509Certificate> linkedList) {
        linkedList.removeFirst();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PKIXCertComparator
    implements Comparator<X509Certificate> {
        static final String METHOD_NME = "ForwardBuilder.PKIXCertComparator.compare()";
        private final Set<X500Principal> trustedSubjectDNs;

        PKIXCertComparator(Set<X500Principal> set) {
            this.trustedSubjectDNs = set;
        }

        @Override
        public int compare(X509Certificate x509Certificate, X509Certificate x509Certificate2) {
            int n;
            int n2;
            X500Principal x500Principal4;
            X500Principal x500Principal2 = x509Certificate.getIssuerX500Principal();
            X500Principal x500Principal3 = x509Certificate2.getIssuerX500Principal();
            X500Name x500Name = X500Name.asX500Name(x500Principal2);
            X500Name x500Name2 = X500Name.asX500Name(x500Principal3);
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Issuer:  " + x500Principal2.toString());
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Issuer:  " + x500Principal3.toString());
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() MATCH TRUSTED SUBJECT TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                boolean bl = x500Principal2.equals(x500Principal4);
                n2 = x500Principal3.equals(x500Principal4);
                if (bl && n2 != 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() m1 && m2; RETURN 0");
                    }
                    return 0;
                }
                if (bl) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() m1; RETURN -1");
                    }
                    return -1;
                }
                if (n2 == 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() m2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING DESCENDANT TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                X500Name x500Name3 = X500Name.asX500Name(x500Principal4);
                try {
                    n2 = Builder.distance(x500Name3, x500Name);
                }
                catch (IOException iOException) {
                    n2 = -1;
                }
                try {
                    n = Builder.distance(x500Name3, x500Name2);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n2);
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n);
                }
                if (n2 <= 0 && n <= 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 || distanceTto2 > 0...");
                }
                if (n2 == n) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 == distanceTto2; RETURN 0");
                    }
                    return 0;
                }
                if (n2 > 0 && n <= 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > 0 && distanceTto2 <= 0); RETURN -1");
                    }
                    return -1;
                }
                if (n2 <= 0 && n > 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= 0 && distanceTto2 > 0; RETURN 1");
                    }
                    return 1;
                }
                if (n2 < n) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < distance Tto2; RETURN -1");
                    }
                    return -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() NAMING ANCESTOR TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                X500Name x500Name4 = X500Name.asX500Name(x500Principal4);
                n2 = 0;
                n = 0;
                try {
                    n2 = Builder.distance(x500Name4, x500Name);
                }
                catch (IOException iOException) {
                    n2 = Integer.MAX_VALUE;
                }
                try {
                    n = Builder.distance(x500Name4, x500Name2);
                }
                catch (IOException iOException) {
                    n = Integer.MAX_VALUE;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1: " + n2);
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto2: " + n);
                }
                if (n2 >= 0 && n >= 0) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 || distanceTto2 < 0...");
                }
                if (n2 == n) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distance==; RETURN 0");
                    }
                    return 0;
                }
                if (n2 < 0 && n >= 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 < 0 && distanceTto2 >= 0; RETURN -1");
                    }
                    return -1;
                }
                if (n2 >= 0 && n < 0) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 >= 0 && distanceTto2 < 0; RETURN 1");
                    }
                    return 1;
                }
                if (n2 > n) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 > distanceTto2; RETURN -1");
                    }
                    return -1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceTto1 <= distanceTto2; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() SAME NAMESPACE AS TRUSTED TEST...");
            }
            for (X500Principal x500Principal4 : this.trustedSubjectDNs) {
                X500Name x500Name5 = X500Name.asX500Name(x500Principal4);
                X500Name x500Name6 = x500Name5.commonAncestor(x500Name);
                X500Name x500Name7 = x500Name5.commonAncestor(x500Name2);
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1: " + String.valueOf(x500Name6));
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo2: " + String.valueOf(x500Name7));
                }
                if (x500Name6 == null && x500Name7 == null) continue;
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null || tAo2 != null...");
                }
                if (x500Name6 != null && x500Name7 != null) {
                    int n3;
                    int n4;
                    block73: {
                        block72: {
                            if (debug != null) {
                                debug.println("ForwardBuilder.PKIXCertComparator.compare() tAo1 != null && tAo2 != null...");
                            }
                            n4 = Integer.MAX_VALUE;
                            n3 = Integer.MAX_VALUE;
                            try {
                                n4 = Builder.hops(x500Name5, x500Name);
                            }
                            catch (IOException iOException) {
                                if (debug == null) break block72;
                                debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer1)");
                                iOException.printStackTrace();
                            }
                        }
                        try {
                            n3 = Builder.hops(x500Name5, x500Name2);
                        }
                        catch (IOException iOException) {
                            if (debug == null) break block73;
                            debug.println("ForwardBuilder.PKIXCertComparator.compare() exception in Builder.hops(tSubject, cIssuer2)");
                            iOException.printStackTrace();
                        }
                    }
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1: " + n4);
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto2: " + n3);
                    }
                    if (n4 == n3) {
                        if (debug == null) continue;
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 == hopsTto2; continue");
                        continue;
                    }
                    if (n4 > n3) {
                        if (debug != null) {
                            debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 > hopsTto2; RETURN 1");
                        }
                        return 1;
                    }
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() hopsTto1 < hopsTto2; RETURN -1");
                    }
                    return -1;
                }
                if (x500Name6 == null) {
                    if (debug != null) {
                        debug.println("ForwardBuilder.PKIXCertComparator.compare() tA01 == null; RETURN 1");
                    }
                    return 1;
                }
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() tA02 == null; RETURN -1");
                }
                return -1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() CERT ISSUER/SUBJECT COMPARISON TEST...");
            }
            X500Principal x500Principal5 = x509Certificate.getSubjectX500Principal();
            x500Principal4 = x509Certificate2.getSubjectX500Principal();
            X500Name x500Name8 = X500Name.asX500Name(x500Principal5);
            X500Name x500Name9 = X500Name.asX500Name(x500Principal4);
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o1 Subject: " + x500Principal5.toString());
                debug.println("ForwardBuilder.PKIXCertComparator.compare() o2 Subject: " + x500Principal4.toString());
            }
            int n5 = 0;
            int n6 = 0;
            try {
                n5 = Builder.distance(x500Name8, x500Name);
            }
            catch (IOException iOException) {
                n5 = Integer.MAX_VALUE;
            }
            try {
                n6 = Builder.distance(x500Name9, x500Name2);
            }
            catch (IOException iOException) {
                n6 = Integer.MAX_VALUE;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI1: " + n5);
                debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2: " + n6);
            }
            if (n6 > n5) {
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 > distanceStoI1; RETURN -1");
                }
                return -1;
            }
            if (n6 < n5) {
                if (debug != null) {
                    debug.println("ForwardBuilder.PKIXCertComparator.compare() distanceStoI2 < distanceStoI1; RETURN 1");
                }
                return 1;
            }
            if (debug != null) {
                debug.println("ForwardBuilder.PKIXCertComparator.compare() no tests matched; RETURN 0");
            }
            return 0;
        }
    }
}

