/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.peer.SystemTrayPeer;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.X11.Native;
import sun.awt.X11.XAtom;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XMSelection;
import sun.awt.X11.XMSelectionListener;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTrayIconPeer;
import sun.awt.X11.XlibWrapper;

public class XSystemTrayPeer
implements SystemTrayPeer,
XMSelectionListener {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XSystemTrayPeer");
    SystemTray target;
    static XSystemTrayPeer peerInstance;
    private volatile boolean available;
    private final XMSelection selection = new XMSelection("_NET_SYSTEM_TRAY");
    private static final int SCREEN = 0;
    private static final XAtom _NET_SYSTEM_TRAY;
    private static final XAtom _XEMBED_INFO;
    private static final XAtom _NET_SYSTEM_TRAY_OPCODE;
    private static final XAtom _NET_WM_ICON;
    private static final long SYSTEM_TRAY_REQUEST_DOCK = 0L;

    XSystemTrayPeer(SystemTray systemTray) {
        this.target = systemTray;
        peerInstance = this;
        this.selection.addSelectionListener(this);
        long l = this.selection.getOwner(0);
        this.available = l != 0L;
        log.fine(" check if system tray is available. selection owner: " + l);
    }

    public void ownerChanged(int n, XMSelection xMSelection, long l, long l2, long l3) {
        if (n != 0) {
            return;
        }
        if (!this.available) {
            this.available = true;
        } else {
            this.removeTrayPeers();
        }
        this.createTrayPeers();
    }

    public void ownerDeath(int n, XMSelection xMSelection, long l) {
        if (n != 0) {
            return;
        }
        if (this.available) {
            this.available = false;
            this.removeTrayPeers();
        }
    }

    public void selectionChanged(int n, XMSelection xMSelection, long l, XPropertyEvent xPropertyEvent) {
    }

    public Dimension getTrayIconSize() {
        return new Dimension(24, 24);
    }

    boolean isAvailable() {
        return this.available;
    }

    void dispose() {
        this.selection.removeSelectionListener(this);
    }

    void addTrayIcon(XTrayIconPeer xTrayIconPeer) throws AWTException {
        long l = this.selection.getOwner(0);
        log.fine(" send SYSTEM_TRAY_REQUEST_DOCK message to owner: " + l);
        if (l == 0L) {
            throw new AWTException("TrayIcon couldn't be displayed.");
        }
        long l2 = xTrayIconPeer.getWindow();
        long[] lArray = new long[]{0L, 1L};
        long l3 = Native.card32ToData(lArray);
        _XEMBED_INFO.setAtomData(l2, l3, lArray.length);
        this.sendMessage(l, 0L, l2, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendMessage(long l, long l2, long l3, long l4, long l5) {
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        try {
            xClientMessageEvent.set_type(33);
            xClientMessageEvent.set_window(l);
            xClientMessageEvent.set_format(32);
            xClientMessageEvent.set_message_type(_NET_SYSTEM_TRAY_OPCODE.getAtom());
            xClientMessageEvent.set_data(0, 0L);
            xClientMessageEvent.set_data(1, l2);
            xClientMessageEvent.set_data(2, l3);
            xClientMessageEvent.set_data(3, l4);
            xClientMessageEvent.set_data(4, l5);
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), l, false, 0L, xClientMessageEvent.pData);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        finally {
            xClientMessageEvent.dispose();
        }
    }

    static XSystemTrayPeer getPeerInstance() {
        return peerInstance;
    }

    private void createTrayPeers() {
        Runnable runnable = new Runnable(){

            public void run() {
                TrayIcon[] trayIconArray = XSystemTrayPeer.this.target.getTrayIcons();
                try {
                    for (TrayIcon trayIcon : trayIconArray) {
                        AWTAccessor.getTrayIconAccessor().addNotify(trayIcon);
                    }
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            }
        };
        this.invokeOnEachAppContext(runnable);
    }

    private void removeTrayPeers() {
        Runnable runnable = new Runnable(){

            public void run() {
                TrayIcon[] trayIconArray;
                for (TrayIcon trayIcon : trayIconArray = XSystemTrayPeer.this.target.getTrayIcons()) {
                    AWTAccessor.getTrayIconAccessor().removeNotify(trayIcon);
                }
            }
        };
        this.invokeOnEachAppContext(runnable);
    }

    private void invokeOnEachAppContext(Runnable runnable) {
        for (AppContext appContext : AppContext.getAppContexts()) {
            SunToolkit.invokeLaterOnAppContext(appContext, runnable);
        }
    }

    static {
        _NET_SYSTEM_TRAY = XAtom.get("_NET_SYSTEM_TRAY_S0");
        _XEMBED_INFO = XAtom.get("_XEMBED_INFO");
        _NET_SYSTEM_TRAY_OPCODE = XAtom.get("_NET_SYSTEM_TRAY_OPCODE");
        _NET_WM_ICON = XAtom.get("_NET_WM_ICON");
    }
}

