/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.utils;

import com.sun.org.apache.xerces.internal.utils.ConfigurationError;
import com.sun.org.apache.xerces.internal.utils.SecuritySupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

public final class ObjectFactory {
    private static final String DEFAULT_INTERNAL_CLASSES = "com.sun.org.apache.";
    private static final String DEFAULT_PROPERTIES_FILENAME = "xerces.properties";
    private static final boolean DEBUG = ObjectFactory.isDebugEnabled();
    private static final int DEFAULT_LINE_LENGTH = 80;
    private static Properties fXercesProperties = null;
    private static long fLastModified = -1L;

    public static Object createObject(String string, String string2) throws ConfigurationError {
        return ObjectFactory.createObject(string, null, string2);
    }

    public static Object createObject(String string, String string2, String string3) throws ConfigurationError {
        if (DEBUG) {
            ObjectFactory.debugPrintln("debug is on");
        }
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        try {
            String string4 = SecuritySupport.getSystemProperty(string);
            if (string4 != null && string4.length() > 0) {
                if (DEBUG) {
                    ObjectFactory.debugPrintln("found system property, value=" + string4);
                }
                return ObjectFactory.newInstance(string4, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string3 == null) {
            throw new ConfigurationError("Provider for " + string + " cannot be found", null);
        }
        if (DEBUG) {
            ObjectFactory.debugPrintln("using fallback, value=" + string3);
        }
        return ObjectFactory.newInstance(string3, classLoader, true);
    }

    private static boolean isDebugEnabled() {
        try {
            String string = SecuritySupport.getSystemProperty("xerces.debug");
            return string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    private static void debugPrintln(String string) {
        if (DEBUG) {
            System.err.println("XERCES: " + string);
        }
    }

    public static ClassLoader findClassLoader() throws ConfigurationError {
        ClassLoader classLoader;
        if (System.getSecurityManager() != null) {
            return null;
        }
        ClassLoader classLoader2 = SecuritySupport.getContextClassLoader();
        ClassLoader classLoader3 = classLoader = SecuritySupport.getSystemClassLoader();
        while (true) {
            if (classLoader2 == classLoader3) {
                ClassLoader classLoader4 = ObjectFactory.class.getClassLoader();
                classLoader3 = classLoader;
                while (true) {
                    if (classLoader4 == classLoader3) {
                        return classLoader;
                    }
                    if (classLoader3 == null) break;
                    classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
                }
                return classLoader4;
            }
            if (classLoader3 == null) break;
            classLoader3 = SecuritySupport.getParentClassLoader(classLoader3);
        }
        return classLoader2;
    }

    public static Object newInstance(String string, boolean bl) throws ConfigurationError {
        if (System.getSecurityManager() != null) {
            return ObjectFactory.newInstance(string, null, bl);
        }
        return ObjectFactory.newInstance(string, ObjectFactory.findClassLoader(), bl);
    }

    public static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class clazz = ObjectFactory.findProviderClass(string, classLoader, bl);
            Object t = clazz.newInstance();
            if (DEBUG) {
                ObjectFactory.debugPrintln("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return t;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    public static Class findProviderClass(String string, boolean bl) throws ClassNotFoundException, ConfigurationError {
        if (System.getSecurityManager() != null) {
            return Class.forName(string);
        }
        return ObjectFactory.findProviderClass(string, ObjectFactory.findClassLoader(), bl);
    }

    public static Class findProviderClass(String string, ClassLoader classLoader, boolean bl) throws ClassNotFoundException, ConfigurationError {
        Class<?> clazz;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (string.startsWith(DEFAULT_INTERNAL_CLASSES)) {
                classLoader = null;
            } else {
                int n = string.lastIndexOf(".");
                String string2 = string;
                if (n != -1) {
                    string2 = string.substring(0, n);
                }
                securityManager.checkPackageAccess(string2);
            }
        }
        if (classLoader == null) {
            clazz = Class.forName(string);
        } else {
            try {
                clazz = classLoader.loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl) {
                    ClassLoader classLoader2 = ObjectFactory.class.getClassLoader();
                    if (classLoader2 == null) {
                        clazz = Class.forName(string);
                    }
                    if (classLoader != classLoader2) {
                        classLoader = classLoader2;
                        clazz = classLoader.loadClass(string);
                    }
                    throw classNotFoundException;
                }
                throw classNotFoundException;
            }
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object findJarServiceProvider(String string) throws ConfigurationError {
        Object object;
        String string2 = "META-INF/services/" + string;
        InputStream inputStream = null;
        ClassLoader classLoader = ObjectFactory.findClassLoader();
        inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        if (inputStream == null && classLoader != (object = ObjectFactory.class.getClassLoader())) {
            classLoader = object;
            inputStream = SecuritySupport.getResourceAsStream(classLoader, string2);
        }
        if (inputStream == null) {
            return null;
        }
        if (DEBUG) {
            ObjectFactory.debugPrintln("found jar resource=" + string2 + " using ClassLoader: " + classLoader);
        }
        try {
            object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"), 80);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new BufferedReader(new InputStreamReader(inputStream), 80);
        }
        String string3 = null;
        try {
            string3 = ((BufferedReader)object).readLine();
        }
        catch (IOException iOException) {
            Object var7_9 = null;
            return var7_9;
        }
        finally {
            try {
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {}
        }
        if (string3 != null && !"".equals(string3)) {
            if (DEBUG) {
                ObjectFactory.debugPrintln("found in resource, value=" + string3);
            }
            return ObjectFactory.newInstance(string3, classLoader, false);
        }
        return null;
    }
}

