/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.lw3d.TextfileParser;
import java.io.StreamTokenizer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3d;

class LwsFrame
extends TextfileParser {
    double x;
    double y;
    double z;
    double heading;
    double pitch;
    double bank;
    double xScale;
    double yScale;
    double zScale;
    double frameNumber;
    int linearValue;
    double tension;
    double continuity;
    double bias;

    LwsFrame(StreamTokenizer streamTokenizer) {
        this.x = this.getNumber(streamTokenizer);
        this.y = this.getNumber(streamTokenizer);
        this.z = -this.getNumber(streamTokenizer);
        this.debugOutputLn(2, "x, y, z " + this.x + ", " + this.y + ", " + this.z);
        this.heading = this.getNumber(streamTokenizer);
        this.pitch = this.getNumber(streamTokenizer);
        this.bank = this.getNumber(streamTokenizer);
        this.debugOutputLn(2, "(degrees) h, p, b = " + this.heading + ", " + this.pitch + ", " + this.bank);
        this.heading *= Math.PI / 180;
        this.pitch *= Math.PI / 180;
        this.bank *= Math.PI / 180;
        this.debugOutputLn(2, "(radians) h, p, b = " + this.heading + ", " + this.pitch + ", " + this.bank);
        this.debugOutputLn(8, "got pos and ori");
        this.xScale = this.getNumber(streamTokenizer);
        this.yScale = this.getNumber(streamTokenizer);
        this.zScale = this.getNumber(streamTokenizer);
        this.debugOutputLn(2, "xs, ys, zs " + this.xScale + ", " + this.yScale + ", " + this.zScale);
        this.frameNumber = (int)this.getNumber(streamTokenizer);
        this.linearValue = (int)this.getNumber(streamTokenizer);
        this.debugOutputLn(2, "framenum, linear " + this.frameNumber + " , " + this.linearValue);
        this.tension = this.getNumber(streamTokenizer);
        this.continuity = this.getNumber(streamTokenizer);
        this.bias = this.getNumber(streamTokenizer);
        this.debugOutputLn(2, "tension, cont, bias = " + this.tension + ", " + this.continuity + ", " + this.bias);
    }

    LwsFrame(LwsFrame lwsFrame, LwsFrame lwsFrame2, double d) {
        this.x = lwsFrame.x + (lwsFrame2.x - lwsFrame.x) * d;
        this.y = lwsFrame.y + (lwsFrame2.y - lwsFrame.y) * d;
        this.z = lwsFrame.z + (lwsFrame2.z - lwsFrame.z) * d;
        this.heading = lwsFrame.heading + (lwsFrame2.heading - lwsFrame.heading) * d;
        this.pitch = lwsFrame.pitch + (lwsFrame2.pitch - lwsFrame.pitch) * d;
        this.bank = lwsFrame.bank + (lwsFrame2.bank - lwsFrame.bank) * d;
        this.xScale = lwsFrame.xScale + (lwsFrame2.xScale - lwsFrame.xScale) * d;
        this.yScale = lwsFrame.yScale + (lwsFrame2.yScale - lwsFrame.yScale) * d;
        this.zScale = lwsFrame.zScale + (lwsFrame2.zScale - lwsFrame.zScale) * d;
        this.frameNumber = lwsFrame.frameNumber + (lwsFrame2.frameNumber - lwsFrame.frameNumber) * d;
        this.linearValue = lwsFrame.linearValue;
        this.tension = lwsFrame.tension;
        this.continuity = lwsFrame.continuity;
        this.bias = lwsFrame.bias;
    }

    LwsFrame(LwsFrame lwsFrame, LwsFrame lwsFrame2, LwsFrame lwsFrame3, LwsFrame lwsFrame4, double d, double d2, double d3) {
        double d4 = d * d;
        double d5 = d4 * d;
        double d6 = 3.0 * d4 - d5 - d5;
        double d7 = 1.0 - d6;
        double d8 = d6;
        double d9 = d5 - d4 - d4 + d;
        double d10 = d5 - d4;
        double d11 = (1.0 - lwsFrame2.tension) * (1.0 + lwsFrame2.continuity) * (1.0 + lwsFrame2.bias);
        double d12 = (1.0 - lwsFrame2.tension) * (1.0 - lwsFrame2.continuity) * (1.0 - lwsFrame2.bias);
        double d13 = (1.0 - lwsFrame3.tension) * (1.0 - lwsFrame3.continuity) * (1.0 + lwsFrame3.bias);
        double d14 = (1.0 - lwsFrame3.tension) * (1.0 + lwsFrame3.continuity) * (1.0 - lwsFrame3.bias);
        double[] dArray = new double[]{lwsFrame.x, lwsFrame2.x, lwsFrame3.x, lwsFrame4.x};
        this.x = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        dArray[0] = lwsFrame.y;
        dArray[1] = lwsFrame2.y;
        dArray[2] = lwsFrame3.y;
        dArray[3] = lwsFrame4.y;
        this.y = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        dArray[0] = lwsFrame.z;
        dArray[1] = lwsFrame2.z;
        dArray[2] = lwsFrame3.z;
        dArray[3] = lwsFrame4.z;
        this.z = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        dArray[0] = lwsFrame.heading;
        dArray[1] = lwsFrame2.heading;
        dArray[2] = lwsFrame3.heading;
        dArray[3] = lwsFrame4.heading;
        this.heading = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        dArray[0] = lwsFrame.pitch;
        dArray[1] = lwsFrame2.pitch;
        dArray[2] = lwsFrame3.pitch;
        dArray[3] = lwsFrame4.pitch;
        this.pitch = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        dArray[0] = lwsFrame.bank;
        dArray[1] = lwsFrame2.bank;
        dArray[2] = lwsFrame3.bank;
        dArray[3] = lwsFrame4.bank;
        this.bank = this.computeInterpolation(dArray, d11, d12, d13, d14, d2, d3, d7, d8, d9, d10);
        this.xScale = lwsFrame2.xScale + (lwsFrame3.xScale - lwsFrame2.xScale) * d;
        this.yScale = lwsFrame2.yScale + (lwsFrame3.yScale - lwsFrame2.yScale) * d;
        this.zScale = lwsFrame2.zScale + (lwsFrame3.zScale - lwsFrame2.zScale) * d;
        this.frameNumber = lwsFrame2.frameNumber + (lwsFrame3.frameNumber - lwsFrame2.frameNumber) * d;
        this.linearValue = lwsFrame3.linearValue;
        this.tension = 0.0;
        this.continuity = 0.0;
        this.bias = 0.0;
    }

    double computeInterpolation(double[] dArray, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        double d11 = dArray[2] - dArray[1];
        double d12 = d5 < -1.0E-4 || d5 > 1.0E-4 ? d5 * (d * (dArray[1] - dArray[0]) + d2 * d11) : 0.5 * (d + d2) * d11;
        double d13 = d6 < -1.0E-4 || d6 > 1.0E-4 ? d6 * (d3 * d11 + d4 * (dArray[3] - dArray[2])) : 0.5 * (d3 + d4) * d11;
        double d14 = dArray[1] * d7 + dArray[2] * d8 + d12 * d9 + d13 * d10;
        return d14;
    }

    double getHeading() {
        return this.heading;
    }

    double getPitch() {
        return this.pitch;
    }

    double getBank() {
        return this.bank;
    }

    void setMatrix(Matrix4d matrix4d) {
        this.setRotationMatrix(matrix4d);
        matrix4d.setTranslation(new Vector3d(this.x, this.y, this.z));
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.setColumn(0, this.xScale, 0.0, 0.0, 0.0);
        matrix4d2.setColumn(1, 0.0, this.yScale, 0.0, 0.0);
        matrix4d2.setColumn(2, 0.0, 0.0, this.zScale, 0.0);
        matrix4d2.setColumn(3, 0.0, 0.0, 0.0, 1.0);
        matrix4d.mul(matrix4d2);
    }

    void setRotationMatrix(Matrix4d matrix4d) {
        this.debugOutputLn(1, "setRotMat()");
        this.debugOutputLn(2, " p, h, b = " + this.pitch + ", " + this.heading + ", " + this.bank);
        Matrix4d matrix4d2 = new Matrix4d();
        matrix4d2.rotX(-this.pitch);
        Matrix4d matrix4d3 = new Matrix4d();
        matrix4d3.rotZ(this.bank);
        matrix4d.rotY(-this.heading);
        matrix4d.mul(matrix4d2);
        matrix4d.mul(matrix4d3);
        this.debugOutputLn(2, "setRotMat(), mat = " + matrix4d);
    }

    Point3f getPosition() {
        return new Point3f((float)this.x, (float)this.y, (float)this.z);
    }

    Point3f getScale() {
        if ((this.xScale < -1.0E-4 || this.xScale > 1.0E-4) && (this.yScale < -1.0E-4 || this.yScale > 1.0E-4) && (this.zScale < -1.0E-4 || this.zScale > 1.0E-4)) {
            return new Point3f((float)this.xScale, (float)this.yScale, (float)this.zScale);
        }
        return new Point3f(1.0f, 1.0f, 1.0f);
    }

    double getFrameNum() {
        return this.frameNumber;
    }

    void printVals() {
        this.debugOutputLn(2, "         x = " + this.x);
        this.debugOutputLn(2, "         y = " + this.y);
        this.debugOutputLn(2, "         z = " + this.z);
        this.debugOutputLn(2, "         xScale = " + this.xScale);
        this.debugOutputLn(2, "         yScale = " + this.yScale);
        this.debugOutputLn(2, "         zScale = " + this.zScale);
        this.debugOutputLn(2, "         heading = " + this.heading);
        this.debugOutputLn(2, "         pitch = " + this.pitch);
        this.debugOutputLn(2, "         bank = " + this.bank);
        this.debugOutputLn(2, "         frameNum = " + this.frameNumber);
        this.debugOutputLn(2, "         lin = " + this.linearValue);
        this.debugOutputLn(2, "         tension = " + this.tension);
        this.debugOutputLn(2, "         continuity = " + this.continuity);
        this.debugOutputLn(2, "         bias = " + this.bias);
    }
}

