!macro CustomCodePreInstall
	;=== Move the settings files from old format to new
	${If} ${FileExists} "$INSTDIR\Data\settings\*.*"
	${AndIfNot} ${FileExists} "$INSTDIR\Data\.gimp\*.*"
		CreateDirectory "$INSTDIR\Data\.gimp"
		CopyFiles /SILENT "$INSTDIR\Data\settings\*.*" "$INSTDIR\Data\.gimp"
		RMDir /r "$INSTDIR\Data\settings"
		CreateDirectory "$INSTDIR\Data\settings"
		Rename "$INSTDIR\Data\.gimp\GIMPPortableSettings.ini" "$INSTDIR\Data\settings\GIMPPortableSettings.ini"
	${EndIf}
	
	${If} ${FileExists} "$INSTDIR\Data\.gimp\gtkrc"
	${AndIfNot} ${FileExists} "$INSTDIR\Data\.gimp\gimprc"
		CopyFiles /SILENT "$INSTDIR\App\DefaultData\.gimp\gimprc" "$INSTDIR\Data\.gimp"
	${EndIf}
	;=== Add missing folders on upgrades
	${If} ${FileExists} "$INSTDIR\Data\.gimp\*.*"
		CreateDirectory "$INSTDIR\Data\.gimp\brushes"
		CreateDirectory "$INSTDIR\Data\.gimp\curves"
		CreateDirectory "$INSTDIR\Data\.gimp\dynamics"
		CreateDirectory "$INSTDIR\Data\.gimp\environ"
		CreateDirectory "$INSTDIR\Data\.gimp\fontconfig"
		CreateDirectory "$INSTDIR\Data\.gimp\fonts"
		CreateDirectory "$INSTDIR\Data\.gimp\fractalexplorer"
		CreateDirectory "$INSTDIR\Data\.gimp\gfig"
		CreateDirectory "$INSTDIR\Data\.gimp\gflare"
		CreateDirectory "$INSTDIR\Data\.gimp\gimpressionist"
		CreateDirectory "$INSTDIR\Data\.gimp\gradients"
		CreateDirectory "$INSTDIR\Data\.gimp\interpreters"
		CreateDirectory "$INSTDIR\Data\.gimp\levels"
		CreateDirectory "$INSTDIR\Data\.gimp\modules"
		CreateDirectory "$INSTDIR\Data\.gimp\palettes"
		CreateDirectory "$INSTDIR\Data\.gimp\patterns"
		CreateDirectory "$INSTDIR\Data\.gimp\plug-ins"
		CreateDirectory "$INSTDIR\Data\.gimp\scripts"
		CreateDirectory "$INSTDIR\Data\.gimp\templates"
		CreateDirectory "$INSTDIR\Data\.gimp\themes"
		CreateDirectory "$INSTDIR\Data\.gimp\tmp"
		CreateDirectory "$INSTDIR\Data\.gimp\tool-options"
		CreateDirectory "$INSTDIR\Data\.gimp\tool-presets"
	${EndIf}

	;=== Delete old GIMP files (pre 2.6.0)
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\freetype.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gif.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gifload.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\psd.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\psd_save.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tiff.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\winclipboard.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\winprint.exe"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\11circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\11fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\13circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\13fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\15circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\15fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\17circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\17fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\19circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\19fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\1circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\3circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\3fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\5circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\5fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\7circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\7fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\9circle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\9fcircle.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\callig1.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\callig2.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\callig3.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\callig4.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\DStar11.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\DStar17.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\DStar25.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\thegimp.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\brushes\xcf.gbr"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\menus\colormap-editor-menu.xml"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\menus\qmask-menu.xml"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\menus\selection-editor-menu.xml"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\scripts\fade-outline.scm"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\scripts\hsv-graph.scm"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\scripts\image-structure.scm"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\themes\Default\imagerc"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\themes\Default\images\*.png"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\themes\Default\images\preferences\monitor.png"
		
	;=== Delete old GIMP files (2.6.0)
	Delete "$INSTDIR\App\gimp\bin\gimp-2.4.exe"
	Delete "$INSTDIR\App\gimp\bin\gimp-console-2.4.exe"
	Delete "$INSTDIR\App\gimp\bin\gimp-win-remote.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcdisplay_colorblind.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcdisplay_gamma.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcdisplay_highcontrast.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcdisplay_lcms.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcdisplay_proof.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcolorsel_cmyk.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcolorsel_triangle.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcolorsel_water.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\modules\libcontroller_dx_dinput.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\AlienMap2.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\align_layers.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\animationplay.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\animoptimize.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\apply_lens.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\autocrop.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\autostretch_hsv.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\bmp.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\borderaverage.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\bumpmap.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\c_astretch.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\ccanalyze.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\CEL.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\channel_mixer.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\CML_explorer.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\color_enhance.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\colortoalpha.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\compressor.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\convmatrix.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\csource.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\curve_bend.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\depthmerge.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\desktop-link.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\dicom.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\dog.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\exchange.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\faxg3.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\fits.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\flarefx.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\fp.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\FractalExplorer.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\fractaltrace.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gauss.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gbr.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gee_zoom.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gflare.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gfli.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gif-load.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gif-save.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gih.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\glasstile.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\glob.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gqbist.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gradmap.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gtm.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\header.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\helpbrowser.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\ifscompose.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\jpeg.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\laplace.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\lens.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\lic.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\mapcolor.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\MapObject.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\max_rgb.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\mblur.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\mng.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\neon.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\nlfilt.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\noisify.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\normalize.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\papertile.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\pat.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\pcx.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\pix.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\png.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\pnm.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\polar.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\poppler.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\postscript.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\psd-load.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\psd-save.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\psp.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\randomize.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\raw.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\rcm.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\redeye.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\retinex.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sample_colorize.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\scatter_hsv.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sel2path.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sel_gauss.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\semiflatten.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sgi.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\smooth_palette.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\snoise.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sobel.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\spheredesigner.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\spread.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\struc.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\sunras.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\svg.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tga.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\threshold_alpha.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tiff-load.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tiff-save.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tileit.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\tiler.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\uniteditor.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\unsharp.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\uri.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\vinvert.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\vpropagate.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\webbrowser.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\whirlpinch.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\winicon.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\winsnap.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\wmf.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\xbm.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\xpm.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\xwd.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\zealouscrop.exe"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\immodules"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ani.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-bmp.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-gif.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-icns.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ico.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-jpeg.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-pcx.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-png.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-pnm.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-ras.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-tga.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-tiff.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-wbmp.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-xbm.dll"
	Delete "$INSTDIR\App\gimp\lib\gtk-2.0\2.10.0\loaders\libpixbufloader-xpm.dll"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\images\gimp-splash-original.png"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\menus\toolbox-menu.xml"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\scripts\sphere.scm"
	Delete "$INSTDIR\App\gimp\share\gimp\2.0\scripts\starburst-logo.scm"

	;=== Delete old GIMP files (2.6.6)
	Delete "$INSTDIR\App\gimp\bin\libexpat.dll"

	;=== Delete old GIMP files (2.6.7)
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\CIE-Lab.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\frequency.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\gegl-fixups.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\gggl-lies.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\gggl.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\gimp-8bit.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\naive-CMYK.dll"
	Delete "$INSTDIR\App\gimp\lib\babl-0.0\sse-fixups.dll"
	Delete "$INSTDIR\App\gimp\lib\gegl-0.0\load-buffer.dll"
	Delete "$INSTDIR\App\gimp\lib\gegl-0.0\save-buffer.dll"
	Delete "$INSTDIR\App\gimp\lib\gegl-0.0\shift.dll"

	;=== Delete old GIMP files (2.8.0)
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\file-pdf.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gee-zoom.exe.exe"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gee.exe"
	
	;=== Deprecated gimp portable background window plugin
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gimpportablebgwindow.dll"
	Delete "$INSTDIR\App\gimp\lib\gimp\2.0\plug-ins\gimpportablebgwindow.exe"
	Delete "$INSTDIR\Data\.gimp\gimpportablebgwindow.reg"
	Delete "$INSTDIR\Data\settings\gimpportablebgwindow.reg"
!macroend

!macro CustomCodePostInstall
	IfFileExists "$INSTDIR\Data\.gimp\pluginrc" "" CustomCodePostInstallEnd
		Delete "$INSTDIR\Data\.gimp\pluginrc"
		CopyFiles /SILENT "$INSTDIR\App\DefaultData\.gimp\pluginrc" "$INSTDIR\Data\.gimp\"
	CustomCodePostInstallEnd:
!macroend