/*
 * Decompiled with CFR 0.152.
 */
package mrcomputerghost.runicdungeons;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import mrcomputerghost.runicdungeons.blocks.RunicBlocks;
import mrcomputerghost.runicdungeons.commands.CommandGetDungeonScore;
import mrcomputerghost.runicdungeons.commands.CommandSetDungeonScore;
import mrcomputerghost.runicdungeons.dim.WorldProviderDungeon;
import mrcomputerghost.runicdungeons.events.RunicEventHandler;
import mrcomputerghost.runicdungeons.items.RunicItems;
import mrcomputerghost.runicdungeons.libs.CreativeTab;
import mrcomputerghost.runicdungeons.proxy.CommonProxy;
import mrcomputerghost.runicdungeons.utils.RecipeUtils;
import mrcomputerghost.runicdungeons.world.BiomeDungeon;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="runicdungeons", name="Runic Dungeons", version="0.9.4")
public class RunicDungeons {
    public static int dimId;
    public static int biomeId;
    public static BiomeGenBase dungeon;
    @Mod.Instance
    public static RunicDungeons instance;
    public static Logger logger;
    @SidedProxy(serverSide="mrcomputerghost.runicdungeons.proxy.CommonProxy", clientSide="mrcomputerghost.runicdungeons.proxy.ClientProxy")
    public static CommonProxy proxy;
    public static CreativeTabs tab;
    public static Achievement portalAch;
    public static Achievement keyAch;
    public static AchievementPage runicAchPage;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        dimId = config.get("IDs", "Runic Dimension Id", 34).getInt();
        biomeId = config.get("IDs", "Dungeon Biome Id", 78).getInt();
        int jungleChance = config.get("Spawning", "Chance of Magic Chalk spawning in a Jungle Temple", 30).getInt();
        int desertChance = config.get("Spawning", "Chance of Magic Chalk spawning in a Desert Temple", 30).getInt();
        int keyDungeonChance = config.get("Spawning", "Chance of a Dungeon Key spawning in regular Dungeon Chests (You OP Little Cheat)", 0).getInt();
        RunicEventHandler.strongChance = config.get("Spawning", "Chance of mobs in Runic Dungens spawning with Strength", 25).getInt();
        RunicEventHandler.speedChance = config.get("Spawning", "Chance of mobs in Runic Dungens spawning with Speed", 25).getInt();
        config.save();
        RunicBlocks.initBlocks();
        RunicItems.initItems();
        RecipeUtils.registerRecipes();
        dungeon = new BiomeDungeon(biomeId);
        BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.WARM, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(dungeon, 0));
        ChestGenHooks.getInfo((String)"villageBlacksmith").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, 15));
        ChestGenHooks.getInfo((String)"bonusChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, 3));
        ChestGenHooks.getInfo((String)"dungeonChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.key), 1, 1, keyDungeonChance));
        ChestGenHooks.getInfo((String)"pyramidDesertyChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, desertChance));
        ChestGenHooks.getInfo((String)"pyramidJungleChest").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.magicChalk), 1, 1, jungleChance));
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.amuletHaste), 1, 1, 15));
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.amuletJump), 1, 1, 15));
        ChestGenHooks.getInfo((String)"strongholdLibrary").addItem(new WeightedRandomChestContent(new ItemStack(RunicItems.amuletResist), 1, 1, 15));
        DimensionManager.registerProviderType((int)dimId, WorldProviderDungeon.class, (boolean)true);
        DimensionManager.registerDimension((int)dimId, (int)dimId);
        portalAch = new Achievement("portalAch", "portalAch", -2, -1, RunicItems.magicChalk, AchievementList.field_76004_f).func_75971_g().func_75987_b();
        keyAch = new Achievement("keyAch", "keyAch", -5, -1, RunicItems.key, portalAch).func_75971_g().func_75987_b();
        Achievement[] achs = new Achievement[]{portalAch, keyAch};
        runicAchPage = new AchievementPage("runicDungeons", achs);
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandGetDungeonScore());
        event.registerServerCommand((ICommand)new CommandSetDungeonScore());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new RunicEventHandler());
        FMLCommonHandler.instance().bus().register((Object)new RunicEventHandler());
        if (!Loader.isModLoaded((String)"Baubles")) {
            logger.log(Level.INFO, "Warning! Baubles not detected, amulets and ring will not function!");
        } else if (Loader.isModLoaded((String)"Baubles")) {
            logger.log(Level.INFO, "Baubles detected, let's roll!");
        }
        for (int i = 0; i <= 3; ++i) {
            OreDictionary.registerOre((String)"stonebrick", (ItemStack)new ItemStack(RunicBlocks.survivalBricks, 1, i));
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (!Loader.isModLoaded((String)"Baubles")) {
            logger.log(Level.INFO, "Warning! Baubles not detected, amulets and belts will not function!");
        } else if (Loader.isModLoaded((String)"Baubles")) {
            logger.log(Level.INFO, "Baubles detected, let's roll!");
        }
    }

    static {
        tab = new CreativeTab("runicdungeons");
    }
}

