/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.patterns;

import de.maggicraft.ism.Unpacker;
import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.frames.FrameCredits;
import de.maggicraft.ism.gui.frames.FrameMoreContent;
import de.maggicraft.ism.gui.frames.FrameSettings;
import de.maggicraft.ism.gui.frames.FrameSpotlight;
import de.maggicraft.ism.gui.frames.FrameStructures;
import de.maggicraft.ism.gui.frames.FrameTutorial;
import de.maggicraft.ism.gui.patterns.ComboBox;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class GuiUtil {
    private static String changeCap = "May I introduce the largest update of ISM.";
    private static String changelog = "-new structures\n-one mod for client and server side\n-ISM can read and place more blocks\n-only one placing system\n-general GUI improvemts\n-over-worked the whole wiki\n-other changes\nPlans for the future.\nThank you for download and playing my mod. Please report bugs, post suggestions for improvements, rate a diamond on Planetminecraft or favorite my mod.\n-Marc (MaggiCraft)\n You can read the whole changelog on my planetminecraft thread.";
    private static Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    private static int xPos = 0;
    private static int yPos = 0;
    private static int frameWidth = 966;
    private static int frameHeight = 566;
    private static int mediumWidth = 646;
    private static int mediumHeight = 386;
    private static int dialogWidth = 320;
    private static int dialogHeight = 180;
    private static Color colorDark = new Color(30, 30, 30);
    private static Color colorMedium = new Color(90, 90, 90);
    private static Color colorBright = new Color(150, 150, 150);
    private static String[] menuItems = new String[]{"Spotlight", "Structures", "Tutorials", "More Content", "Credits", "Settings"};
    private static boolean triggered = false;
    private static ImageIcon frameIcon = new ImageIcon(Util.getPath() + "textures/gui/icon.png");
    private static String settingsVersion = "1.0.0";
    private static String[] settings = new String[]{"//settings - customize by write \"true\" or \"false\" next to the comma", "", "showStartGui=true", "showUpdateWindow=true", "showPlacingGui=true", "flattenArea=true", "colorDark=30,30,30", "colorMedium=90,90,90", "colorBright=150,150,150", "", "//showStartGui: true=shows spotlight gui after loading world", "//showUpdateWindow: true=shows update window", "//showPlacingGui: true=shows external gui while placing a structure", "//flattenArea: true=flatten area before placing structure", "//colorDark: font color in rgb code", "//colorMedium: background color in rgb code", "//colorBright: button color in rgb code", "settingsVersion=" + settingsVersion};
    private static String[] backUpSettings = new String[]{"//settings - customize by write \"true\" or \"false\" next to the comma", "", "showStartGui=true", "showUpdateWindow=true", "showPlacingGui=true", "flattenArea=true", "colorDark=30,30,30", "colorMedium=90,90,90", "colorBright=150,150,150", "", "//showStartGui: true=shows spotlight gui after loading world", "//showUpdateWindow: true=shows update window", "//showPlacingGui: true=shows external gui while placing a structure", "//flattenArea: true=flatten area before placing structure", "//colorDark: font color in rgb code", "//colorMedium: background color in rgb code", "//colorBright: button color in rgb code", "settingsVersion=" + settingsVersion};
    private static int[] convertedColor = new int[3];

    public static String getChangeCap() {
        return changeCap;
    }

    public static String getChangelog() {
        return changelog;
    }

    public static void setPoint(Point point) {
        xPos = (int)point.getX();
        yPos = (int)point.getY();
    }

    public static int getXPos() {
        if (xPos == 0) {
            xPos = (GuiUtil.d.width - frameWidth) / 2;
            return xPos;
        }
        return xPos;
    }

    public static int getYPos() {
        if (yPos == 0) {
            yPos = (GuiUtil.d.height - frameHeight) / 2;
            return yPos;
        }
        return yPos;
    }

    public static int getFrameWidth() {
        return frameWidth;
    }

    public static int getFrameHeight() {
        return frameHeight;
    }

    public static int getMediumWidth() {
        return mediumWidth;
    }

    public static int getMediumHeight() {
        return mediumHeight;
    }

    public static int getDialogWidth() {
        return dialogWidth;
    }

    public static int getDialogHeight() {
        return dialogHeight;
    }

    public static Color getColorDark() {
        return colorDark;
    }

    public static Color getColorMedium() {
        return colorMedium;
    }

    public static Color getColorBright() {
        return colorBright;
    }

    public static Font getFont(int size) {
        if (Util.getOs().equals("mac")) {
            size -= 3;
        }
        return new Font("Berlin Sans FB", 0, size);
    }

    public static Font getFontBold(int size) {
        if (Util.getOs().equals("mac")) {
            size -= 3;
        }
        return new Font("Berlin Sans FB", 1, size);
    }

    public static String[] getMenuItems() {
        return menuItems;
    }

    public static Image getFrameIcon() {
        new Unpacker("textures/gui/icon.png");
        try {
            return ImageIO.read(new File(Util.getPath() + "textures/gui/icon.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSettingsVersion() {
        return settingsVersion;
    }

    public static String[] getSettings() {
        return settings;
    }

    public static String[] getBackUpSettings() {
        return backUpSettings;
    }

    public static void setColorDark(String color) {
        int[] convertedColor = GuiUtil.convertToColor(color);
        colorDark = new Color(convertedColor[0], convertedColor[1], convertedColor[2]);
    }

    public static void setColorMedium(String color) {
        int[] convertedColor = GuiUtil.convertToColor(color);
        colorMedium = new Color(convertedColor[0], convertedColor[1], convertedColor[2]);
    }

    public static void setColorBright(String color) {
        int[] convertedColor = GuiUtil.convertToColor(color);
        colorBright = new Color(convertedColor[0], convertedColor[1], convertedColor[2]);
    }

    public static int[] convertToColor(String color) {
        String[] colorSplit = color.split(",");
        if (colorSplit.length == 3) {
            GuiUtil.convertedColor[0] = Integer.parseInt(colorSplit[0]);
            GuiUtil.convertedColor[1] = Integer.parseInt(colorSplit[1]);
            GuiUtil.convertedColor[2] = Integer.parseInt(colorSplit[2]);
        } else {
            GuiUtil.convertedColor[0] = 125;
            GuiUtil.convertedColor[1] = 125;
            GuiUtil.convertedColor[2] = 125;
        }
        for (int i = 0; i < convertedColor.length; ++i) {
            if (convertedColor[i] <= 255) continue;
            GuiUtil.convertedColor[i] = 255;
        }
        return convertedColor;
    }

    public static void chooseWindow(ComboBox menu, JFrame frame) {
        if (!triggered) {
            if (menu.getSelectedIndex() == 0) {
                new FrameSpotlight();
            } else if (menu.getSelectedIndex() == 1) {
                new FrameStructures();
            } else if (menu.getSelectedIndex() == 2) {
                new FrameTutorial();
            } else if (menu.getSelectedIndex() == 3) {
                new FrameMoreContent();
            } else if (menu.getSelectedIndex() == 4) {
                new FrameCredits();
            } else if (menu.getSelectedIndex() == 5) {
                new FrameSettings();
            }
            frame.getContentPane().removeAll();
            frame.dispose();
            triggered = true;
        } else {
            triggered = false;
        }
    }
}

