/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.frames;

import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.frames.FrameInfo;
import de.maggicraft.ism.gui.patterns.Button;
import de.maggicraft.ism.gui.patterns.CheckBox;
import de.maggicraft.ism.gui.patterns.ComboBox;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.gui.patterns.TextArea;
import de.maggicraft.ism.gui.patterns.TextField;
import de.maggicraft.ism.manager.ItemWriter;
import de.maggicraft.ism.manager.WriterUtil;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrameWriter
extends JFrame {
    private static JFrame frame = new JFrame();
    private CheckBox checkBox;
    private static TextField setFileName;
    private static TextField setStructureName;
    private static TextField setCreatorName;
    private static boolean removeBlocks;
    private static String[] tabs;
    private static ComboBox creator;
    private static ComboBox tab;
    private static int idCreator;
    private static int idTab;
    private static String[] creatorsArray;
    private static String currentCreator;

    public FrameWriter() {
        frame.setSize(GuiUtil.getFrameWidth(), GuiUtil.getFrameHeight());
        frame.setLocation(GuiUtil.getXPos(), GuiUtil.getYPos());
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(GuiUtil.getColorMedium());
        frame.setTitle("Writer - save your own structures");
        frame.setIconImage(GuiUtil.getFrameIcon());
        frame.add(cp);
        WriterUtil.deleteTemp();
        creatorsArray = FrameWriter.getCreators();
        if (currentCreator != "") {
            int i = 0;
            while (!creatorsArray[i].equals(currentCreator)) {
                ++i;
            }
            idCreator = i;
        }
        TextArea caption = new TextArea(20, 25, 200, 25, "Scan your structure", cp, GuiUtil.getFont(18));
        TextArea send = new TextArea(20, 60, 920, 25, "Send your scanned structures to MaggiCraftInfo@gmail.com, become a part of the mod and share it with other players.", cp, GuiUtil.getFont(18));
        TextArea captionFileName = new TextArea(20, 95, 130, 25, "file name", cp, GuiUtil.getFont(18));
        setFileName = new TextField(160, 95, 200, 25, Util.getFileName(), cp, GuiUtil.getFont(16));
        TextArea captionStructureName = new TextArea(20, 130, 130, 25, "structure name", cp, GuiUtil.getFont(18));
        setStructureName = new TextField(160, 130, 200, 25, Util.getStructureName(), cp, GuiUtil.getFont(16));
        TextArea captionCreatorName = new TextArea(20, 165, 130, 25, "creator name", cp, GuiUtil.getFont(18));
        creator = new ComboBox(160, 165, 200, 25, creatorsArray, "", idCreator, cp, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                idCreator = creator.getSelectedIndex();
                Util.setFileName(setFileName.getText());
                Util.setStructureName(setStructureName.getText());
                Util.setCreatorName(creatorsArray[idCreator]);
                frame.getContentPane().removeAll();
                new FrameWriter();
            }
        });
        setCreatorName = new TextField(380, 165, 200, 25, Util.getCreatorName(), cp, GuiUtil.getFont(16));
        Button addCreator = new Button(590, 165, 75, 25, "add", "adds creator to the list of creators", cp, GuiUtil.getFontBold(16), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                currentCreator = setCreatorName.getText();
                Util.setFileName(setFileName.getText());
                Util.setStructureName(setStructureName.getText());
                Util.setCreatorName(setCreatorName.getText());
                WriterUtil.writeString(setCreatorName.getText(), new File(Util.getPath() + "creators.txt"));
                frame.getContentPane().removeAll();
                new FrameWriter();
            }
        });
        TextArea captionGenre = new TextArea(20, 200, 130, 25, "genre", cp, GuiUtil.getFont(18));
        tab = new ComboBox(160, 200, 200, 25, tabs, "", idTab, cp, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                idTab = tab.getSelectedIndex();
                Util.setGenre(tabs[idTab]);
            }
        });
        removeBlocks = false;
        TextArea captionRemove = new TextArea(20, 235, 200, 30, "remove unnecessary blocks", cp, GuiUtil.getFont(18));
        this.checkBox = new CheckBox(225, 235, 25, 25, removeBlocks, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                removeBlocks = FrameWriter.this.checkBox.getBoolean();
            }
        });
        Button enter = new Button(20, 485, 150, 35, "start scanning", "starts scanning", cp, GuiUtil.getFont(20), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File checkFile = new File(Util.getPath() + "myStructures/" + setStructureName.getText() + ".ism-structure");
                if (checkFile.exists()) {
                    new FrameInfo("Error", "The file " + setStructureName.getText() + ".ism-structure already exist. Do you want to rename your current file?", "fileExist");
                } else {
                    FrameWriter.enter();
                }
            }
        });
        frame.setVisible(true);
    }

    public static void enter() {
        if (setFileName.getText().equals("file name")) {
            new FrameInfo("Error", "Add a file name!", "noFileName");
        } else if (setStructureName.getText().equals("structure name")) {
            new FrameInfo("Error", "Add a structure name!", "noStructureName");
        } else {
            Util.setFileName(setFileName.getText());
            Util.setStructureName(setStructureName.getText());
            if (setCreatorName.getText().equals("add new creator")) {
                Util.setCreatorName(creator.getSelectedObject().toString());
            } else {
                Util.setCreatorName(setCreatorName.getText());
            }
            Util.setGenre(tabs[idTab]);
            ItemWriter.write(removeBlocks);
        }
    }

    public static void close() {
        frame.getContentPane().removeAll();
        frame.dispose();
    }

    public static boolean getRemoveBlocks() {
        return removeBlocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getCreators() {
        File creatorFile = new File(Util.getPath() + "creators.txt");
        BufferedReader br = null;
        int lineQuantity = 0;
        try {
            br = new BufferedReader(new FileReader(creatorFile));
            String line = null;
            while ((line = br.readLine()) != null) {
                ++lineQuantity;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        BufferedReader br2 = null;
        Object[] creators = new String[lineQuantity];
        try {
            br2 = new BufferedReader(new FileReader(creatorFile));
            String line = null;
            int id = 0;
            while ((line = br2.readLine()) != null) {
                String[] parts = line.split(";");
                creators[id] = parts[0];
                ++id;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br2 != null) {
                try {
                    br2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Arrays.sort(creators);
        Object[] tmpCreators = creators;
        if (((String)creators[0]).equals("")) {
            int i = 0;
            while (((String)creators[i]).equals("")) {
                ++i;
            }
            creators = new String[creators.length - i];
            for (int j = 0; j < creators.length; ++j) {
                creators[j] = tmpCreators[j + i];
            }
            creatorFile.delete();
            WriterUtil.writeString((String[])creators, new File(Util.getPath() + "creators.txt"));
        }
        return creators;
    }

    public static void resetInfo() {
        idTab = 0;
        currentCreator = "";
        idCreator = 0;
        Util.setFileName("file name");
        Util.setStructureName("structure name");
        Util.setCreatorName("add new creator");
    }

    static {
        tabs = new String[]{"Modern Houses", "Modern Structures", "Medieval Buildings", "Asia Buildings", "Oriental Buildings", "Ships", "Vehicles", "Sci-Fi", "3D Art", "Pixel-Art"};
        idCreator = 0;
        idTab = 0;
        currentCreator = "";
    }
}

