/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.frames;

import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.frames.FrameInfo;
import de.maggicraft.ism.gui.patterns.Button;
import de.maggicraft.ism.gui.patterns.CheckBox;
import de.maggicraft.ism.gui.patterns.ComboBox;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.gui.patterns.TextArea;
import de.maggicraft.ism.gui.patterns.TextField;
import de.maggicraft.ism.manager.WriterUtil;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FrameSettings
extends JFrame {
    private static JFrame frame = new JFrame();
    private static ComboBox menu;
    private static boolean triggered;
    private CheckBox checkStartGui;
    private CheckBox checkUpdateWindow;
    private CheckBox checkPlacingGui;
    private CheckBox checkFlattenArea;
    private TextField fieldColorDark;
    private TextField fieldColorMedium;
    private TextField fieldColorBright;
    boolean showStartGui;
    boolean showUpdateWindow;
    boolean showPlacingGui;
    boolean flattenArea;
    String colorDark;
    String colorMedium;
    String colorBright;

    public FrameSettings() {
        frame.setSize(GuiUtil.getFrameWidth(), GuiUtil.getFrameHeight());
        frame.setLocation(GuiUtil.getXPos(), GuiUtil.getYPos());
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(GuiUtil.getColorMedium());
        frame.setTitle("More Content by MaggiCraft");
        frame.setIconImage(GuiUtil.getFrameIcon());
        frame.add(cp);
        menu = new ComboBox(45, 35, 160, 25, GuiUtil.getMenuItems(), "choose a genre", 5, cp, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                GuiUtil.chooseWindow(menu, frame);
            }
        });
        this.showStartGui = WriterUtil.getSettings("showStartGui");
        this.showUpdateWindow = WriterUtil.getSettings("showUpdateWindow");
        this.showPlacingGui = WriterUtil.getSettings("showPlacingGui");
        this.flattenArea = WriterUtil.getSettings("flattenArea");
        this.colorDark = WriterUtil.getColorSettings("colorDark");
        this.colorMedium = WriterUtil.getColorSettings("colorMedium");
        this.colorBright = WriterUtil.getColorSettings("colorBright");
        this.checkStartGui = new CheckBox(70, 95, 25, 25, this.showStartGui, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrameSettings.this.showStartGui = FrameSettings.this.checkStartGui.getBoolean();
            }
        });
        this.checkUpdateWindow = new CheckBox(70, 135, 25, 25, this.showUpdateWindow, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrameSettings.this.showUpdateWindow = FrameSettings.this.checkUpdateWindow.getBoolean();
            }
        });
        this.checkPlacingGui = new CheckBox(70, 175, 25, 25, this.showPlacingGui, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrameSettings.this.showPlacingGui = FrameSettings.this.checkPlacingGui.getBoolean();
            }
        });
        this.checkFlattenArea = new CheckBox(70, 215, 25, 25, this.flattenArea, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                FrameSettings.this.flattenArea = FrameSettings.this.checkFlattenArea.getBoolean();
            }
        });
        TextArea textStartGui = new TextArea(105, 95, 335, 25, "opens spotlight gui after loading world", cp, GuiUtil.getFont(16));
        TextArea textUpdateWindow = new TextArea(105, 135, 335, 25, "opens the update window if an update is avaible", cp, GuiUtil.getFont(16));
        TextArea textPlacingGui = new TextArea(105, 175, 335, 25, "shows external gui while placing a structure", cp, GuiUtil.getFont(16));
        TextArea textFlattenArea = new TextArea(105, 215, 335, 25, "flatten area before placing a structure", cp, GuiUtil.getFont(16));
        TextArea example = new TextArea(60, 260, 410, 25, "seperate each number with a comma, example: \"255,100,0\"", cp, GuiUtil.getFont(16));
        this.fieldColorDark = new TextField(60, 295, 100, 25, this.colorDark, cp, GuiUtil.getFont(16));
        this.fieldColorMedium = new TextField(60, 335, 100, 25, this.colorMedium, cp, GuiUtil.getFont(16));
        this.fieldColorBright = new TextField(60, 375, 100, 25, this.colorBright, cp, GuiUtil.getFont(16));
        TextArea textColorDark = new TextArea(175, 295, 200, 25, "font color in rgb code", cp, GuiUtil.getFont(16));
        TextArea textColorMedium = new TextArea(175, 335, 200, 25, "background color in rgb code", cp, GuiUtil.getFont(16));
        TextArea textColorBright = new TextArea(175, 375, 200, 25, "button color in rgb code", cp, GuiUtil.getFont(16));
        Button accept = new Button(45, 485, 100, 35, "accept", "save the settings", cp, GuiUtil.getFontBold(16), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String[] newSettings = GuiUtil.getSettings();
                newSettings[2] = "showStartGui=" + FrameSettings.this.showStartGui;
                newSettings[3] = "showUpdateWindow=" + FrameSettings.this.showUpdateWindow;
                newSettings[4] = "showPlacingGui=" + FrameSettings.this.showPlacingGui;
                newSettings[5] = "flattenArea=" + FrameSettings.this.flattenArea;
                newSettings[6] = "colorDark=" + FrameSettings.this.fieldColorDark.getText();
                newSettings[7] = "colorMedium=" + FrameSettings.this.fieldColorMedium.getText();
                newSettings[8] = "colorBright=" + FrameSettings.this.fieldColorBright.getText();
                File settings = new File(Util.getPath() + "ism-settings.txt");
                WriterUtil.writeString(newSettings, settings);
                GuiUtil.setColorDark(FrameSettings.this.fieldColorDark.getText());
                GuiUtil.setColorMedium(FrameSettings.this.fieldColorMedium.getText());
                GuiUtil.setColorBright(FrameSettings.this.fieldColorBright.getText());
                FrameSettings.this.setWindowPos();
                frame.getContentPane().removeAll();
                new FrameSettings();
                new FrameInfo("saved the settings");
            }
        });
        Button reset = new Button(815, 485, 100, 35, "reset", "set the default settings", cp, GuiUtil.getFontBold(16), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                File settings = new File(Util.getPath() + "ism-settings.txt");
                WriterUtil.writeString(GuiUtil.getBackUpSettings(), settings);
                GuiUtil.setColorDark(GuiUtil.getBackUpSettings()[6].split("=")[1]);
                GuiUtil.setColorMedium(GuiUtil.getBackUpSettings()[7].split("=")[1]);
                GuiUtil.setColorBright(GuiUtil.getBackUpSettings()[8].split("=")[1]);
                FrameSettings.this.colorDark = WriterUtil.getColorSettings("colorDark");
                FrameSettings.this.colorMedium = WriterUtil.getColorSettings("colorMedium");
                FrameSettings.this.colorBright = WriterUtil.getColorSettings("colorBright");
                FrameSettings.this.showStartGui = WriterUtil.getSettings("showStartGui");
                FrameSettings.this.showUpdateWindow = WriterUtil.getSettings("showUpdateWindow");
                FrameSettings.this.showPlacingGui = WriterUtil.getSettings("showPlacingGui");
                FrameSettings.this.setWindowPos();
                frame.getContentPane().removeAll();
                new FrameSettings();
                new FrameInfo("reset the settings");
            }
        });
        frame.setVisible(true);
    }

    public static void close() {
        frame.dispose();
    }

    public void setWindowPos() {
        Point point = frame.getLocation(this.getLocation());
        GuiUtil.setPoint(point);
    }

    static {
        triggered = false;
    }
}

