/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.frames;

import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.frames.FrameSetFundament;
import de.maggicraft.ism.gui.patterns.Button;
import de.maggicraft.ism.gui.patterns.CheckBox;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.gui.patterns.Picture;
import de.maggicraft.ism.gui.patterns.TextArea;
import de.maggicraft.ism.manager.Reader;
import de.maggicraft.ism.manager.SpecialCore;
import de.maggicraft.ism.manager.WriterUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraft.init.Blocks;

public class FrameSetStructure
extends JFrame {
    public static JFrame frame = new JFrame();
    private static String tmpStructure;
    private static boolean flattenArea;
    private CheckBox checkFlattenArea;
    private static String fileName;
    private static String tip;

    public FrameSetStructure(String tmpFileName, String name, String creator, String genre, String blocksQuantity, int maxX, int maxY, int maxZ) {
        frame.setSize(GuiUtil.getMediumWidth(), GuiUtil.getMediumHeight());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - GuiUtil.getMediumWidth()) / 2, (d.height - GuiUtil.getMediumHeight()) / 2);
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(GuiUtil.getColorMedium());
        frame.setTitle("Place a structure");
        frame.setIconImage(GuiUtil.getFrameIcon());
        frame.add(cp);
        WriterUtil.deleteTemp();
        flattenArea = true;
        fileName = tmpFileName;
        tip = Integer.parseInt(blocksQuantity.replace(",", "")) > 15000 ? " It is recommended that you reload the world." : "";
        try {
            Picture pic = new Picture(451, 75, fileName, cp);
        }
        catch (Exception e) {
            System.out.println("picture not found");
        }
        TextArea textInfo = new TextArea(20, 20, 600, 50, "Do you want to place the structure in the selected area? After you clicked \"yes\" wait till this window disappears." + tip, cp, GuiUtil.getFont(16));
        TextArea textStructureName = new TextArea(20, 85, 340, 25, "name: " + name, cp, GuiUtil.getFont(16));
        TextArea textCreator = new TextArea(20, 115, 340, 25, "creator: " + creator, cp, GuiUtil.getFont(16));
        TextArea textGenre = new TextArea(20, 145, 340, 25, "genre: " + genre, cp, GuiUtil.getFont(16));
        TextArea textBlocks = new TextArea(20, 175, 600, 25, blocksQuantity + " blocks (a normal PC places around 1,200 blocks per second)", cp, GuiUtil.getFont(16));
        TextArea showDimension = new TextArea(20, 205, 340, 25, maxZ + " blocks wide, " + maxX + " blocks long, " + maxY + " blocks high", cp, GuiUtil.getFont(16));
        TextArea textFlattenArea = new TextArea(35, 235, 325, 25, "flatten area before placing the structure", cp, GuiUtil.getFont(16));
        this.checkFlattenArea = new CheckBox(15, 232, 25, 25, flattenArea, "", "", cp, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                flattenArea = FrameSetStructure.this.checkFlattenArea.getBoolean();
            }
        });
        Button setStructure = new Button(20, 305, 125, 35, "yes", "set structure in the selected area", cp, GuiUtil.getFontBold(19), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Reader.read(false);
            }
        });
        Button buttonClose = new Button(495, 305, 125, 35, "cancel", "doesn't places a structure", cp, GuiUtil.getFontBold(19), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WriterUtil.deleteFile(Util.getRdmString() + ".ism-structure");
                SpecialCore.removeTestArea();
                frame.getContentPane().removeAll();
                frame.dispose();
            }
        });
        frame.setVisible(true);
    }

    public static void close() {
        frame.dispose();
    }

    public void placeStructure() {
        SpecialCore.removeTestArea();
        if (flattenArea) {
            SpecialCore.flatten();
        }
        new FrameSetFundament(0, 0, Blocks.field_150346_d);
        frame.getContentPane().removeAll();
        frame.dispose();
    }
}

