/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.manager;

import de.maggicraft.ism.ISMMain;
import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.tools.Tools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WriterUtil {
    private static World world;
    private static int x;
    private static int y;
    private static int z;
    private static int blocksQuantity;
    private static int blocksQuan;
    private static int oldY;
    private static int oldX;
    private static String oldBlock;

    public static String getString(int i) {
        Integer integer = new Integer(i);
        return integer.toString();
    }

    public static void deleteTemp() {
        for (int j = 0; j < 2; ++j) {
            String path = j == 0 ? Util.getPath() + "myStructures/" : Util.getPath();
            File file = new File(path);
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (!fileArray[i].getPath().endsWith(".ism-temp")) continue;
                try {
                    Path hiddenFile = Paths.get(fileArray[i].getPath(), new String[0]);
                    Files.setAttribute(hiddenFile, "dos:hidden", false, new LinkOption[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                new File(fileArray[i].getPath()).delete();
            }
        }
    }

    public static void writeP(String block, String metaPack) {
        try {
            FileWriter writer = new FileWriter(Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-temp", true);
            if (!oldBlock.equals(block)) {
                writer.write(block + ";" + metaPack);
            } else {
                writer.write("p;" + metaPack);
            }
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        oldBlock = block;
    }

    public static void writeBlock(String block) {
        try {
            FileWriter writer = new FileWriter(Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-temp", true);
            writer.write(block);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeString(String tmp, File file) {
        try {
            FileWriter writer = new FileWriter(file, true);
            writer.write(tmp);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeString(String[] tmp, File file) {
        try {
            FileWriter writer = new FileWriter(file);
            for (int i = 0; i < tmp.length; ++i) {
                writer.write(tmp[i]);
                writer.write(System.getProperty("line.separator"));
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeInfo() {
        try {
            FileWriter writer = new FileWriter(Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-temp");
            try {
                Path hiddenFile = Paths.get(Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-temp", new String[0]);
                Files.setAttribute(hiddenFile, "dos:hidden", true, new LinkOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            writer.write("i;date;" + new SimpleDateFormat("dd.MM.yyyy").format(new Date()));
            writer.write(System.getProperty("line.separator"));
            writer.write("i;str;" + Util.getStructureName());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;cr;" + Util.getCreatorName());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;gen;" + Util.getGenre());
            writer.write(System.getProperty("line.separator"));
            writer.write("i;quan;" + blocksQuantity);
            blocksQuan = blocksQuantity;
            writer.write(System.getProperty("line.separator"));
            writer.write("i;depth;" + Tools.fixPoint);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;xX;" + Tools.sizeX);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;xY;" + Tools.sizeY);
            writer.write(System.getProperty("line.separator"));
            writer.write("i;xZ;" + Tools.sizeZ);
            writer.write(System.getProperty("line.separator"));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createItem() {
        String itemName = "";
        if (Util.getFileName().contains("(") && Util.getFileName().contains(")")) {
            int a = Util.getFileName().indexOf("(");
            int b = Util.getFileName().indexOf(")");
            itemName = "item".concat(Util.getFileName().substring(a + 1, a + 2).toUpperCase().concat(Util.getFileName().substring(a + 2, b)).replace(" ", "_"));
        }
        String line1 = "structures[id] = new ItemStructure(\"" + Util.getFileName() + "\", \"" + Util.getStructureName() + "\", \"" + Util.getCreatorName() + "\", \"" + Util.getGenre() + "\", \"" + blocksQuan + "\", " + Tools.sizeX + ", " + Tools.sizeY + ", " + Tools.sizeZ + ", " + Tools.fixPoint + ", \"" + itemName + "\");";
        String line2 = "item." + itemName + ".name=" + Util.getStructureName() + " (" + Util.addDecimalMark(WriterUtil.getString(blocksQuan)) + ")";
        WriterUtil.writeString(line1, new File(Util.getPath() + "structures.txt"));
        WriterUtil.writeString(line2, new File(Util.getPath() + "structures.txt"));
    }

    public static void encryptFile() throws Exception {
        int n;
        String encryptedFile = Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-structure";
        String decryptedFile = Util.getPath() + "myStructures/" + Util.getFileName() + ".ism-temp";
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeySpec key = new SecretKeySpec(Util.getPassword().getBytes(), "DES");
        cipher.init(1, key);
        FileInputStream in = new FileInputStream(decryptedFile);
        CipherOutputStream out = new CipherOutputStream(new FileOutputStream(encryptedFile), cipher);
        byte[] byteBuffer = new byte[1024];
        while ((n = ((InputStream)in).read(byteBuffer)) != -1) {
            out.write(byteBuffer, 0, n);
        }
        ((InputStream)in).close();
        out.close();
    }

    public static void decryptFile(String name, boolean delete) throws Exception {
        int n;
        String encryptedFile = Util.getPath() + name + ".ism-structure";
        String decryptedFile = Util.getPath() + name + ".ism-temp";
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeySpec key = new SecretKeySpec(Util.getPassword().getBytes(), "DES");
        cipher.init(2, key);
        CipherInputStream in = new CipherInputStream(new FileInputStream(encryptedFile), cipher);
        FileOutputStream out = new FileOutputStream(decryptedFile);
        byte[] byteBuffer = new byte[1024];
        while ((n = in.read(byteBuffer)) != -1) {
            ((OutputStream)out).write(byteBuffer, 0, n);
        }
        in.close();
        ((OutputStream)out).close();
        if (delete) {
            new File(Util.getPath() + name + ".ism-structure").delete();
        }
        try {
            Path hiddenFile = Paths.get(Util.getPath() + name + ".ism-temp", new String[0]);
            Files.setAttribute(hiddenFile, "dos:hidden", true, new LinkOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteFile(String name) {
        try {
            Path hiddenFile = Paths.get(Util.getPath() + name, new String[0]);
            Files.setAttribute(hiddenFile, "dos:hidden", false, new LinkOption[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new File(Util.getPath() + name).delete();
    }

    public static void readBlocks(String block, Block tmpBlock) {
        WriterUtil.writeBlock("nM;" + block);
        for (int Y = 0; Y < Tools.sizeY; ++Y) {
            for (int X = 0; X < Tools.sizeX; ++X) {
                for (int Z = 0; Z < Tools.sizeZ; ++Z) {
                    if (Util.getBlock(world, x + X, y + Y, z + Z) != tmpBlock) continue;
                    if (oldY == Y + 1 - Tools.fixPoint) {
                        if (oldX == X) {
                            WriterUtil.writeBlock(WriterUtil.getString(Z));
                        } else {
                            WriterUtil.writeBlock(WriterUtil.getString(X) + ";" + WriterUtil.getString(Z));
                        }
                        oldX = X;
                    } else {
                        WriterUtil.writeBlock(WriterUtil.getString(X) + ";" + WriterUtil.getString(Y + 1 - Tools.fixPoint) + ";" + WriterUtil.getString(Z));
                    }
                    oldY = Y + 1 - Tools.fixPoint;
                }
            }
        }
    }

    public static void readBlocks(String block, Block tmpBlock, int tmpMeta) {
        WriterUtil.writeP("sM;" + block, WriterUtil.getString(tmpMeta));
        WriterUtil.checkPos(tmpBlock, tmpMeta);
    }

    public static void readBlocks(String block, Block tmpBlock, int tmpMeta, String metaPack) {
        WriterUtil.writeP("cM;" + block, metaPack);
        WriterUtil.checkPos(tmpBlock, tmpMeta);
    }

    public static void specialBlocks(String block, Block tmpBlock, int tmpMeta, String metaPack) {
        WriterUtil.writeBlock("sB;" + block + ";" + metaPack);
        WriterUtil.checkPos(tmpBlock, tmpMeta);
    }

    public static void checkPos(Block tmpBlock, int tmpMeta) {
        for (int Y = 0; Y < Tools.sizeY; ++Y) {
            for (int X = 0; X < Tools.sizeX; ++X) {
                for (int Z = 0; Z < Tools.sizeZ; ++Z) {
                    if (Util.getBlock(world, x + X, y + Y, z + Z) != tmpBlock || Util.getMeta(world, x + X, y + Y, z + Z) != tmpMeta) continue;
                    if (oldY == Y + 1 - Tools.fixPoint) {
                        if (oldX == X) {
                            WriterUtil.writeBlock(WriterUtil.getString(Z));
                        } else {
                            WriterUtil.writeBlock(WriterUtil.getString(X) + ";" + WriterUtil.getString(Z));
                        }
                        oldX = X;
                    } else {
                        WriterUtil.writeBlock(WriterUtil.getString(X) + ";" + WriterUtil.getString(Y + 1 - Tools.fixPoint) + ";" + WriterUtil.getString(Z));
                    }
                    oldY = Y + 1 - Tools.fixPoint;
                }
            }
        }
    }

    public static void count(World world, int x, int y, int z) {
        blocksQuantity = 0;
        for (int X = 0; X < Tools.sizeX; ++X) {
            for (int Y = 0; Y < Tools.sizeY; ++Y) {
                for (int Z = 0; Z < Tools.sizeZ; ++Z) {
                    if (Util.getBlock(world, x + X, y + Y, z + Z) == Blocks.field_150350_a || Util.getBlock(world, x + X, y + Y, z + Z) == ISMMain.blockArea) continue;
                    ++blocksQuantity;
                }
            }
        }
    }

    public static void setDatas(World tmpWorld, int tmpX, int tmpY, int tmpZ) {
        blocksQuantity = 0;
        oldY = 1000000;
        oldX = 1000000;
        oldBlock = "";
        world = tmpWorld;
        x = tmpX;
        y = tmpY;
        z = tmpZ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkSettingsVersion() {
        BufferedReader br = null;
        File settings = new File(Util.getPath() + "ism-settings.txt");
        boolean read = false;
        boolean delete = false;
        try {
            br = new BufferedReader(new FileReader(settings));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("=");
                if (!parts[0].equals("settingsVersion")) continue;
                if (!parts[1].equals(GuiUtil.getSettingsVersion())) {
                    delete = true;
                }
                read = true;
            }
            if (!read) {
                delete = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (delete) {
            new File(Util.getPath() + "ism-settings.txt").delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean getSettings(String setting) {
        BufferedReader br = null;
        boolean set = true;
        try {
            br = new BufferedReader(new FileReader(new File(Util.getPath() + "ism-settings.txt")));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("=");
                if (!parts[0].equals(setting)) continue;
                if (parts[1].equals("true")) {
                    set = true;
                    continue;
                }
                if (parts[1].equals("false")) {
                    set = false;
                    continue;
                }
                set = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getColorSettings(String setting) {
        BufferedReader br = null;
        String color = "";
        try {
            br = new BufferedReader(new FileReader(new File(Util.getPath() + "ism-settings.txt")));
            String line = null;
            while ((line = br.readLine()) != null) {
                String[] parts = line.split("=");
                if (!parts[0].equals(setting)) continue;
                color = parts[1];
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return color;
    }

    static {
        x = 0;
        y = 0;
        z = 0;
        blocksQuantity = 0;
        blocksQuan = 0;
        oldY = 1000000;
        oldX = 1000000;
        oldBlock = "";
    }
}

