/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.manager;

import de.maggicraft.ism.ISMMain;
import de.maggicraft.ism.Unpacker;
import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.frames.FrameDownload;
import de.maggicraft.ism.gui.frames.FrameInfo;
import de.maggicraft.ism.gui.frames.FrameSetStructure;
import de.maggicraft.ism.manager.Reader;
import de.maggicraft.ism.manager.SpecialCore;
import de.maggicraft.ism.manager.WriterUtil;
import de.maggicraft.ism.tools.Storage;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class ItemStructure
extends Item {
    private String fileName;
    private String structure;
    private String creator;
    private String genre;
    private String blocksQuantity;
    private String regName;
    private String downloadUrl;
    private String genreAlt;
    private String texture;
    private int maxX;
    private int maxY;
    private int maxZ;
    private int fixPoint;
    private boolean toDownload = false;

    public ItemStructure(String tmpFileName, String tmpStructure, String tmpCreator, String tmpGenre, String tmpBlocksQuantity, int tmpMaxX, int tmpMaxY, int tmpMaxZ, int tmpFixPoint, String tmpRegName) {
        this.fileName = tmpFileName;
        this.structure = tmpStructure;
        this.creator = tmpCreator;
        this.genre = tmpGenre;
        this.blocksQuantity = Util.addDecimalMark(tmpBlocksQuantity);
        this.maxX = tmpMaxX;
        this.maxY = tmpMaxY;
        this.maxZ = tmpMaxZ;
        this.regName = tmpRegName;
        this.fixPoint = tmpFixPoint;
        this.func_77655_b(this.regName);
        Storage.setNode(0, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        if (this.genre == "Modern Houses") {
            this.func_77637_a(ISMMain.tabModernHouses);
            this.texture = "oak_door";
            Storage.setNode(4, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Modern Structures") {
            this.func_77637_a(ISMMain.tabModernStructures);
            this.texture = "brick";
            Storage.setNode(5, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Medieval Buildings") {
            this.func_77637_a(ISMMain.tabMedievalBuildings);
            this.texture = "chainmail_helmet";
            Storage.setNode(6, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Asia Buildings") {
            this.func_77637_a(ISMMain.tabAsiaBuildings);
            this.texture = "reeds";
            Storage.setNode(7, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Oriental Buildings") {
            this.func_77637_a(ISMMain.tabOrientalBuildings);
            this.texture = "paper";
            Storage.setNode(8, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Ships") {
            this.func_77637_a(ISMMain.tabShips);
            this.texture = "boat";
            Storage.setNode(9, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Vehicles") {
            this.func_77637_a(ISMMain.tabVehicles);
            this.texture = "minecart";
            Storage.setNode(10, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Sci-Fi") {
            this.func_77637_a(ISMMain.tabSciFi);
            this.texture = "ender_pearl";
            Storage.setNode(11, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "3D Art") {
            this.func_77637_a(ISMMain.tab3DArt);
            this.texture = "skull_skeleton";
            Storage.setNode(12, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else if (this.genre == "Pixel-Art") {
            this.func_77637_a(ISMMain.tabPixelArt);
            this.texture = "painting";
            Storage.setNode(13, this.fileName, this.structure, this.creator, this.blocksQuantity, ISMMain.getId());
        } else {
            this.func_77637_a(ISMMain.tabTools);
            this.texture = "wood_axe";
        }
        if (Integer.parseInt(tmpBlocksQuantity) > 500000) {
            Storage.setBlocksGenre(0);
            this.genreAlt = "Insane Structures";
        } else if (Integer.parseInt(tmpBlocksQuantity) > 125000) {
            Storage.setBlocksGenre(1);
            this.genreAlt = "Giant Structures";
        } else if (Integer.parseInt(tmpBlocksQuantity) > 50000) {
            Storage.setBlocksGenre(2);
            this.genreAlt = "Huge Structures";
        }
        ISMMain.nextId();
        Storage.addCreator(this.creator);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            WriterUtil.deleteTemp();
            Util.RandomString();
            new Unpacker("structures/" + this.fileName + ".ism-structure", Util.getRdmString() + ".ism-structure");
            File file = new File(Util.getPath() + Util.getRdmString() + ".ism-structure");
            try {
                Path hiddenFile = Paths.get(Util.getPath() + Util.getRdmString() + ".ism-structure", new String[0]);
                Files.setAttribute(hiddenFile, "dos:hidden", true, new LinkOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (file.exists()) {
                if (WriterUtil.getSettings("showPlacingGui")) {
                    Reader.setDatas(Util.getDir(player), world, x, y, z);
                    SpecialCore.setDatas(Util.getDir(player), this.fixPoint, this.maxX, this.maxY, this.maxZ, world, x, y, z);
                    SpecialCore.testArea();
                    new FrameSetStructure(this.fileName, this.structure, this.creator, this.genre, this.blocksQuantity, this.maxX, this.maxY, this.maxZ);
                } else {
                    Reader.setCanFlatten(WriterUtil.getSettings("flattenArea"));
                    Reader.read(false);
                }
            } else if (this.toDownload) {
                new FrameDownload(this.downloadUrl);
            } else {
                new FrameInfo("Error", "an error occured");
            }
        }
        return true;
    }

    public void setDownload(String tmpDownloadUrl) {
        this.toDownload = true;
        this.downloadUrl = tmpDownloadUrl;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStructure() {
        return this.structure;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getBlocksQuantity() {
        return this.blocksQuantity;
    }

    public int getMaxX() {
        return this.maxX;
    }

    public int getMaxY() {
        return this.maxY;
    }

    public int getMaxZ() {
        return this.maxZ;
    }

    public String getRegName() {
        return this.regName;
    }

    public int getFixPoint() {
        return this.fixPoint;
    }

    public String getGenreAlt() {
        return this.genreAlt;
    }

    public String getTexture() {
        return this.texture;
    }
}

