/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.frames;

import de.maggicraft.ism.Util;
import de.maggicraft.ism.gui.patterns.Button;
import de.maggicraft.ism.gui.patterns.CheckBox;
import de.maggicraft.ism.gui.patterns.ComboBox;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.gui.patterns.TextArea;
import de.maggicraft.ism.manager.Reader;
import de.maggicraft.ism.manager.SpecialCore;
import de.maggicraft.ism.manager.WriterUtil;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraft.world.World;

public class FrameReader
extends JFrame {
    private static int dir;
    private static int x;
    private static int y;
    private static int z;
    private static World world;
    private static JFrame frame;
    private ComboBox comboBox;
    private CheckBox checkBox;
    private static File file;
    private static File[] fileArray;
    private static File[] selectedFiles;
    private static String[] fileNames;
    private static String[] structureNames;
    private static String[] creatorNames;
    private static String[] genres;
    private static String[] blockQuantities;
    private static int[] fixPoint;
    private static int[] maxX;
    private static int[] maxY;
    private static int[] maxZ;
    private static boolean noFiles;
    private static int id;
    private static int pos1;
    private static String tip;

    public FrameReader(boolean large) {
        frame.getContentPane().removeAll();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (large) {
            frame.setSize(GuiUtil.getMediumWidth(), GuiUtil.getMediumHeight());
            frame.setLocation((d.width - GuiUtil.getMediumWidth()) / 2, (d.height - GuiUtil.getMediumHeight()) / 2);
        } else {
            frame.getContentPane().removeAll();
            frame.setSize(GuiUtil.getDialogWidth(), GuiUtil.getDialogHeight());
            frame.setLocation((d.width - GuiUtil.getDialogWidth()) / 2, (d.height - GuiUtil.getDialogHeight()) / 2);
        }
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(GuiUtil.getColorMedium());
        frame.setTitle("Place your structures");
        frame.setIconImage(GuiUtil.getFrameIcon());
        frame.add(cp);
        WriterUtil.deleteTemp();
        noFiles = false;
        if (large) {
            FrameReader.preLoad();
            if (!noFiles) {
                TextArea choose = new TextArea(20, 20, 200, 25, "choose a file", cp, GuiUtil.getFont(16));
                this.comboBox = new ComboBox(20, 50, 275, 25, fileNames, "choose a structure file", id, cp, new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent evt) {
                        frame.getContentPane().removeAll();
                        id = FrameReader.this.comboBox.getSelectedIndex();
                        new FrameReader(true);
                    }
                });
                TextArea showFileName = new TextArea(20, 85, 600, 25, "file: " + fileNames[id] + ".ism-structure", cp, GuiUtil.getFont(16));
                TextArea showStructureName = new TextArea(20, 115, 600, 25, "name: " + structureNames[id], cp, GuiUtil.getFont(16));
                TextArea showCreatorName = new TextArea(20, 145, 600, 25, "creator: " + creatorNames[id], cp, GuiUtil.getFont(16));
                TextArea showGenre = new TextArea(20, 175, 600, 25, "genre: " + genres[id], cp, GuiUtil.getFont(16));
                TextArea showBlockQuantities = new TextArea(20, 205, 600, 25, Util.addDecimalMark(blockQuantities[id]) + " blocks (a normal PC places around 1,200 blocks per second)", cp, GuiUtil.getFont(16));
                TextArea showDimension = new TextArea(20, 235, 600, 25, maxZ[id] + " blocks wide, " + maxX[id] + " blocks long, " + maxY[id] + " blocks high", cp, GuiUtil.getFont(16));
                TextArea textCanFlatten = new TextArea(35, 265, 600, 25, "flatten area before placing the structure", cp, GuiUtil.getFont(16));
                this.checkBox = new CheckBox(15, 263, 25, 25, true, "", "true=flatten, false=not", cp, new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent evt) {
                    }
                });
                Button enter = new Button(20, 305, 125, 35, "place", "starts scanning", cp, GuiUtil.getFontBold(19), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Reader.setFlatten(FrameReader.this.checkBox.getBoolean());
                        Util.setFileName(fileNames[id]);
                        SpecialCore.setDatas(dir, fixPoint[id], maxX[id], maxY[id], maxZ[id], world, x, y, z);
                        SpecialCore.testArea();
                        new FrameReader(false);
                    }
                });
                Button cancel = new Button(495, 305, 125, 35, "cancel", "closes the window", cp, GuiUtil.getFontBold(19), new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        frame.getContentPane().removeAll();
                        frame.dispose();
                    }
                });
                if (Integer.parseInt(blockQuantities[id]) > 15000) {
                    tip = " It is recommended that you reload the world.";
                    pos1 = 5;
                } else {
                    tip = "";
                    pos1 = 15;
                }
            } else {
                TextArea download = new TextArea(20, 30, 340, 25, "Scan your own files!", cp, GuiUtil.getFont(16));
            }
        } else {
            TextArea textUpdate = new TextArea(15, pos1, 284, 85, "Do you want to place the structure in the selected area? After you clicked \"yes\" wait till this window disappears." + tip, cp, GuiUtil.getFont(16));
            Button ok = new Button(15, 104, 110, 35, "ok", "places the structure", cp, GuiUtil.getFontBold(19), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpecialCore.removeTestArea();
                    Reader.read(true);
                    FrameReader.close();
                }
            });
            Button cancel = new Button(189, 104, 110, 35, "cancel", "doesn't place the structure", cp, GuiUtil.getFontBold(19), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SpecialCore.removeTestArea();
                    frame.getContentPane().removeAll();
                    frame.dispose();
                }
            });
        }
        frame.setVisible(true);
    }

    public static void close() {
        frame.getContentPane().removeAll();
        frame.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void preLoad() {
        file = new File(Util.getPath() + "myStructures/");
        fileArray = file.listFiles();
        int tmp = 0;
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].getName().endsWith(".ism-structure")) continue;
            ++tmp;
        }
        if (tmp > 0) {
            selectedFiles = new File[tmp];
            fileNames = new String[tmp];
            structureNames = new String[tmp];
            creatorNames = new String[tmp];
            genres = new String[tmp];
            blockQuantities = new String[tmp];
            fixPoint = new int[tmp];
            maxX = new int[tmp];
            maxY = new int[tmp];
            maxZ = new int[tmp];
            tmp = 0;
            while (tmp < fileNames.length) {
                if (!fileArray[tmp].getName().endsWith(".ism-structure")) continue;
                FrameReader.selectedFiles[tmp] = fileArray[tmp];
                FrameReader.fileNames[tmp] = fileArray[tmp].getName().substring(0, fileArray[tmp].getName().length() - 14);
                try {
                    WriterUtil.decryptFile("myStructures/" + fileNames[tmp], false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                File structureFile = new File(Util.getPath() + "myStructures/" + fileNames[tmp] + ".ism-temp");
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new FileReader(structureFile));
                    String line = null;
                    boolean cancel = false;
                    while ((line = br.readLine()) != null && !cancel) {
                        String[] parts = line.split(";");
                        if (parts[0].equals("i")) {
                            if (parts[1].equals("str")) {
                                FrameReader.structureNames[tmp] = parts[2];
                                continue;
                            }
                            if (parts[1].equals("cr")) {
                                FrameReader.creatorNames[tmp] = parts[2];
                                continue;
                            }
                            if (parts[1].equals("gen")) {
                                FrameReader.genres[tmp] = parts[2];
                                continue;
                            }
                            if (parts[1].equals("quan")) {
                                FrameReader.blockQuantities[tmp] = parts[2];
                                continue;
                            }
                            if (parts[1].equals("depth")) {
                                FrameReader.fixPoint[tmp] = Integer.parseInt(parts[2]);
                                continue;
                            }
                            if (parts[1].equals("xX")) {
                                FrameReader.maxX[tmp] = Integer.parseInt(parts[2]);
                                continue;
                            }
                            if (parts[1].equals("xY")) {
                                FrameReader.maxY[tmp] = Integer.parseInt(parts[2]);
                                continue;
                            }
                            if (!parts[1].equals("xZ")) continue;
                            FrameReader.maxZ[tmp] = Integer.parseInt(parts[2]);
                            continue;
                        }
                        cancel = true;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
                WriterUtil.deleteFile("myStructures/" + fileNames[tmp] + ".ism-temp");
                ++tmp;
            }
        } else {
            noFiles = true;
        }
    }

    public static void setDatas(int tmpDir, World tmpWorld, int tmpX, int tmpY, int tmpZ) {
        dir = tmpDir;
        world = tmpWorld;
        x = tmpX;
        y = tmpY;
        z = tmpZ;
    }

    public static void setId(int i) {
        id = i;
    }

    static {
        frame = new JFrame();
        noFiles = false;
        id = 0;
        pos1 = 15;
    }
}

