/*
 * Decompiled with CFR 0.152.
 */
package de.maggicraft.ism.gui.frames;

import de.maggicraft.ism.gui.patterns.Button;
import de.maggicraft.ism.gui.patterns.GuiUtil;
import de.maggicraft.ism.gui.patterns.TextArea;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JFrame;

public class FrameDownload
extends JFrame {
    private static JFrame frame = new JFrame();
    private static String url;

    public FrameDownload(String tmpUrl) {
        frame.setSize(GuiUtil.getDialogWidth(), GuiUtil.getDialogHeight());
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - GuiUtil.getDialogWidth()) / 2, (d.height - GuiUtil.getDialogHeight()) / 2);
        frame.setResizable(false);
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.setBackground(new Color(100, 100, 100));
        frame.setTitle("Downloader (beta)");
        frame.setIconImage(GuiUtil.getFrameIcon());
        frame.add(cp);
        url = tmpUrl;
        TextArea info = new TextArea(20, 15, 274, 75, "You must click the download button and store the downloaded file in your \"/minecraft/mods/ism/structures/\" folder.", cp, GuiUtil.getFont(16));
        Button downloader = new Button(20, 104, 115, 35, "download", "opens mediafire in your browser", cp, GuiUtil.getFont(18), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Desktop desktop;
                if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                    try {
                        URI uri = new URI(url);
                        desktop.browse(uri);
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        frame.setVisible(true);
    }
}

