Texture2D texColor <
	string type = "input";
>;
Texture2D texTarget <
	string type = "output";
>;
SamplerState samplerColor
{
	Filter = MIN_MAG_LINEAR_MIP_POINT;
	AddressU = Clamp; AddressV = Clamp;
};


Texture2D tex2D < string type = "input"; >;

// --------------------------------------------------------- \\

struct VS_INPUT
{
	float4 pos : POSITION;
	float2 tex : TEXCOORD0;
};
struct VS_OUTPUT
{
	float4 pos : SV_POSITION;
	float2 tex : TEXCOORD0;
};

// --------------------------------------------------------- \\

VS_OUTPUT PostProcess_VS(VS_INPUT IN)
{
	VS_OUTPUT OUT;
	
	OUT.pos = IN.pos;
	OUT.tex = IN.tex;
	
	return OUT;
}

// --------------------------------------------------------- \\	

float ScreenScaleY;
float ScreenSize;
float PI = 3.14159265;
float2 texel = {0.0009765625,0.00130208333333333333333333333333};

//your screen resolution

float2 screenRes = {1920,1080};
float focalDepth = 0;
float focalLength = 0;
float fstop = 50;
bool manualdof = true; 				//manual dof calculation
float ndofstart = 0.104; 					//near dof blur start
float ndofdist = 1.08; 					//near dof blur falloff distance
float fdofstart = 0.002; 					//far dof blur start
float fdofdist = 2.4; 					//far dof blur falloff distance
bool autofocus = true;
float2 focus = float2(0.5,0.5);
float CoC = 1.000;					//Circle of confusion http://en.wikipedia.org/wiki/Circle_of_confusion
bool noise = false; 					//DOF noise, adds grain
float namount = 0.00005; 				//grain amount
float DOFdownsample = 10;
float maxblur = 1.95; //Power of DOF blur
static const int samples = 40; 				//more samples =better quality but also less fps
static const int rings = 1; 				//ring count, DO NOT GO BEYOND 2 OR GAME CRASH!!!
float threshold = 2.5;					//threshold for gain
float gain = 0.0;					//brightens blurred areas to make bokeh effect visible
float bias = 1.0;
float fringe = 0.0;
float znear = 1.0; 					//camera clipping start (blur start)
float zfar = 1180.0; 					//camera clipping end (distance beyond which blur doesn't get bigger anymore)
bool pentagon = false; 					//use pentagon as bokeh shape? Bugged!
float feather = 1.1; 					//pentagon shape feather

//vignetting, darkens screen borders
bool vignetting = false;
float vignout = 25.31; 					//vignetting outer border
float vignin = 5.30; 					//vignetting inner border
float MartyMcFly = 25.30; 				//f-stops till vignette fades

float penta(float2 coords) //pentagonal shape
{
	float scale = float(rings) - 1.3;
	float4  HS0 = float4( 1.0,         0.0,         0.0,  1.0);
	float4  HS1 = float4( 0.309016994, 0.951056516, 0.0,  1.0);
	float4  HS2 = float4(-0.809016994, 0.587785252, 0.0,  1.0);
	float4  HS3 = float4(-0.809016994,-0.587785252, 0.0,  1.0);
	float4  HS4 = float4( 0.309016994,-0.951056516, 0.0,  1.0);
	float4  HS5 = float4( 0.0        ,0.0         , 1.0,  1.0);
	
	float4  one = float4( 1,1,1,1 );
	
	float4 P = float4(coords,float2(scale, scale)); 
	
	float4 dist = float4(0,0,0,0);
	float inorout = -4.0;
	
	dist.x = dot( P, HS0 ); //by Marty McFly
	dist.y = dot( P, HS1 );
	dist.z = dot( P, HS2 );
	dist.w = dot( P, HS3 );
	
	dist = smoothstep( -feather, feather, dist );
	
	inorout += dot( dist, one );
	
	dist.x = dot( P, HS4 );
	dist.y = HS5.w - abs( P.z );
	
	dist = smoothstep( -feather, feather, dist );
	inorout += dist.x;
	
	return saturate( inorout );
}


float linearize(float depth)
{
	return -zfar * znear / (depth * (zfar - znear) - zfar);
}

float2 rand(float2 coord) //generating noise/pattern texture for dithering
{
	float noiseX = ((frac(1.0-coord.x*(screenRes.x/2.0))*0.25)+(frac(coord.y*(screenRes.y/2.0))*0.75))*2.0-1.0;
	float noiseY = ((frac(1.0-coord.x*(screenRes.x/2.0))*0.75)+(frac(coord.y*(screenRes.y/2.0))*0.25))*2.0-1.0;
	
	return float2(noiseX,noiseY);
}

#define CHROMA_POW		35.0

float4 colorDof(float2 coords,float blur) //processing the sample
{
	float4 colDF = float4(0,0,0,1);
	
	colDF.x = tex2D.Sample(samplerColor,coords + float2(0.0,1.0)*texel*fringe*blur).x;
	colDF.y = tex2D.Sample(samplerColor,coords + float2(-0.866,-0.5)*texel*fringe*blur).y;
	colDF.z = tex2D.Sample(samplerColor,coords + float2(0.866,-0.5)*texel*fringe*blur).z; //by Marty McFly
	///////
	float3 fvChroma = float3(0.9934, 0.995, 1.0066);
	float3 chroma = pow(fvChroma, CHROMA_POW * 0.0193);

	float2 tr = ((2.0 * coords - 1.0) * chroma.r) *0.5 + 0.5;
	float2 tg = ((2.0 * coords - 1.0) * chroma.g) *0.5 + 0.5;
	float2 tb = ((2.0 * coords - 1.0) * chroma.b) *0.5 + 0.5;
	
	float3 color = float3(tex2D.Sample(samplerColor, tr).r, tex2D.Sample(samplerColor, tg).g, tex2D.Sample(samplerColor, tb).b) * (1.0 - 0.0063);
	
	colDF.xyz = color.xyz;
	//////
	coords = (0.05 * texel) + coords;  
  	color.rgb = tex2D.Sample(samplerColor, (-0.016 * 0.65 * texel) + coords).rgb;
  	color.rgb = tex2D.Sample(samplerColor, (0.016 * 0.65 * texel) + coords).rgb;

	//colDF.xyz = color.xyz;
	//////
	float3 lumcoeff = float3(0.299,0.587,0.114);
	float lum = dot(colDF.xyz,lumcoeff);
	float thresh = max((lum-threshold)*gain, 0.0);
	float3 nullcol = float3(0,0,0);
	colDF.xyz +=lerp(nullcol,colDF.xyz,thresh*blur);
	return colDF;
}

float vignette(float2 coord)
{
	float dist = distance(coord, float2(0.5,0.5));
	dist = smoothstep(vignout+(fstop/MartyMcFly), vignin+(fstop/MartyMcFly), dist);
	return saturate(dist);
}

float4 PS_ProcessDoFBokeh(VS_OUTPUT OUT) : SV_TARGET 
{
	float depth = linearize(tex2D.Sample(samplerColor,OUT.tex.xy).x);
	
	float fDepth = focalDepth;
	
	if (autofocus)
	{
		fDepth = linearize(tex2D.Sample(samplerColor,focus).x);
	}
	
	float blur = 0.0;
	if (manualdof)
	{    
		float a = depth-fDepth; //focal plane
		float b = (a-fdofstart)/fdofdist; //far DoF
		float c = (-a-ndofstart)/ndofdist; //near Dof
		blur = (a>0.0)?b:c;
	}
	else
	{
		float f = focalLength; //focal length in mm
		float d = fDepth*1000.0; //focal plane in mm
		float o = depth*1000.0; //depth in mm
		
		float a = (o*f)/(o-f); 
		float b = (d*f)/(d-f); 
		float c = (d-f)/(d*fstop*CoC); 
		
		blur = abs(a-b)*c;
	}
	blur = saturate(blur);
	float2 noise = rand(OUT.tex.xy)*namount*blur;
	
	float w = (1.0/screenRes.x)*blur*maxblur+noise.x;
	float h = (1.0/screenRes.y)*blur*maxblur+noise.y;
	
	float4 col = float4(0,0,0,1);
	
	if(blur < 0.05) //some optimization thingy
	{
		col = tex2D.Sample(samplerColor, OUT.tex.xy);
	}
	else
	{
	col = tex2D.Sample(samplerColor, OUT.tex.xy);
	float s = 1.0;
	int ringsamples;
	float step = 0.0f;
	float pw = 0.0f;
	float ph = 0.0f;
	float p = 0.0f;
	for (float i = 1; i <= rings; i += 1)
	{
		ringsamples = i * samples;
		step = PI*2.0 / ringsamples;
		pw = cos(step*i);
		ph = sin(step*i);	
		for (float j = 0 ; j < ringsamples ; j += 1)
		{
			//pw = pw * j;
			//ph = ph * j;
			//pw = cos(j*step)*1;
			//ph = sin(j*step)*i;
			p = 1.0;
			if (pentagon)
			{ 
				p = penta(float2(pw,ph));
			}
			col.xyz += colorDof(OUT.tex.xy + float2(pw*w,ph*h),blur).xyz;  
			s += 1.0*lerp(1.0,i/rings,bias)*p;
		}
	}
	col = col/s; //divide by sample count
	}
	
	if (vignetting)
	{
		col *= vignette(OUT.tex.xy);
	}
	
	return col;
}

BlendState SrcAlphaBlendingAdd
{
    BlendEnable[0] = TRUE;
    SrcBlend = ONE;
    DestBlend = ONE;
    BlendOp = ADD;
    SrcBlendAlpha = One;
    DestBlendAlpha = One;
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

BlendState SrcAlphaBlendingAdd2
{
    BlendEnable[0] = TRUE;
    SrcBlend = INV_SRC_COLOR; //zero
    DestBlend = SRC_COLOR; //src_color
    BlendOp = ADD;
    SrcBlendAlpha = zero; //one
    DestBlendAlpha = zero; //one
    BlendOpAlpha = ADD;
    RenderTargetWriteMask[0] = 0x0F;
};

BlendState NoBlending {
    AlphaToCoverageEnable = TRUE;
    BlendEnable[0] = TRUE;
};

DepthStencilState DisableDepth
{

    DepthEnable = FALSE;
    DepthWriteMask = ZERO;
    DepthFunc = LESS_EQUAL;

    StencilEnable  = FALSE;

};

DepthStencilState DisableDepthReplaceStencil {
    DepthEnable = FALSE;
    StencilEnable = TRUE;
    FrontFaceStencilPass = REPLACE;
};

DepthStencilState DisableDepthUseStencil {
    DepthEnable = FALSE;
    StencilEnable = TRUE;
    FrontFaceStencilFunc = EQUAL;
};

technique11 PostProcess
{	
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, PostProcess_VS()));
		SetGeometryShader( NULL );
		SetPixelShader(CompileShader(ps_4_0, PS_ProcessDoFBokeh()));
		SetBlendState( SrcAlphaBlendingAdd2, float4( 0.0f, 0.0f, 0.0f, 0.0f ), 0xFFFFFFFF );
		SetDepthStencilState( DisableDepth, 1 );
	}
}