/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.skin;

import java.awt.Color;
import org.jvnet.substance.border.FlatBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.SubduedGradientPainter;
import org.jvnet.substance.skin.SubstanceAbstractSkin;
import org.jvnet.substance.theme.SubstanceComplexTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.title.ArcHeaderPainter;
import org.jvnet.substance.title.MarbleNoiseHeaderPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

public class NebulaSkin
extends SubstanceAbstractSkin {
    public static String NAME = "Nebula";

    public NebulaSkin() {
        SubstanceTheme activeTheme = new SubstanceTheme(new ActiveScheme(), "Nebula Active", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme defaultTheme = new SubstanceTheme(new DefaultScheme(), "Nebula Default", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme rolloverUnselectedTheme = new SubstanceTheme(new RolloverUnselectedScheme(), "Nebula Rollover Unselected", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme pressedTheme = new SubstanceTheme(new PressedTheme(), "Nebula Pressed", SubstanceTheme.ThemeKind.DARK);
        SubstanceTheme rolloverSelectedTheme = new SubstanceTheme(new RolloverSelectedTheme(), "Nebula Rollover Selected", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme disabledTheme = new SubstanceTheme(new DisabledScheme(), "Nebula Disabled", SubstanceTheme.ThemeKind.COLD);
        SubstanceTheme activeTitleTheme = activeTheme.getDefaultTheme();
        SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME, SubstanceTheme.ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme, activeTitleTheme);
        theme.registerComponentStateTheme(rolloverUnselectedTheme, false, ComponentState.ROLLOVER_UNSELECTED);
        theme.registerComponentStateTheme(rolloverSelectedTheme, false, ComponentState.ROLLOVER_SELECTED);
        theme.registerComponentStateTheme(pressedTheme, true, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        theme.registerComponentHighlightStateTheme(pressedTheme, 0.6f, ComponentState.ROLLOVER_UNSELECTED);
        theme.registerComponentHighlightStateTheme(pressedTheme, 0.8f, ComponentState.SELECTED);
        theme.registerComponentHighlightStateTheme(pressedTheme, 0.95f, ComponentState.ROLLOVER_SELECTED);
        theme.registerComponentHighlightStateTheme(pressedTheme, 0.8f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        theme.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
        theme.setSelectedTabFadeStart(0.1);
        theme.setSelectedTabFadeEnd(0.3);
        this.theme = theme;
        this.shaper = new ClassicButtonShaper();
        this.watermark = new SubstanceNullWatermark();
        this.gradientPainter = new SubduedGradientPainter();
        MarbleNoiseHeaderPainter titlePainter = new MarbleNoiseHeaderPainter(false, true);
        titlePainter.setPaintingToolbarDropShadows(true);
        titlePainter.setPaintingSeparators(true);
        titlePainter.setBaseTitlePainter(new ArcHeaderPainter());
        titlePainter.setTextureAlpha(0.3f);
        this.titlePainter = titlePainter;
        this.borderPainter = new FlatBorderPainter();
    }

    public String getDisplayName() {
        return NAME;
    }

    protected static class PressedTheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#8FA9C0");
        private static final Color mainExtraLightColor = Color.decode("#7695B2");
        private static final Color mainLightColor = Color.decode("#5B89B4");
        private static final Color mainMidColor = Color.decode("#33628C");
        private static final Color mainDarkColor = Color.decode("#1C3851");
        private static final Color mainUltraDarkColor = Color.decode("#000000");
        private static final Color foregroundColor = Color.decode("#FFFFFF");

        protected PressedTheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class RolloverSelectedTheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#F8FAFC");
        private static final Color mainExtraLightColor = Color.decode("#E8FDFF");
        private static final Color mainLightColor = Color.decode("#D4E9FC");
        private static final Color mainMidColor = Color.decode("#B6CBDE");
        private static final Color mainDarkColor = Color.decode("#3B556D");
        private static final Color mainUltraDarkColor = Color.decode("#00051D");
        private static final Color foregroundColor = Color.decode("#000000");

        protected RolloverSelectedTheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class RolloverUnselectedScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FFFFFF");
        private static final Color mainExtraLightColor = Color.decode("#FDFDFE");
        private static final Color mainLightColor = Color.decode("#F7F8FA");
        private static final Color mainMidColor = Color.decode("#E9ECF2");
        private static final Color mainDarkColor = Color.decode("#7A7E86");
        private static final Color mainUltraDarkColor = Color.decode("#55585E");
        private static final Color foregroundColor = Color.decode("#2A2E36");

        protected RolloverUnselectedScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class DisabledScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#E3EFE9");
        private static final Color mainExtraLightColor = Color.decode("#DFE2E6");
        private static final Color mainLightColor = Color.decode("#DADDE3");
        private static final Color mainMidColor = Color.decode("#D6D9DF");
        private static final Color mainDarkColor = Color.decode("#C9CCD2");
        private static final Color mainUltraDarkColor = Color.decode("#BCBFC5");
        private static final Color foregroundColor = Color.decode("#848B98");

        protected DisabledScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class DefaultScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#FBFBFC");
        private static final Color mainExtraLightColor = Color.decode("#F4F7FC");
        private static final Color mainLightColor = Color.decode("#F1F2F4");
        private static final Color mainMidColor = Color.decode("#D6D9DF");
        private static final Color mainDarkColor = Color.decode("#95989E");
        private static final Color mainUltraDarkColor = Color.decode("#55585E");
        private static final Color foregroundColor = Color.decode("#2A2E36");

        protected DefaultScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }

    protected static class ActiveScheme
    implements ColorScheme {
        private static final Color mainUltraLightColor = Color.decode("#F6F8FA");
        private static final Color mainExtraLightColor = Color.decode("#DFE6ED");
        private static final Color mainLightColor = Color.decode("#C1D6E9");
        private static final Color mainMidColor = Color.decode("#A3B8CB");
        private static final Color mainDarkColor = Color.decode("#62778A");
        private static final Color mainUltraDarkColor = Color.decode("#22374A");
        private static final Color foregroundColor = Color.decode("#000000");

        protected ActiveScheme() {
        }

        public Color getForegroundColor() {
            return foregroundColor;
        }

        public Color getUltraLightColor() {
            return mainUltraLightColor;
        }

        public Color getExtraLightColor() {
            return mainExtraLightColor;
        }

        public Color getLightColor() {
            return mainLightColor;
        }

        public Color getMidColor() {
            return mainMidColor;
        }

        public Color getDarkColor() {
            return mainDarkColor;
        }

        public Color getUltraDarkColor() {
            return mainUltraDarkColor;
        }
    }
}

