/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.animation.FadeStateListener;
import org.jvnet.lafwidget.animation.FadeTracker;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceFillBackgroundDelegate;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.border.SubstanceBorderPainter;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ClassicGradientPainter;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverControlListener;
import org.jvnet.substance.utils.SubstanceColorUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.Trackable;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;

public class SubstanceSliderUI
extends BasicSliderUI
implements Trackable {
    protected Set lafWidgets;
    private static SubstanceFillBackgroundDelegate bgDelegate = new SubstanceFillBackgroundDelegate();
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected FadeStateListener substanceFadeStateListener;
    protected Icon horizontalIcon;
    protected Icon roundIcon;
    protected Icon verticalIcon;

    public void __org__jvnet__substance__SubstanceSliderUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite((Component)jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceSliderUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceSliderUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void installListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceSliderUI__installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
    }

    public void installDefaults(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__installDefaults(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void uninstallListeners(JSlider jSlider) {
        this.__org__jvnet__substance__SubstanceSliderUI__uninstallListeners(jSlider);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return new SubstanceSliderUI((JSlider)c);
    }

    public SubstanceSliderUI(JSlider slider) {
        super(null);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(slider.isEnabled());
        int size = SubstanceSizeUtils.getSliderIconSize();
        this.horizontalIcon = SubstanceIconFactory.getSliderHorizontalIcon(size, false);
        this.roundIcon = SubstanceIconFactory.getSliderRoundIcon(size);
        this.verticalIcon = SubstanceIconFactory.getSliderVerticalIcon(size, false);
    }

    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 0) {
            this.trackRect.y = 3 + this.insetCache.top;
        }
    }

    private Rectangle getPaintTrackRect() {
        int trackLeft = 0;
        int trackRight = 0;
        int trackTop = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackTop = 7 + this.insetCache.top;
            trackBottom = trackTop + this.getTrackWidth() - 1;
            trackRight = this.trackRect.width;
            return new Rectangle(this.trackRect.x + trackLeft, trackTop, trackRight - trackLeft, trackBottom - trackTop);
        }
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            trackLeft = 8 + this.insetCache.left;
            trackRight = trackLeft + this.getTrackWidth() - 1;
        } else {
            trackRight = this.slider.getWidth() - 8 - this.insetCache.right;
            trackLeft = trackRight - this.getTrackWidth() + 1;
        }
        trackBottom = this.trackRect.height - 1;
        return new Rectangle(trackLeft, this.trackRect.y + trackTop, trackRight - trackLeft, trackBottom - trackTop);
    }

    public void paintTrack(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean drawInverted = this.drawInverted();
        Rectangle paintRect = this.getPaintTrackRect();
        graphics.translate(paintRect.x, paintRect.y);
        int width = paintRect.width;
        int height = paintRect.height;
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(this.slider);
        SubstanceTheme trackTheme = SubstanceCoreUtilities.getTheme(this.slider, true);
        trackTheme = this.slider.isEnabled() ? trackTheme.getDefaultTheme() : trackTheme.getDisabledTheme();
        this.paintSliderTrack(graphics, drawInverted, trackTheme, width, height, this.slider.getOrientation() == 1);
        SubstanceTheme theme = SubstanceCoreUtilities.getTheme((Component)this.slider, currState, true, true);
        FadeState fadeState = SubstanceFadeUtilities.getFadeState((Component)this.slider, FadeKind.ROLLOVER, FadeKind.SELECTION, FadeKind.PRESS);
        if (fadeState != null) {
            SubstanceTheme prevTheme = SubstanceCoreUtilities.getTheme((Component)this.slider, prevState, true, true);
            float cyclePos = fadeState.getFadePosition();
            if (!fadeState.isFadingIn()) {
                cyclePos = 10.0f - cyclePos;
            }
            if (prevState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, 1.0f - cyclePos / 10.0f, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, prevTheme, width, height);
            }
            if (currState != ComponentState.DEFAULT) {
                graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, cyclePos / 10.0f, g));
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, theme, width, height);
            }
        } else {
            boolean hasFill;
            boolean bl = hasFill = currState.isKindActive(FadeKind.ROLLOVER) || currState.isKindActive(FadeKind.PRESS) || SubstanceCoreUtilities.isControlAlwaysPaintedActive(this.slider, true);
            if (hasFill) {
                this.paintSliderTrackSelected(graphics, drawInverted, paintRect, theme, width, height);
            }
        }
        graphics.dispose();
    }

    private void paintSliderTrack(Graphics2D graphics, boolean drawInverted, SubstanceTheme theme, int width, int height, boolean toRotate) {
        ClassicGradientPainter gradientPainter = new ClassicGradientPainter();
        ColorScheme fillColorScheme = theme.getColorScheme();
        SubstanceBorderPainter borderPainter = SubstanceCoreUtilities.getBorderPainter(this.slider, gradientPainter);
        if (toRotate) {
            BufferedImage image = SubstanceCoreUtilities.getBlankImage(height + 1, width + 1);
            this.paintSliderTrack((Graphics2D)image.getGraphics(), drawInverted, theme, height, width, false);
            BufferedImage track = SubstanceImageCreator.getRotated(image, 3);
            graphics.drawImage((Image)track, 0, 0, null);
            return;
        }
        GeneralPath contour = BaseButtonShaper.getBaseOutline(width + 1, height + 1, 1.0f, null);
        BufferedImage fillTrackImage = gradientPainter.getContourBackground(width, height, contour, false, fillColorScheme, fillColorScheme, 0.0f, false, false);
        graphics.drawImage((Image)fillTrackImage, 0, 0, null);
        ColorScheme borderScheme = theme.getBorderTheme().getColorScheme();
        borderPainter.paintBorder(graphics, width + 1, height + 1, contour, borderScheme, borderScheme, 0.0f, false);
    }

    private void paintSliderTrackSelected(Graphics2D graphics, boolean drawInverted, Rectangle paintRect, SubstanceTheme theme, int width, int height) {
        Color fillColor2;
        boolean isDark = SubstanceCoreUtilities.isThemeDark(theme);
        ColorScheme colorScheme = theme.getColorScheme();
        int radius = 2;
        Color fillColor1 = isDark ? colorScheme.getUltraLightColor() : colorScheme.getUltraLightColor();
        Color color = fillColor2 = isDark ? colorScheme.getLightColor() : colorScheme.getLightColor();
        if (this.slider.isEnabled()) {
            if (this.slider.getOrientation() == 0) {
                int fillMaxX;
                int fillMinX;
                int middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2 - paintRect.x;
                graphics.setPaint(new GradientPaint(0.0f, 1.0f, fillColor1, 0.0f, height - 1, fillColor2));
                if (drawInverted) {
                    fillMinX = middleOfThumb;
                    fillMaxX = width - 2;
                } else {
                    fillMinX = 1;
                    fillMaxX = middleOfThumb;
                }
                graphics.fillRoundRect(fillMinX, 1, fillMaxX - fillMinX + 2, height - 1, radius - 2, radius - 2);
            } else {
                int fillMaxY;
                int fillMinY;
                int middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2 - paintRect.y;
                graphics.setPaint(new GradientPaint(1.0f, 0.0f, fillColor1, width - 1, 0.0f, fillColor2));
                if (this.drawInverted()) {
                    fillMinY = 1;
                    fillMaxY = middleOfThumb;
                } else {
                    fillMinY = middleOfThumb;
                    fillMaxY = height - 2;
                }
                graphics.fillRoundRect(1, fillMinY, width - 1, fillMaxY - fillMinY + 2, radius - 2, radius - 2);
            }
        }
    }

    protected Dimension getThumbSize() {
        Icon thumbIcon = this.getIcon();
        return new Dimension(thumbIcon.getIconWidth(), thumbIcon.getIconHeight());
    }

    protected Icon getIcon() {
        if (this.slider.getOrientation() == 0) {
            if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
                return this.horizontalIcon;
            }
            return this.roundIcon;
        }
        if (this.slider.getPaintTicks() || this.slider.getPaintLabels()) {
            return this.verticalIcon;
        }
        return this.roundIcon;
    }

    public void paintThumb(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        Rectangle knobBounds = this.thumbRect;
        graphics.translate(knobBounds.x, knobBounds.y);
        Icon icon = this.getIcon();
        if (this.slider.getOrientation() == 0) {
            int yOffset = 0;
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, -1, yOffset);
            }
        } else if (this.slider.getComponentOrientation().isLeftToRight()) {
            int xOffset = 0;
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, xOffset, -1);
            }
        } else {
            int xOffset = 0;
            if (icon != null) {
                icon.paintIcon(this.slider, graphics, xOffset, 1);
            }
        }
        graphics.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics g, JComponent c) {
        Graphics2D graphics = (Graphics2D)g.create();
        ComponentState currState = ComponentState.getState(this.thumbModel, this.slider);
        float alpha = SubstanceCoreUtilities.getTheme(this.slider, true).getThemeAlpha(this.slider, currState);
        graphics.setComposite(TransitionLayout.getAlphaComposite(this.slider, alpha, g));
        SubstanceCoreUtilities.workaroundBug6576507(graphics);
        JComponent jComponent = c;
        synchronized (jComponent) {
            bgDelegate.updateIfOpaque(graphics, c);
            boolean isOpaque = c.isOpaque();
            c.setOpaque(false);
            super.paint(graphics, c);
            c.setOpaque(isOpaque);
        }
        if (!this.slider.hasFocus() && FadeTracker.getInstance().isTracked(c, FadeKind.FOCUS)) {
            this.paintFocus(graphics);
        }
        graphics.dispose();
    }

    public ButtonModel getButtonModel() {
        return this.thumbModel;
    }

    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        if (thumbB == null) {
            return false;
        }
        return thumbB.contains(me.getX(), me.getY());
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__installListeners(final JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    SubstanceSliderUI.this.thumbModel.setEnabled(slider.isEnabled());
                }
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.substanceFadeStateListener = new FadeStateListener(this.slider, this.thumbModel, SubstanceCoreUtilities.getFadeCallback(this.slider, this.thumbModel, false));
        this.substanceFadeStateListener.registerListeners(false);
    }

    protected void __org__jvnet__substance__SubstanceSliderUI__uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
    }

    public void paintFocus(Graphics g) {
        SubstanceCoreUtilities.paintFocus(g, this.slider, this.slider, null);
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    protected int getTrackWidth() {
        return SubstanceSizeUtils.getSliderTrackSize();
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0 && this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum() + this.slider.getMinorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    int delta = value - this.slider.getMinimum();
                    if (delta % this.slider.getMajorTickSpacing() == 0) continue;
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum() + this.slider.getMajorTickSpacing(); value < this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum() + this.slider.getMinorTickSpacing();
            int yPos = 0;
            boolean ltr = this.slider.getComponentOrientation().isLeftToRight();
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!ltr) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!ltr) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum() + this.slider.getMajorTickSpacing();
                if (!ltr) {
                    g.translate(2, 0);
                }
                while (value < this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!ltr) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = this.slider.isEnabled() ? SubstanceCoreUtilities.getDefaultScheme(this.slider) : SubstanceCoreUtilities.getDisabledScheme(this.slider);
        Color color = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color icolor = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setPaint(new GradientPaint(x - 1, 0.0f, color, x - 1, tickBounds.height, SubstanceColorUtilities.getAlphaColor(color, 96)));
        graphics.drawLine(x - 1, 0, x - 1, tickBounds.height - 1);
        graphics.setPaint(new GradientPaint(x, 0.0f, icolor, x, tickBounds.height, SubstanceColorUtilities.getAlphaColor(icolor, 96)));
        graphics.drawLine(x, 0, x, tickBounds.height - 1);
        graphics.dispose();
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = this.slider.isEnabled() ? SubstanceCoreUtilities.getDefaultScheme(this.slider) : SubstanceCoreUtilities.getDisabledScheme(this.slider);
        Color color = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color icolor = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            graphics.setPaint(new GradientPaint(0.0f, y, color, tickBounds.width - 1, y, SubstanceColorUtilities.getAlphaColor(color, 96)));
        } else {
            graphics.setPaint(new GradientPaint(0.0f, y, SubstanceColorUtilities.getAlphaColor(color, 96), tickBounds.width - 1, y, color));
        }
        graphics.drawLine(0, y, tickBounds.width - 1, y);
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            graphics.setPaint(new GradientPaint(0.0f, y + 1, icolor, tickBounds.width - 1, y + 1, SubstanceColorUtilities.getAlphaColor(icolor, 96)));
        } else {
            graphics.setPaint(new GradientPaint(0.0f, y + 1, SubstanceColorUtilities.getAlphaColor(icolor, 96), tickBounds.width - 1, y + 1, icolor));
        }
        graphics.drawLine(0, y + 1, tickBounds.width - 1, y + 1);
        graphics.dispose();
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = this.slider.isEnabled() ? SubstanceCoreUtilities.getDefaultScheme(this.slider) : SubstanceCoreUtilities.getDisabledScheme(this.slider);
        Color color = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color icolor = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setPaint(new GradientPaint(x - 1, 0.0f, color, x - 1, tickBounds.height / 2, SubstanceColorUtilities.getAlphaColor(color, 96)));
        graphics.drawLine(x - 1, 0, x - 1, tickBounds.height / 2);
        graphics.setPaint(new GradientPaint(x, 0.0f, icolor, x, tickBounds.height / 2, SubstanceColorUtilities.getAlphaColor(icolor, 96)));
        graphics.drawLine(x, 0, x, tickBounds.height / 2);
        graphics.dispose();
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        boolean isDark = SubstanceCoreUtilities.isThemeDark(SubstanceLookAndFeel.getTheme());
        ColorScheme colorScheme = this.slider.isEnabled() ? SubstanceCoreUtilities.getDefaultScheme(this.slider) : SubstanceCoreUtilities.getDisabledScheme(this.slider);
        Color color = isDark ? colorScheme.getUltraLightColor() : colorScheme.getDarkColor();
        Color icolor = isDark ? colorScheme.getDarkColor() : colorScheme.getUltraLightColor();
        Graphics2D graphics = (Graphics2D)g.create();
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            graphics.setPaint(new GradientPaint(0.0f, y, color, tickBounds.width / 2, y, SubstanceColorUtilities.getAlphaColor(color, 96)));
            graphics.drawLine(0, y, tickBounds.width / 2, y);
        } else {
            graphics.setPaint(new GradientPaint(1.0f, y, SubstanceColorUtilities.getAlphaColor(color, 96), tickBounds.width / 2 + 1, y, color));
            graphics.drawLine(1, y, tickBounds.width / 2 + 1, y);
        }
        if (this.slider.getComponentOrientation().isLeftToRight()) {
            graphics.setPaint(new GradientPaint(0.0f, y + 1, icolor, tickBounds.width / 2, y + 1, SubstanceColorUtilities.getAlphaColor(icolor, 96)));
            graphics.drawLine(0, y + 1, tickBounds.width / 2, y + 1);
        } else {
            graphics.setPaint(new GradientPaint(1.0f, y + 1, SubstanceColorUtilities.getAlphaColor(icolor, 96), tickBounds.width / 2 + 1, y + 1, icolor));
            graphics.drawLine(1, y + 1, tickBounds.width / 2 + 1, y + 1);
        }
        graphics.dispose();
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.slider.getPaintTicks() ? this.getTickLength() : 0;
        } else {
            this.tickRect.width = this.slider.getPaintTicks() ? this.getTickLength() : 0;
            this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? this.trackRect.x + this.trackRect.width : this.trackRect.x - this.tickRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
        }
        if (this.slider.getPaintTicks()) {
            if (this.slider.getOrientation() == 0) {
                this.tickRect.y -= 3;
            } else {
                this.tickRect.x = this.slider.getComponentOrientation().isLeftToRight() ? (this.tickRect.x -= 2) : (this.tickRect.x += 2);
            }
        }
    }

    protected void calculateLabelRect() {
        super.calculateLabelRect();
        if (this.slider.getOrientation() == 0) {
            if (!this.slider.getPaintTicks()) {
                // empty if block
            }
        } else if (!this.slider.getPaintTicks() && this.slider.getComponentOrientation().isLeftToRight()) {
            this.labelRect.x += 3;
        }
    }

    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        Rectangle trackRect = this.getPaintTrackRect();
        if (this.slider.getOrientation() == 0) {
            int valuePosition = this.xPositionForValue(this.slider.getValue());
            double centerY = (double)trackRect.y + (double)trackRect.height / 2.0;
            this.thumbRect.y = (int)(centerY - (double)this.thumbRect.height / 2.0) + 1;
            this.thumbRect.x = valuePosition - this.thumbRect.width / 2;
        } else {
            int valuePosition = this.yPositionForValue(this.slider.getValue());
            double centerX = (double)trackRect.x + (double)trackRect.width / 2.0;
            this.thumbRect.x = (int)(centerX - (double)this.thumbRect.width / 2.0) + 1;
            this.thumbRect.y = valuePosition - this.thumbRect.height / 2;
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        label.setEnabled(this.slider.isEnabled());
        super.paintHorizontalLabel(g, value, label);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        label.setEnabled(this.slider.isEnabled());
        super.paintVerticalLabel(g, value, label);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width + this.labelRect.width;
            if (this.slider.getPaintTicks()) {
                d.width += 3;
            }
            if (this.slider.getPaintLabels()) {
                ++d.width;
            }
            d.width += 3;
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height + this.labelRect.height;
            if (this.slider.getPaintTicks()) {
                d.height += 3;
            }
            if (this.slider.getPaintLabels()) {
                ++d.height;
            }
            d.height += 3;
        }
        return d;
    }

    public void setThumbLocation(int x, int y) {
        super.setThumbLocation(x, y);
        this.slider.repaint();
    }
}

